/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.script;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;

public class QueryResult {
    private static final int LARGE_TABLE_THRESHOLD = 20000;
    private final String query;
    private final String[] columntitles;
    private final int nColumns;
    private final List<List<String>> rows;
    private String[][] data;

    public QueryResult(String query, ResultSet rs) throws SQLException {
        this.query = query;
        Objects.requireNonNull(rs);
        this.nColumns = rs.getMetaData().getColumnCount();
        if (this.nColumns == 0) {
            throw new IllegalStateException("The query produced no results.");
        }
        this.columntitles = new String[this.nColumns];
        for (int i = 0; i < this.nColumns; ++i) {
            this.columntitles[i] = rs.getMetaData().getColumnLabel(i + 1);
        }
        this.rows = new LinkedList<List<String>>();
        try (ResultSet resultSet = rs;){
            while (rs.next()) {
                LinkedList<String> row = new LinkedList<String>();
                for (int i = 1; i <= this.nColumns; ++i) {
                    row.add(rs.getString(i));
                }
                this.rows.add(row);
            }
        }
    }

    public Initialiser getInitialiser(Runnable listener) {
        return new Initialiser(this, listener);
    }

    public String columnName(int nCol) {
        return this.columntitles[nCol];
    }

    public int nColumns() {
        return this.nColumns;
    }

    public int nRows() {
        return this.rows.size();
    }

    public String getData(int row, int col) {
        return this.data[row][col];
    }

    public List<String[]> getRows() {
        return Arrays.asList(this.data);
    }

    public String query() {
        return this.query;
    }

    public boolean isOverLargeTableThreshold() {
        return this.rows.size() > 20000;
    }

    public class Initialiser
    implements Runnable {
        private final AtomicBoolean running;
        private final Runnable listener;
        final /* synthetic */ QueryResult this$0;

        private Initialiser(QueryResult this$0, Runnable listener) {
            QueryResult queryResult = this$0;
            Objects.requireNonNull(queryResult);
            this.this$0 = queryResult;
            this.running = new AtomicBoolean(false);
            this.listener = listener;
        }

        @Override
        public void run() {
            if (this.this$0.data != null) {
                return;
            }
            this.running.set(true);
            this.this$0.data = new String[this.this$0.rows.size()][this.this$0.nColumns];
            int row = 0;
            Iterator<List<String>> it = this.this$0.rows.iterator();
            while (it.hasNext() && this.running.get()) {
                List<String> rowData = it.next();
                for (int col = 0; col < this.this$0.nColumns; ++col) {
                    this.this$0.data[row][col] = rowData.get(col);
                }
                ++row;
            }
            this.running.set(false);
            SwingUtilities.invokeLater(this.listener);
        }

        public void stop() {
            this.running.set(false);
        }
    }
}

