/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.script;

import com.stratadata.util.script.QueryResult;
import com.stratadata.util.script.ScriptUtilities;
import java.awt.Window;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.text.JTextComponent;
import model3.ConnectionProvider;
import util.SBPermissionException;
import util.exception.StackError;

public class ScriptRunner
extends SwingWorker<List<QueryResult>, String> {
    private static final Logger LOGGER = Logger.getLogger(ScriptRunner.class.getName());
    private final String script;
    private final ConnectionProvider connection;
    private final Window parentWindow;
    private final JTextComponent outputComponent;
    private boolean allowUnrestrictedQueries = false;
    private CommitMode commitMode = CommitMode.ALL;
    private int queryTimeout = 30;
    private final StringBuilder output = new StringBuilder();
    private boolean ranToComplete = false;
    private boolean confirmed = false;
    private boolean wasCancelled = false;

    public boolean hasConfirmed() {
        return this.confirmed;
    }

    public ScriptRunner(String script, ConnectionProvider connection, JTextComponent outputComponent, Window parentWindow, boolean allowUnrestrictedQueries) {
        this.script = script;
        this.connection = connection;
        this.outputComponent = outputComponent;
        this.parentWindow = parentWindow;
        this.allowUnrestrictedQueries = allowUnrestrictedQueries;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected List<QueryResult> doInBackground() throws Exception {
        List<String> statements = ScriptUtilities.getStatements(this.script);
        if (statements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<QueryResult> results = new LinkedList<QueryResult>();
        try (Statement stmt = this.connection.getDatabase().createStatement();){
            if (this.queryTimeout > 0) {
                try {
                    stmt.setQueryTimeout(this.queryTimeout);
                }
                catch (SQLException ex) {
                    LOGGER.log(Level.WARNING, "Error setting timeout: {0}", ex.getMessage());
                }
            }
            for (String sql : statements) {
                try {
                    QueryResult result = this.runStatement(stmt, sql);
                    if (result != null) {
                        results.add(result);
                    }
                    if (!this.wasCancelled) continue;
                    return results;
                }
                catch (SQLException sqle) {
                    this.connection.doRollback();
                    LOGGER.warning("Error: " + sqle.getMessage());
                    if (sql == statements.get(statements.size() - 1)) {
                        JOptionPane.showMessageDialog(this.parentWindow, "The following error occurred: \n\n" + sqle.getMessage(), "Run Script", 0);
                        this.confirmed = true;
                        throw new UserDiscontinuedException(sqle);
                    }
                    if (JOptionPane.showConfirmDialog(this.parentWindow, "The following error occurred: \n\n" + sqle.getMessage() + "\n\nContinue with rest of script?", "Run Script", 0, 3) != 1) continue;
                    throw new UserDiscontinuedException(sqle);
                    return results;
                }
            }
        }
    }

    private QueryResult runStatement(Statement stmt, String sql) throws SQLException, SBPermissionException {
        if (ScriptUtilities.isUpdate(sql) && !this.allowUnrestrictedQueries) {
            throw new SBPermissionException("You do not have permission to run update statements.");
        }
        if (sql.startsWith("CREATE TABLE") && !this.checkCreateTable(stmt, sql)) {
            return null;
        }
        return this.execute(stmt, sql);
    }

    private QueryResult execute(Statement stmt, String sql) throws SQLException {
        sql = this.connection.modQuery(sql);
        this.publish(sql);
        if (sql.equalsIgnoreCase("commit")) {
            this.connection.commit();
            return null;
        }
        boolean queryResultType = stmt.execute(sql);
        if (queryResultType) {
            try (ResultSet rs = stmt.getResultSet();){
                QueryResult queryResult = new QueryResult(sql, rs);
                return queryResult;
            }
        }
        int rowsUpdated = stmt.getUpdateCount();
        block2 : switch (this.commitMode.ordinal()) {
            case 0: {
                break;
            }
            case 2: {
                this.connection.commit();
                this.publish(rowsUpdated + " rows updated");
                break;
            }
            case 1: {
                Object[] buttons = new String[]{"Yes", "Yes to all", "No"};
                int opt = JOptionPane.showOptionDialog(this.parentWindow, (String)(sql.length() > 60 ? sql.substring(0, 57) + "..." : sql) + "\n\nNumber of rows updated: " + rowsUpdated + "\nCommit?", "Confirm Commit", 0, 3, null, buttons, null);
                this.confirmed = true;
                switch (opt) {
                    case 1: {
                        this.commitMode = CommitMode.ALL;
                    }
                    case 0: {
                        this.connection.commit();
                        this.publish(rowsUpdated + " rows updated");
                        break block2;
                    }
                }
                this.cancel(true);
                this.wasCancelled = true;
            }
        }
        return null;
    }

    private boolean checkCreateTable(Statement stmt, String sql) {
        String CTS = "CREATE TABLE ";
        if (sql.contains("CREATE TABLE ")) {
            String tableName = sql.substring(sql.toUpperCase().indexOf("CREATE TABLE ") + "CREATE TABLE ".length());
            tableName = tableName.substring(0, tableName.indexOf(32));
            try {
                ResultSet rs = stmt.executeQuery("SELECT 1 FROM " + tableName);
                rs.close();
                this.publish("Table '" + tableName + "' already exists in target");
                return false;
            }
            catch (SQLException ex) {
                this.publish("Creating table '" + tableName + "'");
                return true;
            }
        }
        return false;
    }

    @Override
    protected void process(List<String> chunks) {
        if (this.outputComponent == null) {
            chunks.forEach(chunk -> LOGGER.info((String)chunk));
            return;
        }
        chunks.forEach(chunk -> this.output.append((String)chunk).append("\n"));
        this.outputComponent.setText(this.output.toString());
    }

    @Override
    protected void done() {
        try {
            this.get();
            this.ranToComplete = true;
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof UserDiscontinuedException) {
                UserDiscontinuedException disEx = (UserDiscontinuedException)throwable;
                this.output.append(disEx.getMessage());
                if (this.outputComponent != null) {
                    this.outputComponent.setText(this.output.toString());
                }
                return;
            }
            throwable = ex.getCause();
            if (throwable instanceof SBPermissionException) {
                SBPermissionException pe = (SBPermissionException)throwable;
                if (this.outputComponent != null) {
                    this.output.append(pe.getMessage());
                }
                if (this.outputComponent != null) {
                    this.outputComponent.setText(this.output.toString());
                }
                JOptionPane.showMessageDialog(this.parentWindow, pe.getMessage(), "Error", 0);
                return;
            }
            StackError.showStackError((String)"Error during script execution", (Throwable)ex.getCause());
        }
        catch (InterruptedException | CancellationException ie) {
            System.out.println("INTERRUPTED!");
            try {
                this.connection.doRollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean ranToComplete() {
        return this.ranToComplete;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setCommitMode(CommitMode commitMode) {
        Objects.requireNonNull(commitMode);
        this.commitMode = commitMode;
    }

    public CommitMode getCommitMode() {
        return this.commitMode;
    }

    public static enum CommitMode {
        NONE,
        WITH_CONFIRM,
        ALL;

    }

    private static class UserDiscontinuedException
    extends Exception {
        public UserDiscontinuedException(SQLException cause) {
            super("User cancelled after error: " + cause.getMessage(), cause);
        }
    }
}

