/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.ui;

import com.stratadata.util.ui.HelpUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class DialogBase
extends JDialog {
    private ReturnCode returnCode = null;
    private boolean isOK;
    private String helpLocation = null;
    private String okText = "OK";
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel buttonBar;
    private JButton jButtonOK;
    private JButton jButtonHelp;
    private JButton jButtonCancel;

    public DialogBase(Window owner) {
        super(owner, DEFAULT_MODALITY_TYPE);
        this.initComponents();
        if (Beans.isDesignTime()) {
            this.helpLocation = "help.html";
        }
        this.jButtonHelp.setVisible(false);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public String getHelpLocation() {
        return this.helpLocation;
    }

    public void setHelpLocation(String helpLocation) {
        this.helpLocation = helpLocation;
        this.jButtonHelp.setVisible(helpLocation != null);
    }

    public String getOkText() {
        return this.okText;
    }

    public void setOkText(String okText) {
        this.okText = okText;
        this.jButtonOK.setText(okText);
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void addOkButtonActionListener(ActionListener l) {
        this.jButtonOK.addActionListener(l);
    }

    public void enbaleOkButton(boolean enable, String tooltipText) {
        this.jButtonOK.setEnabled(enable);
        this.jButtonOK.setToolTipText(tooltipText);
        if (!enable) {
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        }
    }

    private void jButtonCancelActionPerformed() {
        this.returnWithCode(ReturnCode.CANCEL);
    }

    private void jButtonHelpActionPerformed() {
        if (this.helpLocation != null) {
            HelpUtils.openHelp(this.helpLocation);
        }
    }

    public void returnWithCode(ReturnCode returnCode) {
        this.returnCode = returnCode != null ? returnCode : ReturnCode.CANCEL;
        this.dispose();
    }

    public ReturnCode getReturnCode() {
        return this.returnCode;
    }

    public boolean isOK() {
        return this.returnCode == ReturnCode.SUCCESS;
    }

    public static void centreWindow(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = w.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        w.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("locale.UiText");
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.buttonBar = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new MigLayout("insets dialog,hidemode 3", "[fill][fill]", "[][][]"));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setLayout((LayoutManager)new MigLayout("insets dialog,hidemode 3,alignx right", "[button,fill]", null));
        this.jButtonOK.setText(bundle.getString("button.ok"));
        this.buttonBar.add((Component)this.jButtonOK, "cell 0 0");
        this.jButtonHelp.setText(bundle.getString("button.help"));
        this.jButtonHelp.addActionListener(e -> this.jButtonHelpActionPerformed());
        this.buttonBar.add((Component)this.jButtonHelp, "cell 0 0");
        this.jButtonCancel.setText(bundle.getString("button.cancel"));
        this.jButtonCancel.addActionListener(e -> this.jButtonCancelActionPerformed());
        this.buttonBar.add((Component)this.jButtonCancel, "cell 0 0");
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static enum ReturnCode {
        SUCCESS,
        CANCEL;

    }
}

