/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.ui;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.util.SystemInfo;
import com.stratadata.util.preferences.RegistryPreferencesHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SbugsLookAndFeelSetup {
    public static final String LAF_DEFAULT = "default";
    private static final Logger LOGGER = Logger.getLogger(SbugsLookAndFeelSetup.class.getName());

    public static void setupLookAndFeel() {
        String laf = RegistryPreferencesHelper.getLookAndFeel((String)LAF.FLAT_LIGHT.registryString);
        if (laf.equalsIgnoreCase(LAF.FLAT_LIGHT.registryString) || laf.equals(LAF_DEFAULT)) {
            FlatLightLaf.setup();
            SbugsLookAndFeelSetup.flatLafUIManagerSetup(LAF.FLAT_LIGHT);
        } else if (laf.equalsIgnoreCase(LAF.FLAT_DARK.registryString)) {
            FlatDarkLaf.setup();
            SbugsLookAndFeelSetup.flatLafUIManagerSetup(LAF.FLAT_DARK);
        } else {
            try {
                String look = UIManager.getSystemLookAndFeelClassName();
                if (look.contains("Windows")) {
                    LOGGER.log(Level.INFO, "Setting look and feel to: {0}", look);
                    UIManager.setLookAndFeel(look);
                    SbugsLookAndFeelSetup.windowsUIManagerSetup();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                System.out.println("Exception setting look & feel: " + e.getMessage());
                e.printStackTrace();
            }
            if (System.getProperty("os.name").startsWith("Mac")) {
                SbugsLookAndFeelSetup.macUIManagerSetup();
            } else {
                UIManager.put("TextArea.font", (Font)UIManager.get("Label.font"));
            }
        }
        UIManager.put("TitledBorder.titleColor", new Color(51, 102, 204));
        UIManager.put("TitledBorder.font", UIManager.get("Label.font"));
    }

    private static void flatLafUIManagerSetup(LAF laf) {
        UIManager.put("TabbedPane.showTabSeparators", true);
        UIManager.put("TabbedPane.tabSeparatorsFullHeight", false);
        if (laf == LAF.FLAT_LIGHT) {
            UIManager.put("TabbedPane.selectedBackground", Color.white);
        }
        UIManager.put("TabbedPane.tabType", "card");
        UIManager.put("TabbedPane.tabHeight", 26);
        UIManager.put("TitlePane.menuBarEmbedded", false);
        UIManager.put("TitlePane.unifiedBackground", false);
        UIManager.put("Table.showHorizontalLines", true);
        UIManager.put("Table.showVerticalLines", true);
        UIManager.put("Table.intercellSpacing", new Dimension(1, 1));
        UIManager.put("Table.selectionInactiveForeground", UIManager.get("Table.selectionForeground"));
        UIManager.put("Table.selectionInactiveBackground", UIManager.get("Table.selectionBackground"));
        if (SystemInfo.isMacOS) {
            Logger.getLogger(SbugsLookAndFeelSetup.class.getName()).log(Level.INFO, "Setting FlatLaf smooth scrolling");
            UIManager.put("ScrollPane.smoothScrolling", false);
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        LOGGER.log(Level.INFO, "Initial FlatLafFont {0}", toolkit.getDesktopProperty("win.messagebox.font"));
        toolkit.addPropertyChangeListener("win.messagebox.font", e -> LOGGER.log(Level.INFO, "Changed FlatLafFont {0}", toolkit.getDesktopProperty("win.messagebox.font")));
    }

    private static void windowsUIManagerSetup() {
        String[] iconOps = new String[]{"OptionPane.errorIcon", "OptionPane.informationIcon", "OptionPane.warningIcon", "OptionPane.questionIcon"};
        int i = 0;
        ImageIcon[] icon = new ImageIcon[iconOps.length];
        for (String key : iconOps) {
            icon[i++] = (ImageIcon)UIManager.get(key);
        }
        Font font = (Font)UIManager.get("Label.font");
        if (font.getSize() != 11) {
            System.out.println("Detected non 11pt font: " + font.getSize());
            if (RegistryPreferencesHelper.getGuiResizePreference((boolean)true)) {
                System.out.println("Setting resize GUI font to 11pt");
                Font newFont = font.deriveFont(11.0f);
                UIManager.put("Label.font", newFont);
                UIManager.put("Button.font", newFont);
                UIManager.put("List.font", newFont);
                UIManager.put("ComboBox.font", newFont);
                UIManager.put("RadioButton.font", newFont);
                UIManager.put("CheckBox.font", newFont);
                UIManager.put("Spinner.font", newFont);
                UIManager.put("TextField.font", newFont);
                UIManager.put("TabbedPane.font", newFont);
                UIManager.put("Table.font", newFont);
                UIManager.put("TitledBorder.font", newFont);
                UIManager.put("Tree.font", newFont);
                UIManager.put("TextPane.font", newFont);
                i = 0;
                for (String key : iconOps) {
                    UIManager.put(key, icon[i++]);
                }
            }
        }
    }

    private static void macUIManagerSetup() {
        System.out.println("Using LAF: " + UIManager.getLookAndFeel().getName() + " (" + UIManager.getLookAndFeel().getDescription() + ")");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "StrataBugs");
        Font font = (Font)UIManager.get("Label.font");
        int fontSize = 11;
        UIManager.put("Label.font", font.deriveFont(fontSize));
        UIManager.put("Button.font", font.deriveFont(fontSize));
        UIManager.put("List.font", font.deriveFont(fontSize));
        UIManager.put("ComboBox.font", font.deriveFont(fontSize));
        UIManager.put("RadioButton.font", font.deriveFont(fontSize));
        UIManager.put("TextField.font", font.deriveFont(fontSize));
        UIManager.put("Table.font", font.deriveFont(fontSize));
        UIManager.put("TableHeader.font", font.deriveFont(fontSize));
        UIManager.put("TitledBorder.font", font.deriveFont(fontSize));
        UIManager.put("Tree.font", font.deriveFont(fontSize));
        UIManager.put("TextPane.font", font.deriveFont(fontSize));
        UIManager.put("TabbedPane.selectedTabTitleNormalColor", new Color(0, 0, 0));
        UIManager.put("TabbedPane.selectedTabTitleShadowNormalColor", new Color(255, 255, 255));
    }

    @Deprecated
    public static boolean isDefaultLAF() {
        return RegistryPreferencesHelper.getLookAndFeel((String)LAF_DEFAULT).equals(LAF_DEFAULT);
    }

    public static boolean isNativeLAF() {
        return RegistryPreferencesHelper.getLookAndFeel((String)LAF.NATIVE.registryString).equals(LAF.NATIVE.registryString);
    }

    public static LAF getLAF() {
        String registryString = RegistryPreferencesHelper.getLookAndFeel((String)LAF.getDefaultLAF().registryString);
        for (LAF laf : LAF.values()) {
            if (!laf.registryString.equalsIgnoreCase(registryString)) continue;
            return laf;
        }
        return LAF.getDefaultLAF();
    }

    public static void setLAF(LAF laf) {
        RegistryPreferencesHelper.putLookAndFeel((String)laf.registryString);
    }

    public static enum LAF {
        FLAT_LIGHT("flatlight"),
        FLAT_DARK("flatdark"),
        NATIVE("native");

        private final String registryString;

        private LAF(String registryString) {
            this.registryString = registryString;
        }

        static LAF getDefaultLAF() {
            return FLAT_LIGHT;
        }
    }
}

