/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.util.logging.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.geotools.util.logging.LoggerAdapter;
import org.geotools.util.logging.Logging;

public final class Log4JLogger
extends LoggerAdapter {
    final Logger logger;
    private static final int CONFIG_INT = 15000;
    public static final org.apache.log4j.Level CONFIG = new Log4JLevel(15000, "CONFIG", 6);
    private static final int FINEST_INT = 4000;
    public static final org.apache.log4j.Level FINEST = new Log4JLevel(4000, "FINEST", 7);

    public Log4JLogger(String name, Logger logger) {
        super(name);
        this.logger = logger;
    }

    private static org.apache.log4j.Level toLog4JLevel(Level level) {
        int n = level.intValue();
        switch (n / 100) {
            case 11: {
                return org.apache.log4j.Level.FATAL;
            }
            case 10: {
                return org.apache.log4j.Level.ERROR;
            }
            case 9: {
                return org.apache.log4j.Level.WARN;
            }
            case 8: {
                return org.apache.log4j.Level.INFO;
            }
            case 7: {
                return CONFIG;
            }
            case 5: 
            case 6: {
                return org.apache.log4j.Level.DEBUG;
            }
            case 4: {
                return org.apache.log4j.Level.TRACE;
            }
            case 3: {
                return FINEST;
            }
            case 0: 
            case 1: 
            case 2: {
                return org.apache.log4j.Level.ALL;
            }
        }
        switch (n) {
            case -2147483648: {
                return org.apache.log4j.Level.ALL;
            }
            case 0x7FFFFFFF: {
                return org.apache.log4j.Level.OFF;
            }
        }
        if (n >= 0) {
            return org.apache.log4j.Level.FATAL;
        }
        return org.apache.log4j.Level.ALL;
    }

    private static Level toJavaLevel(org.apache.log4j.Level level) {
        int n = level.toInt();
        if (n == Integer.MAX_VALUE) {
            return Level.OFF;
        }
        if (n >= 50000) {
            return Logging.FATAL;
        }
        if (n >= 40000) {
            return Level.SEVERE;
        }
        if (n >= 30000) {
            return Level.WARNING;
        }
        if (n >= 20000) {
            return Level.INFO;
        }
        if (n >= 15000) {
            return Level.CONFIG;
        }
        if (n >= 10000) {
            return Level.FINE;
        }
        if (n >= 5000) {
            return Level.FINER;
        }
        if (n >= 4000) {
            return Level.FINEST;
        }
        return Level.ALL;
    }

    @Override
    public void setLevel(Level level) {
        this.logger.setLevel(Log4JLogger.toLog4JLevel(level));
    }

    @Override
    public Level getLevel() {
        return Log4JLogger.toJavaLevel(this.logger.getEffectiveLevel());
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isEnabledFor((Priority)Log4JLogger.toLog4JLevel(level));
    }

    @Override
    public void log(Level level, String message) {
        this.logger.log((Priority)Log4JLogger.toLog4JLevel(level), (Object)message);
    }

    @Override
    public void log(Level level, String message, Throwable thrown) {
        this.logger.log((Priority)Log4JLogger.toLog4JLevel(level), (Object)message, thrown);
    }

    @Override
    public void severe(String message) {
        this.logger.error((Object)message);
    }

    @Override
    public void warning(String message) {
        this.logger.warn((Object)message);
    }

    @Override
    public void info(String message) {
        this.logger.info((Object)message);
    }

    @Override
    public void config(String message) {
        this.logger.log((Priority)CONFIG, (Object)message);
    }

    @Override
    public void fine(String message) {
        this.logger.debug((Object)message);
    }

    @Override
    public void finer(String message) {
        this.logger.trace((Object)message);
    }

    @Override
    public void finest(String message) {
        this.logger.log((Priority)FINEST, (Object)message);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Log4jLogger: ");
        sb.append(this.getName() == null ? "anonymous" : this.getName());
        sb.append(" : ");
        sb.append(this.getLevel());
        sb.append(" (");
        sb.append(this.logger.getLevel());
        sb.append(")");
        return sb.toString();
    }

    static class Log4JLevel
    extends org.apache.log4j.Level {
        Log4JLevel(int level, String levelStr, int syslogEquivalent) {
            super(level, levelStr, syslogEquivalent);
        }
    }
}

