/*
 * Decompiled with CFR 0.152.
 */
package com.hashmapinc.tempus.WitsmlObjects.Util.log;

import com.hashmapinc.tempus.WitsmlObjects.Util.log.ColumnarDataPoint;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ColumnarDataTrace<I, V> {
    private String mnemonic;
    private String unitOfMeasure;
    private String logName;
    private String logUid;
    private String index;
    private String indexString;
    private String wellUid;
    private String wellboreUid;
    private List<ColumnarDataPoint<I, V>> dataPoints = new ArrayList<ColumnarDataPoint<I, V>>();

    public String getIndexString() {
        return this.indexString;
    }

    public void setIndexString(String indexString) {
        this.indexString = indexString;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getWellUid() {
        return this.wellUid;
    }

    public void setWellUid(String wellUid) {
        this.wellUid = wellUid;
    }

    public String getWellboreUid() {
        return this.wellboreUid;
    }

    public void setWellboreUid(String wellboreUid) {
        this.wellboreUid = wellboreUid;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(String mnemonic) {
        this.mnemonic = mnemonic;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public String getLogUid() {
        return this.logUid;
    }

    public void setLogUid(String logUid) {
        this.logUid = logUid;
    }

    public List<ColumnarDataPoint<I, V>> getDataPoints() {
        return this.dataPoints;
    }

    public void setDataPoints(List<ColumnarDataPoint<I, V>> dataPoints) {
        this.dataPoints = dataPoints;
    }

    public void createDataPoint(I index, V value) {
        ColumnarDataPoint<I, V> datapoint = new ColumnarDataPoint<I, V>();
        datapoint.setMneumoic(this.mnemonic);
        datapoint.setIndex(index);
        datapoint.setValue(value);
        datapoint.setLogName(this.logName);
        datapoint.setWellboreUid(this.wellboreUid);
        datapoint.setWellUid(this.wellUid);
        this.dataPoints.add(datapoint);
    }

    public void createDataPoint(I index, V value, String typeConvertFilter) {
        ColumnarDataPoint<I, V> datapoint = new ColumnarDataPoint<I, V>();
        datapoint.setMneumoic(this.mnemonic);
        datapoint.setIndex(index);
        datapoint.setValue(value);
        datapoint.setLogName(this.logName);
        datapoint.setWellboreUid(this.wellboreUid);
        datapoint.setWellUid(this.wellUid);
        try {
            if (StringUtils.isNotEmpty((CharSequence)typeConvertFilter) && StringUtils.isNumeric((CharSequence)typeConvertFilter)) {
                int dataLength = Integer.valueOf(typeConvertFilter);
                String indexvalue = String.valueOf(index);
                if (StringUtils.isNotEmpty((CharSequence)indexvalue) && indexvalue.length() < dataLength) {
                    datapoint.setIndexString(StringUtils.leftPad((String)indexvalue, (int)dataLength, (String)"0"));
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        this.dataPoints.add(datapoint);
    }
}

