/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.mod.command.ddl.CommandWithColumns;
import org.h2.mod.command.ddl.CreateTableData;
import org.h2.mod.command.dml.Insert;
import org.h2.mod.command.dml.Query;
import org.h2.mod.engine.Database;
import org.h2.mod.engine.DbObject;
import org.h2.mod.engine.DbObjectBase;
import org.h2.mod.engine.Session;
import org.h2.mod.expression.Expression;
import org.h2.mod.message.DbException;
import org.h2.mod.schema.Schema;
import org.h2.mod.schema.SchemaObject;
import org.h2.mod.schema.Sequence;
import org.h2.mod.table.Column;
import org.h2.mod.table.Table;
import org.h2.mod.util.ColumnNamer;

public class CreateTable
extends CommandWithColumns {
    private final CreateTableData data = new CreateTableData();
    private boolean ifNotExists;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Query asQuery;
    private String comment;
    private boolean sortedInsertMode;
    private boolean withNoData;

    public CreateTable(Session session, Schema schema) {
        super(session, schema);
        this.data.persistIndexes = true;
        this.data.persistData = true;
    }

    public void setQuery(Query query) {
        this.asQuery = query;
    }

    public void setTemporary(boolean bl) {
        this.data.temporary = bl;
    }

    public void setTableName(String string) {
        this.data.tableName = string;
    }

    @Override
    public void addColumn(Column column) {
        this.data.columns.add(column);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Object object;
        boolean bl;
        Database database;
        if (!this.transactional) {
            this.session.commit(true);
        }
        if (!(database = this.session.getDatabase()).isPersistent()) {
            this.data.persistIndexes = false;
        }
        boolean bl2 = bl = this.data.temporary && !this.data.globalTemporary;
        if (!bl) {
            database.lockMeta(this.session);
        }
        if (this.getSchema().resolveTableOrView(this.session, this.data.tableName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(42101, this.data.tableName);
        }
        if (this.asQuery != null) {
            this.asQuery.prepare();
            if (this.data.columns.isEmpty()) {
                this.generateColumnsFromQuery();
            } else {
                if (this.data.columns.size() != this.asQuery.getColumnCount()) {
                    throw DbException.get(21002);
                }
                object = this.data.columns;
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    Column column = (Column)((ArrayList)object).get(i);
                    if (column.getType().getValueType() != -1) continue;
                    ((ArrayList)object).set(i, new Column(column.getName(), this.asQuery.getExpressions().get(i).getType()));
                }
            }
        }
        this.changePrimaryKeysToNotNull(this.data.columns);
        this.data.id = this.getObjectId();
        this.data.create = this.create;
        this.data.session = this.session;
        object = this.getSchema().createTable(this.data);
        ArrayList<Sequence> arrayList = this.generateSequences(this.data.columns, this.data.temporary);
        ((DbObjectBase)object).setComment(this.comment);
        if (bl) {
            if (this.onCommitDrop) {
                ((Table)object).setOnCommitDrop(true);
            }
            if (this.onCommitTruncate) {
                ((Table)object).setOnCommitTruncate(true);
            }
            this.session.addLocalTempTable((Table)object);
        } else {
            database.lockMeta(this.session);
            database.addSchemaObject(this.session, (SchemaObject)object);
        }
        try {
            for (Column object2 : this.data.columns) {
                object2.prepareExpression(this.session);
            }
            for (Sequence sequence : arrayList) {
                ((Table)object).addSequence(sequence);
            }
            this.createConstraints();
            if (this.asQuery != null && !this.withNoData) {
                boolean bl3 = this.session.isUndoLogEnabled();
                try {
                    this.session.setUndoLogEnabled(false);
                    this.session.startStatementWithinTransaction();
                    Insert insert = new Insert(this.session);
                    insert.setSortedInsertMode(this.sortedInsertMode);
                    insert.setQuery(this.asQuery);
                    insert.setTable((Table)object);
                    insert.setInsertFromSelect(true);
                    insert.prepare();
                    insert.update();
                }
                finally {
                    this.session.setUndoLogEnabled(bl3);
                }
            }
            HashSet<DbObject> hashSet = new HashSet<DbObject>();
            ((Table)object).addDependencies(hashSet);
            for (DbObject dbObject : hashSet) {
                Table table;
                if (dbObject == object || dbObject.getType() != 0 || !(dbObject instanceof Table) || (table = (Table)dbObject).getId() <= ((DbObjectBase)object).getId()) continue;
                throw DbException.get(50100, "Table depends on another table with a higher ID: " + table + ", this is currently not supported, " + "as it would prevent the database from " + "being re-opened");
            }
        }
        catch (DbException dbException) {
            try {
                database.checkPowerOff();
                database.removeSchemaObject(this.session, (SchemaObject)object);
                if (!this.transactional) {
                    this.session.commit(true);
                }
            }
            catch (Throwable throwable) {
                dbException.addSuppressed(throwable);
            }
            throw dbException;
        }
        return 0;
    }

    private void generateColumnsFromQuery() {
        int n = this.asQuery.getColumnCount();
        ArrayList<Expression> arrayList = this.asQuery.getExpressions();
        ColumnNamer columnNamer = new ColumnNamer(this.session);
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            String string = columnNamer.getColumnName(expression, i, expression.getAlias());
            Column column = new Column(string, expression.getType());
            this.addColumn(column);
        }
    }

    public void setPersistIndexes(boolean bl) {
        this.data.persistIndexes = bl;
    }

    public void setGlobalTemporary(boolean bl) {
        this.data.globalTemporary = bl;
    }

    public void setOnCommitDrop() {
        this.onCommitDrop = true;
    }

    public void setOnCommitTruncate() {
        this.onCommitTruncate = true;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setPersistData(boolean bl) {
        this.data.persistData = bl;
        if (!bl) {
            this.data.persistIndexes = false;
        }
    }

    public void setSortedInsertMode(boolean bl) {
        this.sortedInsertMode = bl;
    }

    public void setWithNoData(boolean bl) {
        this.withNoData = bl;
    }

    public void setTableEngine(String string) {
        this.data.tableEngine = string;
    }

    public void setTableEngineParams(ArrayList<String> arrayList) {
        this.data.tableEngineParams = arrayList;
    }

    public void setHidden(boolean bl) {
        this.data.isHidden = bl;
    }

    @Override
    public int getType() {
        return 30;
    }
}

