/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.expression.function;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.h2.mod.command.Command;
import org.h2.mod.command.Parser;
import org.h2.mod.engine.Constants;
import org.h2.mod.engine.Database;
import org.h2.mod.engine.Mode;
import org.h2.mod.engine.Session;
import org.h2.mod.expression.Expression;
import org.h2.mod.expression.ExpressionColumn;
import org.h2.mod.expression.ExpressionVisitor;
import org.h2.mod.expression.SequenceValue;
import org.h2.mod.expression.ValueExpression;
import org.h2.mod.expression.Variable;
import org.h2.mod.expression.function.DateTimeFunctions;
import org.h2.mod.expression.function.FunctionCall;
import org.h2.mod.expression.function.FunctionInfo;
import org.h2.mod.expression.function.TableFunction;
import org.h2.mod.expression.function.ToChar;
import org.h2.mod.expression.function.ToDateParser;
import org.h2.mod.index.Index;
import org.h2.mod.message.DbException;
import org.h2.mod.mode.FunctionsMSSQLServer;
import org.h2.mod.mode.FunctionsMySQL;
import org.h2.mod.mvstore.db.MVSpatialIndex;
import org.h2.mod.schema.Schema;
import org.h2.mod.schema.Sequence;
import org.h2.mod.security.BlockCipher;
import org.h2.mod.security.CipherFactory;
import org.h2.mod.store.fs.FileUtils;
import org.h2.mod.table.Column;
import org.h2.mod.table.ColumnResolver;
import org.h2.mod.table.LinkSchema;
import org.h2.mod.table.Table;
import org.h2.mod.table.TableFilter;
import org.h2.mod.tools.CompressTool;
import org.h2.mod.tools.Csv;
import org.h2.mod.util.Bits;
import org.h2.mod.util.DateTimeUtils;
import org.h2.mod.util.IOUtils;
import org.h2.mod.util.JdbcUtils;
import org.h2.mod.util.MathUtils;
import org.h2.mod.util.StringUtils;
import org.h2.mod.util.Utils;
import org.h2.mod.value.DataType;
import org.h2.mod.value.TypeInfo;
import org.h2.mod.value.Value;
import org.h2.mod.value.ValueArray;
import org.h2.mod.value.ValueBoolean;
import org.h2.mod.value.ValueBytes;
import org.h2.mod.value.ValueCollectionBase;
import org.h2.mod.value.ValueDate;
import org.h2.mod.value.ValueDouble;
import org.h2.mod.value.ValueInt;
import org.h2.mod.value.ValueLong;
import org.h2.mod.value.ValueNull;
import org.h2.mod.value.ValueResultSet;
import org.h2.mod.value.ValueString;
import org.h2.mod.value.ValueTime;
import org.h2.mod.value.ValueTimestamp;
import org.h2.mod.value.ValueTimestampTimeZone;
import org.h2.mod.value.ValueUuid;

public class Function
extends Expression
implements FunctionCall {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int ATAN2 = 4;
    public static final int BITAND = 5;
    public static final int BITOR = 6;
    public static final int BITXOR = 7;
    public static final int CEILING = 8;
    public static final int COS = 9;
    public static final int COT = 10;
    public static final int DEGREES = 11;
    public static final int EXP = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int MOD = 16;
    public static final int PI = 17;
    public static final int POWER = 18;
    public static final int RADIANS = 19;
    public static final int RAND = 20;
    public static final int ROUND = 21;
    public static final int ROUNDMAGIC = 22;
    public static final int SIGN = 23;
    public static final int SIN = 24;
    public static final int SQRT = 25;
    public static final int TAN = 26;
    public static final int TRUNCATE = 27;
    public static final int SECURE_RAND = 28;
    public static final int HASH = 29;
    public static final int ENCRYPT = 30;
    public static final int DECRYPT = 31;
    public static final int COMPRESS = 32;
    public static final int EXPAND = 33;
    public static final int ZERO = 34;
    public static final int RANDOM_UUID = 35;
    public static final int COSH = 36;
    public static final int SINH = 37;
    public static final int TANH = 38;
    public static final int LN = 39;
    public static final int BITGET = 40;
    public static final int ORA_HASH = 41;
    public static final int ASCII = 50;
    public static final int BIT_LENGTH = 51;
    public static final int CHAR = 52;
    public static final int CHAR_LENGTH = 53;
    public static final int CONCAT = 54;
    public static final int DIFFERENCE = 55;
    public static final int HEXTORAW = 56;
    public static final int INSERT = 57;
    public static final int INSTR = 58;
    public static final int LCASE = 59;
    public static final int LEFT = 60;
    public static final int LENGTH = 61;
    public static final int LOCATE = 62;
    public static final int LTRIM = 63;
    public static final int OCTET_LENGTH = 64;
    public static final int RAWTOHEX = 65;
    public static final int REPEAT = 66;
    public static final int REPLACE = 67;
    public static final int RIGHT = 68;
    public static final int RTRIM = 69;
    public static final int SOUNDEX = 70;
    public static final int SPACE = 71;
    public static final int SUBSTR = 72;
    public static final int SUBSTRING = 73;
    public static final int UCASE = 74;
    public static final int LOWER = 75;
    public static final int UPPER = 76;
    public static final int POSITION = 77;
    public static final int TRIM = 78;
    public static final int STRINGENCODE = 79;
    public static final int STRINGDECODE = 80;
    public static final int STRINGTOUTF8 = 81;
    public static final int UTF8TOSTRING = 82;
    public static final int XMLATTR = 83;
    public static final int XMLNODE = 84;
    public static final int XMLCOMMENT = 85;
    public static final int XMLCDATA = 86;
    public static final int XMLSTARTDOC = 87;
    public static final int XMLTEXT = 88;
    public static final int REGEXP_REPLACE = 89;
    public static final int RPAD = 90;
    public static final int LPAD = 91;
    public static final int CONCAT_WS = 92;
    public static final int TO_CHAR = 93;
    public static final int TRANSLATE = 94;
    public static final int TO_DATE = 96;
    public static final int TO_TIMESTAMP = 97;
    public static final int ADD_MONTHS = 98;
    public static final int TO_TIMESTAMP_TZ = 99;
    public static final int CURRENT_DATE = 100;
    public static final int CURRENT_TIME = 101;
    public static final int LOCALTIME = 102;
    public static final int CURRENT_TIMESTAMP = 103;
    public static final int LOCALTIMESTAMP = 104;
    public static final int DATE_ADD = 105;
    public static final int DATE_DIFF = 106;
    public static final int DAY_NAME = 107;
    public static final int DAY_OF_MONTH = 108;
    public static final int DAY_OF_WEEK = 109;
    public static final int DAY_OF_YEAR = 110;
    public static final int HOUR = 111;
    public static final int MINUTE = 112;
    public static final int MONTH = 113;
    public static final int MONTH_NAME = 114;
    public static final int QUARTER = 115;
    public static final int SECOND = 116;
    public static final int WEEK = 117;
    public static final int YEAR = 118;
    public static final int EXTRACT = 119;
    public static final int FORMATDATETIME = 120;
    public static final int PARSEDATETIME = 121;
    public static final int ISO_YEAR = 122;
    public static final int ISO_WEEK = 123;
    public static final int ISO_DAY_OF_WEEK = 124;
    public static final int DATE_TRUNC = 125;
    public static final int MILLISECOND = 126;
    public static final int EPOCH = 127;
    public static final int MICROSECOND = 128;
    public static final int NANOSECOND = 129;
    public static final int TIMEZONE_HOUR = 130;
    public static final int TIMEZONE_MINUTE = 131;
    public static final int DECADE = 132;
    public static final int CENTURY = 133;
    public static final int MILLENNIUM = 134;
    public static final int DOW = 135;
    public static final int DATABASE = 150;
    public static final int USER = 151;
    public static final int CURRENT_USER = 152;
    public static final int IDENTITY = 153;
    public static final int SCOPE_IDENTITY = 154;
    public static final int AUTOCOMMIT = 155;
    public static final int READONLY = 156;
    public static final int DATABASE_PATH = 157;
    public static final int LOCK_TIMEOUT = 158;
    public static final int DISK_SPACE_USED = 159;
    public static final int SIGNAL = 160;
    public static final int ESTIMATED_ENVELOPE = 161;
    private static final Pattern SIGNAL_PATTERN = Pattern.compile("[0-9A-Z]{5}");
    public static final int IFNULL = 200;
    public static final int CASEWHEN = 201;
    public static final int CONVERT = 202;
    public static final int CAST = 203;
    public static final int COALESCE = 204;
    public static final int NULLIF = 205;
    public static final int CASE = 206;
    public static final int NEXTVAL = 207;
    public static final int CURRVAL = 208;
    public static final int ARRAY_GET = 209;
    public static final int CSVREAD = 210;
    public static final int CSVWRITE = 211;
    public static final int MEMORY_FREE = 212;
    public static final int MEMORY_USED = 213;
    public static final int LOCK_MODE = 214;
    public static final int SCHEMA = 215;
    public static final int SESSION_ID = 216;
    public static final int ARRAY_LENGTH = 217;
    public static final int LINK_SCHEMA = 218;
    public static final int GREATEST = 219;
    public static final int LEAST = 220;
    public static final int CANCEL_SESSION = 221;
    public static final int SET = 222;
    public static final int TABLE = 223;
    public static final int TABLE_DISTINCT = 224;
    public static final int FILE_READ = 225;
    public static final int TRANSACTION_ID = 226;
    public static final int TRUNCATE_VALUE = 227;
    public static final int NVL2 = 228;
    public static final int DECODE = 229;
    public static final int ARRAY_CONTAINS = 230;
    public static final int FILE_WRITE = 232;
    public static final int UNNEST = 233;
    public static final int ARRAY_CONCAT = 234;
    public static final int ARRAY_APPEND = 235;
    public static final int ARRAY_SLICE = 236;
    public static final int REGEXP_LIKE = 240;
    public static final int VALUES = 250;
    public static final int H2VERSION = 231;
    public static final int TRIM_LEADING = 1;
    public static final int TRIM_TRAILING = 2;
    protected static final int VAR_ARGS = -1;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap(256);
    private static final char[] SOUNDEX_INDEX = new char[128];
    protected Expression[] args;
    protected final FunctionInfo info;
    private ArrayList<Expression> varArgs;
    private int flags;
    protected TypeInfo type;
    private final Database database;

    public Function(Database database, FunctionInfo functionInfo) {
        this.database = database;
        this.info = functionInfo;
        if (functionInfo.parameterCount == -1) {
            this.varArgs = Utils.newSmallArrayList();
        } else {
            this.args = new Expression[functionInfo.parameterCount];
        }
    }

    private static void addFunction(String string, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FUNCTIONS.put(string, new FunctionInfo(string, n, n2, n3, bl, bl2, bl3, bl4));
    }

    private static void addFunctionNotDeterministic(String string, int n, int n2, int n3) {
        Function.addFunctionNotDeterministic(string, n, n2, n3, true);
    }

    private static void addFunctionNotDeterministic(String string, int n, int n2, int n3, boolean bl) {
        Function.addFunction(string, n, n2, n3, true, false, true, bl);
    }

    private static void addFunction(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, true, true, true, true);
    }

    private static void addFunctionWithNull(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, false, true, true, true);
    }

    public static Function getFunction(Database database, String string) {
        FunctionInfo functionInfo;
        if (!database.getSettings().databaseToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((functionInfo = FUNCTIONS.get(string)) == null) {
            switch (database.getMode().getEnum()) {
                case MSSQLServer: {
                    return FunctionsMSSQLServer.getFunction(database, string);
                }
                case MySQL: {
                    return FunctionsMySQL.getFunction(database, string);
                }
            }
            return null;
        }
        switch (functionInfo.type) {
            case 223: 
            case 224: 
            case 233: {
                return new TableFunction(database, functionInfo, Long.MAX_VALUE);
            }
        }
        return new Function(database, functionInfo);
    }

    public static FunctionInfo getFunctionInfo(String string) {
        return FUNCTIONS.get(string);
    }

    public void setParameter(int n, Expression expression) {
        if (this.varArgs != null) {
            this.varArgs.add(expression);
        } else {
            if (n >= this.args.length) {
                throw DbException.get(7001, this.info.name, Integer.toString(this.args.length));
            }
            this.args[n] = expression;
        }
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public Value getValue(Session session) {
        return this.getValueWithArgs(session, this.args);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Value getSimpleValue(Session session, Value value, Expression[] expressionArray, Value[] valueArray) {
        Expression expression;
        block112: {
            int n;
            int n2;
            switch (this.info.type) {
                case 0: {
                    return value.getSignum() >= 0 ? value : value.negate();
                }
                case 1: {
                    return ValueDouble.get(Math.acos(value.getDouble()));
                }
                case 2: {
                    return ValueDouble.get(Math.asin(value.getDouble()));
                }
                case 3: {
                    return ValueDouble.get(Math.atan(value.getDouble()));
                }
                case 8: {
                    return ValueDouble.get(Math.ceil(value.getDouble()));
                }
                case 9: {
                    return ValueDouble.get(Math.cos(value.getDouble()));
                }
                case 36: {
                    return ValueDouble.get(Math.cosh(value.getDouble()));
                }
                case 10: {
                    double d = Math.tan(value.getDouble());
                    if (d != 0.0) return ValueDouble.get(1.0 / d);
                    throw DbException.get(22012, this.getSQL(false));
                }
                case 11: {
                    return ValueDouble.get(Math.toDegrees(value.getDouble()));
                }
                case 12: {
                    return ValueDouble.get(Math.exp(value.getDouble()));
                }
                case 13: {
                    return ValueDouble.get(Math.floor(value.getDouble()));
                }
                case 39: {
                    return ValueDouble.get(Math.log(value.getDouble()));
                }
                case 14: {
                    if (!this.database.getMode().logIsLogBase10) return ValueDouble.get(Math.log(value.getDouble()));
                    return ValueDouble.get(Math.log10(value.getDouble()));
                }
                case 15: {
                    return ValueDouble.get(Math.log10(value.getDouble()));
                }
                case 17: {
                    return ValueDouble.get(Math.PI);
                }
                case 19: {
                    return ValueDouble.get(Math.toRadians(value.getDouble()));
                }
                case 20: {
                    if (value == null) return ValueDouble.get(session.getRandom().nextDouble());
                    session.getRandom().setSeed(value.getInt());
                    return ValueDouble.get(session.getRandom().nextDouble());
                }
                case 22: {
                    return ValueDouble.get(Function.roundMagic(value.getDouble()));
                }
                case 23: {
                    return ValueInt.get(value.getSignum());
                }
                case 24: {
                    return ValueDouble.get(Math.sin(value.getDouble()));
                }
                case 37: {
                    return ValueDouble.get(Math.sinh(value.getDouble()));
                }
                case 25: {
                    return ValueDouble.get(Math.sqrt(value.getDouble()));
                }
                case 26: {
                    return ValueDouble.get(Math.tan(value.getDouble()));
                }
                case 38: {
                    return ValueDouble.get(Math.tanh(value.getDouble()));
                }
                case 28: {
                    return ValueBytes.getNoCopy(MathUtils.secureRandomBytes(value.getInt()));
                }
                case 33: {
                    return ValueBytes.getNoCopy(CompressTool.getInstance().expand(value.getBytesNoCopy()));
                }
                case 34: {
                    return ValueInt.get(0);
                }
                case 35: {
                    return ValueUuid.getNewRandom();
                }
                case 50: {
                    String string = value.getString();
                    if (!string.isEmpty()) return ValueInt.get(string.charAt(0));
                    return ValueNull.INSTANCE;
                }
                case 51: {
                    return ValueLong.get(16L * Function.length(value));
                }
                case 52: {
                    return ValueString.get(String.valueOf((char)value.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 53: 
                case 61: {
                    return ValueLong.get(Function.length(value));
                }
                case 64: {
                    return ValueLong.get(2L * Function.length(value));
                }
                case 54: 
                case 92: {
                    Value value2 = ValueNull.INSTANCE;
                    int n3 = 0;
                    String string = "";
                    if (this.info.type == 92) {
                        n3 = 1;
                        string = Function.getNullOrValue(session, expressionArray, valueArray, 0).getString();
                    }
                    int n4 = n3;
                    while (true) {
                        if (n4 >= expressionArray.length) {
                            if (this.info.type != 92) return value2;
                            if (string == null) return value2;
                            if (value2 != ValueNull.INSTANCE) return value2;
                            return ValueString.get("", this.database.getMode().treatEmptyStringsAsNull);
                        }
                        Value value3 = Function.getNullOrValue(session, expressionArray, valueArray, n4);
                        if (value3 != ValueNull.INSTANCE) {
                            if (value2 == ValueNull.INSTANCE) {
                                value2 = value3;
                            } else {
                                String string2 = value3.getString();
                                if (!StringUtils.isNullOrEmpty(string) && !StringUtils.isNullOrEmpty(string2)) {
                                    string2 = string + string2;
                                }
                                value2 = ValueString.get(value2.getString() + string2, this.database.getMode().treatEmptyStringsAsNull);
                            }
                        }
                        ++n4;
                    }
                }
                case 56: {
                    return ValueString.get(Function.hexToRaw(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 59: 
                case 75: {
                    return ValueString.get(value.getString().toLowerCase(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 65: {
                    return ValueString.get(Function.rawToHex(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 70: {
                    return ValueString.get(Function.getSoundex(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 71: {
                    int n5 = Math.max(0, value.getInt());
                    char[] cArray = new char[n5];
                    int n6 = n5 - 1;
                    while (true) {
                        if (n6 < 0) {
                            return ValueString.get(new String(cArray), this.database.getMode().treatEmptyStringsAsNull);
                        }
                        cArray[n6] = 32;
                        --n6;
                    }
                }
                case 74: 
                case 76: {
                    return ValueString.get(value.getString().toUpperCase(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 79: {
                    return ValueString.get(StringUtils.javaEncode(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 80: {
                    return ValueString.get(StringUtils.javaDecode(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 81: {
                    return ValueBytes.getNoCopy(value.getString().getBytes(StandardCharsets.UTF_8));
                }
                case 82: {
                    return ValueString.get(new String(value.getBytesNoCopy(), StandardCharsets.UTF_8), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 85: {
                    return ValueString.get(StringUtils.xmlComment(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 86: {
                    return ValueString.get(StringUtils.xmlCData(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 87: {
                    return ValueString.get(StringUtils.xmlStartDoc(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 100: {
                    return (this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart()).convertTo(10);
                }
                case 101: 
                case 102: {
                    ValueTime valueTime = (ValueTime)(this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart()).convertTo(9);
                    return valueTime.convertScale(false, value == null ? 0 : value.getInt());
                }
                case 103: {
                    ValueTimestampTimeZone valueTimestampTimeZone = this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart();
                    return valueTimestampTimeZone.convertScale(false, value == null ? 6 : value.getInt());
                }
                case 104: {
                    Value value4 = (this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart()).convertTo(11);
                    return value4.convertScale(false, value == null ? 6 : value.getInt());
                }
                case 107: {
                    int n7 = DateTimeUtils.getSundayDayOfWeek(DateTimeUtils.dateAndTimeFromValue(value)[0]);
                    return ValueString.get(DateTimeFunctions.getMonthsAndWeeks(1)[n7], this.database.getMode().treatEmptyStringsAsNull);
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 122: 
                case 123: 
                case 124: {
                    return ValueInt.get(DateTimeFunctions.getIntDatePart(value, this.info.type, this.database.getMode()));
                }
                case 114: {
                    int n8 = DateTimeUtils.monthFromDateValue(DateTimeUtils.dateAndTimeFromValue(value)[0]);
                    return ValueString.get(DateTimeFunctions.getMonthsAndWeeks(0)[n8 - 1], this.database.getMode().treatEmptyStringsAsNull);
                }
                case 150: {
                    return ValueString.get(this.database.getShortName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 151: 
                case 152: {
                    return ValueString.get(session.getUser().getName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 153: {
                    return session.getLastIdentity();
                }
                case 154: {
                    return session.getLastScopeIdentity();
                }
                case 155: {
                    return ValueBoolean.get(session.getAutoCommit());
                }
                case 156: {
                    return ValueBoolean.get(this.database.isReadOnly());
                }
                case 157: {
                    String string = this.database.getDatabasePath();
                    return string == null ? ValueNull.INSTANCE : ValueString.get(string, this.database.getMode().treatEmptyStringsAsNull);
                }
                case 158: {
                    return ValueInt.get(session.getLockTimeout());
                }
                case 159: {
                    return ValueLong.get(Function.getDiskSpaceUsed(session, value));
                }
                case 161: {
                    return Function.getEstimatedEnvelope(session, value, valueArray[1]);
                }
                case 202: 
                case 203: {
                    Mode mode = this.database.getMode();
                    TypeInfo typeInfo = this.type;
                    value = value.convertTo(typeInfo, mode, null);
                    value = value.convertScale(mode.convertOnlyToSmallerScale, typeInfo.getScale());
                    return value = value.convertPrecision(typeInfo.getPrecision(), false);
                }
                case 212: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryFree());
                }
                case 213: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryUsed());
                }
                case 214: {
                    return ValueInt.get(this.database.getLockMode());
                }
                case 215: {
                    return ValueString.get(session.getCurrentSchemaName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 216: {
                    return ValueInt.get(session.getId());
                }
                case 200: {
                    Value value2 = value;
                    if (value != ValueNull.INSTANCE) return value2.convertTo(this.type, this.database.getMode(), null);
                    value2 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value2.convertTo(this.type, this.database.getMode(), null);
                }
                case 201: {
                    Value value5 = !value.getBoolean() ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value5.convertTo(this.type, this.database.getMode(), null);
                }
                case 229: {
                    int n9 = -1;
                    int n10 = expressionArray.length - 1;
                    for (int i = 1; i < n10; i += 2) {
                        if (!this.database.areEqual(value, Function.getNullOrValue(session, expressionArray, valueArray, i))) continue;
                        n9 = i + 1;
                        break;
                    }
                    if (n9 < 0 && expressionArray.length % 2 == 0) {
                        n9 = expressionArray.length - 1;
                    }
                    ValueNull valueNull = n9 < 0 ? ValueNull.INSTANCE : Function.getNullOrValue(session, expressionArray, valueArray, n9);
                    return valueNull.convertTo(this.type, this.database.getMode(), null);
                }
                case 228: {
                    Value value6 = value == ValueNull.INSTANCE ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value6.convertTo(this.type, this.database.getMode(), null);
                }
                case 204: {
                    Value value2 = value;
                    int n11 = 0;
                    while (n11 < expressionArray.length) {
                        Value value7 = Function.getNullOrValue(session, expressionArray, valueArray, n11);
                        if (value7 != ValueNull.INSTANCE) {
                            return value7.convertTo(this.type, this.database.getMode(), null);
                        }
                        ++n11;
                    }
                    return value2;
                }
                case 219: 
                case 220: {
                    Value value2 = ValueNull.INSTANCE;
                    int n12 = 0;
                    while (n12 < expressionArray.length) {
                        Value value8 = Function.getNullOrValue(session, expressionArray, valueArray, n12);
                        if (value8 != ValueNull.INSTANCE) {
                            value8 = value8.convertTo(this.type, this.database.getMode(), null);
                            if (value2 == ValueNull.INSTANCE) {
                                value2 = value8;
                            } else {
                                int n13 = this.database.compareTypeSafe(value2, value8);
                                if (this.info.type == 219 && n13 < 0) {
                                    value2 = value8;
                                } else if (this.info.type == 220 && n13 > 0) {
                                    value2 = value8;
                                }
                            }
                        }
                        ++n12;
                    }
                    return value2;
                }
                case 206: {
                    expression = null;
                    if (value == null) {
                        n2 = expressionArray.length - 1;
                        break;
                    }
                    if (value == ValueNull.INSTANCE) break block112;
                    int n14 = expressionArray.length - 1;
                    for (n = 1; n < n14; n += 2) {
                        Value value9 = expressionArray[n].getValue(session);
                        if (!this.database.areEqual(value, value9)) continue;
                        expression = expressionArray[n + 1];
                        break block112;
                    }
                    break block112;
                }
                case 209: {
                    Value[] valueArray2 = Function.getArray(value);
                    if (valueArray2 == null) {
                        return ValueNull.INSTANCE;
                    }
                    Value value10 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    int n15 = value10.getInt();
                    if (n15 < 1) return ValueNull.INSTANCE;
                    if (n15 > valueArray2.length) return ValueNull.INSTANCE;
                    return valueArray2[n15 - 1];
                }
                case 217: {
                    Value[] valueArray3 = Function.getArray(value);
                    if (valueArray3 == null) return ValueNull.INSTANCE;
                    return ValueInt.get(valueArray3.length);
                }
                case 230: {
                    Value value2 = ValueBoolean.FALSE;
                    Value[] valueArray4 = Function.getArray(value);
                    if (valueArray4 == null) {
                        return ValueNull.INSTANCE;
                    }
                    Value value11 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    Value[] valueArray5 = valueArray4;
                    int n16 = valueArray5.length;
                    int n17 = 0;
                    while (n17 < n16) {
                        Value value12 = valueArray5[n17];
                        if (this.database.areEqual(value12, value11)) {
                            return ValueBoolean.TRUE;
                        }
                        ++n17;
                    }
                    return value2;
                }
                case 221: {
                    return ValueBoolean.get(Function.cancelStatement(session, value.getInt()));
                }
                case 226: {
                    return session.getTransactionId();
                }
                default: {
                    return null;
                }
            }
            for (n = 1; n < n2; n += 2) {
                Value value13 = expressionArray[n].getValue(session);
                if (!value13.getBoolean()) continue;
                expression = expressionArray[n + 1];
                break;
            }
        }
        if (expression == null && expressionArray.length % 2 == 0) {
            expression = expressionArray[expressionArray.length - 1];
        }
        ValueNull valueNull = expression == null ? ValueNull.INSTANCE : expression.getValue(session);
        return valueNull.convertTo(this.type, this.database.getMode(), null);
    }

    private static Value[] getArray(Value value) {
        int n = value.getValueType();
        Object object = n == 17 || n == 39 ? ((ValueCollectionBase)value).getList() : null;
        return object;
    }

    private static boolean cancelStatement(Session session, int n) {
        Session[] sessionArray;
        session.getUser().checkAdmin();
        for (Session session2 : sessionArray = session.getDatabase().getSessions(false)) {
            if (session2.getId() != n) continue;
            Command command = session2.getCurrentCommand();
            if (command == null) {
                return false;
            }
            command.cancel();
            return true;
        }
        return false;
    }

    private static long getDiskSpaceUsed(Session session, Value value) {
        return Function.getTable(session, value).getDiskSpaceUsed();
    }

    private static Value getEstimatedEnvelope(Session session, Value value, Value value2) {
        Table table = Function.getTable(session, value);
        Column column = table.getColumn(value2.getString());
        ArrayList<Index> arrayList = table.getIndexes();
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 1; i < n; ++i) {
                Index index = arrayList.get(i);
                if (!(index instanceof MVSpatialIndex) || !index.isFirstColumn(column)) continue;
                return ((MVSpatialIndex)index).getEstimatedBounds(session);
            }
        }
        return ValueNull.INSTANCE;
    }

    private static Table getTable(Session session, Value value) {
        return new Parser(session).parseTableName(value.getString());
    }

    protected static Value getNullOrValue(Session session, Expression[] expressionArray, Value[] valueArray, int n) {
        if (n >= expressionArray.length) {
            return null;
        }
        Value value = valueArray[n];
        if (value == null) {
            Expression expression = expressionArray[n];
            if (expression == null) {
                return null;
            }
            value = valueArray[n] = expression.getValue(session);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Value getValueWithArgs(Session var1_1, Expression[] var2_2) {
        var3_3 = new Value[var2_2.length];
        if (this.info.nullIfParameterIsNull) {
            for (var4_4 = 0; var4_4 < var2_2.length; ++var4_4) {
                var5_6 = var2_2[var4_4];
                var6_7 = var5_6.getValue(var1_1);
                if (var6_7 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                var3_3[var4_4] = var6_7;
            }
        }
        if ((var5_6 = this.getSimpleValue(var1_1, var4_5 = Function.getNullOrValue(var1_1, var2_2, var3_3, 0), var2_2, var3_3)) != null) {
            return var5_6;
        }
        var6_7 = Function.getNullOrValue(var1_1, var2_2, var3_3, 1);
        var7_8 = Function.getNullOrValue(var1_1, var2_2, var3_3, 2);
        var8_9 = Function.getNullOrValue(var1_1, var2_2, var3_3, 3);
        var9_10 = Function.getNullOrValue(var1_1, var2_2, var3_3, 4);
        var10_11 = Function.getNullOrValue(var1_1, var2_2, var3_3, 5);
        block10 : switch (this.info.type) {
            case 4: {
                var11_12 = ValueDouble.get(Math.atan2(var4_5.getDouble(), var6_7.getDouble()));
                break;
            }
            case 5: {
                var11_12 = ValueLong.get(var4_5.getLong() & var6_7.getLong());
                break;
            }
            case 40: {
                var11_12 = ValueBoolean.get((var4_5.getLong() & 1L << var6_7.getInt()) != 0L);
                break;
            }
            case 6: {
                var11_12 = ValueLong.get(var4_5.getLong() | var6_7.getLong());
                break;
            }
            case 7: {
                var11_12 = ValueLong.get(var4_5.getLong() ^ var6_7.getLong());
                break;
            }
            case 16: {
                var12_13 = var6_7.getLong();
                if (var12_13 == 0L) {
                    throw DbException.get(22012, this.getSQL(false));
                }
                var11_12 = ValueLong.get(var4_5.getLong() % var12_13);
                break;
            }
            case 18: {
                var11_12 = ValueDouble.get(Math.pow(var4_5.getDouble(), var6_7.getDouble()));
                break;
            }
            case 21: {
                var12_14 = var6_7 == null ? 1.0 : Math.pow(10.0, var6_7.getDouble());
                var14_16 = var4_5.getDouble() * var12_14;
                var16_18 = var14_16 > 0.0 ? 1 : -1;
                var11_12 = ValueDouble.get((double)Math.round(Math.abs(var14_16)) / var12_14 * (double)var16_18);
                break;
            }
            case 27: {
                if (var4_5.getValueType() == 11) {
                    var11_12 = ValueTimestamp.fromDateValueAndNanos(((ValueTimestamp)var4_5).getDateValue(), 0L);
                    break;
                }
                if (var4_5.getValueType() == 10) {
                    var11_12 = ValueTimestamp.fromDateValueAndNanos(((ValueDate)var4_5).getDateValue(), 0L);
                    break;
                }
                if (var4_5.getValueType() == 24) {
                    var17_26 = (ValueTimestampTimeZone)var4_5;
                    var11_12 = ValueTimestampTimeZone.fromDateValueAndNanos(var17_26.getDateValue(), 0L, var17_26.getTimeZoneOffsetMins());
                    break;
                }
                if (var4_5.getValueType() == 13) {
                    var17_27 = ValueTimestamp.parse(var4_5.getString(), var1_1.getDatabase().getMode());
                    var11_12 = ValueTimestamp.fromDateValueAndNanos(var17_27.getDateValue(), 0L);
                    break;
                }
                var12_15 = var4_5.getDouble();
                var18_53 = var6_7 == null ? 0 : var6_7.getInt();
                var19_66 = Math.pow(10.0, var18_53);
                var21_67 = var12_15 * var19_66;
                var11_12 = ValueDouble.get((var12_15 < 0.0 ? Math.ceil(var21_67) : Math.floor(var21_67)) / var19_66);
                break;
            }
            case 29: {
                var11_12 = Function.getHash(var4_5.getString(), var6_7, var7_8 == null ? 1 : var7_8.getInt());
                break;
            }
            case 30: {
                var11_12 = ValueBytes.getNoCopy(Function.encrypt(var4_5.getString(), var6_7.getBytesNoCopy(), var7_8.getBytesNoCopy()));
                break;
            }
            case 31: {
                var11_12 = ValueBytes.getNoCopy(Function.decrypt(var4_5.getString(), var6_7.getBytesNoCopy(), var7_8.getBytesNoCopy()));
                break;
            }
            case 32: {
                var17_28 = null;
                if (var6_7 != null) {
                    var17_28 = var6_7.getString();
                }
                var11_12 = ValueBytes.getNoCopy(CompressTool.getInstance().compress(var4_5.getBytesNoCopy(), var17_28));
                break;
            }
            case 41: {
                var11_12 = Function.oraHash(var4_5, var6_7 == null ? 0xFFFFFFFFL : var6_7.getLong(), var7_8 == null ? 0L : var7_8.getLong());
                break;
            }
            case 55: {
                var11_12 = ValueInt.get(Function.getDifference(var4_5.getString(), var6_7.getString()));
                break;
            }
            case 57: {
                if (var6_7 == ValueNull.INSTANCE || var7_8 == ValueNull.INSTANCE) {
                    var11_12 = var6_7;
                    break;
                }
                var11_12 = ValueString.get(Function.insert(var4_5.getString(), var6_7.getInt(), var7_8.getInt(), var8_9.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 60: {
                var11_12 = ValueString.get(Function.left(var4_5.getString(), var6_7.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 62: {
                var17_29 = var7_8 == null ? 0 : var7_8.getInt();
                var11_12 = ValueInt.get(Function.locate(var4_5.getString(), var6_7.getString(), var17_29));
                break;
            }
            case 58: {
                var17_30 = var7_8 == null ? 0 : var7_8.getInt();
                var11_12 = ValueInt.get(Function.locate(var6_7.getString(), var4_5.getString(), var17_30));
                break;
            }
            case 66: {
                var17_31 = Math.max(0, var6_7.getInt());
                var11_12 = ValueString.get(Function.repeat(var4_5.getString(), var17_31), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 67: {
                if (var4_5 == ValueNull.INSTANCE || var6_7 == ValueNull.INSTANCE || var7_8 == ValueNull.INSTANCE && this.database.getMode().getEnum() != Mode.ModeEnum.Oracle) {
                    var11_12 = ValueNull.INSTANCE;
                    break;
                }
                var17_32 = var4_5.getString();
                var23_68 = var6_7.getString();
                v0 = var18_54 = var7_8 == null ? "" : var7_8.getString();
                if (var18_54 == null) {
                    var18_54 = "";
                }
                var11_12 = ValueString.get(StringUtils.replaceAll(var17_32, var23_68, var18_54), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 68: {
                var11_12 = ValueString.get(Function.right(var4_5.getString(), var6_7.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 63: {
                var11_12 = ValueString.get(StringUtils.trim(var4_5.getString(), true, false, var6_7 == null ? " " : var6_7.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 78: {
                var11_12 = ValueString.get(StringUtils.trim(var4_5.getString(), (this.flags & 1) != 0, (this.flags & 2) != 0, var6_7 == null ? " " : var6_7.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 69: {
                var11_12 = ValueString.get(StringUtils.trim(var4_5.getString(), false, true, var6_7 == null ? " " : var6_7.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 72: 
            case 73: {
                var17_33 = var4_5.getString();
                var23_69 = var6_7.getInt();
                if (var23_69 < 0) {
                    var23_69 = var17_33.length() + var23_69 + 1;
                }
                var18_55 = var7_8 == null ? var17_33.length() : var7_8.getInt();
                var11_12 = ValueString.get(Function.substring(var17_33, var23_69, var18_55), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 77: {
                var11_12 = ValueInt.get(Function.locate(var4_5.getString(), var6_7.getString(), 0));
                break;
            }
            case 83: {
                var11_12 = ValueString.get(StringUtils.xmlAttr(var4_5.getString(), var6_7.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 84: {
                v1 = var6_7 == null ? null : (var17_34 = var6_7 == ValueNull.INSTANCE ? null : var6_7.getString());
                var23_70 = var7_8 == null ? null : (var7_8 == ValueNull.INSTANCE ? null : var7_8.getString());
                var18_56 = var8_9 == null ? true : var8_9.getBoolean();
                var11_12 = ValueString.get(StringUtils.xmlNode(var4_5.getString(), var17_34, var23_70, var18_56), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 89: {
                var17_35 = var4_5.getString();
                var23_71 = var6_7.getString();
                var18_57 = var7_8.getString();
                var24_88 = var8_9 != null ? var8_9.getString() : null;
                var11_12 = this.regexpReplace(var17_35, var23_71, var18_57, var24_88);
                break;
            }
            case 90: {
                var11_12 = ValueString.get(StringUtils.pad(var4_5.getString(), var6_7.getInt(), var7_8 == null ? null : var7_8.getString(), true), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 91: {
                var11_12 = ValueString.get(StringUtils.pad(var4_5.getString(), var6_7.getInt(), var7_8 == null ? null : var7_8.getString(), false), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 93: {
                switch (var4_5.getValueType()) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 24: {
                        var11_12 = ValueString.get(ToChar.toCharDateTime(var4_5, var6_7 == null ? null : var6_7.getString(), var7_8 == null ? null : var7_8.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block10;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        var11_12 = ValueString.get(ToChar.toChar(var4_5.getBigDecimal(), var6_7 == null ? null : var6_7.getString(), var7_8 == null ? null : var7_8.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block10;
                    }
                }
                var11_12 = ValueString.get(var4_5.getString(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 96: {
                var11_12 = ToDateParser.toDate(var1_1, var4_5.getString(), var6_7 == null ? null : var6_7.getString());
                break;
            }
            case 97: {
                var11_12 = ToDateParser.toTimestamp(var1_1, var4_5.getString(), var6_7 == null ? null : var6_7.getString());
                break;
            }
            case 98: {
                var11_12 = DateTimeFunctions.dateadd("MONTH", var6_7.getInt(), var4_5);
                break;
            }
            case 99: {
                var11_12 = ToDateParser.toTimestampTz(var1_1, var4_5.getString(), var6_7 == null ? null : var6_7.getString());
                break;
            }
            case 94: {
                var17_36 = var6_7.getString();
                var23_72 = var7_8.getString();
                var11_12 = ValueString.get(Function.translate(var4_5.getString(), var17_36, var23_72), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 231: {
                var11_12 = ValueString.get(Constants.getVersion(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 105: {
                var11_12 = DateTimeFunctions.dateadd(var4_5.getString(), var6_7.getLong(), var7_8);
                break;
            }
            case 106: {
                var11_12 = ValueLong.get(DateTimeFunctions.datediff(var4_5.getString(), var6_7, var7_8));
                break;
            }
            case 125: {
                var11_12 = DateTimeFunctions.truncateDate(var4_5.getString(), var6_7);
                break;
            }
            case 119: {
                var11_12 = DateTimeFunctions.extract(var4_5.getString(), var6_7, this.database.getMode());
                break;
            }
            case 120: {
                if (var4_5 == ValueNull.INSTANCE || var6_7 == ValueNull.INSTANCE) {
                    var11_12 = ValueNull.INSTANCE;
                    break;
                }
                v2 = var7_8 == null ? null : (var17_37 = var7_8 == ValueNull.INSTANCE ? null : var7_8.getString());
                v3 = var8_9 == null ? null : (var23_73 = var8_9 == ValueNull.INSTANCE ? null : var8_9.getString());
                if (var4_5 instanceof ValueTimestampTimeZone) {
                    var23_73 = DateTimeUtils.timeZoneNameFromOffsetMins(((ValueTimestampTimeZone)var4_5).getTimeZoneOffsetMins());
                }
                var11_12 = ValueString.get(DateTimeFunctions.formatDateTime(var4_5.getTimestamp(), var6_7.getString(), var17_37, var23_73), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 121: {
                if (var4_5 == ValueNull.INSTANCE || var6_7 == ValueNull.INSTANCE) {
                    var11_12 = ValueNull.INSTANCE;
                    break;
                }
                v4 = var7_8 == null ? null : (var17_38 = var7_8 == ValueNull.INSTANCE ? null : var7_8.getString());
                var23_74 = var8_9 == null ? null : (var8_9 == ValueNull.INSTANCE ? null : var8_9.getString());
                var18_58 = DateTimeFunctions.parseDateTime(var4_5.getString(), var6_7.getString(), var17_38, var23_74);
                var11_12 = ValueTimestamp.fromMillis(var18_58.getTime());
                break;
            }
            case 205: {
                var11_12 = this.database.areEqual(var4_5, var6_7) != false ? ValueNull.INSTANCE : var4_5;
                break;
            }
            case 207: {
                var17_39 = this.getSequence(var1_1, var4_5, var6_7);
                var23_75 = new SequenceValue(var17_39);
                var11_12 = var23_75.getValue(var1_1);
                break;
            }
            case 208: {
                var17_40 = this.getSequence(var1_1, var4_5, var6_7);
                var11_12 = ValueLong.get(var17_40.getCurrentValue());
                break;
            }
            case 210: {
                var17_41 = var4_5.getString();
                var23_76 = var6_7 == null ? null : var6_7.getString();
                var18_59 = new Csv();
                var24_89 = var7_8 == null ? null : var7_8.getString();
                var16_19 = null;
                if (var24_89 != null && var24_89.indexOf(61) >= 0) {
                    var16_19 = var18_59.setOptions(var24_89);
                } else {
                    var16_19 = var24_89;
                    var25_94 = var8_9 == null ? null : var8_9.getString();
                    var26_98 = var9_10 == null ? null : var9_10.getString();
                    var27_100 = var10_11 == null ? null : var10_11.getString();
                    var28_103 = Function.getNullOrValue(var1_1, var2_2, var3_3, 6);
                    var29_105 = var28_103 == null ? null : var28_103.getString();
                    Function.setCsvDelimiterEscape(var18_59, var25_94, (String)var26_98, var27_100);
                    var18_59.setNullString(var29_105);
                }
                var25_95 = var18_59.getFieldSeparatorRead();
                var26_98 = StringUtils.arraySplit(var23_76, var25_95, true);
                try {
                    var11_12 = ValueResultSet.get(var1_1, var18_59.read(var17_41, var26_98, var16_19), 0x7FFFFFFF);
                    break;
                }
                catch (SQLException var27_101) {
                    throw DbException.convert(var27_101);
                }
            }
            case 234: {
                var17_42 = (ValueArray)var4_5.convertTo(17);
                var23_77 = (ValueArray)var6_7.convertTo(17);
                if (!var17_42.getComponentType().equals(var23_77.getComponentType())) {
                    throw DbException.get(50000, "Expected component type " + var17_42.getComponentType() + " but got " + var23_77.getComponentType());
                }
                var18_60 = Arrays.copyOf(var17_42.getList(), var17_42.getList().length + var23_77.getList().length);
                System.arraycopy(var23_77.getList(), 0, var18_60, var17_42.getList().length, var23_77.getList().length);
                var11_12 = ValueArray.get(var17_42.getComponentType(), var18_60);
                break;
            }
            case 235: {
                var17_43 = (ValueArray)var4_5.convertTo(17);
                if (var6_7 != ValueNull.INSTANCE && var17_43.getComponentType() != Object.class && !var17_43.getComponentType().isInstance(var6_7.getObject())) {
                    throw DbException.get(50000, "Expected component type " + var17_43.getComponentType() + " but got " + var6_7.getClass());
                }
                var23_78 = Arrays.copyOf(var17_43.getList(), var17_43.getList().length + 1);
                var23_78[var17_43.getList().length] = var6_7;
                var11_12 = ValueArray.get(var17_43.getComponentType(), var23_78);
                break;
            }
            case 236: {
                var11_12 = null;
                var17_44 = (ValueArray)var4_5.convertTo(17);
                var23_79 = var6_7.getInt() - 1;
                var18_61 = var7_8.getInt();
                v5 = var24_90 = this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL;
                if (var23_79 > var18_61) {
                    var11_12 = var24_90 ? ValueArray.get(var17_44.getComponentType(), new Value[0]) : ValueNull.INSTANCE;
                } else {
                    if (var23_79 < 0) {
                        if (var24_90) {
                            var23_79 = 0;
                        } else {
                            var11_12 = ValueNull.INSTANCE;
                        }
                    }
                    if (var18_61 > var17_44.getList().length) {
                        if (var24_90) {
                            var18_61 = var17_44.getList().length;
                        } else {
                            var11_12 = ValueNull.INSTANCE;
                        }
                    }
                }
                if (var11_12 != null) break;
                var11_12 = ValueArray.get(var17_44.getComponentType(), Arrays.copyOfRange(var17_44.getList(), var23_79, var18_61));
                break;
            }
            case 218: {
                var1_1.getUser().checkAdmin();
                var17_45 = var1_1.createConnection(false);
                var23_80 = LinkSchema.linkSchema(var17_45, var4_5.getString(), var6_7.getString(), var7_8.getString(), var8_9.getString(), var9_10.getString(), var10_11.getString());
                var11_12 = ValueResultSet.get(var1_1, var23_80, 0x7FFFFFFF);
                break;
            }
            case 211: {
                var1_1.getUser().checkAdmin();
                var17_46 = var1_1.createConnection(false);
                var23_81 = new Csv();
                var18_62 = var7_8 == null ? null : var7_8.getString();
                var24_91 = null;
                if (var18_62 != null && var18_62.indexOf(61) >= 0) {
                    var24_91 = var23_81.setOptions(var18_62);
                } else {
                    var24_91 = var18_62;
                    var16_20 = var8_9 == null ? null : var8_9.getString();
                    var25_96 = var9_10 == null ? null : var9_10.getString();
                    var26_99 = var10_11 == null ? null : var10_11.getString();
                    var27_102 = Function.getNullOrValue(var1_1, var2_2, var3_3, 6);
                    var28_104 = var27_102 == null ? null : var27_102.getString();
                    var29_106 = Function.getNullOrValue(var1_1, var2_2, var3_3, 7);
                    var30_107 = var29_106 == null ? null : var29_106.getString();
                    Function.setCsvDelimiterEscape(var23_81, var16_20, var25_96, var26_99);
                    var23_81.setNullString(var28_104);
                    if (var30_107 != null) {
                        var23_81.setLineSeparator(var30_107);
                    }
                }
                try {
                    var16_21 = var23_81.write(var17_46, var4_5.getString(), var6_7.getString(), var24_91);
                    var11_12 = ValueInt.get(var16_21);
                    break;
                }
                catch (SQLException var16_22) {
                    throw DbException.convert(var16_22);
                }
            }
            case 222: {
                var17_47 = (Variable)var2_2[0];
                var1_1.setVariable(var17_47.getName(), var6_7);
                var11_12 = var6_7;
                break;
            }
            case 225: {
                var1_1.getUser().checkAdmin();
                var17_48 = var4_5.getString();
                var23_82 = var2_2.length == 1;
                try {
                    var14_17 = FileUtils.size(var17_48);
                    var16_23 = FileUtils.newInputStream(var17_48);
                    try {
                        if (var23_82) {
                            var11_12 = this.database.getLobStorage().createBlob(var16_23, var14_17);
                        } else {
                            var25_97 = var6_7 == ValueNull.INSTANCE ? new InputStreamReader(var16_23) : new InputStreamReader(var16_23, var6_7.getString());
                            var11_12 = this.database.getLobStorage().createClob(var25_97, var14_17);
                        }
                    }
                    finally {
                        IOUtils.closeSilently(var16_23);
                    }
                    var1_1.addTemporaryLob(var11_12);
                    break;
                }
                catch (IOException var18_63) {
                    throw DbException.convertIOException(var18_63, var17_48);
                }
            }
            case 232: {
                var1_1.getUser().checkAdmin();
                var11_12 = ValueNull.INSTANCE;
                var17_49 = var6_7.getString();
                try {
                    var23_83 = new FileOutputStream(var17_49);
                    var18_64 = var4_5.getInputStream();
                    var24_92 = null;
                    var11_12 = ValueLong.get(IOUtils.copyAndClose(var18_64, var23_83));
                    if (var18_64 == null) break;
                    if (var24_92 == null) ** GOTO lbl380
                    try {
                        var18_64.close();
                    }
                    catch (Throwable var16_24) {
                        var24_92.addSuppressed(var16_24);
                    }
                    break;
lbl380:
                    // 1 sources

                    var18_64.close();
                    ** break;
                    catch (Throwable var16_25) {
                        try {
                            var24_92 = var16_25;
                            throw var16_25;
                        }
                        catch (Throwable var32_109) {
                            if (var18_64 != null) {
                                if (var24_92 != null) {
                                    try {
                                        var18_64.close();
                                    }
                                    catch (Throwable var33_110) {
                                        var24_92.addSuppressed(var33_110);
                                    }
                                } else {
                                    var18_64.close();
                                }
                            }
                            throw var32_109;
lbl397:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException var23_84) {
                    throw DbException.convertIOException(var23_84, var17_49);
                }
            }
            case 227: {
                var11_12 = var4_5.convertPrecision(var6_7.getLong(), var7_8.getBoolean());
                break;
            }
            case 88: {
                if (var6_7 == null) {
                    var11_12 = ValueString.get(StringUtils.xmlText(var4_5.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    break;
                }
                var11_12 = ValueString.get(StringUtils.xmlText(var4_5.getString(), var6_7.getBoolean()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 240: {
                var17_50 = var6_7.getString();
                var23_85 = var7_8 != null ? var7_8.getString() : null;
                var18_65 = Function.makeRegexpFlags(var23_85, false);
                try {
                    var11_12 = ValueBoolean.get(Pattern.compile(var17_50, var18_65).matcher(var4_5.getString()).find());
                    break;
                }
                catch (PatternSyntaxException var24_93) {
                    throw DbException.get(22025, var24_93, new String[]{var17_50});
                }
            }
            case 250: {
                var17_51 = var2_2[0];
                var23_86 = new StringBuilder();
                Parser.quoteIdentifier(var23_86, var17_51.getSchemaName(), true).append('.');
                Parser.quoteIdentifier(var23_86, var17_51.getTableName(), true).append('.');
                Parser.quoteIdentifier(var23_86, var17_51.getColumnName(), true);
                var11_12 = var1_1.getVariable(var23_86.toString());
                break;
            }
            case 160: {
                var17_52 = var4_5.getString();
                if (var17_52.startsWith("00") || !Function.SIGNAL_PATTERN.matcher(var17_52).matches()) {
                    throw DbException.getInvalidValueException("SQLSTATE", var17_52);
                }
                var23_87 = var6_7.getString();
                throw DbException.fromUser(var17_52, var23_87);
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return var11_12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sequence getSequence(Session session, Value value, Value value2) {
        Object object;
        String string;
        Object object2;
        Object object3;
        if (value2 == null) {
            object3 = new Parser(session);
            object2 = value.getString();
            Expression expression = ((Parser)object3).parseExpression((String)object2);
            if (!(expression instanceof ExpressionColumn)) throw DbException.getSyntaxError((String)object2, 1);
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            string = expressionColumn.getOriginalTableAliasName();
            if (string == null) {
                string = session.getCurrentSchemaName();
                object = object2;
            } else {
                object = expressionColumn.getColumnName();
            }
        } else {
            string = value.getString();
            object = value2.getString();
        }
        if ((object3 = this.database.findSchema(string)) == null) {
            string = StringUtils.toUpperEnglish(string);
            object3 = this.database.getSchema(string);
        }
        if ((object2 = ((Schema)object3).findSequence((String)object)) != null) return object2;
        object = StringUtils.toUpperEnglish((String)object);
        return ((Schema)object3).getSequence((String)object);
    }

    private static long length(Value value) {
        switch (value.getValueType()) {
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                return value.getType().getPrecision();
            }
        }
        return value.getString().length();
    }

    private static byte[] getPaddedArrayCopy(byte[] byArray, int n) {
        int n2 = MathUtils.roundUpInt(byArray.length, n);
        return Utils.copyBytes(byArray, n2);
    }

    private static byte[] decrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.decrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static byte[] encrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.encrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static Value getHash(String string, Value value, int n) {
        if (!"SHA256".equalsIgnoreCase(string)) {
            throw DbException.getInvalidValueException("algorithm", string);
        }
        if (n <= 0) {
            throw DbException.getInvalidValueException("iterations", n);
        }
        MessageDigest messageDigest = Function.hashImpl(value, "SHA-256");
        if (messageDigest == null) {
            return ValueNull.INSTANCE;
        }
        byte[] byArray = messageDigest.digest();
        for (int i = 1; i < n; ++i) {
            byArray = messageDigest.digest(byArray);
        }
        return ValueBytes.getNoCopy(byArray);
    }

    private static String substring(String string, int n, int n2) {
        int n3 = string.length();
        if (--n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = n = n > n3 ? n3 : n;
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(n, n + n2);
    }

    private static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        while (n-- > 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String rawToHex(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(4 * n);
        for (int i = 0; i < n; ++i) {
            String string2 = Integer.toHexString(string.charAt(i) & 0xFFFF);
            for (int j = string2.length(); j < 4; ++j) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static int locate(String string, String string2, int n) {
        if (n < 0) {
            int n2 = string2.length() + n;
            return string2.lastIndexOf(string, n2) + 1;
        }
        int n3 = n == 0 ? 0 : n - 1;
        return string2.indexOf(string, n3) + 1;
    }

    private static String right(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(string.length() - n);
    }

    private static String left(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    private static String insert(String string, int n, int n2, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (--n < 0 || n2 <= 0 || n4 == 0 || n > n3) {
            return string;
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(0, n) + string2 + string.substring(n + n2);
    }

    private static String hexToRaw(String string) {
        int n = string.length();
        if (n % 4 != 0) {
            throw DbException.get(22018, string);
        }
        StringBuilder stringBuilder = new StringBuilder(n / 4);
        for (int i = 0; i < n; i += 4) {
            try {
                char c = (char)Integer.parseInt(string.substring(i, i + 4), 16);
                stringBuilder.append(c);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw DbException.get(22018, string);
            }
        }
        return stringBuilder.toString();
    }

    private static int getDifference(String string, String string2) {
        string = Function.getSoundex(string);
        string2 = Function.getSoundex(string2);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (string.charAt(i) != string2.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    private static String translate(String string, String string2, String string3) {
        if (StringUtils.isNullOrEmpty(string) || StringUtils.isNullOrEmpty(string2)) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n = string3 == null ? 0 : string3.length();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = string2.indexOf(c);
            if (n3 >= 0) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n2);
                    if (i > 0) {
                        stringBuilder.append(string, 0, i);
                    }
                }
                if (n3 < n) {
                    c = string3.charAt(n3);
                }
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    private static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(d);
        if (stringBuilder.toString().indexOf(69) >= 0) {
            return d;
        }
        int n = stringBuilder.length();
        if (n < 16) {
            return d;
        }
        if (stringBuilder.toString().indexOf(46) > n - 3) {
            return d;
        }
        stringBuilder.delete(n - 2, n);
        char c = stringBuilder.charAt((n -= 2) - 2);
        char c2 = stringBuilder.charAt(n - 3);
        char c3 = stringBuilder.charAt(n - 4);
        if (c == '0' && c2 == '0' && c3 == '0') {
            stringBuilder.setCharAt(n - 1, '0');
        } else if (c == '9' && c2 == '9' && c3 == '9') {
            stringBuilder.setCharAt(n - 1, '9');
            stringBuilder.append('9');
            stringBuilder.append('9');
            stringBuilder.append('9');
        }
        return Double.parseDouble(stringBuilder.toString());
    }

    private static String getSoundex(String string) {
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        char c = '0';
        int n2 = 0;
        for (int i = 0; i < n && n2 < 4; ++i) {
            char c2;
            char c3 = string.charAt(i);
            char c4 = c2 = c3 > SOUNDEX_INDEX.length ? (char)'\u0000' : SOUNDEX_INDEX[c3];
            if (c2 == '\u0000') continue;
            if (n2 == 0) {
                cArray[n2++] = c3;
                c = c2;
                continue;
            }
            if (c2 <= '6') {
                if (c2 == c) continue;
                cArray[n2++] = c2;
                c = c2;
                continue;
            }
            if (c2 != '7') continue;
            c = c2;
        }
        return new String(cArray);
    }

    private static Value oraHash(Value value, long l, long l2) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("bucket", l);
        }
        if ((l2 & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("seed", l2);
        }
        MessageDigest messageDigest = Function.hashImpl(value, "SHA-1");
        if (messageDigest == null) {
            return ValueNull.INSTANCE;
        }
        if (l2 != 0L) {
            byte[] byArray = new byte[4];
            Bits.writeInt(byArray, 0, (int)l2);
            messageDigest.update(byArray);
        }
        long l3 = Bits.readLong(messageDigest.digest(), 0);
        return ValueLong.get((l3 & Long.MAX_VALUE) % (l + 1L));
    }

    /*
     * Unable to fully structure code
     */
    private static MessageDigest hashImpl(Value var0, String var1_1) {
        switch (var0.getValueType()) {
            case 0: {
                return null;
            }
            case 13: 
            case 14: 
            case 21: {
                try {
                    var2_2 = MessageDigest.getInstance(var1_1);
                    var2_2.update(var0.getString().getBytes(StandardCharsets.UTF_8));
                    break;
                }
                catch (Exception var3_3) {
                    throw DbException.convert(var3_3);
                }
            }
            case 15: 
            case 16: {
                try {
                    var2_2 = MessageDigest.getInstance(var1_1);
                    var3_4 = new byte[4096];
                    var4_7 = var0.getInputStream();
                    var5_8 = null;
                    while ((var6_9 = var4_7.read(var3_4)) > 0) {
                        var2_2.update(var3_4, 0, var6_9);
                    }
                    if (var4_7 == null) break;
                    if (var5_8 == null) ** GOTO lbl29
                    try {
                        var4_7.close();
                    }
                    catch (Throwable var6_10) {
                        var5_8.addSuppressed(var6_10);
                    }
                    break;
lbl29:
                    // 1 sources

                    var4_7.close();
                    ** break;
                    catch (Throwable var6_11) {
                        try {
                            var5_8 = var6_11;
                            throw var6_11;
                        }
                        catch (Throwable var7_12) {
                            if (var4_7 != null) {
                                if (var5_8 != null) {
                                    try {
                                        var4_7.close();
                                    }
                                    catch (Throwable var8_13) {
                                        var5_8.addSuppressed(var8_13);
                                    }
                                } else {
                                    var4_7.close();
                                }
                            }
                            throw var7_12;
lbl46:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (Exception var3_5) {
                    throw DbException.convert(var3_5);
                }
            }
            default: {
                try {
                    var2_2 = MessageDigest.getInstance(var1_1);
                    var2_2.update(var0.getBytesNoCopy());
                    break;
                }
                catch (Exception var3_6) {
                    throw DbException.convert(var3_6);
                }
            }
        }
        return var2_2;
    }

    private Value regexpReplace(String string, String string2, String string3, String string4) {
        int n;
        Mode mode = this.database.getMode();
        if (mode.regexpReplaceBackslashReferences && (string3.indexOf(92) >= 0 || string3.indexOf(36) >= 0)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < string3.length(); ++n) {
                char c = string3.charAt(n);
                if (c == '$') {
                    stringBuilder.append('\\');
                } else if (c == '\\' && ++n < string3.length()) {
                    c = string3.charAt(n);
                    stringBuilder.append((char)(c >= '0' && c <= '9' ? 36 : 92));
                }
                stringBuilder.append(c);
            }
            string3 = stringBuilder.toString();
        }
        boolean bl = Mode.ModeEnum.PostgreSQL.equals((Object)mode.getEnum());
        n = Function.makeRegexpFlags(string4, bl);
        try {
            Matcher matcher = Pattern.compile(string2, n).matcher(string);
            return ValueString.get(bl && (string4 == null || string4.indexOf(103) < 0) ? matcher.replaceFirst(string3) : matcher.replaceAll(string3), mode.treatEmptyStringsAsNull);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DbException.get(22025, patternSyntaxException, string2);
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException runtimeException) {
            throw DbException.get(22025, runtimeException, string3);
        }
    }

    private static int makeRegexpFlags(String string, boolean bl) {
        int n = 64;
        if (string != null) {
            block7: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case 'i': {
                        n |= 2;
                        continue block7;
                    }
                    case 'c': {
                        n &= 0xFFFFFFFD;
                        continue block7;
                    }
                    case 'n': {
                        n |= 0x20;
                        continue block7;
                    }
                    case 'm': {
                        n |= 8;
                        continue block7;
                    }
                    case 'g': {
                        if (bl) continue block7;
                    }
                    default: {
                        throw DbException.get(90008, string);
                    }
                }
            }
        }
        return n;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public int getValueType() {
        return this.type.getValueType();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.mapColumns(columnResolver, n, n2);
        }
    }

    protected void checkParameterCount(int n) {
        boolean bl;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        switch (this.info.type) {
            case 204: 
            case 210: 
            case 219: 
            case 220: {
                n2 = 1;
                break;
            }
            case 20: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                n3 = 1;
                break;
            }
            case 21: 
            case 27: 
            case 32: 
            case 63: 
            case 69: 
            case 78: 
            case 88: 
            case 97: 
            case 99: 
            case 225: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 125: {
                n2 = 2;
                n3 = 2;
                break;
            }
            case 93: 
            case 96: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 41: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 29: 
            case 58: 
            case 62: 
            case 67: 
            case 72: 
            case 73: 
            case 90: 
            case 91: {
                n2 = 2;
                n3 = 3;
                break;
            }
            case 54: 
            case 92: 
            case 211: {
                n2 = 2;
                break;
            }
            case 84: {
                n2 = 1;
                n3 = 4;
                break;
            }
            case 120: 
            case 121: {
                n2 = 2;
                n3 = 4;
                break;
            }
            case 207: 
            case 208: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 206: 
            case 229: {
                n2 = 3;
                break;
            }
            case 89: {
                n2 = 3;
                n3 = 4;
                break;
            }
            case 240: {
                n2 = 2;
                n3 = 3;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.info.type);
            }
        }
        boolean bl2 = bl = n >= n2 && n <= n3;
        if (!bl) {
            throw DbException.get(7001, this.info.name, n2 + ".." + n3);
        }
    }

    public void doneWithParameters() {
        if (this.info.parameterCount == -1) {
            this.checkParameterCount(this.varArgs.size());
            this.args = this.varArgs.toArray(new Expression[0]);
            this.varArgs = null;
        } else {
            int n = this.args.length;
            if (n > 0 && this.args[n - 1] == null) {
                throw DbException.get(7001, this.info.name, Integer.toString(n));
            }
        }
    }

    public void setDataType(Column column) {
        TypeInfo typeInfo;
        this.type = typeInfo = column.getType();
    }

    @Override
    public Expression optimize(Session session) {
        TypeInfo typeInfo;
        Expression expression;
        boolean bl = this.info.deterministic;
        for (int i = 0; i < this.args.length; ++i) {
            expression = this.args[i];
            if (expression == null) continue;
            this.args[i] = expression = expression.optimize(session);
            if (expression.isConstant()) continue;
            bl = false;
        }
        expression = this.args.length < 1 ? null : this.args[0];
        block0 : switch (this.info.type) {
            case 105: {
                typeInfo = TypeInfo.TYPE_TIMESTAMP;
                if (!expression.isConstant()) break;
                Expression expression2 = this.args[2];
                block24 : switch (expression2.getType().getValueType()) {
                    case 9: {
                        typeInfo = TypeInfo.TYPE_TIME;
                        break;
                    }
                    case 10: {
                        int n = DateTimeFunctions.getDatePart(expression.getValue(session).getString());
                        switch (n) {
                            case 111: 
                            case 112: 
                            case 116: 
                            case 126: 
                            case 127: 
                            case 128: 
                            case 129: {
                                break block24;
                            }
                        }
                        this.type = TypeInfo.TYPE_DATE;
                        break;
                    }
                    case 24: {
                        this.type = TypeInfo.TYPE_TIMESTAMP_TZ;
                    }
                }
                break;
            }
            case 119: {
                if (expression.isConstant() && DateTimeFunctions.getDatePart(expression.getValue(session).getString()) == 127) {
                    typeInfo = TypeInfo.getTypeInfo(6, 28L, 9, null);
                    break;
                }
                typeInfo = TypeInfo.TYPE_INT;
                break;
            }
            case 125: {
                typeInfo = this.args[1].getType();
                if (typeInfo.getValueType() == 24) break;
                typeInfo = TypeInfo.TYPE_TIMESTAMP;
                break;
            }
            case 200: 
            case 204: 
            case 205: 
            case 219: 
            case 220: {
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                for (Expression expression3 : this.args) {
                    TypeInfo typeInfo2;
                    int n;
                    if (expression3 == ValueExpression.getNull() || (n = (typeInfo2 = expression3.getType()).getValueType()) == -1 || n == 0) continue;
                    typeInfo = Value.getHigherType(typeInfo, typeInfo2);
                }
                if (typeInfo.getValueType() != -1) break;
                typeInfo = TypeInfo.TYPE_STRING;
                break;
            }
            case 206: 
            case 229: {
                TypeInfo typeInfo3;
                int n;
                Expression expression4;
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                int n2 = this.args.length;
                for (int i = 2; i < n2; i += 2) {
                    TypeInfo typeInfo4;
                    int n3;
                    Expression expression5 = this.args[i];
                    if (expression5 == ValueExpression.getNull() || (n3 = (typeInfo4 = expression5.getType()).getValueType()) == -1 || n3 == 0) continue;
                    typeInfo = Value.getHigherType(typeInfo, typeInfo4);
                }
                if (this.args.length % 2 == 0 && (expression4 = this.args[this.args.length - 1]) != ValueExpression.getNull() && (n = (typeInfo3 = expression4.getType()).getValueType()) != -1 && n != 0) {
                    typeInfo = Value.getHigherType(typeInfo, typeInfo3);
                }
                if (typeInfo.getValueType() != -1) break;
                typeInfo = TypeInfo.TYPE_STRING;
                break;
            }
            case 201: {
                typeInfo = Value.getHigherType(this.args[1].getType(), this.args[2].getType());
                break;
            }
            case 228: {
                TypeInfo typeInfo5 = this.args[1].getType();
                TypeInfo typeInfo6 = this.args[2].getType();
                switch (typeInfo5.getValueType()) {
                    case 13: 
                    case 14: 
                    case 16: 
                    case 21: {
                        typeInfo = TypeInfo.getTypeInfo(typeInfo5.getValueType(), -1L, 0, null);
                        break block0;
                    }
                }
                typeInfo = Value.getHigherType(typeInfo5, typeInfo6);
                break;
            }
            case 202: 
            case 203: 
            case 227: {
                if (this.type != null) {
                    typeInfo = this.type;
                    break;
                }
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                break;
            }
            case 27: {
                switch (expression.getType().getValueType()) {
                    case 10: 
                    case 11: 
                    case 13: {
                        typeInfo = TypeInfo.getTypeInfo(11, -1L, 0, null);
                        break block0;
                    }
                    case 24: {
                        typeInfo = TypeInfo.getTypeInfo(24, -1L, 0, null);
                        break block0;
                    }
                }
                typeInfo = TypeInfo.TYPE_DOUBLE;
                break;
            }
            case 0: 
            case 13: 
            case 21: {
                TypeInfo typeInfo7;
                typeInfo = typeInfo7 = expression.getType();
                if (typeInfo.getValueType() != 0) break;
                typeInfo = TypeInfo.TYPE_INT;
                break;
            }
            case 222: {
                typeInfo = this.args[1].getType();
                if (expression instanceof Variable) break;
                throw DbException.get(90137, expression.getSQL(false));
            }
            case 225: {
                if (this.args.length == 1) {
                    typeInfo = TypeInfo.getTypeInfo(15, Integer.MAX_VALUE, 0, null);
                    break;
                }
                typeInfo = TypeInfo.getTypeInfo(16, Integer.MAX_VALUE, 0, null);
                break;
            }
            case 72: 
            case 73: {
                long l = this.args[0].getType().getPrecision();
                if (this.args[1].isConstant()) {
                    l -= this.args[1].getValue(session).getLong() - 1L;
                }
                if (this.args.length == 3 && this.args[2].isConstant()) {
                    l = Math.min(l, this.args[2].getValue(session).getLong());
                }
                l = Math.max(0L, l);
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, l, 0, null);
                break;
            }
            case 30: 
            case 31: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[2].getType().getPrecision(), 0, null);
                break;
            }
            case 32: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[0].getType().getPrecision(), 0, null);
                break;
            }
            case 52: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 1L, 0, null);
                break;
            }
            case 54: {
                long l = 0L;
                for (Expression expression6 : this.args) {
                    TypeInfo typeInfo8 = expression6.getType();
                    if ((l += typeInfo8.getPrecision()) >= 0L) continue;
                    l = Long.MAX_VALUE;
                }
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, l, 0, null);
                break;
            }
            case 56: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, (this.args[0].getType().getPrecision() + 3L) / 4L, 0, null);
                break;
            }
            case 59: 
            case 63: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[0].getType().getPrecision(), 0, null);
                break;
            }
            case 65: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[0].getType().getPrecision() * 4L, 0, null);
                break;
            }
            case 70: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 4L, 0, null);
                break;
            }
            case 107: 
            case 114: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 20L, 0, null);
                break;
            }
            default: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, -1L, -1, null);
            }
        }
        this.type = typeInfo;
        if (bl) {
            Value value = this.getValue(session);
            if (this.info.type == 203 || this.info.type == 202) {
                if (value == ValueNull.INSTANCE) {
                    return this;
                }
                DataType dataType = DataType.getDataType(this.type.getValueType());
                TypeInfo typeInfo9 = value.getType();
                if (dataType.supportsPrecision && this.type.getPrecision() != typeInfo9.getPrecision() || dataType.supportsScale && this.type.getScale() != typeInfo9.getScale()) {
                    return this;
                }
            }
            return ValueExpression.get(value);
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        boolean bl2;
        stringBuilder.append(this.info.name);
        if (this.info.type == 206) {
            if (this.args[0] != null) {
                stringBuilder.append(' ');
                this.args[0].getSQL(stringBuilder, bl);
            }
            int n = this.args.length - 1;
            for (int i = 1; i < n; i += 2) {
                stringBuilder.append(" WHEN ");
                this.args[i].getSQL(stringBuilder, bl);
                stringBuilder.append(" THEN ");
                this.args[i + 1].getSQL(stringBuilder, bl);
            }
            if (this.args.length % 2 == 0) {
                stringBuilder.append(" ELSE ");
                this.args[this.args.length - 1].getSQL(stringBuilder, bl);
            }
            return stringBuilder.append(" END");
        }
        boolean bl3 = bl2 = this.args.length > 0 || this.info.requireParentheses;
        if (bl2) {
            stringBuilder.append('(');
        }
        switch (this.info.type) {
            case 78: {
                switch (this.flags) {
                    case 1: {
                        stringBuilder.append("LEADING ");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("TRAILING ");
                    }
                }
                if (this.args.length > 1) {
                    this.args[1].getSQL(stringBuilder, bl).append(" FROM ");
                }
                this.args[0].getSQL(stringBuilder, bl);
                break;
            }
            case 203: {
                this.args[0].getSQL(stringBuilder, bl).append(" AS ").append(new Column(null, this.type).getCreateSQL());
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    stringBuilder.append(new Column(null, this.type).getCreateSQL()).append(',');
                    this.args[0].getSQL(stringBuilder, bl);
                    break;
                }
                this.args[0].getSQL(stringBuilder, bl).append(',').append(new Column(null, this.type).getCreateSQL());
                break;
            }
            case 119: {
                ValueString valueString = (ValueString)((ValueExpression)this.args[0]).getValue(null);
                stringBuilder.append(valueString.getString()).append(" FROM ");
                this.args[1].getSQL(stringBuilder, bl);
                break;
            }
            default: {
                Function.writeExpressions(stringBuilder, this.args, bl);
            }
        }
        if (bl2) {
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.updateAggregate(session, n);
        }
    }

    public int getFunctionType() {
        return this.info.type;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) {
        switch (this.info.type) {
            case 210: {
                ValueResultSet valueResultSet;
                ResultSet resultSet;
                String[] stringArray;
                String string = expressionArray[0].getValue(session).getString();
                if (string == null) {
                    throw DbException.get(90012, "fileName");
                }
                String string2 = expressionArray.length < 2 ? null : expressionArray[1].getValue(session).getString();
                Csv csv = new Csv();
                String string3 = expressionArray.length < 3 ? null : expressionArray[2].getValue(session).getString();
                String string4 = null;
                if (string3 != null && string3.indexOf(61) >= 0) {
                    string4 = csv.setOptions(string3);
                } else {
                    string4 = string3;
                    String string5 = expressionArray.length < 4 ? null : expressionArray[3].getValue(session).getString();
                    stringArray = expressionArray.length < 5 ? null : expressionArray[4].getValue(session).getString();
                    resultSet = expressionArray.length < 6 ? null : expressionArray[5].getValue(session).getString();
                    Function.setCsvDelimiterEscape(csv, string5, (String)stringArray, (String)((Object)resultSet));
                }
                char c = csv.getFieldSeparatorRead();
                stringArray = StringUtils.arraySplit(string2, c, true);
                resultSet = null;
                try {
                    resultSet = csv.read(string, stringArray, string4);
                    valueResultSet = ValueResultSet.get(session, resultSet, 0);
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
                finally {
                    csv.close();
                    JdbcUtils.closeSilently(resultSet);
                }
                return valueResultSet;
            }
        }
        return (ValueResultSet)this.getValueWithArgs(session, expressionArray);
    }

    private static void setCsvDelimiterEscape(Csv csv, String string, String string2, String string3) {
        char c;
        if (string != null) {
            csv.setFieldSeparatorWrite(string);
            if (!string.isEmpty()) {
                c = string.charAt(0);
                csv.setFieldSeparatorRead(c);
            }
        }
        if (string2 != null) {
            c = string2.isEmpty() ? (char)'\u0000' : string2.charAt(0);
            csv.setFieldDelimiter(c);
        }
        if (string3 != null) {
            c = string3.isEmpty() ? (char)'\u0000' : string3.charAt(0);
            csv.setEscapeCharacter(c);
        }
    }

    @Override
    public Expression[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return this.info.deterministic;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        int n = 3;
        for (Expression expression : this.args) {
            if (expression == null) continue;
            n += expression.getCost();
        }
        return n;
    }

    @Override
    public boolean isDeterministic() {
        return this.info.deterministic;
    }

    @Override
    public boolean isBufferResultSetToLocalTemp() {
        return this.info.bufferResultSetToLocalTemp;
    }

    @Override
    public boolean isGeneratedKey() {
        return this.info.type == 207;
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int n) {
        return this.args[n];
    }

    static {
        String string = "7AEIOUY8HW1BFPV2CGJKQSXZ3DT4L5MN6R";
        char c = '\u0000';
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 < '9') {
                c = c2;
                continue;
            }
            Function.SOUNDEX_INDEX[c2] = c;
            Function.SOUNDEX_INDEX[Character.toLowerCase((char)c2)] = c;
        }
        Function.addFunction("ABS", 0, 1, 0);
        Function.addFunction("ACOS", 1, 1, 7);
        Function.addFunction("ASIN", 2, 1, 7);
        Function.addFunction("ATAN", 3, 1, 7);
        Function.addFunction("ATAN2", 4, 2, 7);
        Function.addFunction("BITAND", 5, 2, 5);
        Function.addFunction("BITGET", 40, 2, 1);
        Function.addFunction("BITOR", 6, 2, 5);
        Function.addFunction("BITXOR", 7, 2, 5);
        Function.addFunction("CEILING", 8, 1, 7);
        Function.addFunction("CEIL", 8, 1, 7);
        Function.addFunction("COS", 9, 1, 7);
        Function.addFunction("COSH", 36, 1, 7);
        Function.addFunction("COT", 10, 1, 7);
        Function.addFunction("DEGREES", 11, 1, 7);
        Function.addFunction("EXP", 12, 1, 7);
        Function.addFunction("FLOOR", 13, 1, 7);
        Function.addFunction("LOG", 14, 1, 7);
        Function.addFunction("LN", 39, 1, 7);
        Function.addFunction("LOG10", 15, 1, 7);
        Function.addFunction("MOD", 16, 2, 5);
        Function.addFunction("PI", 17, 0, 7);
        Function.addFunction("POWER", 18, 2, 7);
        Function.addFunction("RADIANS", 19, 1, 7);
        Function.addFunctionNotDeterministic("RAND", 20, -1, 7);
        Function.addFunctionNotDeterministic("RANDOM", 20, -1, 7);
        Function.addFunction("ROUND", 21, -1, 7);
        Function.addFunction("ROUNDMAGIC", 22, 1, 7);
        Function.addFunction("SIGN", 23, 1, 4);
        Function.addFunction("SIN", 24, 1, 7);
        Function.addFunction("SINH", 37, 1, 7);
        Function.addFunction("SQRT", 25, 1, 7);
        Function.addFunction("TAN", 26, 1, 7);
        Function.addFunction("TANH", 38, 1, 7);
        Function.addFunction("TRUNCATE", 27, -1, 0);
        Function.addFunction("TRUNC", 27, -1, 0);
        Function.addFunction("HASH", 29, -1, 12);
        Function.addFunction("ENCRYPT", 30, 3, 12);
        Function.addFunction("DECRYPT", 31, 3, 12);
        Function.addFunctionNotDeterministic("SECURE_RAND", 28, 1, 12);
        Function.addFunction("COMPRESS", 32, -1, 12);
        Function.addFunction("EXPAND", 33, 1, 12);
        Function.addFunction("ZERO", 34, 0, 4);
        Function.addFunctionNotDeterministic("RANDOM_UUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("SYS_GUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("UUID", 35, 0, 20);
        Function.addFunction("ORA_HASH", 41, -1, 5);
        Function.addFunction("ASCII", 50, 1, 4);
        Function.addFunction("BIT_LENGTH", 51, 1, 5);
        Function.addFunction("CHAR", 52, 1, 13);
        Function.addFunction("CHR", 52, 1, 13);
        Function.addFunction("CHAR_LENGTH", 53, 1, 4);
        Function.addFunction("CHARACTER_LENGTH", 53, 1, 4);
        Function.addFunctionWithNull("CONCAT", 54, -1, 13);
        Function.addFunctionWithNull("CONCAT_WS", 92, -1, 13);
        Function.addFunction("DIFFERENCE", 55, 2, 4);
        Function.addFunction("HEXTORAW", 56, 1, 13);
        Function.addFunctionWithNull("INSERT", 57, 4, 13);
        Function.addFunction("LCASE", 59, 1, 13);
        Function.addFunction("LEFT", 60, 2, 13);
        Function.addFunction("LENGTH", 61, 1, 5);
        Function.addFunction("LOCATE", 62, -1, 4);
        Function.addFunction("POSITION", 62, 2, 4);
        Function.addFunction("INSTR", 58, -1, 4);
        Function.addFunction("LTRIM", 63, -1, 13);
        Function.addFunction("OCTET_LENGTH", 64, 1, 5);
        Function.addFunction("RAWTOHEX", 65, 1, 13);
        Function.addFunction("REPEAT", 66, 2, 13);
        Function.addFunctionWithNull("REPLACE", 67, -1, 13);
        Function.addFunction("RIGHT", 68, 2, 13);
        Function.addFunction("RTRIM", 69, -1, 13);
        Function.addFunction("SOUNDEX", 70, 1, 13);
        Function.addFunction("SPACE", 71, 1, 13);
        Function.addFunction("SUBSTR", 72, -1, 13);
        Function.addFunction("SUBSTRING", 73, -1, 13);
        Function.addFunction("UCASE", 74, 1, 13);
        Function.addFunction("LOWER", 75, 1, 13);
        Function.addFunction("UPPER", 76, 1, 13);
        Function.addFunction("POSITION", 77, 2, 4);
        Function.addFunction("TRIM", 78, -1, 13);
        Function.addFunction("STRINGENCODE", 79, 1, 13);
        Function.addFunction("STRINGDECODE", 80, 1, 13);
        Function.addFunction("STRINGTOUTF8", 81, 1, 12);
        Function.addFunction("UTF8TOSTRING", 82, 1, 13);
        Function.addFunction("XMLATTR", 83, 2, 13);
        Function.addFunctionWithNull("XMLNODE", 84, -1, 13);
        Function.addFunction("XMLCOMMENT", 85, 1, 13);
        Function.addFunction("XMLCDATA", 86, 1, 13);
        Function.addFunction("XMLSTARTDOC", 87, 0, 13);
        Function.addFunction("XMLTEXT", 88, -1, 13);
        Function.addFunction("REGEXP_REPLACE", 89, -1, 13);
        Function.addFunction("RPAD", 90, -1, 13);
        Function.addFunction("LPAD", 91, -1, 13);
        Function.addFunction("TO_CHAR", 93, -1, 13);
        Function.addFunction("TRANSLATE", 94, 3, 13);
        Function.addFunction("REGEXP_LIKE", 240, -1, 1);
        Function.addFunctionNotDeterministic("CURRENT_DATE", 100, 0, 10, false);
        Function.addFunctionNotDeterministic("CURDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("SYSDATE", 100, 0, 10, false);
        Function.addFunctionNotDeterministic("TODAY", 100, 0, 10, false);
        Function.addFunctionNotDeterministic("CURRENT_TIME", 101, -1, 9);
        Function.addFunctionNotDeterministic("LOCALTIME", 102, -1, 9, false);
        Function.addFunctionNotDeterministic("SYSTIME", 102, 0, 9, false);
        Function.addFunctionNotDeterministic("CURTIME", 102, -1, 9);
        Function.addFunctionNotDeterministic("CURRENT_TIMESTAMP", 103, -1, 24, false);
        Function.addFunctionNotDeterministic("SYSTIMESTAMP", 103, -1, 24, false);
        Function.addFunctionNotDeterministic("LOCALTIMESTAMP", 104, -1, 11, false);
        Function.addFunctionNotDeterministic("NOW", 104, -1, 11);
        Function.addFunction("TO_DATE", 96, -1, 11);
        Function.addFunction("TO_TIMESTAMP", 97, -1, 11);
        Function.addFunction("ADD_MONTHS", 98, 2, 11);
        Function.addFunction("TO_TIMESTAMP_TZ", 99, -1, 24);
        Function.addFunction("DATEADD", 105, 3, 11);
        Function.addFunction("TIMESTAMPADD", 105, 3, 11);
        Function.addFunction("DATEDIFF", 106, 3, 5);
        Function.addFunction("TIMESTAMPDIFF", 106, 3, 5);
        Function.addFunction("DAYNAME", 107, 1, 13);
        Function.addFunction("DAYNAME", 107, 1, 13);
        Function.addFunction("DAY", 108, 1, 4);
        Function.addFunction("DAY_OF_MONTH", 108, 1, 4);
        Function.addFunction("DAY_OF_WEEK", 109, 1, 4);
        Function.addFunction("DAY_OF_YEAR", 110, 1, 4);
        Function.addFunction("DAYOFMONTH", 108, 1, 4);
        Function.addFunction("DAYOFWEEK", 109, 1, 4);
        Function.addFunction("DAYOFYEAR", 110, 1, 4);
        Function.addFunction("HOUR", 111, 1, 4);
        Function.addFunction("MINUTE", 112, 1, 4);
        Function.addFunction("MONTH", 113, 1, 4);
        Function.addFunction("MONTHNAME", 114, 1, 13);
        Function.addFunction("QUARTER", 115, 1, 4);
        Function.addFunction("SECOND", 116, 1, 4);
        Function.addFunction("WEEK", 117, 1, 4);
        Function.addFunction("YEAR", 118, 1, 4);
        Function.addFunction("EXTRACT", 119, 2, 4);
        Function.addFunctionWithNull("FORMATDATETIME", 120, -1, 13);
        Function.addFunctionWithNull("PARSEDATETIME", 121, -1, 11);
        Function.addFunction("ISO_YEAR", 122, 1, 4);
        Function.addFunction("ISO_WEEK", 123, 1, 4);
        Function.addFunction("ISO_DAY_OF_WEEK", 124, 1, 4);
        Function.addFunction("DATE_TRUNC", 125, 2, 0);
        Function.addFunctionNotDeterministic("DATABASE", 150, 0, 13);
        Function.addFunctionNotDeterministic("USER", 151, 0, 13);
        Function.addFunctionNotDeterministic("CURRENT_USER", 152, 0, 13);
        Function.addFunctionNotDeterministic("IDENTITY", 153, 0, 5);
        Function.addFunctionNotDeterministic("SCOPE_IDENTITY", 154, 0, 5);
        Function.addFunctionNotDeterministic("IDENTITY_VAL_LOCAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("LAST_INSERT_ID", 153, 0, 5);
        Function.addFunctionNotDeterministic("LASTVAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("AUTOCOMMIT", 155, 0, 1);
        Function.addFunctionNotDeterministic("READONLY", 156, 0, 1);
        Function.addFunction("DATABASE_PATH", 157, 0, 13);
        Function.addFunctionNotDeterministic("LOCK_TIMEOUT", 158, 0, 4);
        Function.addFunctionWithNull("IFNULL", 200, 2, 0);
        Function.addFunctionWithNull("ISNULL", 200, 2, 0);
        Function.addFunctionWithNull("CASEWHEN", 201, 3, 0);
        Function.addFunctionWithNull("CONVERT", 202, 1, 0);
        Function.addFunctionWithNull("CAST", 203, 1, 0);
        Function.addFunctionWithNull("TRUNCATE_VALUE", 227, 3, 0);
        Function.addFunctionWithNull("COALESCE", 204, -1, 0);
        Function.addFunctionWithNull("NVL", 204, -1, 0);
        Function.addFunctionWithNull("NVL2", 228, 3, 0);
        Function.addFunctionWithNull("NULLIF", 205, 2, 0);
        Function.addFunctionWithNull("CASE", 206, -1, 0);
        Function.addFunctionNotDeterministic("NEXTVAL", 207, -1, 5);
        Function.addFunctionNotDeterministic("CURRVAL", 208, -1, 5);
        Function.addFunction("ARRAY_GET", 209, 2, 0);
        Function.addFunctionWithNull("ARRAY_CONTAINS", 230, 2, 1);
        Function.addFunction("ARRAY_CAT", 234, 2, 17);
        Function.addFunction("ARRAY_APPEND", 235, 2, 17);
        Function.addFunction("ARRAY_SLICE", 236, 3, 17);
        Function.addFunction("CSVREAD", 210, -1, 18, false, false, false, true);
        Function.addFunction("CSVWRITE", 211, -1, 4, false, false, true, true);
        Function.addFunctionNotDeterministic("MEMORY_FREE", 212, 0, 4);
        Function.addFunctionNotDeterministic("MEMORY_USED", 213, 0, 4);
        Function.addFunctionNotDeterministic("LOCK_MODE", 214, 0, 4);
        Function.addFunctionNotDeterministic("SCHEMA", 215, 0, 13);
        Function.addFunctionNotDeterministic("SESSION_ID", 216, 0, 4);
        Function.addFunction("ARRAY_LENGTH", 217, 1, 4);
        Function.addFunctionNotDeterministic("LINK_SCHEMA", 218, 6, 18);
        Function.addFunctionWithNull("LEAST", 220, -1, 0);
        Function.addFunctionWithNull("GREATEST", 219, -1, 0);
        Function.addFunctionNotDeterministic("CANCEL_SESSION", 221, 1, 1);
        Function.addFunction("SET", 222, 2, 0, false, false, true, true);
        Function.addFunction("FILE_READ", 225, -1, 0, false, false, true, true);
        Function.addFunction("FILE_WRITE", 232, 2, 5, false, false, true, true);
        Function.addFunctionNotDeterministic("TRANSACTION_ID", 226, 0, 13);
        Function.addFunctionWithNull("DECODE", 229, -1, 0);
        Function.addFunctionNotDeterministic("DISK_SPACE_USED", 159, 1, 5);
        Function.addFunctionWithNull("SIGNAL", 160, 2, 0);
        Function.addFunctionNotDeterministic("ESTIMATED_ENVELOPE", 161, 2, 5);
        Function.addFunction("H2VERSION", 231, 0, 13);
        Function.addFunctionWithNull("TABLE", 223, -1, 18);
        Function.addFunctionWithNull("TABLE_DISTINCT", 224, -1, 18);
        Function.addFunctionWithNull("UNNEST", 233, -1, 18);
        Function.addFunction("VALUES", 250, 1, 0, false, true, false, true);
    }
}

