/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.mvstore;

import org.h2.mod.mvstore.Page;

public final class RootReference {
    public final Page root;
    public final long version;
    final boolean lockedForUpdate;
    public volatile RootReference previous;
    final long updateCounter;
    final long updateAttemptCounter;
    final byte appendCounter;

    RootReference(Page page, long l) {
        this.root = page;
        this.version = l;
        this.previous = null;
        this.updateCounter = 1L;
        this.updateAttemptCounter = 1L;
        this.lockedForUpdate = false;
        this.appendCounter = 0;
    }

    RootReference(RootReference rootReference, Page page, long l) {
        this.root = page;
        this.version = rootReference.version;
        this.previous = rootReference.previous;
        this.updateCounter = rootReference.updateCounter + 1L;
        this.updateAttemptCounter = rootReference.updateAttemptCounter + l;
        this.lockedForUpdate = false;
        this.appendCounter = rootReference.appendCounter;
    }

    RootReference(RootReference rootReference, int n) {
        this.root = rootReference.root;
        this.version = rootReference.version;
        this.previous = rootReference.previous;
        this.updateCounter = rootReference.updateCounter + 1L;
        this.updateAttemptCounter = rootReference.updateAttemptCounter + (long)n;
        this.lockedForUpdate = true;
        this.appendCounter = rootReference.appendCounter;
    }

    RootReference(RootReference rootReference, Page page, int n, boolean bl) {
        this.root = page;
        this.version = rootReference.version;
        this.previous = rootReference.previous;
        this.updateCounter = rootReference.updateCounter;
        this.updateAttemptCounter = rootReference.updateAttemptCounter;
        this.lockedForUpdate = bl;
        this.appendCounter = (byte)n;
    }

    RootReference(RootReference rootReference, long l, int n) {
        RootReference rootReference2;
        RootReference rootReference3 = rootReference;
        while ((rootReference2 = rootReference3.previous) != null && rootReference2.root == rootReference.root) {
            rootReference3 = rootReference2;
        }
        this.root = rootReference.root;
        this.version = l;
        this.previous = rootReference3;
        this.updateCounter = rootReference.updateCounter + 1L;
        this.updateAttemptCounter = rootReference.updateAttemptCounter + (long)n;
        this.lockedForUpdate = rootReference.lockedForUpdate;
        this.appendCounter = rootReference.appendCounter;
    }

    int getAppendCounter() {
        return this.appendCounter & 0xFF;
    }

    public long getTotalCount() {
        return this.root.getTotalCount() + (long)this.getAppendCounter();
    }

    public String toString() {
        return "RootReference(" + System.identityHashCode(this.root) + "," + this.version + "," + this.lockedForUpdate + ")";
    }
}

