/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.mvstore.db;

import org.h2.mod.engine.Database;
import org.h2.mod.expression.Expression;
import org.h2.mod.message.DbException;
import org.h2.mod.mvstore.Cursor;
import org.h2.mod.mvstore.MVMap;
import org.h2.mod.mvstore.db.MVTempResult;
import org.h2.mod.mvstore.db.ValueDataType;
import org.h2.mod.result.ResultExternal;
import org.h2.mod.value.Value;
import org.h2.mod.value.ValueRow;

class MVPlainTempResult
extends MVTempResult {
    private final MVMap<Long, ValueRow> map;
    private long counter;
    private Cursor<Long, ValueRow> cursor;

    private MVPlainTempResult(MVPlainTempResult mVPlainTempResult) {
        super(mVPlainTempResult);
        this.map = mVPlainTempResult.map;
    }

    MVPlainTempResult(Database database, Expression[] expressionArray, int n) {
        super(database, expressionArray, n);
        ValueDataType valueDataType = new ValueDataType(database, new int[expressionArray.length]);
        MVMap.Builder builder = ((MVMap.Builder)new MVMap.Builder().valueType(valueDataType)).singleWriter();
        this.map = this.store.openMap("tmp", builder);
    }

    @Override
    public int addRow(Value[] valueArray) {
        assert (this.parent == null);
        this.map.append(this.counter++, ValueRow.get(valueArray));
        return ++this.rowCount;
    }

    @Override
    public boolean contains(Value[] valueArray) {
        throw DbException.getUnsupportedException("contains()");
    }

    @Override
    public synchronized ResultExternal createShallowCopy() {
        if (this.parent != null) {
            return this.parent.createShallowCopy();
        }
        if (this.closed) {
            return null;
        }
        ++this.childCount;
        return new MVPlainTempResult(this);
    }

    @Override
    public Value[] next() {
        if (this.cursor == null) {
            this.cursor = this.map.cursor(null);
        }
        if (!this.cursor.hasNext()) {
            return null;
        }
        this.cursor.next();
        Value[] valueArray = this.cursor.getValue().getList();
        if (this.hasEnum) {
            this.fixEnum(valueArray);
        }
        return valueArray;
    }

    @Override
    public int removeRow(Value[] valueArray) {
        throw DbException.getUnsupportedException("removeRow()");
    }

    @Override
    public void reset() {
        this.cursor = null;
    }
}

