/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.mvstore.db;

import java.util.Iterator;
import java.util.List;
import org.h2.mod.command.dml.AllColumnsForPlan;
import org.h2.mod.engine.Database;
import org.h2.mod.engine.Session;
import org.h2.mod.index.BaseIndex;
import org.h2.mod.index.Cursor;
import org.h2.mod.index.IndexType;
import org.h2.mod.index.SpatialIndex;
import org.h2.mod.index.SpatialTreeIndex;
import org.h2.mod.message.DbException;
import org.h2.mod.mvstore.MVMap;
import org.h2.mod.mvstore.Page;
import org.h2.mod.mvstore.db.MVIndex;
import org.h2.mod.mvstore.db.MVTable;
import org.h2.mod.mvstore.db.ValueDataType;
import org.h2.mod.mvstore.rtree.MVRTreeMap;
import org.h2.mod.mvstore.rtree.SpatialKey;
import org.h2.mod.mvstore.tx.Transaction;
import org.h2.mod.mvstore.tx.TransactionMap;
import org.h2.mod.mvstore.tx.VersionedValueType;
import org.h2.mod.result.Row;
import org.h2.mod.result.SearchRow;
import org.h2.mod.result.SortOrder;
import org.h2.mod.table.IndexColumn;
import org.h2.mod.table.TableFilter;
import org.h2.mod.value.Value;
import org.h2.mod.value.ValueGeometry;
import org.h2.mod.value.ValueLong;
import org.h2.mod.value.ValueNull;
import org.h2.mod.value.VersionedValue;

public class MVSpatialIndex
extends BaseIndex
implements SpatialIndex,
MVIndex {
    final MVTable mvTable;
    private final TransactionMap<SpatialKey, Value> dataMap;
    private final MVRTreeMap<VersionedValue> spatialMap;

    public MVSpatialIndex(Database database, MVTable mVTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(mVTable, n, string, indexColumnArray, indexType);
        if (indexColumnArray.length != 1) {
            throw DbException.getUnsupportedException("Can only index one column");
        }
        IndexColumn indexColumn = indexColumnArray[0];
        if ((indexColumn.sortType & 1) != 0) {
            throw DbException.getUnsupportedException("Cannot index in descending order");
        }
        if ((indexColumn.sortType & 2) != 0) {
            throw DbException.getUnsupportedException("Nulls first is not supported");
        }
        if ((indexColumn.sortType & 4) != 0) {
            throw DbException.getUnsupportedException("Nulls last is not supported");
        }
        if (indexColumn.column.getType().getValueType() != 22) {
            throw DbException.getUnsupportedException("Spatial index on non-geometry column, " + indexColumn.column.getCreateSQL());
        }
        this.mvTable = mVTable;
        if (!this.database.isStarting()) {
            MVSpatialIndex.checkIndexColumnTypes(indexColumnArray);
        }
        String string2 = "index." + this.getId();
        ValueDataType valueDataType = new ValueDataType(database, null);
        VersionedValueType versionedValueType = new VersionedValueType(valueDataType);
        MVMap.BasicBuilder basicBuilder = new MVRTreeMap.Builder().valueType(versionedValueType);
        this.spatialMap = (MVRTreeMap)database.getStore().getMvStore().openMap(string2, basicBuilder);
        Transaction transaction = this.mvTable.getTransactionBegin();
        this.dataMap = transaction.openMap(this.spatialMap);
        this.dataMap.map.setVolatile(!mVTable.isPersistData() || !indexType.isPersistent());
        transaction.commit();
    }

    @Override
    public void addRowsToBuffer(List<Row> list, String string) {
        throw DbException.throwInternalError();
    }

    @Override
    public void addBufferedRows(List<String> list) {
        throw DbException.throwInternalError();
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        SpatialKey spatialKey;
        Iterator<SpatialKey> iterator;
        MVRTreeMap.RTreeCursor rTreeCursor;
        TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        SpatialKey spatialKey2 = this.getKey(row);
        if (spatialKey2.isNull()) {
            return;
        }
        if (this.indexType.isUnique()) {
            rTreeCursor = this.spatialMap.findContainedKeys(spatialKey2);
            iterator = transactionMap.wrapIterator(rTreeCursor, false);
            while (iterator.hasNext()) {
                spatialKey = iterator.next();
                if (!spatialKey.equalsIgnoringId(spatialKey2)) continue;
                throw this.getDuplicateKeyException(spatialKey2.toString());
            }
        }
        try {
            transactionMap.put(spatialKey2, ValueLong.get(0L));
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
        if (this.indexType.isUnique()) {
            rTreeCursor = this.spatialMap.findContainedKeys(spatialKey2);
            iterator = transactionMap.wrapIterator(rTreeCursor, true);
            while (iterator.hasNext()) {
                spatialKey = iterator.next();
                if (!spatialKey.equalsIgnoringId(spatialKey2) || transactionMap.isSameTransaction(spatialKey)) continue;
                transactionMap.remove(spatialKey2);
                if (transactionMap.get(spatialKey) != null) {
                    throw this.getDuplicateKeyException(spatialKey.toString());
                }
                throw DbException.get(90131, this.table.getName());
            }
        }
    }

    @Override
    public void remove(Session session, Row row) {
        SpatialKey spatialKey = this.getKey(row);
        if (spatialKey.isNull()) {
            return;
        }
        TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        try {
            Value value = transactionMap.remove(spatialKey);
            if (value == null) {
                StringBuilder stringBuilder = new StringBuilder();
                this.getSQL(stringBuilder, false).append(": ").append(row.getKey());
                throw DbException.get(90112, stringBuilder.toString());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
    }

    @Override
    public Cursor find(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(tableFilter.getSession());
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session);
    }

    private Cursor find(Session session) {
        Iterator<Object> iterator = this.spatialMap.keyIterator(null);
        TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        Iterator<Object> iterator2 = transactionMap.wrapIterator(iterator, false);
        return new MVStoreCursor(session, iterator2, this.mvTable);
    }

    @Override
    public Cursor findByGeometry(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2, SearchRow searchRow3) {
        Session session = tableFilter.getSession();
        if (searchRow3 == null) {
            return this.find(session, searchRow, searchRow2);
        }
        MVRTreeMap.RTreeCursor rTreeCursor = this.spatialMap.findIntersectingKeys(this.getKey(searchRow3));
        TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        Iterator<SpatialKey> iterator = transactionMap.wrapIterator(rTreeCursor, false);
        return new MVStoreCursor(session, iterator, this.mvTable);
    }

    public Value getBounds(Session session) {
        FindBoundsCursor findBoundsCursor = new FindBoundsCursor(this.spatialMap.getRootPage(), new SpatialKey(0L, new float[0]), session, this.getMap(session), this.columnIds[0]);
        while (findBoundsCursor.hasNext()) {
            findBoundsCursor.next();
        }
        return findBoundsCursor.getBounds();
    }

    public Value getEstimatedBounds(Session session) {
        Page page = this.spatialMap.getRootPage();
        int n = page.getKeyCount();
        if (n > 0) {
            SpatialKey spatialKey = (SpatialKey)page.getKey(0);
            float f = spatialKey.min(0);
            float f2 = spatialKey.max(0);
            float f3 = spatialKey.min(1);
            float f4 = spatialKey.max(1);
            for (int i = 1; i < n; ++i) {
                spatialKey = (SpatialKey)page.getKey(i);
                float f5 = spatialKey.min(0);
                float f6 = spatialKey.max(0);
                float f7 = spatialKey.min(1);
                float f8 = spatialKey.max(1);
                if (f5 < f) {
                    f = f5;
                }
                if (f6 > f2) {
                    f2 = f6;
                }
                if (f7 < f3) {
                    f3 = f7;
                }
                if (!(f8 > f4)) continue;
                f4 = f8;
            }
            return ValueGeometry.fromEnvelope(new double[]{f, f2, f3, f4});
        }
        return ValueNull.INSTANCE;
    }

    private SpatialKey getKey(SearchRow searchRow) {
        double[] dArray;
        Value value = searchRow.getValue(this.columnIds[0]);
        if (value == ValueNull.INSTANCE || (dArray = ((ValueGeometry)value.convertTo(22)).getEnvelopeNoCopy()) == null) {
            return new SpatialKey(searchRow.getKey(), new float[0]);
        }
        return new SpatialKey(searchRow.getKey(), (float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3]);
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return SpatialTreeIndex.getCostRangeIndex(nArray, this.columns);
    }

    @Override
    public void remove(Session session) {
        TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        if (!transactionMap.isClosed()) {
            Transaction transaction = session.getTransaction();
            transaction.removeMap(transactionMap);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        transactionMap.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        if (!bl) {
            throw DbException.throwInternalError("Spatial Index can only be fetch in ascending order");
        }
        return this.find(session);
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        return transactionMap.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
    }

    private TransactionMap<SpatialKey, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction transaction = session.getTransaction();
        return this.dataMap.getInstance(transaction);
    }

    private final class FindBoundsCursor
    extends MVRTreeMap.RTreeCursor {
        private final Session session;
        private final TransactionMap<SpatialKey, Value> map;
        private final int columnId;
        private boolean hasBounds;
        private float bminxf;
        private float bmaxxf;
        private float bminyf;
        private float bmaxyf;
        private double bminxd;
        private double bmaxxd;
        private double bminyd;
        private double bmaxyd;

        FindBoundsCursor(Page page, SpatialKey spatialKey, Session session, TransactionMap<SpatialKey, Value> transactionMap, int n) {
            super(page, spatialKey);
            this.session = session;
            this.map = transactionMap;
            this.columnId = n;
        }

        @Override
        protected boolean check(boolean bl, SpatialKey spatialKey, SpatialKey spatialKey2) {
            float f = spatialKey.min(0);
            float f2 = spatialKey.max(0);
            float f3 = spatialKey.min(1);
            float f4 = spatialKey.max(1);
            if (bl) {
                if (this.hasBounds) {
                    if ((f <= this.bminxf || f2 >= this.bmaxxf || f3 <= this.bminyf || f4 >= this.bmaxyf) && this.map.containsKey(spatialKey)) {
                        double[] dArray = ((ValueGeometry)MVSpatialIndex.this.mvTable.getRow(this.session, spatialKey.getId()).getValue(this.columnId)).getEnvelopeNoCopy();
                        double d = dArray[0];
                        double d2 = dArray[1];
                        double d3 = dArray[2];
                        double d4 = dArray[3];
                        if (d < this.bminxd) {
                            this.bminxf = f;
                            this.bminxd = d;
                        }
                        if (d2 > this.bmaxxd) {
                            this.bmaxxf = f2;
                            this.bmaxxd = d2;
                        }
                        if (d3 < this.bminyd) {
                            this.bminyf = f3;
                            this.bminyd = d3;
                        }
                        if (d4 > this.bmaxyd) {
                            this.bmaxyf = f4;
                            this.bmaxyd = d4;
                        }
                    }
                } else if (this.map.containsKey(spatialKey)) {
                    this.hasBounds = true;
                    double[] dArray = ((ValueGeometry)MVSpatialIndex.this.mvTable.getRow(this.session, spatialKey.getId()).getValue(this.columnId)).getEnvelopeNoCopy();
                    this.bminxf = f;
                    this.bminxd = dArray[0];
                    this.bmaxxf = f2;
                    this.bmaxxd = dArray[1];
                    this.bminyf = f3;
                    this.bminyd = dArray[2];
                    this.bmaxyf = f4;
                    this.bmaxyd = dArray[3];
                }
            } else if (this.hasBounds) {
                if (f <= this.bminxf || f2 >= this.bmaxxf || f3 <= this.bminyf || f4 >= this.bmaxyf) {
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }

        Value getBounds() {
            return this.hasBounds ? ValueGeometry.fromEnvelope(new double[]{this.bminxd, this.bmaxxd, this.bminyd, this.bmaxyd}) : ValueNull.INSTANCE;
        }
    }

    public static class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<SpatialKey> it;
        private final MVTable mvTable;
        private SpatialKey current;
        private SearchRow searchRow;
        private Row row;

        public MVStoreCursor(Session session, Iterator<SpatialKey> iterator, MVTable mVTable) {
            this.session = session;
            this.it = iterator;
            this.mvTable = mVTable;
        }

        @Override
        public Row get() {
            SearchRow searchRow;
            if (this.row == null && (searchRow = this.getSearchRow()) != null) {
                this.row = this.mvTable.getRow(this.session, searchRow.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            if (this.searchRow == null && this.current != null) {
                this.searchRow = this.mvTable.getTemplateRow();
                this.searchRow.setKey(this.current.getId());
            }
            return this.searchRow;
        }

        public SpatialKey getKey() {
            return this.current;
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            this.searchRow = null;
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

