/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.h2.mod.store.fs.FileBase;

class FileAsync
extends FileBase {
    private static final OpenOption[] R = new OpenOption[]{StandardOpenOption.READ};
    private static final OpenOption[] W = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
    private static final OpenOption[] RWS = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.SYNC};
    private static final OpenOption[] RWD = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DSYNC};
    private final String name;
    private final AsynchronousFileChannel channel;
    private long position;

    /*
     * Loose catch block
     */
    private static <T> T complete(Future<T> future) throws IOException {
        boolean bl = false;
        while (true) {
            try {
                T t = future.get();
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                return t;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException.getCause());
        }
    }

    FileAsync(String string, String string2) throws IOException {
        OpenOption[] openOptionArray;
        this.name = string;
        switch (string2) {
            case "r": {
                openOptionArray = R;
                break;
            }
            case "rw": {
                openOptionArray = W;
                break;
            }
            case "rws": {
                openOptionArray = RWS;
                break;
            }
            case "rwd": {
                openOptionArray = RWD;
                break;
            }
            default: {
                throw new IllegalArgumentException(string2);
            }
        }
        this.channel = AsynchronousFileChannel.open(Paths.get(string, new String[0]), openOptionArray);
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.channel.close();
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = FileAsync.complete(this.channel.read(byteBuffer, this.position));
        if (n > 0) {
            this.position += (long)n;
        }
        return n;
    }

    @Override
    public FileChannel position(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.position = l;
        return this;
    }

    @Override
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        return FileAsync.complete(this.channel.read(byteBuffer, l));
    }

    @Override
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        try {
            return FileAsync.complete(this.channel.write(byteBuffer, l));
        }
        catch (NonWritableChannelException nonWritableChannelException) {
            throw new IOException("read only");
        }
    }

    @Override
    public FileChannel truncate(long l) throws IOException {
        this.channel.truncate(l);
        if (l < this.position) {
            this.position = l;
        }
        return this;
    }

    @Override
    public void force(boolean bl) throws IOException {
        this.channel.force(bl);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n;
        try {
            n = FileAsync.complete(this.channel.write(byteBuffer, this.position));
            this.position += (long)n;
        }
        catch (NonWritableChannelException nonWritableChannelException) {
            throw new IOException("read only");
        }
        return n;
    }

    @Override
    public synchronized FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        return this.channel.tryLock(l, l2, bl);
    }

    public String toString() {
        return "async:" + this.name;
    }
}

