/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.EISSystemException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.SecurityException;
import jakarta.resource.spi.security.PasswordCredential;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.connector.OracleConnectionRequestInfo;
import oracle.jdbc.connector.OracleManagedConnection;

public class OracleManagedConnectionFactory
implements ManagedConnectionFactory {
    private XADataSource xaDataSource = null;
    private String xaDataSourceName = null;
    private static final String RAERR_MCF_SET_XADS = "invalid xads";
    private static final String RAERR_MCF_GET_PCRED = "no password credential";

    public OracleManagedConnectionFactory() throws ResourceException {
    }

    public OracleManagedConnectionFactory(XADataSource xads) throws ResourceException {
        this.xaDataSource = xads;
        this.xaDataSourceName = "XADataSource";
    }

    public void setXADataSourceName(String xadsName) {
        this.xaDataSourceName = xadsName;
    }

    public String getXADataSourceName() {
        return this.xaDataSourceName;
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        if (this.xaDataSource == null) {
            this.setupXADataSource();
        }
        return (DataSource)((Object)this.xaDataSource);
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            XAConnection xaconn = null;
            PasswordCredential pcred = this.getPasswordCredential(subject, cxRequestInfo);
            xaconn = pcred == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(pcred.getUserName(), new String(pcred.getPassword()));
            OracleManagedConnection omc = new OracleManagedConnection(xaconn);
            omc.setPasswordCredential(pcred);
            omc.setLogWriter(this.getLogWriter());
            return omc;
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        PasswordCredential pcred = this.getPasswordCredential(subject, cxRequestInfo);
        for (Object obj : connectionSet) {
            OracleManagedConnection omc;
            if (!(obj instanceof OracleManagedConnection) || !(omc = (OracleManagedConnection)obj).getPasswordCredential().equals((Object)pcred)) continue;
            return omc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            this.xaDataSource.setLogWriter(out);
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            return this.xaDataSource.getLogWriter();
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
    }

    private void setupXADataSource() throws ResourceException {
        try {
            XADataSource xads;
            InitialContext ic = null;
            try {
                Properties props = System.getProperties();
                ic = new InitialContext(props);
            }
            catch (java.lang.SecurityException props) {
                // empty catch block
            }
            if (ic == null) {
                ic = new InitialContext();
            }
            if ((xads = (XADataSource)ic.lookup(this.xaDataSourceName)) == null) {
                throw new ResourceAdapterInternalException("Invalid XADataSource object");
            }
            this.xaDataSource = xads;
        }
        catch (NamingException exc) {
            throw new ResourceException("NamingException: " + exc.getMessage(), (Throwable)exc);
        }
    }

    private PasswordCredential getPasswordCredential(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (subject != null) {
            Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
            for (PasswordCredential pcred : creds) {
                if (!pcred.getManagedConnectionFactory().equals((Object)this)) continue;
                return pcred;
            }
            throw new SecurityException("Can not find user/password information", RAERR_MCF_GET_PCRED);
        }
        if (cxRequestInfo == null) {
            return null;
        }
        OracleConnectionRequestInfo info = (OracleConnectionRequestInfo)cxRequestInfo;
        PasswordCredential pcred = new PasswordCredential(info.getUser(), info.getPassword().toCharArray());
        pcred.setManagedConnectionFactory((ManagedConnectionFactory)this);
        return pcred;
    }
}

