/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconvert;

import com.stratadata.model3.db.DBType;
import com.stratadata.model3.db.SBTables;
import com.stratadata.sbconvert.OracleBooleanColumnTransform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SbugsScriptUtilities {
    private static final String BASE_SCRIPT_FILENAME = "SBUGS3-0_base.sql";
    private static final Logger LOGGER = Logger.getLogger(SbugsScriptUtilities.class.getName());

    private SbugsScriptUtilities() {
    }

    private static List<String> loadBaseScriptAsLines() {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(SbugsScriptUtilities.locateBaseScriptFile().getInputStream()));
            LinkedList<String> lines = new LinkedList<String>();
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Error reading base script", ioe);
            return null;
        }
    }

    private static String loadBaseScriptAsString() {
        try {
            String line;
            Object retString = "";
            BufferedReader in = new BufferedReader(new InputStreamReader(SbugsScriptUtilities.locateBaseScriptFile().getInputStream()));
            while ((line = in.readLine()) != null) {
                retString = (String)retString + line;
                retString = (String)retString + System.lineSeparator();
            }
            retString = (String)retString + System.lineSeparator();
            return retString;
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Error reading base script", ioe);
            return null;
        }
    }

    private static URLConnection locateBaseScriptFile() {
        URL url = SbugsScriptUtilities.class.getClassLoader().getResource(BASE_SCRIPT_FILENAME);
        try {
            URLConnection connection = url.openConnection();
            return connection;
        }
        catch (IOException e) {
            throw new RuntimeException("Base script location exception: " + e.getMessage());
        }
    }

    public static String createTableScript(DBType dbType, boolean createFKsAfterTables) {
        String baseScript = SbugsScriptUtilities.loadBaseScriptAsString();
        baseScript = SbugsScriptUtilities.stripCommentsFromString(baseScript);
        String[] buffer = SbugsScriptUtilities.splitStringScriptIntoLines(baseScript);
        LinkedList<String> outBuff = new LinkedList<String>();
        LinkedList<Object> fkBuff = new LinkedList<Object>();
        String lastTableName = null;
        for (String s : buffer) {
            if ((s = StringUtils.stripToNull((String)s)) == null) continue;
            if (createFKsAfterTables && s.toUpperCase().contains("FOREIGN KEY") && lastTableName != null) {
                s = SbugsScriptUtilities.stripCommaFromEnd(s);
                s = StringUtils.appendIfMissing((String)s, (CharSequence)";", (CharSequence[])new CharSequence[]{null});
                fkBuff.add("ALTER TABLE " + lastTableName + " ADD " + s.trim());
                continue;
            }
            if ((s = SbugsScriptUtilities.translateDDL(dbType, s)).equals(");")) {
                String last = (String)outBuff.get(outBuff.size() - 1);
                outBuff.remove(outBuff.size() - 1);
                outBuff.add(SbugsScriptUtilities.stripCommaFromEnd(last));
            }
            outBuff.add(s);
            Optional<String> optionalTableName = SbugsScriptUtilities.getTableNameFromCreate(s);
            if (!optionalTableName.isPresent()) continue;
            String tableName = optionalTableName.get();
            if (!SBTables.isValidTableName(tableName)) {
                throw new IllegalStateException("Attempt to create table unknown to data model: " + tableName);
            }
            lastTableName = tableName;
            if (!createFKsAfterTables) continue;
            fkBuff.add("");
        }
        if (createFKsAfterTables) {
            outBuff.addAll(List.of("", "/* Foreign keys */", ""));
            outBuff.addAll(fkBuff);
        }
        return StringUtils.join(outBuff, (String)"\n");
    }

    private static String stripCommaFromEnd(String s) {
        if (s.contains(",") && s.contains("/*") && s.indexOf("/*") > s.indexOf(",")) {
            s = s.substring(0, s.indexOf("/*") - 1);
        }
        while (s.endsWith(" ")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static String translateDDL(DBType dbType, String sql) {
        sql = sql.toUpperCase();
        switch (dbType) {
            case H2: {
                sql = sql.replace("SYSDATE", "now()");
                return sql;
            }
            default: {
                return sql;
            }
            case ORACLE: {
                if (sql.contains("!NOT_ORACLE")) {
                    return "";
                }
                OracleBooleanColumnTransform transformer = new OracleBooleanColumnTransform();
                if (transformer.match(sql)) {
                    sql = transformer.transform(sql);
                }
                return sql;
            }
            case MSSQLSERVER: {
                sql = sql.replace("NUMBER(5,0)", "SMALLINT");
                sql = sql.replace("NUMBER(11,0)", "INT");
                sql = sql.replace("NUMBER(", "NUMERIC(");
                sql = sql.replace(" NUMBER", " FLOAT");
                sql = sql.replace("\tNUMBER", "\tFLOAT");
                sql = sql.replace("TIMESTAMP", "DATETIME");
                sql = sql.replace("VARCHAR2", "NVARCHAR");
                sql = sql.replace("BLOB", "IMAGE");
                sql = sql.replace("CLOB", "NVARCHAR(max)");
                sql = sql.replace("INSERT INTO ", "BEGIN TRAN\nINSERT INTO ");
                sql = sql.replace("SYSDATE", "getdate()");
                sql = sql.replace("sysdate", "getdate()");
                return sql;
            }
            case POSTGRESQL: {
                sql = sql.replace("NUMBER(5,0)", "SMALLINT");
                sql = sql.replace("NUMBER(11,0)", "INT");
                sql = sql.replace(" NUMBER", " NUMERIC");
                sql = sql.replace("\tNUMBER", "\tNUMERIC");
                sql = sql.replace("VARCHAR2", "VARCHAR");
                sql = sql.replace("BLOB", "BYTEA");
                sql = sql.replace("CLOB", "TEXT");
                sql = sql.replace("SYSDATE", "CURRENT_DATE");
                sql = sql.replace("BIT DEFAULT 0", "BOOLEAN DEFAULT FALSE");
                sql = sql.replace("BIT DEFAULT 1", "BOOLEAN DEFAULT TRUE");
                sql = sql.replace("BIT", "BOOLEAN");
                return sql;
            }
            case MYSQL: 
        }
        sql = sql.replace("NUMBER(5,0)", "SMALLINT");
        sql = sql.replace("NUMBER(11,0)", "INT");
        sql = sql.replace("NUMBER(", "NUMERIC(");
        sql = sql.replace(" NUMBER", " NUMERIC(30,8)");
        sql = sql.replace("VARCHAR2", "VARCHAR");
        sql = sql.replace("BLOB", "LONGBLOB");
        sql = sql.replace("CLOB", "BLOB");
        sql = sql.replace("SYSDATE", "CURRENT_TIMESTAMP()");
        sql = sql.replace("BIT DEFAULT 0", "TINYINT DEFAULT 0");
        sql = sql.replace("BIT DEFAULT 1", "TINYINT DEFAULT 1");
        sql = sql.replace("BIT", "TINYINT");
        return sql;
    }

    public static String grantScript(String grantee) {
        List grantList = SbugsScriptUtilities.loadBaseScriptAsLines().stream().map(s -> SbugsScriptUtilities.getTableNameFromCreate(s)).flatMap(Optional::stream).map(tableName -> "GRANT select,update,insert,delete ON " + tableName + " TO " + grantee + ";").collect(Collectors.toList());
        return StringUtils.join(grantList, (String)"\n");
    }

    public static String dropScript(boolean ifExists, boolean cascade, DBType dbType) {
        String cascadeText;
        if (dbType == DBType.ORACLE) {
            ifExists = false;
            cascadeText = " CASCADE CONSTRAINTS;";
        } else {
            cascadeText = " CASCADE;";
        }
        boolean ifExistsInternal = ifExists;
        List dropList = SbugsScriptUtilities.loadBaseScriptAsLines().stream().map(s -> SbugsScriptUtilities.getTableNameFromCreate(s)).flatMap(Optional::stream).map(tableName -> "DROP TABLE " + (ifExistsInternal ? "IF EXISTS " : "") + tableName + (cascade ? cascadeText : ";")).collect(Collectors.toList());
        Collections.reverse(dropList);
        return StringUtils.join(dropList, (String)"\n");
    }

    private static Optional<String> getTableNameFromCreate(String s) {
        String[] words;
        String tableName = null;
        if (s.contains("CREATE TABLE") && (words = s.split(" ")).length > 2) {
            tableName = words[2].trim();
        }
        return Optional.ofNullable(tableName);
    }

    public static String stripCommentsFromString(String source) {
        return source.replaceAll("/\\*(?:.|[\\n\\r])*?\\*/", "");
    }

    public static String[] splitStringScriptIntoLines(String scriptAsString) {
        return scriptAsString.split("[\\r\\n]+");
    }
}

