/*
 * Decompiled with CFR 0.152.
 */
package jsbchart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.SBGraphicsConverter;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class SVGFillArtist {
    public static final float pixPerMM = 2.8346457f;
    private static final Logger LOGGER = Logger.getLogger(SVGFillArtist.class.getName());
    private static boolean SHOW_BORDER = false;
    private static boolean SHOW_TILE_OUTLINE = false;
    private static boolean SHOW_TILE_OUTLINE_ICON = false;
    private SVGDocument doc;
    SBGraphicsConverter converter = new SBGraphicsConverter(0.028346456587314606);
    private float tileSize = 20.0f;
    private float padding = 4.0f;

    public float getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(float tileSize) {
        this.tileSize = tileSize;
    }

    public float getPadding() {
        return this.padding;
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public void loadSVGFromFile(String url) {
        this.doc = SVGFillArtist.loadSVGDocument(url);
    }

    public void loadSVGFromString(String data) {
        this.doc = SVGFillArtist.loadSVGDocumentFromString(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageIcon buildIcon(int size, int padding, Color fillColour, Color backgroundColour) {
        BufferedImage img = new BufferedImage(size + padding, size + padding, 1);
        Graphics2D g2dIcon = (Graphics2D)img.getGraphics();
        g2dIcon.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2dIcon.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2dIcon.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2dIcon.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2dIcon.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2dIcon.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2dIcon.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2dIcon.setColor(backgroundColour);
        g2dIcon.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2dIcon.setColor(backgroundColour);
        g2dIcon.fillRect(0, 0, size, size);
        try {
            AffineTransform saveTransform = g2dIcon.getTransform();
            try {
                List<SVGShape> shapes = this.getShapesFromDocument();
                this.scaleSVGShapeTo1(shapes);
                for (SVGShape sp : shapes) {
                    this.updateStrokeWidthScale(sp);
                    this.updatePainterColours(sp.painter, Color.magenta, fillColour);
                    if (SHOW_TILE_OUTLINE_ICON) {
                        GeneralPath p = new GeneralPath(new Rectangle2D.Float(-0.5f, -0.5f, 1.0f, 1.0f));
                        g2dIcon.setStroke(new BasicStroke(20.0f));
                        g2dIcon.setColor(Color.black);
                        p.transform(AffineTransform.getTranslateInstance(0.5, 0.5));
                        p.transform(AffineTransform.getScaleInstance(size, size));
                        g2dIcon.draw(p);
                    }
                    GeneralPath gp2 = new GeneralPath(sp.shape);
                    gp2.transform(AffineTransform.getTranslateInstance(0.5, 0.5));
                    gp2.transform(AffineTransform.getScaleInstance(size, size));
                    sp.painter.setShape((Shape)gp2);
                    sp.painter.paint(g2dIcon);
                }
            }
            finally {
                g2dIcon.setTransform(saveTransform);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error building image icon", e);
        }
        ImageIcon icon = new ImageIcon(img);
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillArea(SBGraphics sg, Shape shapeToFill, Color fillColour) {
        List<SVGShape> shapes = this.getShapesFromDocument();
        this.scaleSVGShapeTo1(shapes);
        Shape oldClip = sg.getGraphics().getClip();
        try {
            Area a = SVGFillArtist.calculateFillArea(shapeToFill, oldClip);
            sg.setColor(Color.black);
            for (SVGShape sp : shapes) {
                this.scaleShapeToSize(sp, this.tileSize);
                this.updateStrokeWidthScale(sp);
                this.updatePainterColours(sp.painter, Color.magenta, fillColour);
            }
            sg.setStroke(0.3f);
            GeneralPath outlinePath = new GeneralPath(a);
            Shape transformedArea = outlinePath.createTransformedShape(AffineTransform.getScaleInstance(100.0, 100.0));
            if (SHOW_BORDER) {
                sg.getGraphics().draw(transformedArea);
            }
            sg.setClip(transformedArea);
            double step = this.tileSize + this.padding;
            double halfTile = (double)this.tileSize * 0.5;
            int numX = (int)Math.ceil(a.getBounds2D().getWidth() / step);
            int numY = (int)Math.ceil(a.getBounds2D().getHeight() / step);
            double startX = a.getBounds2D().getMinX();
            double startY = a.getBounds2D().getMinY();
            for (int i = 0; i < numX; ++i) {
                for (int j = 0; j < numY; ++j) {
                    double dx = startX + (double)i * step + halfTile;
                    double dy = startY + (double)j * step + halfTile;
                    sg.setColor(Color.black);
                    sg.setStroke(0.3f);
                    for (SVGShape sp : shapes) {
                        GeneralPath gp2 = new GeneralPath(sp.shape);
                        gp2.transform(AffineTransform.getTranslateInstance(dx, dy));
                        gp2.transform(AffineTransform.getScaleInstance(100.0, 100.0));
                        if (SHOW_TILE_OUTLINE) {
                            sg.setColor(Color.black);
                            sg.drawRect((float)(startX + (double)i * step), (float)(startY + (double)j * step), this.tileSize, this.tileSize);
                        }
                        sp.painter.setShape((Shape)gp2);
                        sp.painter.paint(sg.getGraphics());
                    }
                }
            }
        }
        finally {
            sg.getGraphics().setClip(oldClip);
        }
    }

    private void updateStrokeWidthScale(SVGShape sp) {
        ShapePainter shapePainter = sp.painter;
        if (shapePainter instanceof StrokeShapePainter) {
            StrokeShapePainter ssp = (StrokeShapePainter)shapePainter;
            this.updateStrokeShapePainterStroke(ssp);
        } else {
            shapePainter = sp.painter;
            if (shapePainter instanceof CompositeShapePainter) {
                CompositeShapePainter csp = (CompositeShapePainter)shapePainter;
                for (int n = 0; n < csp.getShapePainterCount(); ++n) {
                    ShapePainter p = csp.getShapePainter(n);
                    if (!(p instanceof StrokeShapePainter)) continue;
                    StrokeShapePainter ssp = (StrokeShapePainter)p;
                    this.updateStrokeShapePainterStroke(ssp);
                }
            }
        }
    }

    private void updateStrokeShapePainterStroke(StrokeShapePainter ssp) {
        Stroke stroke = ssp.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke s = (BasicStroke)stroke;
            float newWidth = s.getLineWidth() / 2.8346457f;
            BasicStroke newStroke = new BasicStroke(newWidth, s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), s.getDashArray(), s.getDashPhase());
            ssp.setStroke((Stroke)newStroke);
        }
    }

    private void updatePainterColours(ShapePainter sp, Color colourToReplace, Color replacementColour) {
        if (sp instanceof StrokeShapePainter) {
            Color c;
            StrokeShapePainter ssp = (StrokeShapePainter)sp;
            Paint paint = ssp.getPaint();
            if (paint instanceof Color && (c = (Color)paint).equals(colourToReplace)) {
                ssp.setPaint((Paint)replacementColour);
            }
        } else if (sp instanceof FillShapePainter) {
            Color c;
            FillShapePainter fsp = (FillShapePainter)sp;
            Paint paint = fsp.getPaint();
            if (paint instanceof Color && (c = (Color)paint).equals(colourToReplace)) {
                fsp.setPaint((Paint)replacementColour);
            }
        } else if (sp instanceof CompositeShapePainter) {
            CompositeShapePainter csp = (CompositeShapePainter)sp;
            for (int n = 0; n < csp.getShapePainterCount(); ++n) {
                ShapePainter child = csp.getShapePainter(n);
                this.updatePainterColours(child, colourToReplace, replacementColour);
            }
        }
    }

    private void scaleShapeToSize(SVGShape sp, float size) {
        GeneralPath gp2 = new GeneralPath(sp.shape);
        sp.shape = gp2.createTransformedShape(AffineTransform.getScaleInstance(size, size));
        sp.painter.setShape(sp.shape);
    }

    private static Area calculateFillArea(Shape shapeToFill, Shape oldClip) {
        Area a;
        if (oldClip != null) {
            a = new Area(oldClip);
            a.intersect(new Area(shapeToFill));
        } else {
            a = new Area(shapeToFill);
        }
        return a;
    }

    public void scaleSVGShapeTo1(List<SVGShape> shapes) {
        GeneralPath gp;
        double maxSize = 0.0;
        for (SVGShape s : shapes) {
            double m = Math.max(s.shape.getBounds2D().getWidth(), s.shape.getBounds2D().getHeight());
            maxSize = Math.max(m, maxSize);
        }
        Rectangle2D overallBounds = this.getOverallBounds(shapes);
        maxSize = Math.max(overallBounds.getHeight(), overallBounds.getWidth());
        double scaleToOne = 1.0 / maxSize;
        AffineTransform at = new AffineTransform(scaleToOne, 0.0, 0.0, -scaleToOne, -0.5, 0.5);
        for (SVGShape s : shapes) {
            gp = new GeneralPath(s.shape);
            s.shape = gp.createTransformedShape(at);
            s.painter.setShape(s.shape);
        }
        overallBounds = this.getOverallBounds(shapes);
        at = AffineTransform.getTranslateInstance(-overallBounds.getX() - 0.5 * overallBounds.getWidth(), -overallBounds.getY() - 0.5 * overallBounds.getHeight());
        for (SVGShape s : shapes) {
            gp = new GeneralPath(s.shape);
            s.shape = gp.createTransformedShape(at);
            s.painter.setShape(s.shape);
        }
    }

    private Rectangle2D getOverallBounds(List<SVGShape> shapes) {
        Rectangle2D overallBounds = null;
        for (SVGShape s : shapes) {
            if (overallBounds == null) {
                overallBounds = s.shape.getBounds2D();
                continue;
            }
            Rectangle2D bounds = s.shape.getBounds2D();
            double x = Math.min(overallBounds.getX(), bounds.getX());
            double y = Math.min(overallBounds.getY(), bounds.getY());
            double xMax = overallBounds.getX() + overallBounds.getWidth();
            double yMax = overallBounds.getY() + overallBounds.getHeight();
            if (xMax < bounds.getX() + bounds.getWidth()) {
                xMax = bounds.getX() + bounds.getWidth();
            }
            if (yMax < bounds.getY() + bounds.getHeight()) {
                yMax = bounds.getY() + bounds.getHeight();
            }
            overallBounds.setRect(x, y, xMax - x, yMax - y);
        }
        return overallBounds;
    }

    private List<SVGShape> getShapesFromDocument() {
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
        ctx.setDynamic(true);
        GVTBuilder builder = new GVTBuilder();
        GraphicsNode n = builder.build(ctx, (Document)this.doc);
        List<SVGShape> shapes = this.getSVGShape(n);
        return shapes;
    }

    private List<SVGShape> getSVGShape(GraphicsNode node) {
        if (!node.isVisible()) {
            return null;
        }
        ArrayList<SVGShape> result = new ArrayList<SVGShape>();
        if (node instanceof ShapeNode) {
            ShapeNode shapeNode = (ShapeNode)node;
            result.add(this.getSVGShapeFromShapeNode(shapeNode));
        } else if (node instanceof CompositeGraphicsNode) {
            CompositeGraphicsNode compositeNode = (CompositeGraphicsNode)node;
            this.getSVGShapeFromComposite(compositeNode, result);
        }
        return result;
    }

    private void getSVGShapeFromComposite(CompositeGraphicsNode compositeNode, List<SVGShape> result) {
        for (Object child : compositeNode.getChildren()) {
            if (child instanceof ShapeNode) {
                ShapeNode shapeChild = (ShapeNode)child;
                result.add(this.getSVGShapeFromShapeNode(shapeChild));
            }
            if (!(child instanceof CompositeGraphicsNode)) continue;
            CompositeGraphicsNode compositeChild = (CompositeGraphicsNode)child;
            this.getSVGShapeFromComposite(compositeChild, result);
        }
    }

    private SVGShape getSVGShapeFromShapeNode(ShapeNode sn) {
        SVGShape s = new SVGShape(this);
        s.shape = sn.getShape();
        s.painter = sn.getShapePainter();
        return s;
    }

    private static SVGDocument loadSVGDocument(String uri) {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        SVGDocument svgDocument = null;
        try {
            svgDocument = factory.createSVGDocument(uri);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return svgDocument;
    }

    private static SVGDocument loadSVGDocumentFromString(String svgString) {
        StringReader reader = new StringReader(svgString);
        String uri = "file:local";
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        SVGDocument svgDocument = null;
        try {
            svgDocument = factory.createSVGDocument(uri, (Reader)reader);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return svgDocument;
    }

    class SVGShape {
        public Shape shape;
        public ShapePainter painter;

        SVGShape(SVGFillArtist this$0) {
            Objects.requireNonNull(this$0);
        }
    }
}

