/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import jsbchart.block.IBlockProperties;
import model3.Lastval;
import model3.SBdb;

public class BlockProperties
implements IBlockProperties {
    ScaleType scaleType;
    ScaleType labelScaleType = null;
    boolean ageLeftToRight = Default_Age_LTR;
    char units = (char)77;
    private final List<ScaleProperties> scales = new ArrayList<ScaleProperties>();
    private float height;
    private EnumMap<ScaleType, BlockProperties> altProp;
    private static boolean Default_Age_LTR = false;
    private static final String DEFAULT_AGE_LTR_KEY = "AGELTR";

    public int getnScaleSections() {
        return this.scales.size();
    }

    public void addScaleSection(float value) {
        int index;
        ScaleProperties newSection = new ScaleProperties();
        newSection.min = value;
        newSection.max = value;
        newSection.scale = this.scales.get((int)this.getLongestSection()).scale;
        if (value < this.scales.get((int)0).min) {
            newSection.max = this.scales.get((int)0).min;
            this.scales.add(0, newSection);
            return;
        }
        for (index = 0; index < this.scales.size(); ++index) {
            if (!(value < this.scales.get((int)index).max)) continue;
            newSection.max = this.scales.get((int)index).max;
            this.scales.get((int)index).max = value;
            ++index;
            break;
        }
        if (index == this.scales.size()) {
            newSection.min = this.scales.get((int)(this.scales.size() - 1)).max;
            this.scales.add(newSection);
            return;
        }
        this.scales.add(index, newSection);
    }

    public void addScaleSection(float min, float max, float scale) {
        ScaleProperties sp = new ScaleProperties();
        sp.min = min;
        sp.max = max;
        sp.scale = scale;
        if (this.scales.get((int)0).min > max) {
            this.scales.add(0, sp);
        } else {
            this.scales.add(sp);
        }
        ArrayList<ScaleProperties> trimScales = this.trimScales();
        this.scales.clear();
        this.scales.addAll(trimScales);
    }

    public int getLongestSection() {
        if (this.scales.size() == 1) {
            return 0;
        }
        float largestSectionSize = -1.0f;
        int index = -1;
        for (int i = 0; i < this.scales.size(); ++i) {
            ScaleProperties sp = this.scales.get(i);
            float sectionSize = sp.max - sp.min;
            if (!(sectionSize > largestSectionSize)) continue;
            largestSectionSize = sectionSize;
            index = i;
        }
        return index;
    }

    public float scaleDepth(float depth) {
        if (this.scaleType == ScaleType.AGE) {
            throw new IllegalStateException("Illegal scale of depth value");
        }
        float total = 0.0f;
        for (ScaleProperties scale : this.scales) {
            if (this.scales.size() == 1 || depth <= scale.max) {
                total += (depth - scale.min) * 1000.0f / scale.scale;
                break;
            }
            total += (scale.max - scale.min) * 1000.0f / scale.scale;
        }
        if (this.scaleType == ScaleType.SUBSIDENCE) {
            total = this.calcHeight() - total - this.scales.get((int)0).min * 1000.0f / this.scales.get((int)0).scale;
        }
        return total;
    }

    float getDepth(float yPos) {
        if (this.scaleType == ScaleType.AGE) {
            throw new IllegalStateException("Illegal scale of depth value");
        }
        float depth = this.getDepthFromScales(yPos);
        if (this.scaleType == ScaleType.SUBSIDENCE && this.scales.size() == 1 && !Float.isNaN(depth)) {
            float diff;
            float maxMD = this.scales.get((int)0).max;
            depth = diff = maxMD - depth;
        }
        return depth;
    }

    float getDepthFromScales(float yPos) {
        float total = 0.0f;
        for (ScaleProperties scale : this.scales) {
            float scaleHeight = (scale.max - scale.min) * 1000.0f / scale.scale;
            if (yPos < scaleHeight + total) {
                return (yPos - total) * scale.scale / 1000.0f + scale.min;
            }
            total += scaleHeight;
        }
        return Float.NaN;
    }

    public float scaleAge(float age) {
        return this.scaleAge(age, true);
    }

    public float scaleAge(float age, boolean clip) {
        if (this.scaleType != ScaleType.AGE) {
            throw new IllegalStateException("Illegal scale of age value");
        }
        float total = 0.0f;
        for (ScaleProperties scale : this.scales) {
            if (this.scales.size() == 1 || age <= scale.max) {
                if (clip && age < scale.min) break;
                total += (age - scale.min) * scale.scale;
                break;
            }
            total += (scale.max - scale.min) * scale.scale;
        }
        return total;
    }

    public float getAge(float yPos) {
        if (this.scaleType != ScaleType.AGE) {
            throw new IllegalStateException("Illegal scale of age value");
        }
        float total = 0.0f;
        for (ScaleProperties scale : this.scales) {
            float scaleHeight = (scale.max - scale.min) * scale.scale;
            if (yPos < scaleHeight + total) {
                return (yPos - total) / scale.scale + scale.min;
            }
            total += scaleHeight;
        }
        return Float.NaN;
    }

    public float calcHeight() {
        this.height = 0.0f;
        this.scales.forEach(scale -> {
            this.height = this.scaleType == ScaleType.AGE ? (this.height += (scale.max - scale.min) * scale.scale) : (this.height += Math.abs(scale.max - scale.min) * 1000.0f / scale.scale);
        });
        return this.getHeight();
    }

    public float getHeight() {
        return this.height;
    }

    void setHeight(float height) {
        this.height = height;
    }

    public int nAltProp() {
        return this.altProp.size();
    }

    public boolean hasAltProp(ScaleType key) {
        return this.altProp.get((Object)key) != null;
    }

    public BlockProperties getAltProp(ScaleType key) {
        if (this.altProp.get((Object)key) == null) {
            this.altProp.put(key, new BlockProperties(key));
        }
        return this.altProp.get((Object)key);
    }

    public BlockProperties getAltProp() {
        return this.altProp.values().iterator().next();
    }

    void retainAltProp(Set<ScaleType> required) {
        this.altProp.keySet().retainAll(required);
    }

    public float getAltMin(ScaleType key) {
        return this.getAltProp(key).getMin();
    }

    public float getAltMax(ScaleType key) {
        return this.getAltProp(key).getMax();
    }

    public float getAltScale(ScaleType key) {
        return this.getAltProp(key).getScale(0);
    }

    public boolean getAltAgeLeftToRight(ScaleType key) {
        return this.getAltProp((ScaleType)key).ageLeftToRight;
    }

    public BlockProperties() {
        this.scales.add(new ScaleProperties());
        this.altProp = new EnumMap(ScaleType.class);
        this.scaleType = ScaleType.MD;
    }

    public BlockProperties(ScaleType scaleType) {
        this.scales.add(new ScaleProperties());
        this.altProp = new EnumMap(ScaleType.class);
        this.scaleType = scaleType;
        if (scaleType == ScaleType.AGE) {
            this.setScale(5.0f);
        }
    }

    public boolean setScaleType(ScaleType scaleType) {
        boolean change = this.scaleType != scaleType;
        this.scaleType = scaleType;
        return change;
    }

    public boolean setLabelScaleType(ScaleType scaleType) {
        boolean change = this.labelScaleType != scaleType;
        this.labelScaleType = scaleType;
        return change;
    }

    public boolean getNormal() {
        return true;
    }

    private ArrayList<ScaleProperties> trimScales() {
        ArrayList<ScaleProperties> newScales = new ArrayList<ScaleProperties>();
        for (ScaleProperties p : this.scales) {
            if (this.scales.size() > 1 && (double)Math.abs(p.max - p.min) < 0.0029) continue;
            if (!newScales.isEmpty() && (double)Math.abs(newScales.get((int)(newScales.size() - 1)).scale - p.scale) < 0.1) {
                newScales.get((int)(newScales.size() - 1)).max = p.max;
                continue;
            }
            ScaleProperties newsp = new ScaleProperties();
            newsp.min = p.min;
            newsp.max = p.max;
            newsp.scale = p.scale;
            newScales.add(newsp);
        }
        return newScales;
    }

    @Override
    public String getProperties() {
        Object string = new String();
        String[] props = new String[7];
        props[0] = this.scaleType.name();
        props[1] = "" + this.units;
        ArrayList<ScaleProperties> trimmedScales = this.trimScales();
        props[2] = "" + trimmedScales.get((int)0).min;
        props[3] = "" + trimmedScales.get((int)0).max;
        props[4] = "" + trimmedScales.get((int)0).scale;
        props[5] = "" + (this.ageLeftToRight ? 1 : 0);
        props[6] = this.labelScaleType != null ? this.labelScaleType.name() : "";
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        for (BlockProperties alt : this.altProp.values()) {
            string = (String)string + "^" + alt.getProperties();
        }
        if (trimmedScales.size() > 1) {
            for (int i = 1; i < trimmedScales.size(); ++i) {
                string = (String)string + "," + trimmedScales.get((int)i).min + "|" + trimmedScales.get((int)i).max + "|" + trimmedScales.get((int)i).scale;
            }
        }
        return string;
    }

    public BlockProperties(String props) {
        this.scales.add(new ScaleProperties());
        this.altProp = new EnumMap(ScaleType.class);
        if (props == null || props.isEmpty()) {
            this.scaleType = ScaleType.MD;
            return;
        }
        if (props.indexOf(44) > 0) {
            String[] scaleSplits;
            String scaleString = props.substring(props.indexOf(44) + 1);
            for (String scaleToken : scaleSplits = scaleString.split(",")) {
                ScaleProperties sp = new ScaleProperties();
                String[] scalePropertiesElements = scaleToken.split("\\|");
                block15: for (int i = 0; i < scalePropertiesElements.length; ++i) {
                    switch (i) {
                        case 0: {
                            sp.min = Float.parseFloat(scalePropertiesElements[i]);
                            continue block15;
                        }
                        case 1: {
                            sp.max = Float.parseFloat(scalePropertiesElements[i]);
                            continue block15;
                        }
                        case 2: {
                            sp.scale = Float.parseFloat(scalePropertiesElements[i]);
                        }
                    }
                }
                this.scales.add(sp);
            }
            props = props.substring(0, props.indexOf(44));
        }
        String[] altSplit = props.split("\\^");
        for (int j = 0; j < altSplit.length; ++j) {
            String altProps = altSplit[j];
            String[] split = altProps.split("\\|");
            BlockProperties bp = j == 0 ? this : new BlockProperties();
            block17: for (int i = 0; i < split.length; ++i) {
                switch (i) {
                    case 0: {
                        bp.scaleType = ScaleType.valueOf(split[i]);
                        continue block17;
                    }
                    case 1: {
                        bp.units = split[i].charAt(0);
                        continue block17;
                    }
                    case 2: {
                        bp.scales.get((int)0).min = Float.parseFloat(split[i]);
                        continue block17;
                    }
                    case 3: {
                        bp.scales.get((int)0).max = Float.parseFloat(split[i]);
                        continue block17;
                    }
                    case 4: {
                        bp.scales.get((int)0).scale = Float.parseFloat(split[i]);
                        continue block17;
                    }
                    case 5: {
                        bp.ageLeftToRight = Integer.parseInt(split[i]) == 1;
                        continue block17;
                    }
                    case 6: {
                        this.labelScaleType = split[i].length() > 0 ? ScaleType.valueOf(split[i]) : null;
                    }
                }
            }
            if (j <= 0) continue;
            this.altProp.put(bp.scaleType, bp);
        }
    }

    public boolean setLimits(float min, float max) {
        boolean change;
        boolean bl = change = (double)Math.abs(this.getMin() - min) > 0.001 || (double)Math.abs(this.getMax() - max) > 0.001;
        if (min > max) {
            throw new IllegalArgumentException("Max depth must be less than min depth");
        }
        assert (this.scales.size() == 1);
        this.scales.get((int)0).min = min;
        this.scales.get((int)0).max = max;
        return change;
    }

    public final boolean setScale(float scale) {
        assert (this.scales.size() == 1);
        return this.setScale(scale, 0);
    }

    public final boolean setScale(float scale, int section) {
        boolean change = (double)Math.abs(this.getScale(section) - scale) > 0.001;
        this.scales.get((int)section).scale = scale;
        return change;
    }

    public boolean setUnits(char units) {
        boolean change = this.units != units;
        this.units = units;
        return change;
    }

    public boolean setAgeLeftToRight(boolean ageLTR, SBdb sbdb) {
        boolean change = this.ageLeftToRight != ageLTR;
        this.ageLeftToRight = ageLTR;
        if (ageLTR != Default_Age_LTR && sbdb != null) {
            try {
                Lastval.putString((SBdb)sbdb, (String)DEFAULT_AGE_LTR_KEY, (String)Boolean.toString(ageLTR));
                sbdb.commit();
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
            Default_Age_LTR = ageLTR;
        }
        return change;
    }

    public float getMax() {
        return this.getMax(this.scales.size() - 1);
    }

    public float getMax(int section) {
        return this.scales.get((int)section).max;
    }

    public final void setMax(float max) {
        assert (this.scales.size() == 1);
        this.scales.get((int)0).max = max;
    }

    final void setMax(float max, int section) {
        if (section < 0 || section > this.scales.size() - 1) {
            throw new IllegalArgumentException("Attempt to set max value for scale section " + section + " of " + this.scales.size());
        }
        if (section < this.scales.size() - 1) {
            ListIterator<ScaleProperties> it = this.scales.listIterator(section + 1);
            while (it.hasNext()) {
                ScaleProperties sp = it.next();
                if (sp.max < max) {
                    it.remove();
                    continue;
                }
                sp.min = max;
                break;
            }
        }
        this.scales.get((int)section).max = max;
    }

    public float getMin() {
        return this.getMin(0);
    }

    public float getMin(int section) {
        return this.scales.get((int)section).min;
    }

    public final void setMin(float min) {
        assert (this.scales.size() == 1);
        this.scales.get((int)0).min = min;
    }

    final void setMin(float min, int section) {
        if (section < 0 || section > this.scales.size() - 1) {
            throw new IllegalArgumentException("Attempt to set min value for scale section " + section + " of " + this.scales.size());
        }
        assert (min <= this.scales.get((int)section).max);
        if (section > 0) {
            ListIterator<ScaleProperties> it = this.scales.listIterator(section);
            while (it.hasPrevious()) {
                ScaleProperties sp = it.previous();
                sp.max = min;
                if (!(sp.min > sp.max)) break;
                it.remove();
                --section;
            }
        }
        this.scales.get((int)section).min = min;
    }

    @Override
    public float getScaleLimit(IBlockProperties.ScaleLimitType type) {
        return switch (type) {
            case IBlockProperties.ScaleLimitType.MIN -> this.getMin();
            case IBlockProperties.ScaleLimitType.MAX -> this.getMax();
            default -> throw new IllegalArgumentException("Unknown scale limit type: " + String.valueOf((Object)type));
        };
    }

    final void setOverallMin(float min) {
        ListIterator<ScaleProperties> it = this.scales.listIterator();
        while (it.hasNext()) {
            ScaleProperties scale = it.next();
            scale.min = min;
            if (min >= scale.max) {
                if (it.hasNext()) {
                    it.remove();
                    continue;
                }
                scale.max = min;
            }
            return;
        }
    }

    final void setOverallMax(float max) {
        ListIterator<ScaleProperties> it = this.scales.listIterator(this.scales.size());
        while (it.hasPrevious()) {
            ScaleProperties scale = it.previous();
            scale.max = max;
            if (max <= scale.min) {
                if (it.hasPrevious()) {
                    it.remove();
                    continue;
                }
                scale.min = max;
            }
            return;
        }
    }

    public float getScale() {
        assert (this.scales.size() == 1);
        return this.getScale(this.getLongestSection());
    }

    public float getScale(int section) {
        return this.scales.get((int)section).scale;
    }

    public Float getScale(float value) {
        for (ScaleProperties p : this.scales) {
            if (!(value >= p.min) || !(value <= p.max)) continue;
            return Float.valueOf(p.scale);
        }
        return null;
    }

    public float getSingleScale() {
        if (this.scales.size() > 1) {
            throw new IllegalStateException("Attempt to get single scale when there are " + this.scales.size() + " scale sections");
        }
        return this.scales.get((int)0).scale;
    }

    @Override
    public ScaleType getScaleType() {
        return this.scaleType;
    }

    public ScaleType getWorkingLabelScaleType() {
        if (this.labelScaleType == null) {
            return this.scaleType;
        }
        return this.labelScaleType;
    }

    @Override
    public ScaleType getLabelScaleType() {
        return this.labelScaleType;
    }

    public char getUnits() {
        return this.units;
    }

    public boolean getAgeLeftToRight() {
        return this.ageLeftToRight;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockProperties)) {
            return false;
        }
        BlockProperties comp = (BlockProperties)o;
        if (!Objects.equals(this.scales, comp.scales)) {
            return false;
        }
        if (this.scaleType != comp.scaleType) {
            return false;
        }
        if (this.units != comp.units) {
            return false;
        }
        if (this.ageLeftToRight == comp.ageLeftToRight) {
            return false;
        }
        return this.altProp.equals((Object)comp.altProp);
    }

    public static void loadDefaults(SBdb sbdb) throws SQLException {
        String s = Lastval.getString((SBdb)sbdb, (String)DEFAULT_AGE_LTR_KEY);
        if (!s.isEmpty()) {
            Default_Age_LTR = Boolean.valueOf(s);
        }
    }

    private static class ScaleProperties {
        private float min;
        private float max;
        private float scale = 2000.0f;

        private ScaleProperties() {
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + Float.floatToIntBits(this.min);
            hash = 37 * hash + Float.floatToIntBits(this.max);
            hash = 37 * hash + Float.floatToIntBits(this.scale);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScaleProperties other = (ScaleProperties)obj;
            if (Float.floatToIntBits(this.min) != Float.floatToIntBits(other.min)) {
                return false;
            }
            if (Float.floatToIntBits(this.max) != Float.floatToIntBits(other.max)) {
                return false;
            }
            return Float.floatToIntBits(this.scale) == Float.floatToIntBits(other.scale);
        }
    }

    public static enum ScaleType {
        MD,
        TVD,
        AGE,
        SUBSIDENCE,
        TWT;

    }
}

