/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.SchemeBlock;
import jsbchart.core.ChartProperties;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import util.NumberUtils;

public class BlockUtils {
    private BlockUtils() {
    }

    public static void setBlockDatumOffsets(List<ChartBlockBase> baseBlocks, List<Correlation> correlations, ChartProperties cp) {
        List<ChartBlock> blocks = baseBlocks.stream().filter(block -> block instanceof ChartBlock).map(bBlock -> (ChartBlock)bBlock).collect(Collectors.toList());
        if (blocks.isEmpty()) {
            return;
        }
        ArrayList<CorrelationLine> datum = new ArrayList<CorrelationLine>();
        for (Correlation c : correlations) {
            if (!c.hasDatum()) continue;
            datum.add(c.getDatumPrimary());
            datum.add(c.getDatumSecondary());
        }
        if (!datum.isEmpty()) {
            BlockUtils.setDatumOffsetsByCorrelation(blocks, datum);
            return;
        }
        if (BlockUtils.setDatumOffsetsByAge(blocks)) {
            return;
        }
        BlockUtils.setDefaultChartDatumOffset(blocks, cp.getChartDatum());
    }

    private static void setDatumOffsetsByCorrelation(List<ChartBlock> blocks, List<CorrelationLine> datum) {
        Float[] offsets = new Float[blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            offsets[i] = blocks.get(i).getYPos(datum.get(0));
        }
        if (datum.get(1) != null) {
            boolean hasNulls = false;
            for (Float offset : offsets) {
                if (offset != null) continue;
                hasNulls = true;
                break;
            }
            if (hasNulls) {
                Float[] offsets2 = new Float[blocks.size()];
                for (int i = 0; i < blocks.size(); ++i) {
                    offsets2[i] = blocks.get(i).getYPos(datum.get(1));
                }
                ArrayList<ChartBlock> blocksWithBoth = new ArrayList<ChartBlock>();
                for (int i = 0; i < offsets2.length; ++i) {
                    if (offsets[i] == null || offsets2[i] == null) continue;
                    blocksWithBoth.add(blocks.get(i));
                }
                ChartBlock theChosenOne = null;
                if (blocksWithBoth.size() == 1) {
                    theChosenOne = (ChartBlock)blocksWithBoth.get(0);
                } else {
                    for (ChartBlock cb : blocksWithBoth) {
                        if (!(cb instanceof SchemeBlock)) continue;
                        if (theChosenOne == null) {
                            theChosenOne = cb;
                            continue;
                        }
                        theChosenOne = null;
                        break;
                    }
                }
                if (theChosenOne != null) {
                    int index = blocks.indexOf(theChosenOne);
                    float offsetDiff = offsets2[index].floatValue() - offsets[index].floatValue();
                    for (int i = 0; i < offsets2.length; ++i) {
                        if (offsets[i] != null || offsets2[i] == null) continue;
                        offsets[i] = Float.valueOf(offsets2[i].floatValue() - offsetDiff);
                    }
                } else {
                    for (int i = 0; i < offsets2.length; ++i) {
                        if (offsets[i] != null || offsets2[i] == null) continue;
                        offsets[i] = offsets2[i];
                    }
                }
            }
        }
        BlockUtils.setOffsets(blocks, offsets);
    }

    private static boolean setDatumOffsetsByAge(List<ChartBlock> blocks) {
        boolean allAge = true;
        float[] scales = new float[blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            ChartBlock block = blocks.get(i);
            block.setDatumOffset(0.0f);
            allAge = allAge && block.getProp().getScaleType() == BlockProperties.ScaleType.AGE;
            scales[i] = block.getProp().getScale(block.getProp().getLongestSection());
        }
        if (!allAge || !NumberUtils.allEqual((float[])scales)) {
            return false;
        }
        Float minAge = null;
        for (ChartBlock block : blocks) {
            float blockMinAge = block.getProp().getMin();
            if (minAge != null && !(blockMinAge < minAge.floatValue())) continue;
            minAge = Float.valueOf(blockMinAge);
        }
        for (ChartBlock block : blocks) {
            block.setDatumOffset(block.scale(block.getProp().getMin(), BlockProperties.ScaleType.AGE) - block.scale(minAge.floatValue(), BlockProperties.ScaleType.AGE));
        }
        return true;
    }

    private static void setDefaultChartDatumOffset(List<ChartBlock> blocks, ChartProperties.ChartDatum datum) {
        if (datum == ChartProperties.ChartDatum.NONE) {
            return;
        }
        Float[] offsets = new Float[blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            ChartBlock block = blocks.get(i);
            if (block.getWell() == null || block.getWells().size() > 1) continue;
            float offset = 0.0f;
            switch (datum) {
                case SB: {
                    offset = block.getWell().getHeader().getSBDepth();
                    break;
                }
                case SL: {
                    offset = block.getWell().getHeader().getSLDepth();
                    break;
                }
                case RT: {
                    offset = block.getWell().getHeader().getRTDepth();
                }
            }
            offsets[i] = Float.valueOf(block.scale(offset, BlockProperties.ScaleType.MD));
        }
        BlockUtils.setOffsets(blocks, offsets);
    }

    private static void setOffsets(List<ChartBlock> blocks, Float[] offsets) {
        float maxOffset = Float.NEGATIVE_INFINITY;
        float minOffset = Float.POSITIVE_INFINITY;
        for (Float offset : offsets) {
            if (offset == null) continue;
            if (offset.floatValue() > maxOffset) {
                maxOffset = offset.floatValue();
            }
            if (!(offset.floatValue() < minOffset)) continue;
            minOffset = offset.floatValue();
        }
        if (minOffset < 0.0f) {
            for (int i = 0; i < offsets.length; ++i) {
                if (offsets[i] == null) continue;
                Float[] floatArray = offsets;
                int n = i;
                Float.valueOf(floatArray[n].floatValue() + Math.abs(minOffset));
            }
            maxOffset -= minOffset;
        }
        for (int i = 0; i < blocks.size(); ++i) {
            if (offsets[i] != null) {
                blocks.get(i).setDatumOffset(maxOffset - offsets[i].floatValue());
                continue;
            }
            blocks.get(i).setDatumOffset(0.0f);
        }
    }
}

