/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import com.stratadata.model3.well.SectionType;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.IBlockProperties;
import jsbchart.block.SchemeBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrDrawUtils;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartPropertyChangedNotification;
import jsbchart.listener.ChartUpdate;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelFactory;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import jsbchart.util.DrawZone;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.InterpHdr;
import model3.SBdb;
import model3.SQPick;
import model3.TVDList;
import model3.TVDepth;
import model3.TWTDepth;
import model3.TWTList;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import model3.WsWell;
import model3.wellinterp.InterpItem;
import util.DepthUnits;
import util.FloatRange;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public abstract class ChartBlock
extends ChartBlockBase
implements Observer {
    private static final Logger LOGGER = Logger.getLogger(ChartBlock.class.getName());
    LinkedList<SBPanel> panels = new LinkedList();
    protected BlockProperties prop;
    private float datumOffset;
    private final EnumMap<CorrelationType, HashSet<CorrelationPoint>> correlationLines = new EnumMap(CorrelationType.class);

    ChartBlock(SBdb sbdb, BlockTemplate template) {
        super(template, sbdb, false);
        this.correlationLines.put(CorrelationType.EVENT, null);
        this.correlationLines.put(CorrelationType.SURFACE, null);
        this.correlationLines.put(CorrelationType.CHRONO, null);
        this.correlationLines.put(CorrelationType.LITHO, null);
    }

    @Override
    public void terminate() {
        super.terminate();
        for (ChartPanel chartPanel : this.panels) {
            chartPanel.terminate();
        }
    }

    public void setProperties(BlockProperties prop) {
        this.prop = prop;
    }

    @Override
    public String getProperties() {
        return this.prop.getProperties();
    }

    @Override
    void clearMemberWellObservation(Well well) {
        WellInterp origInterp = null;
        if (well.hasInterpLoaded(this.getInterpID())) {
            try {
                origInterp = this.getWell().getInterp(this.getInterpID());
            }
            catch (SBException e) {
                e.printStackTrace();
            }
        }
        for (SBPanel panel : this.panels) {
            well.deleteWeakObserver((Observer)panel);
            if (origInterp == null) continue;
            origInterp.deleteWeakObserver((Observer)panel);
        }
        well.deleteWeakObserver((Observer)this);
    }

    @Override
    void initMemberWellObservation(Well well) {
        try {
            WellInterp newInterp = well.getInterp(this.getInterpID());
            for (SBPanel panel : this.panels) {
                if (panel.getPanelType().isWellObserver()) {
                    well.addWeakObserver((Observer)panel);
                }
                if (!panel.getPanelType().isInterpPanel()) continue;
                if (panel.getPanelOcc().getInterpID() == null) {
                    if (newInterp == null) continue;
                    newInterp.addWeakObserver((Observer)panel);
                    continue;
                }
                WellInterp independentInterp = well.getAddInterp(this.getDb().getInterp(panel.getPanelOcc().getInterpID().intValue()));
                if (independentInterp != null) {
                    independentInterp.addWeakObserver((Observer)panel);
                    continue;
                }
                assert (false);
            }
        }
        catch (SQLException | SBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    String getCaptionElement(CaptionTemplate el, ChartProperties cp) {
        switch (el) {
            case UNITS: {
                return com.stratadata.util.depth.DepthUnits.getUnits((char)this.getProp().getUnits()).getAbr();
            }
        }
        return super.getCaptionElement(el, cp);
    }

    @Override
    public float getHeight() {
        return this.prop.calcHeight();
    }

    public SBPanel createPanel(PanelTemplate panelTemplate, PanelOcc po) throws SQLException, SBException {
        if (this.getTemplate() == null && !panelTemplate.isVisible()) assert (false);
        return (SBPanel)PanelFactory.createPanel(this, panelTemplate, po);
    }

    @Override
    public List<ChartPanel> addNewMember(PanelTemplate templ, PanelOcc occ) throws SQLException, SBException {
        List<SBPanel> newMembers = Arrays.asList(this.createPanel(templ, occ));
        this.addPanels(newMembers);
        return List.copyOf(newMembers);
    }

    public float getPanelHeaderHeight(ChartProperties cp, Chart.Mode mode) {
        if (mode != null) {
            switch (mode) {
                case NO_HEADER: {
                    return 0.0f;
                }
            }
        }
        return Math.max(this.getHeaderHeight(cp), cp.getPanelHeaderHeight());
    }

    @Override
    public float getTotalHeight(ChartProperties p, Chart.Mode hMode) {
        return this.prop.getHeight() + this.getPanelHeaderHeight(p, hMode);
    }

    float drawPanels(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> correlationLines, Chart.Mode vMode) {
        int i;
        if (p.bgBlocks) {
            this.drawBackgroundIGD(g, x, y, p, mode);
        }
        LinkedList<SBPanel> pList = new LinkedList<SBPanel>();
        switch (vMode) {
            case NORMAL: {
                pList.addAll(this.panels);
                break;
            }
            case HEADER_ONLY: {
                int i2;
                for (i2 = 0; i2 < this.getnVHeaderPanels(p.getnVfreeze(), p.drawEmptyPanels) && i2 < this.panels.size(); ++i2) {
                    pList.add(this.panels.get(i2));
                }
                break;
            }
            case NO_HEADER: {
                int i2;
                if (this.panels.size() <= this.getnVHeaderPanels(p.getnVfreeze(), p.drawEmptyPanels)) break;
                for (i2 = this.getnVHeaderPanels(p.getnVfreeze(), p.drawEmptyPanels); i2 < this.panels.size(); ++i2) {
                    pList.add(this.panels.get(i2));
                }
                break;
            }
        }
        float[] panelXPos = ChartBlock.getPanelXpos(pList, x, p, this.prop);
        for (int i3 = 0; i3 < panelXPos.length; ++i3) {
            if (panelXPos[i3] < 0.0f) continue;
            ((SBPanel)pList.get(i3)).drawBackground(g, panelXPos[i3], y, p, this.prop, mode);
        }
        float maxXpos = x + this.getWidth(p);
        for (CorrelationType cType : correlationLines.keySet()) {
            int start = 0;
            for (i = 0; i < pList.size(); ++i) {
                if (panelXPos[i] < 0.0f) {
                    if (i != start) continue;
                    ++start;
                    continue;
                }
                if (!((SBPanel)pList.get(i)).drawsLines(cType) && i != pList.size() - 1) continue;
                this.drawCorrelationLines(g, panelXPos[start], ((SBPanel)pList.get(i)).drawsLines(cType) ? panelXPos[i] : maxXpos, y, p, mode, correlationLines.get(cType));
                for (start = i + 1; start < panelXPos.length && panelXPos[start] < 0.0f; ++start) {
                }
            }
            if (start >= panelXPos.length) continue;
            this.drawCorrelationLines(g, panelXPos[start], maxXpos, y, p, mode, correlationLines.get(cType));
        }
        boolean CONTENT = false;
        boolean FRAME = true;
        for (int k = 0; k < 2; ++k) {
            block20: for (i = 0; i < pList.size(); ++i) {
                SBPanel panel = (SBPanel)pList.get(i);
                if (panelXPos[i] < 0.0f) continue;
                block5 : switch (k) {
                    case 0: {
                        panel.draw(g, panelXPos[i], y, p, this.prop, mode, correlationLines);
                        continue block20;
                    }
                    case 1: {
                        if (panel.isOverplot() || i > 0 && panel.getWidth(this.prop) > 0.0f && Math.abs(panelXPos[i] - panelXPos[i - 1]) == 0.0f && ((SBPanel)pList.get(i - 1)).getWidth(this.prop) > 0.0f) continue block20;
                        switch (mode) {
                            case NORMAL: 
                            case HEADER_ONLY: {
                                panel.drawFrame(g, panelXPos[i], y, p, this, panel.getTemplatedCaption(p, this.prop), panel.getTemplatedSubCaption(p));
                                panel.drawSubHeader(g, panelXPos[i], y, p, this.prop);
                                break block5;
                            }
                            case NO_HEADER: {
                                panel.drawOutline(g, panelXPos[i], y, p, this.prop, mode);
                            }
                        }
                    }
                }
            }
        }
        return maxXpos;
    }

    static float[] getPanelXpos(List<SBPanel> pList, float x, ChartProperties p, BlockProperties prop) {
        float[] panelXPos = new float[pList.size()];
        float xpos = x;
        ChartPanel lastPlottedPanel = null;
        for (int i = 0; i < pList.size(); ++i) {
            SBPanel panel = pList.get(i);
            List<SBPanel> overplotPanels = panel.getOverplotPanels(p);
            if (!p.drawEmptyPanels && !panel.hasData(prop) && overplotPanels.isEmpty()) {
                panelXPos[i] = -1.0f;
                continue;
            }
            if (panel.isOverplot() && i > 0) {
                int prevPlottedPanel = 1;
                while (panelXPos[i - prevPlottedPanel] < 0.0f) {
                    ++prevPlottedPanel;
                }
                panelXPos[i] = panelXPos[i - prevPlottedPanel];
                continue;
            }
            if (p.hideAdjacentBlankPanels && panel.getPanelType() == PanelType.BLANK && lastPlottedPanel != null && lastPlottedPanel.getPanelType() == PanelType.BLANK) {
                panelXPos[i] = -1.0f;
                continue;
            }
            float panelWidth = panel.getWidth(prop);
            if (panelWidth < 1.0f) {
                panelXPos[i] = -1.0f;
                continue;
            }
            panelXPos[i] = xpos;
            xpos += panelWidth;
            lastPlottedPanel = panel;
        }
        return panelXPos;
    }

    public void drawCorrelationLines(SBGraphics g, float x, float x2, float y, ChartProperties cp, Chart.Mode mode, HashSet<CorrelationPoint> cLines) {
        if (cLines == null || Math.abs(x - x2) < 1.0f) {
            return;
        }
        float ypos = y + this.getPanelHeaderHeight(cp, mode);
        for (CorrelationPoint point : cLines) {
            CorrDrawUtils.drawCorrelationLine(g, point.line(), x, x2, ypos + point.ypos(), ypos + point.ypos(), false, cp, point.bnd());
        }
    }

    public synchronized ChartPanel getPanel(float x, float y, ChartProperties cp) {
        float width = 0.0f;
        for (SBPanel panel : this.panels) {
            if (!cp.drawEmptyPanels && !panel.hasData(this.prop) || panel.isOverplot() || !(x < (width += panel.getWidth(this.prop)))) continue;
            return panel;
        }
        return null;
    }

    public synchronized void addPanel(SBPanel panel) {
        if (panel.getBlock() != null && panel.getBlock() != this) {
            throw new IllegalStateException("Attempt to add panel with wrong block context to " + String.valueOf(this));
        }
        this.panels.add(panel);
        panel.registerListener(this);
        this.setPropertyChanged();
    }

    @Override
    public void addMember(ChartPanel m) {
        if (!(m instanceof SBPanel)) {
            throw new IllegalArgumentException("Cannot add member of type '" + String.valueOf(m.getClass()) + "' to ChartBlock");
        }
        this.addPanel((SBPanel)m);
    }

    public SBPanel replacePanel(SBPanel panel, PanelTemplate template) throws SQLException, SBException {
        assert (this instanceof WellBlock);
        if (!this.panels.contains(panel)) {
            throw new IllegalStateException("Attempt to replace panel not in block");
        }
        if (panel.getTemplate().getType() != template.getType()) {
            throw new IllegalArgumentException("Incompatible panel template types");
        }
        if (panel.getTemplateID().intValue() == template.getID()) {
            return panel;
        }
        PanelOcc newPanelOcc = new PanelOcc(template.getID(), panel.getPanelOcc().getInterpID(), panel.getPanelOcc().getCaption(), panel.getPanelOcc().getSubCaption(), panel.getPanelOcc().getCapOrient(), panel.getPanelOcc().getSchID());
        newPanelOcc.setPanelNo(panel.getPanelOcc().getPanelNo());
        SBPanel newPanel = (SBPanel)PanelFactory.createPanel(this, template, newPanelOcc);
        newPanel.registerListener(this);
        this.panels.set(this.panels.indexOf(panel), newPanel);
        panel.deleteListener(this);
        this.setPropertyChanged();
        return newPanel;
    }

    public void addPanels(Collection<SBPanel> panels) {
        for (SBPanel panel : panels) {
            this.addPanel(panel);
        }
    }

    public synchronized void addPanelAt(int index, SBPanel panel) {
        if (panel.getBlock() != null && panel.getBlock() != this) {
            throw new IllegalStateException("Attempt to add panel with wrong block context to " + String.valueOf(this));
        }
        this.panels.add(index, panel);
        panel.registerListener(this);
        this.setPropertyChanged(panel);
    }

    public List<SBPanel> getPanels() {
        return new LinkedList<SBPanel>(this.panels);
    }

    @Override
    public Stream<ChartPanel> members() {
        return new LinkedList<SBPanel>(this.panels).stream();
    }

    @Override
    public void clearMembers() {
        this.clearPanels();
    }

    public synchronized void clearPanels() {
        if (this.panels.isEmpty()) {
            return;
        }
        for (SBPanel panel : this.panels) {
            panel.deleteListener(this);
        }
        this.panels.clear();
        this.setPropertyChanged();
    }

    @Override
    public BlockProperties getProp() {
        return this.prop;
    }

    public int getSize() {
        return this.panels.size();
    }

    @Override
    public boolean isEmpty() {
        return this.panels.isEmpty();
    }

    @Override
    public synchronized void removePanel(ChartPanel p) {
        SBPanel panel;
        if (p instanceof SBPanel && this.panels.remove(panel = (SBPanel)p)) {
            panel.deleteListener(this);
            this.setSoftChanged();
        }
    }

    @Override
    public synchronized float getWidth(ChartProperties cp) {
        float width = 0.0f;
        ChartPanel lastPlottedPanel = null;
        for (SBPanel panel : this.panels) {
            float panelWidth;
            if (!cp.drawEmptyPanels && !panel.hasData(this.prop) && panel.getOverplotPanels(cp).isEmpty() || panel.isOverplot() || cp.hideAdjacentBlankPanels && panel.getPanelType() == PanelType.BLANK && lastPlottedPanel != null && lastPlottedPanel.getPanelType() == PanelType.BLANK || (panelWidth = panel.getWidth(this.prop, cp.drawEmptyPanels)) < 1.0f) continue;
            width += panelWidth;
            lastPlottedPanel = panel;
        }
        if (lastPlottedPanel != null && lastPlottedPanel.getPanelType() == PanelType.BLANK) {
            width -= ((SBPanel)lastPlottedPanel).getWidth(this.prop);
        }
        return width;
    }

    public abstract Point2D.Float getPanelOrigin(SBPanel var1, float var2, float var3, Chart.Mode var4, float var5, ChartProperties var6);

    public Float getPanelOrigin(SBPanel panel, ChartProperties cp, boolean excludeRowHeader) {
        if (!this.panels.contains(panel)) {
            return null;
        }
        float xpos = 0.0f;
        for (int i = 0; i < this.panels.size(); ++i) {
            if (excludeRowHeader && i < cp.getnVfreeze()) continue;
            SBPanel p = this.panels.get(i);
            if (p == panel) {
                return Float.valueOf(xpos);
            }
            if (!cp.drawEmptyPanels && !p.hasData(this.prop)) continue;
            xpos += p.getWidth(this.prop);
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.getTemplate()) {
            if (this.updatingTemplate) {
                return;
            }
            if (arg != null && arg instanceof List) {
                LinkedList<PanelOcc> temp = new LinkedList<PanelOcc>();
                for (SBPanel panel : this.panels) {
                    temp.add(panel.getPanelOcc());
                }
                if (!arg.equals(temp)) {
                    return;
                }
            }
            this.updateFromTemplate(this.getTemplate());
            this.notifyListeners();
            return;
        }
    }

    @Override
    public synchronized void updateFromTemplate(BlockTemplate template) {
        super.updateFromTemplate(template);
        if (this.prop.nAltProp() > 0) {
            this.prop.retainAltProp(this.members().map(m -> m.getTemplate().getAltPropType()).flatMap(Optional::stream).collect(Collectors.toSet()));
        }
    }

    public void copyTemplate(BlockTemplate template) {
        if (this.getTemplate() != null) {
            throw new IllegalStateException("Illegal attempt to switch block template");
        }
        this.updateFromTemplate(template);
        this.notifyListeners();
    }

    @Override
    public float getHeaderHeight(ChartProperties cp) {
        return cp.getPanelHeaderHeight();
    }

    @Override
    public void prepareData(ChartUpdate update) {
    }

    @Override
    public synchronized void setData(ChartEvent e, ChartUpdate update) throws SBException, SQLException, IOException {
        PanelType type = null;
        if (e != null && e.getArg() != null && e.getArg() instanceof PanelType) {
            type = (PanelType)e.getArg();
        }
        for (SBPanel p : this.panels) {
            if (type != null && p.getPanelType() != type) continue;
            p.setData(update.getChartProperties(), update.getDataSections());
        }
    }

    @Override
    public synchronized void setData(ChartProperties cp) throws SBException, SQLException, IOException {
        for (SBPanel p : this.panels) {
            p.setData(cp, null);
        }
    }

    private float scaleAge(float age) {
        return this.prop.scaleAge(age);
    }

    private float scaleDepth(float depth) {
        return this.prop.scaleDepth(depth);
    }

    @Deprecated
    public float scale(float value, BlockProperties.ScaleType valueType) {
        return this.scale(value, valueType, this.getScaleConverter(this.getWell()));
    }

    public float scale(double value, BlockProperties.ScaleType valueType, ScaleConverter cachedScaleConverter) {
        Double convertedValue;
        if (valueType != this.prop.scaleType) {
            convertedValue = cachedScaleConverter.convert(value, valueType, this.prop.scaleType);
            if (convertedValue == null) {
                return 0.0f;
            }
        } else {
            convertedValue = value;
        }
        return switch (this.prop.scaleType) {
            default -> throw new MatchException(null, null);
            case BlockProperties.ScaleType.AGE -> this.scaleAge(convertedValue.floatValue());
            case BlockProperties.ScaleType.MD, BlockProperties.ScaleType.TVD, BlockProperties.ScaleType.SUBSIDENCE, BlockProperties.ScaleType.TWT -> this.scaleDepth(convertedValue.floatValue());
        };
    }

    public float[] scaleToAll(double value, BlockProperties.ScaleType valueType, ScaleConverter cachedScaleConverter) {
        double[] convertedValues = cachedScaleConverter.convertToAll(value, valueType, this.prop.scaleType);
        float[] scaledValues = new float[convertedValues.length];
        for (int i = 0; i < scaledValues.length; ++i) {
            scaledValues[i] = switch (this.prop.scaleType) {
                default -> throw new MatchException(null, null);
                case BlockProperties.ScaleType.AGE -> this.scaleAge((float)convertedValues[i]);
                case BlockProperties.ScaleType.MD, BlockProperties.ScaleType.TVD, BlockProperties.ScaleType.SUBSIDENCE, BlockProperties.ScaleType.TWT -> this.scaleDepth((float)convertedValues[i]);
            };
        }
        return scaledValues;
    }

    public float scaleMeasuredDepth(double valueAsMD, ScaleConverter cachedScaleConverter) {
        double convertedValue = cachedScaleConverter.convertAndTrimMeasuredDepth(valueAsMD);
        return switch (this.prop.scaleType) {
            default -> throw new MatchException(null, null);
            case BlockProperties.ScaleType.AGE -> this.scaleAge((float)convertedValue);
            case BlockProperties.ScaleType.MD, BlockProperties.ScaleType.TVD, BlockProperties.ScaleType.SUBSIDENCE, BlockProperties.ScaleType.TWT -> this.scaleDepth((float)convertedValue);
        };
    }

    public float scaleLimitOfPlottableRange(ScaleConverter cachedScaleConverter, IBlockProperties.ScaleLimitType limitType) {
        Double value = cachedScaleConverter.getScaleLimitAsMeasuredDepth(limitType).orElse(null);
        if (value == null) {
            return 0.0f;
        }
        double convertedValue = cachedScaleConverter.convert(value, BlockProperties.ScaleType.MD);
        return switch (this.prop.scaleType) {
            default -> throw new MatchException(null, null);
            case BlockProperties.ScaleType.AGE -> this.scaleAge((float)convertedValue);
            case BlockProperties.ScaleType.MD, BlockProperties.ScaleType.TVD, BlockProperties.ScaleType.SUBSIDENCE, BlockProperties.ScaleType.TWT -> this.scaleDepth((float)convertedValue);
        };
    }

    public float getAgeLimit(boolean min) {
        return this.getAgeLimits(null, null)[min ? 0 : 1];
    }

    public float[] getAgeLimits(Float minDepth, Float maxDepth) {
        float minValue = this.prop.getMin();
        float maxValue = this.prop.getMax();
        float[] limits = new float[]{minValue, maxValue};
        switch (this.prop.scaleType) {
            case AGE: {
                return limits;
            }
            default: {
                if (minDepth != null) {
                    limits[0] = minDepth.floatValue();
                    limits[1] = maxDepth.floatValue();
                    break;
                }
                if (this.getTVDList() == null) break;
                for (int i = 0; i < 2; ++i) {
                    TVDepth d = this.getTVDList().getDepth((double)limits[i], i == 0, null, null);
                    limits[i] = d != null ? (float)d.getDDepth() : (i == 1 ? (float)this.getTVDList().getBaseTVD() : 0.0f);
                }
                break;
            }
            case TWT: {
                if (minDepth != null) {
                    limits[0] = minDepth.floatValue();
                    limits[1] = maxDepth.floatValue();
                    break;
                }
                if (this.getTWTList() == null) break;
                for (int i = 0; i < 2; ++i) {
                    TWTDepth[] d = this.getTWTList().getDepths((double)limits[i]);
                    if (d != null && d.length > 0) {
                        int index = 0;
                        if (i == 1) {
                            index = d.length - 1;
                        }
                        limits[i] = (float)d[index].getDepth();
                        continue;
                    }
                    limits[i] = i == 1 ? (float)this.getTWTList().getBaseDD() : 0.0f;
                }
                break;
            }
            case MD: 
        }
        if (this.getInterp() == null || this.getInterp().getLOC() == null) {
            limits[0] = 0.0f;
            limits[1] = 0.0f;
            return limits;
        }
        return this.getInterp().getLOC().getAgeLimits(limits[0], limits[1]);
    }

    public float[] getTVDLimits(Float minDepth, Float maxDepth) {
        float minValue = this.prop.getMin();
        float maxValue = this.prop.getMax();
        float[] limits = minDepth != null && maxDepth != null ? new float[]{minDepth.floatValue(), maxDepth.floatValue()} : new float[]{this.prop.getMin(), this.prop.getMax()};
        switch (this.prop.scaleType) {
            case TVD: {
                if (minDepth != null && maxDepth != null) {
                    if (this.getTVDList() != null) {
                        double minTvd = this.getTVDList().getTVDwithExtrapolation((double)minDepth.floatValue()).getTVDepth();
                        double maxTVD = this.getTVDList().getTVDwithExtrapolation((double)maxDepth.floatValue()).getTVDepth();
                        return new float[]{(float)Math.min(minTvd, maxTVD), (float)Math.max(minTvd, maxTVD)};
                    }
                    return limits;
                }
                return limits;
            }
            case SUBSIDENCE: {
                return new float[]{limits[0], limits[1]};
            }
            default: {
                assert (false);
            }
            case AGE: 
            case TWT: {
                if (minDepth != null) break;
                if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
                    if (this.getInterp() == null || this.getInterp().getLOC() == null) {
                        limits[0] = 0.0f;
                        limits[1] = 0.0f;
                        return limits;
                    }
                    limits[0] = (float)this.getInterp().getLOC().getDepth((double)minValue, null, null, true);
                    limits[1] = (float)this.getInterp().getLOC().getDepth((double)maxValue, null, null, false);
                    if (limits[0] == -1.0f) {
                        limits[0] = (float)this.getInterp().getLOC().getMinAge();
                    }
                    if (limits[1] != -1.0f) break;
                    limits[1] = (float)this.getInterp().getLOC().getMaxAge();
                    break;
                }
                if (this.prop.scaleType == BlockProperties.ScaleType.TWT) {
                    if (this.getTWTList() == null || this.getTWTList().getSize() <= 0) break;
                    TWTDepth[] d = this.getTWTList().getDepths((double)minValue);
                    limits[0] = d.length > 0 ? (float)d[0].getDepth() : (float)this.getTWTList().getTopDD();
                    d = this.getTWTList().getDepths((double)maxValue);
                    if (d.length > 0) {
                        limits[1] = (float)d[0].getDepth();
                        break;
                    }
                    limits[1] = (float)this.getTWTList().getBaseDD();
                    break;
                }
                assert (false);
                break;
            }
            case MD: 
        }
        if (this.getTVDList() != null) {
            limits = this.getTVDList().getTVDlimits((double)limits[0], (double)limits[1]);
        }
        return limits;
    }

    public FloatRange getDeviationSurveyDDLimits() {
        FloatRange limits = null;
        if (this.getWells().size() > 1) {
            for (Well w : this.getWells()) {
                TVDList l = this.getTVDList(w);
                if (l == null) continue;
                TVDepth[] wellLimits = l.getDeviationSurveyLimits();
                if (limits == null) {
                    limits = new FloatRange((float)wellLimits[0].getDDepth(), (float)wellLimits[1].getDDepth());
                    continue;
                }
                float minLimit = Math.min(limits.getMin(), (float)wellLimits[0].getDDepth());
                float maxLimit = Math.max(limits.getMax(), (float)wellLimits[1].getDDepth());
                limits = new FloatRange(minLimit, maxLimit);
            }
        } else if (this.getTVDList() != null) {
            TVDepth[] wellLimits = this.getTVDList().getDeviationSurveyLimits();
            limits = new FloatRange((float)wellLimits[0].getDDepth(), (float)wellLimits[1].getDDepth());
        }
        return limits;
    }

    public FloatRange getDeviationSurveyTVDLimits() {
        TVDepth[] wellLimits;
        FloatRange limits = null;
        if (this.getWells().size() > 1) {
            for (Well w : this.getWells()) {
                TVDepth[] wellLimits2;
                TVDList l = this.getTVDList(w);
                if (l == null || (wellLimits2 = l.getDeviationSurveyLimits())[0].getTVDepth() == null || wellLimits2[1].getTVDepth() == null) continue;
                if (limits == null) {
                    limits = new FloatRange(wellLimits2[0].getTVDepth().floatValue(), wellLimits2[1].getTVDepth().floatValue());
                    continue;
                }
                float minLimit = Math.min(limits.getMin(), wellLimits2[0].getTVDepth().floatValue());
                float maxLimit = Math.max(limits.getMax(), wellLimits2[1].getTVDepth().floatValue());
                limits = new FloatRange(minLimit, maxLimit);
            }
        } else if (this.getTVDList() != null && (wellLimits = this.getTVDList().getDeviationSurveyLimits())[0].getTVDepth() != null && wellLimits[1].getTVDepth() != null) {
            limits = new FloatRange(wellLimits[0].getTVDepth().floatValue(), wellLimits[1].getTVDepth().floatValue());
        }
        return limits;
    }

    public float getMDLimit(boolean min) {
        float value = min ? this.prop.getMin() : this.prop.getMax();
        switch (this.prop.scaleType) {
            default: {
                assert (false);
            }
            case SUBSIDENCE: {
                if (min) {
                    return 0.0f;
                }
                return this.prop.getMax() - this.prop.getMin();
            }
            case MD: {
                return value;
            }
            case AGE: {
                if (this.getInterp() == null || this.getInterp().getLOC() == null) {
                    return 0.0f;
                }
                value = (float)this.getInterp().getLOC().getDepth((double)value, null, null, min);
                if (value == -1.0f) {
                    value = min ? (float)this.getInterp().getLOC().getMinDepth() : (float)this.getInterp().getLOC().getMaxDepth();
                }
                return value;
            }
            case TVD: {
                if (this.getTVDList() != null) {
                    TVDepth[] depths = this.getTVDList().getDepthsWithExtrapolation((double)value);
                    Arrays.sort(depths, new Comparator<TVDepth>(this){
                        {
                            Objects.requireNonNull(this$0);
                        }

                        @Override
                        public int compare(TVDepth o1, TVDepth o2) {
                            return Double.compare(o1.getDDepth(), o2.getDDepth());
                        }
                    });
                    if (depths != null && depths.length > 0) {
                        if (min) {
                            return (float)depths[0].getDDepth();
                        }
                        return (float)depths[depths.length - 1].getDDepth();
                    }
                }
                return value;
            }
            case TWT: 
        }
        if (this.getTWTList() != null) {
            TWTDepth[] twt;
            if ((double)value < this.getTWTList().getTopTWT()) {
                return (float)this.getTWTList().getTopDD();
            }
            if ((double)value > this.getTWTList().getBaseTWT()) {
                value = (float)this.getTWTList().getBaseDD();
            }
            if ((twt = this.getTWTList().getDepths((double)value)) != null && twt.length > 0) {
                int index = 0;
                if (!min) {
                    index = twt.length - 1;
                }
                return (float)twt[index].getDepth();
            }
            assert (false);
        }
        return value;
    }

    public float getScale() {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            return (this.getMDLimit(false) - this.getMDLimit(true)) / this.getHeight() * 1000.0f;
        }
        return this.prop.getScale(this.prop.getLongestSection());
    }

    public float getAgeScale() {
        switch (this.prop.scaleType) {
            case AGE: {
                return 1.0f / this.prop.getScale(this.prop.getLongestSection());
            }
        }
        float[] ageLimits = this.getAgeLimits(null, null);
        return Math.abs(ageLimits[0] - ageLimits[1]) / this.getHeight();
    }

    public TVDList getTVDList() {
        return this.getTVDList(this.getWell());
    }

    public TWTList getTWTList() {
        return this.getTWTList(this.getWell());
    }

    boolean contains(ChartPanel panel) {
        if (panel instanceof SBPanel) {
            return this.panels.contains((SBPanel)panel);
        }
        return false;
    }

    public void setSelectedPanels(ChartPanel selection) {
        this.panels.forEach(panel -> {
            panel.setPanelOccSelected(selection == panel);
            if (selection != null) {
                panel.setTemplateSelected(SB.equal((Object)panel.getTemplateID(), (Object)selection.getTemplateID()));
            } else {
                panel.setTemplateSelected(false);
            }
        });
    }

    @Override
    public synchronized boolean removeSelectedPanel() {
        if (this.getSelectedPanel().isEmpty()) {
            return false;
        }
        ChartPanel selection = this.getSelectedPanel().get();
        int index = this.panels.indexOf(selection);
        this.removePanel(selection);
        if (!this.panels.isEmpty()) {
            if (index == this.panels.size()) {
                --index;
            }
            this.setSelectedPanel(this.panels.get(index));
        }
        return true;
    }

    @Override
    public synchronized boolean moveSelectedPanel(boolean left) {
        return this.getSelectedPanel().map(p -> this.movePanel((SBPanel)p, left)).orElse(false);
    }

    public synchronized boolean movePanel(SBPanel selected, boolean left) {
        if (!this.panels.contains(selected)) {
            assert (false);
            return false;
        }
        int index = this.panels.indexOf(selected);
        if (left && index == 0 || !left && index == this.panels.size() - 1) {
            return false;
        }
        this.panels.remove(selected);
        if (left) {
            this.panels.add(index - 1, selected);
        } else {
            this.panels.add(index + 1, selected);
        }
        this.setSoftChanged();
        return true;
    }

    public void setMin(float min, int section) throws InvalidFieldException {
        this.setMin(min, null, section);
    }

    public void setMin(float min) throws InvalidFieldException {
        this.setMin(min, null, 0);
    }

    public void setAltMin(float min, BlockProperties.ScaleType altType) throws InvalidFieldException {
        this.setMin(min, altType, 0);
    }

    private void setMin(float min, BlockProperties.ScaleType altType, int section) throws InvalidFieldException {
        BlockProperties bp;
        BlockProperties blockProperties = bp = altType == null ? this.prop : this.prop.getAltProp(altType);
        if (min > bp.getMax(section)) {
            throw new InvalidFieldException("Minimum can't be greater than maximum");
        }
        if ((double)Math.abs(min - bp.getMin(section)) > 0.01) {
            bp.setMin(min, section);
            this.setPropertyChanged();
            this.notifyListeners();
        }
    }

    public void setMax(float max, int section) throws InvalidFieldException {
        this.setMax(max, null, section);
    }

    public void setMax(float max) throws InvalidFieldException {
        this.setMax(max, null, 0);
    }

    public void setAltMax(float max, BlockProperties.ScaleType altType) throws InvalidFieldException {
        this.setMax(max, altType, 0);
    }

    private void setMax(float max, BlockProperties.ScaleType altType, int section) throws InvalidFieldException {
        BlockProperties bp;
        BlockProperties blockProperties = bp = altType == null ? this.prop : this.prop.getAltProp(altType);
        if (max < bp.getMin(section)) {
            throw new InvalidFieldException("Maximum can't be less than minimum");
        }
        if ((double)Math.abs(max - bp.getMax(section)) > 0.01) {
            bp.setMax(max, section);
            this.setPropertyChanged();
            this.notifyListeners();
        }
    }

    public void setScaleLimits(Float topMD, Float baseMD) throws InvalidFieldException {
        Double convertedMax;
        Double convertedMin;
        ScaleConverter sc = this.getScaleConverter(this.getWell());
        if (topMD != null && (convertedMin = sc.convertMeasuredDepth(topMD.doubleValue())) != null) {
            this.prop.setOverallMin(convertedMin.floatValue());
            this.setPropertyChanged();
        }
        if (baseMD != null && (convertedMax = sc.convertMeasuredDepth(baseMD.floatValue())) != null) {
            this.prop.setOverallMax(convertedMax.floatValue());
            this.setPropertyChanged();
        }
        this.notifyListeners();
    }

    public static float[] getDefaultDepthBounds(Well well, float scale) throws SQLException {
        double tDepth = WellBlock.getDefaultDepthBound(true, well.getTopSampleDepth() - (double)scale * 0.003, well.getBaseSampleDepth() + (double)scale * 0.003, well.getWellUnits());
        double bDepth = WellBlock.getDefaultDepthBound(false, well.getTopSampleDepth() - (double)scale * 0.003, well.getBaseSampleDepth() + (double)scale * 0.003, well.getWellUnits());
        if (well.getSectionType() == SectionType.WELL && tDepth < 0.0 && bDepth > 10.0) {
            tDepth = 0.0;
        }
        if (Math.abs(tDepth - bDepth) < (double)0.0029f) {
            tDepth -= 5.0;
            bDepth += 5.0;
        }
        return new float[]{(float)tDepth, (float)bDepth};
    }

    public void setScale(float scale, int section) {
        this.setScale(scale, null, section);
    }

    public void setScale(float scale) {
        this.setScale(scale, null, 0);
    }

    public void setAltScale(float scale, BlockProperties.ScaleType altType) {
        this.setScale(scale, altType, 0);
    }

    private void setScale(float scale, BlockProperties.ScaleType altType, int section) {
        BlockProperties bp = altType == null ? this.prop : this.prop.getAltProp(altType);
        switch (this.getBlockType()) {
            default: {
                if (Math.abs(scale - bp.getScale(section)) < 1.0f) {
                    return;
                }
                scale = (int)scale;
                break;
            }
            case SCHEME: {
                if ((double)Math.abs(scale - bp.getScale(section)) < 0.001) {
                    return;
                }
                scale = (float)SB.roundToSignificantFigures((double)scale, (int)4);
            }
        }
        boolean changed = bp.setScale(scale, section);
        this.setPropertyChanged();
        if (changed) {
            this.notifyListeners();
        }
    }

    public void setAltAgeLTR(boolean ageLTR, BlockProperties.ScaleType altType) {
        assert (altType == BlockProperties.ScaleType.AGE);
        if (this.prop.getAltProp(altType).setAgeLeftToRight(ageLTR, this.getDb())) {
            this.setPropertyChanged();
        }
    }

    @Override
    public void setScaleType(BlockProperties.ScaleType newScaleType) {
        float newMax;
        float newMin;
        if (newScaleType == this.prop.scaleType) {
            return;
        }
        ScaleConverter sc = this.getScaleConverter(this.getWell());
        double minAsDouble = new BigDecimal(this.prop.getMin()).setScale(2, RoundingMode.HALF_UP).doubleValue();
        double maxAsDouble = new BigDecimal(this.prop.getMax()).setScale(2, RoundingMode.HALF_UP).doubleValue();
        Double convertedMin = sc.convertAndTrim(minAsDouble, this.prop.getScaleType(), newScaleType);
        Double convertedMax = sc.convertAndTrim(maxAsDouble, this.prop.getScaleType(), newScaleType);
        if (convertedMin == null || convertedMax == null || Double.isNaN(convertedMin) || Double.isNaN(convertedMax)) {
            newMin = 0.0f;
            newMax = 0.0f;
        } else {
            newMin = convertedMin.floatValue();
            newMax = convertedMax.floatValue();
        }
        if (Math.abs(newMin - this.prop.getMin()) > 0.0f || Math.abs(newMax - this.prop.getMax()) > 0.0f) {
            float newScale = switch (newScaleType) {
                default -> (float)ChartBlock.getDefaultScale(newMin, newMax, this.prop.units);
                case BlockProperties.ScaleType.TWT -> (float)ChartBlock.getDefaultScale(newMin, newMax, 'M');
                case BlockProperties.ScaleType.AGE -> Math.abs(newMin - newMax) > 0.0f ? SchemeBlock.calcIdealScale(newMin, newMax) : 5.0f;
            };
            this.prop.setScale(newScale);
        }
        this.prop.setMin(newMin);
        this.prop.setMax(newMax);
        ChartPropertyChangedNotification changeNotification = new ChartPropertyChangedNotification((Object)this.prop.scaleType, (Object)newScaleType);
        this.prop.scaleType = newScaleType;
        this.setPropertyChanged(changeNotification);
        this.notifyListeners();
    }

    @Override
    public void setLabelScaleType(BlockProperties.ScaleType newLabelScaleType) {
        ChartPropertyChangedNotification changeNotification = new ChartPropertyChangedNotification((Object)this.prop.labelScaleType, (Object)newLabelScaleType);
        this.prop.setLabelScaleType(newLabelScaleType);
        this.setPropertyChanged(changeNotification);
        this.notifyListeners();
    }

    public static double getDefaultScale(double topDepth, double baseDepth, char units) {
        double depthRange = baseDepth - topDepth;
        if (depthRange < 10.0) {
            return units == 'F' ? 60.0 : 50.0;
        }
        if (depthRange < 100.0) {
            return units == 'F' ? 480.0 : 500.0;
        }
        if (depthRange < 1000.0) {
            return units == 'F' ? 1200.0 : 1000.0;
        }
        if (depthRange < 3000.0) {
            return units == 'F' ? 2400.0 : 2000.0;
        }
        return units == 'F' ? 6000.0 : 5000.0;
    }

    public void setUnits(DepthUnits units) {
        if (this.prop.units != units.getChar()) {
            this.prop.units = units.getChar();
            this.setPropertyChanged();
            this.notifyListeners();
        }
    }

    void setDatumOffset(float offset) {
        this.datumOffset = offset;
    }

    @Override
    public float getDatumOffset() {
        return this.datumOffset;
    }

    @Override
    public EnumMap<CorrelationType, HashSet<CorrelationPoint>> getCorrelationLines() {
        return this.correlationLines;
    }

    @Override
    public Set<CorrelationPoint> getCorrelationLines(CorrelationType type) {
        Set lineSet = this.correlationLines.get(type);
        if (lineSet == null) {
            lineSet = Collections.EMPTY_SET;
        }
        return lineSet;
    }

    public abstract Collection<CorrelationPoint> getYPos(CorrelationLine var1, boolean var2, boolean var3, ChartProperties var4, int var5, boolean var6) throws SBException, SQLException;

    @Override
    public void addCorrelationData(Correlation c, ChartProperties cp) throws SBException, SQLException {
        HashSet<CorrelationPoint> blockSet = this.correlationLines.get(c.getCorrType());
        if (blockSet == null) {
            blockSet = new HashSet();
            this.correlationLines.put(c.getCorrType(), blockSet);
        }
        for (CorrelationLine l : c.getLines()) {
            Collection<CorrelationPoint> yPos = this.getYPos(l, c.getVisibleOnly(), c.getUseBlockInterp(), cp, c.getMaxUnconfidence(), c.getCorrelateRangedIntervals());
            if (yPos == null) continue;
            blockSet.addAll(yPos);
        }
        if (this.correlationLines.get(c.getCorrType()).isEmpty()) {
            this.correlationLines.put(c.getCorrType(), null);
        }
    }

    public Float getYPos(CorrelationLine line) {
        HashSet<CorrelationPoint> s = this.correlationLines.get(line.getCorrelationType());
        if (s != null) {
            for (CorrelationPoint p : s) {
                if (p.line() != line) continue;
                return Float.valueOf(p.ypos());
            }
        }
        return null;
    }

    @Override
    public void clearCorrelationData() {
        this.correlationLines.entrySet().forEach(entry -> entry.setValue(null));
    }

    private void drawBackgroundIGD(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) {
        List<DrawZone> intervals = this.getBackgroundZones();
        if (intervals == null || intervals.isEmpty()) {
            return;
        }
        x += 0.1f;
        float totalWidth = this.getWidth(cp) - 0.2f;
        for (DrawZone i : intervals) {
            if (i.getLowColour() != null) {
                g.paintRect(x, Math.min(i.getYTop(), i.getYBase()) + y + this.getPanelHeaderHeight(cp, mode), totalWidth, Math.abs(i.getYBase() - i.getYTop()), i.getUppColour(), i.getLowColour());
                continue;
            }
            g.setColor(i.getUppColour());
            g.fillRect(x, Math.min(i.getYTop(), i.getYBase()) + y + this.getPanelHeaderHeight(cp, mode), totalWidth, Math.abs(i.getYBase() - i.getYTop()));
        }
        g.setColor(cp.foreground);
    }

    @Override
    public float getVheaderWidth(int nPanels, boolean drawPanelsWithNoData) {
        float width = 0.0f;
        nPanels = this.getnVHeaderPanels(nPanels, drawPanelsWithNoData);
        for (int i = 0; i < nPanels && i < this.panels.size(); ++i) {
            if (!drawPanelsWithNoData && !this.panels.get(i).hasData(this.prop)) continue;
            width += this.panels.get(i).getWidth(this.prop);
        }
        return width;
    }

    private int getnVHeaderPanels(int nPanels, boolean drawPanelsWithNoData) {
        if (drawPanelsWithNoData) {
            return nPanels;
        }
        for (int i = 0; i < nPanels && i < this.panels.size(); ++i) {
            if (this.panels.get(i).hasData(this.prop)) continue;
            ++nPanels;
        }
        return nPanels;
    }

    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        if (ws.isConnected()) {
            throw new IllegalArgumentException("Attempt to fill chart block well data to connected workspace");
        }
        if (this.getWell() == null) {
            return;
        }
        for (SBPanel sBPanel : this.panels) {
            sBPanel.fillWorkspaceWellData(ws, dataTypes);
        }
        if (this.getWells().size() == 1) {
            WsWell wsWell = (WsWell)ws.getWell(this.getWellID());
            for (HashSet<CorrelationPoint> hashSet : this.correlationLines.values()) {
                if (hashSet == null) continue;
                block7: for (CorrelationPoint p : hashSet) {
                    CorrelationType type = p.line().getCorrelationType();
                    WellInterp dbInterp = this.getWell().getInterp(p.line().getInterpID());
                    InterpHdr wsHdr = ws.getInterp(p.line().getInterpID());
                    if (wsHdr == null) {
                        ws.fillInterp(this.getDb().getInterp(p.line().getInterpID()));
                    }
                    block0 : switch (type) {
                        case EVENT: {
                            for (WellEvent event : dbInterp.getEvents()) {
                                if (event.getEvent() != p.line().getObject() || event.getTypeObj() != p.line().getObjectType()) continue;
                                wsWell.getAddInterp(wsHdr).fillEvents(wsWell, true, new WellEvent[]{event});
                                dataTypes.add(16);
                                break block0;
                            }
                            continue block7;
                        }
                        case SURFACE: {
                            for (SQPick pick : dbInterp.getSQPicks()) {
                                if (pick.getSurface() != p.line().getObject()) continue;
                                wsWell.getAddInterp(wsHdr).fillWorkspace(wsWell, true, new InterpItem[]{pick});
                                dataTypes.add(14);
                                break block0;
                            }
                            continue block7;
                        }
                        case CHRONO: 
                        case LITHO: 
                        case BIOZONE: {
                            IGDScheme scheme = this.getDb().getIGDScheme(((IGDUnitBase)p.line().getObject()).getSchID());
                            for (IGDIntervalZone zone : dbInterp.getIGDList(scheme.getIGDType())) {
                                if ((zone.getUppZone() <= 0 || zone.getUppZone() != ((IGDUnitBase)p.line().getObject()).getUnitID()) && (zone.getLowZone() <= 0 || zone.getLowZone() != ((IGDUnitBase)p.line().getObject()).getUnitID())) continue;
                                wsWell.getAddInterp(wsHdr).fillIntervals(wsWell, true, new IGDIntervalZone[]{zone});
                                dataTypes.add(IGDInterval.igdType2dType((int)zone.getIGDType()));
                                break block0;
                            }
                            continue block7;
                        }
                        default: {
                            assert (false);
                            continue block7;
                        }
                    }
                }
            }
            if (this.getBackgroundZones() != null) {
                ArrayList<IGDIntervalZone> arrayList = new ArrayList<IGDIntervalZone>();
                for (DrawZone dz : this.getBackgroundZones()) {
                    if (dz.getObject() == null) continue;
                    arrayList.add((IGDIntervalZone)dz.getObject());
                }
                if (!arrayList.isEmpty()) {
                    dataTypes.add(IGDInterval.igdType2dType((int)((IGDIntervalZone)arrayList.get(0)).getIGDType()));
                    wsWell.getInterp(this.getInterpID()).fillIntervals(wsWell, true, arrayList.toArray(new IGDIntervalZone[arrayList.size()]));
                }
            }
        }
    }

    public List<SBPanel> getOverplotPanels(SBPanel base) {
        SBPanel onTopPanel;
        int index = this.panels.indexOf(base);
        if (index < 0 || index == this.panels.size() - 1 || !this.panels.get(index + 1).isOverplot()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<SBPanel> list = new LinkedList<SBPanel>();
        for (int i = this.panels.indexOf(base) + 1; i < this.panels.size() && (onTopPanel = this.panels.get(i)).isOverplot(); ++i) {
            list.add(onTopPanel);
        }
        return list;
    }
}

