/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.wellinterp.DepthAgeCurve;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Observable;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.SwingWorker;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.IBlockProperties;
import jsbchart.block.MapBlockProperties;
import jsbchart.block.MapBlockSwingWorker;
import jsbchart.block.MapBlockViewport;
import jsbchart.block.MapLegend;
import jsbchart.core.BlockTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import jsbchart.correlation.IGDUnitLine;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.map.ChartDecorationBuilder;
import jsbchart.graphics.map.CrsCode;
import jsbchart.graphics.map.DefaultMapLayerBuilder;
import jsbchart.graphics.map.DirectionArrow;
import jsbchart.graphics.map.MapPositionCalculator;
import jsbchart.graphics.map.SBMapRenderer;
import jsbchart.graphics.map.ScaleBar;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartUpdate;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelFactory;
import jsbchart.panel.spatial.FeatureProcessor;
import jsbchart.panel.spatial.LayerFactory;
import jsbchart.panel.spatial.LayerShape;
import jsbchart.panel.spatial.LayerWellLocation;
import jsbchart.panel.spatial.LayerWellLocationWithSelection;
import jsbchart.panel.spatial.PointDataLayerFactory;
import jsbchart.panel.spatial.SBLayer;
import jsbchart.panel.spatial.SBPointDataLayer;
import jsbchart.util.DrawZone;
import jsbchart.util.GeotoolsUtils;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.LOC;
import model3.LithostratUnit;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import model3.exception.SuppressedSQLException;
import org.apache.batik.svggen.SVGGraphics2D;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XDimension2D;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.visitor.RescaleStyleVisitor;
import org.locationtech.jts.geom.Coordinate;
import org.picocontainer.Disposable;
import util.ColourUtils;
import util.SBException;

public class MapBlock
extends ChartBlockBase
implements Disposable,
MapPositionCalculator {
    private static final Logger LOGGER = Logger.getLogger(MapBlock.class.getName());
    private static final boolean ENABLE_BACKGROUND_RENDERING = true;
    private static final Boolean OUTLINE_LAYER = false;
    private static final int MAX_NUM_MAP_PIXELS = 50000000;
    private final FeatureProcessor featureProcessor = new FeatureProcessor();
    private final MapContent map;
    private final MapContent directDrawContent;
    private final MapContent backgroundDrawContent;
    private final MapContent backgroundMapContent;
    private final MapBlockProperties prop;
    private final LayerList sbLayers = new LayerList(this);
    private MapLegend legend = new MapLegend();
    public static final Object POINT_DATA_FLAG = "POINT_DATA_CHANGED";
    public static final Object SCALE_LIMITS_CHANGED_FLAG = "SCALE_LIMITS_CHANGED";
    private Rectangle mapAreaInPx = null;
    private float zoomLevel = 1.0f;
    private BufferedImage mapImage = null;
    private MapBlockViewport viewport = new MapBlockViewport();
    private boolean mapIsPanningOrResizing = false;
    private Point2D.Float startPanPoint = null;
    private ImageOffset panOffset = new ImageOffset(0.0f, 0.0f);
    private ImageOffset existingOffset = new ImageOffset(0.0f, 0.0f);
    private boolean layersHaveChanged = false;
    private String dataLoadedForESPGProjection = null;
    private static final String COORD_FORMAT = "%3.3f, %3.3f";
    private final List<Well> chartWells = new ArrayList<Well>();
    private Supplier<List<Well>> chartWellsSupplier;
    private boolean singleWellSet = false;
    private final HashSet<CorrelationPoint> correlationData = new HashSet();
    private LinkedList<DrawZone> backgroundZones = new LinkedList();
    public static final double ZOOM_FRACTION = 1.5;
    private Layer outlineLayer = null;
    private SwingWorker<BufferedImage, Void> blockWorker;
    private float graphicsScalingFactor = 1.0f;

    public void dispose() {
        if (this.map != null) {
            this.map.dispose();
        }
        if (this.directDrawContent != null) {
            this.directDrawContent.dispose();
        }
        if (this.backgroundDrawContent != null) {
            this.backgroundDrawContent.dispose();
        }
    }

    public MapBlock(SBdb sbdb, BlockTemplate template, MapBlockProperties prop) {
        super(template, sbdb, true);
        this.map = new MapContent();
        this.directDrawContent = new MapContent();
        this.directDrawContent.setTitle("SB Scaled map");
        this.backgroundDrawContent = new MapContent();
        this.backgroundDrawContent.setTitle("Background scaled map");
        if (prop == null) {
            prop = new MapBlockProperties();
        }
        this.prop = prop;
        this.backgroundMapContent = this.buildBackgroundMapContent();
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> correlationLines, Chart.Mode vMode) {
        ChartDecorationBuilder cdb;
        ScaleBar sb;
        Rectangle2D.Float mapBlockArea;
        long startTime = System.currentTimeMillis();
        if (cp.key != null && cp.keyIsVisible()) {
            this.sbLayers.forEach(l -> l.putKeyData(cp));
        }
        if (!g.isVisible(mapBlockArea = new Rectangle2D.Float(x, y, this.getWidth(cp), this.getHeight()))) {
            return x;
        }
        if (cp.bgBlocks && !this.backgroundZones.isEmpty()) {
            DrawZone z = this.backgroundZones.get(0);
            g.setColor(z.getUppColour());
            g.fillRect(mapBlockArea);
        }
        Rectangle newMapAreaInPx = this.viewport.calcRectInUnscaledPixels(mapBlockArea);
        this.setCurrentGraphicsScalingFactor(g);
        boolean mapReload = this.layersHaveChanged;
        if (!newMapAreaInPx.equals(this.mapAreaInPx)) {
            this.mapAreaInPx = newMapAreaInPx;
            this.viewport.setMapAreaAndBounds(this.mapAreaInPx, this.prop);
            if (!this.mapIsPanningOrResizing) {
                mapReload = true;
            }
        }
        if ((double)Math.abs(this.zoomLevel - g.getZoomLevel()) > 1.0E-4) {
            this.zoomLevel = g.getZoomLevel();
            mapReload = true;
        }
        if (mapReload && this.shouldRenderInBackground(g)) {
            LOGGER.log(Level.FINEST, "Starting map loading from .draw(), mapIsPanningOrResizing = {0}", new Object[]{this.mapIsPanningOrResizing});
            this.startMapLoading();
            this.layersHaveChanged = false;
        }
        if (cp.key != null && cp.keyIsVisible()) {
            this.sbLayers.forEach(l -> l.putKeyData(cp));
        }
        SBMapRenderer sbMapRenderer = new SBMapRenderer();
        if (this.shouldRenderInBackground(g)) {
            if (this.mapImage != null) {
                if ((double)(Math.abs(this.panOffset.x) + Math.abs(this.existingOffset.x) + Math.abs(this.existingOffset.y) + Math.abs(this.panOffset.y)) > 1.0E-4) {
                    this.drawMapDirectly(g, this.backgroundMapContent, mapBlockArea, sbMapRenderer);
                }
                MapBlock.drawMapImage(g, mapBlockArea, this.mapImage, new ImageOffset(this.panOffset.x + this.existingOffset.x, this.panOffset.y + this.existingOffset.y), cp);
            } else {
                this.drawMapDirectly(g, this.backgroundMapContent, mapBlockArea, sbMapRenderer);
            }
        } else {
            this.drawMapDirectly(g, this.map, mapBlockArea, sbMapRenderer);
        }
        if (this.prop.getLegendOrientation() != MapBlockProperties.LegendOrientation.NONE) {
            this.drawLegend(g, x, y, cp);
        }
        if (this.prop.getShowScale() && (sb = (cdb = new ChartDecorationBuilder()).buildScaleBar(this.viewport, cp, this.prop.getLegendOrientation())) != null) {
            sb.draw(g);
            DirectionArrow da = cdb.buildDirectionArrow(sb, cp, this.prop.getLegendOrientation());
            g.setColor(cp.foreground);
            g.setStroke(0.5f, 0, 0);
            da.draw(g);
        }
        g.setStroke(0.4f);
        g.drawRect(mapBlockArea, cp.foreground);
        LOGGER.log(Level.FINEST, "Drawn map in {0}ms", new Object[]{System.currentTimeMillis() - startTime});
        return x;
    }

    private void setCurrentGraphicsScalingFactor(SBGraphics g) {
        if (g.getOriginalTransform() != null && g.getOriginalTransform().getScaleX() - g.getOriginalTransform().getScaleY() < 1.0E-4) {
            this.graphicsScalingFactor = (float)g.getOriginalTransform().getScaleX();
        }
    }

    private boolean shouldRenderInBackground(SBGraphics g) {
        return !(g.getGraphics() instanceof PdfBoxGraphics2D) && !(g.getGraphics() instanceof SVGGraphics2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drawMapImage(SBGraphics g, Rectangle2D.Float mapAreaInMM, BufferedImage img, ImageOffset imageOffset, ChartProperties cp) {
        Shape clip = g.getGraphics().getClip();
        try {
            g.setClip(mapAreaInMM.x, mapAreaInMM.y, mapAreaInMM.width, mapAreaInMM.height);
            g.setColor(cp.background);
            g.fillRect(mapAreaInMM.x + imageOffset.x, mapAreaInMM.y + imageOffset.y, mapAreaInMM.width, mapAreaInMM.height);
            g.drawImage(img, mapAreaInMM.x + imageOffset.x, mapAreaInMM.y + imageOffset.y, mapAreaInMM.width, mapAreaInMM.height);
        }
        finally {
            g.getGraphics().setClip(clip);
        }
    }

    private void drawMapDirectly(SBGraphics g, MapContent mapToDraw, Rectangle2D.Float mapAreaInMm, SBMapRenderer sbMapRenderer) {
        Rectangle mapAreaInScaledPixels = this.viewport.calcRectInScaledPixels(mapAreaInMm, g.getZoomLevel());
        this.directDrawContent.setViewport(new MapViewport());
        this.directDrawContent.getViewport().setMatchingAspectRatio(this.viewport.getMapViewport().isMatchingAspectRatio());
        this.directDrawContent.getViewport().setScreenArea(new Rectangle(mapAreaInScaledPixels.x, mapAreaInScaledPixels.y, mapAreaInScaledPixels.width, mapAreaInScaledPixels.height));
        this.directDrawContent.getViewport().setBounds(this.viewport.getBounds());
        float pixPerMM = 2.8346457f;
        this.copyMapContextWithScaledStyle(mapToDraw, this.directDrawContent, 100.0f / pixPerMM);
        sbMapRenderer.renderMap(g.getGraphics(), this.directDrawContent);
    }

    private void drawLegend(SBGraphics g, float blockX, float blockY, ChartProperties cp) {
        if (this.legend.isEmpty()) {
            return;
        }
        this.legend.calcPreferredWidth(g, cp);
        if (this.legend.getWidth() > this.prop.getWidth()) {
            this.legend.setWidth(this.prop.getWidth());
        }
        this.legend.calcPreferredHeight(cp);
        if (this.legend.getHeight() > this.prop.getHeight()) {
            this.legend.setHeight(this.prop.getHeight());
        }
        float xpos = switch (this.prop.getLegendOrientation()) {
            default -> throw new MatchException(null, null);
            case MapBlockProperties.LegendOrientation.TOPLEFT, MapBlockProperties.LegendOrientation.BOTTOMLEFT, MapBlockProperties.LegendOrientation.NONE -> blockX;
            case MapBlockProperties.LegendOrientation.TOPRIGHT, MapBlockProperties.LegendOrientation.BOTTOMRIGHT -> blockX + this.getWidth(cp) - this.legend.getWidth();
        };
        float ypos = switch (this.prop.getLegendOrientation()) {
            default -> throw new MatchException(null, null);
            case MapBlockProperties.LegendOrientation.TOPLEFT, MapBlockProperties.LegendOrientation.NONE, MapBlockProperties.LegendOrientation.TOPRIGHT -> blockY;
            case MapBlockProperties.LegendOrientation.BOTTOMLEFT, MapBlockProperties.LegendOrientation.BOTTOMRIGHT -> blockY + this.getHeight() - this.legend.getHeight();
        };
        this.legend.draw(g, xpos, ypos, cp, this.prop.fillLegend());
    }

    public void setSelectedWells(List<Well> selectedWells) {
        this.sbLayers.setSelectedWells(selectedWells);
        this.startMapLoading();
    }

    @Override
    public synchronized float getWidth(ChartProperties cp) {
        return this.prop.getWidth();
    }

    @Override
    public float getHeight() {
        return this.prop.getHeight();
    }

    @Override
    public float getDatumOffset() {
        return 0.0f;
    }

    @Override
    public float getHeaderHeight(ChartProperties cp) {
        return 0.0f;
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.MAP;
    }

    @Override
    public boolean isEmpty() {
        return this.sbLayers.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getObject(float x, float y, ChartProperties cp, float zoom) {
        float searchAreaSide = 5.0f;
        Rectangle2D.Float searchArea = new Rectangle2D.Float(x - searchAreaSide / 2.0f, y - searchAreaSide / 2.0f, searchAreaSide, searchAreaSide);
        ReferencedEnvelope bbox = this.viewport.convertMMRectToMapUnits(searchArea);
        if (bbox == null) return this.calculateWorldPos(x, y);
        try {
            Iterator iterator = this.sbLayers.getFeatureSources().reversed().iterator();
            block9: while (iterator.hasNext()) {
                SimpleFeatureSource fs = (SimpleFeatureSource)iterator.next();
                SimpleFeatureCollection selectedFeatures = this.featureProcessor.filterFeaturesToEnvelope(fs, bbox);
                SimpleFeatureIterator iter = selectedFeatures.features();
                try {
                    Object byteString;
                    while (true) {
                        if (!iter.hasNext()) continue block9;
                        Feature feature = iter.next();
                        if ("Well".equals(feature.getType().getName().getLocalPart())) {
                            String wellCode = feature.getProperty("well_code").getValue().toString();
                            Well well = this.getWells().stream().filter(w -> w.getWellCode().equals(wellCode)).findFirst().orElse(null);
                            if (well == null) continue;
                            Well well2 = well;
                            return well2;
                        }
                        Property nameProperty = feature.getProperty("NAME");
                        if (nameProperty != null && (byteString = nameProperty.getValue()) != null) break;
                    }
                    NamedWorldPos namedWorldPos = new NamedWorldPos(this.calculateWorldPos(x, y), new String(byteString.toString().getBytes(), "UTF-8"));
                    return namedWorldPos;
                }
                finally {
                    if (iter == null) continue;
                    iter.close();
                }
            }
            return this.calculateWorldPos(x, y);
        }
        catch (IOException | NoSuchElementException | TransformException ex) {
            LOGGER.log(Level.WARNING, "Exception while getting object on map", ex);
        }
        return this.calculateWorldPos(x, y);
    }

    @Override
    public Position2D getWorldPosInWGS84(float x, float y) {
        Position2D worldPos = this.calculateWorldPos(x, y);
        return GeotoolsUtils.convertPositionToCRS(worldPos, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public Position2D getWGS84FromMMRelativeToChart(float x, float y) {
        Position2D worldPos = this.viewport.getLatLonOfMapPosition(x, y);
        return GeotoolsUtils.convertPositionToCRS(worldPos, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public Point2D.Float getMMPositionFromLatLon(Coordinate c) {
        Position2D posLonLat = new Position2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, c.x, c.y);
        return this.viewport.getMMPositionFromLatLon(posLonLat);
    }

    @Override
    public Position2D calculateWorldPos(float x, float y) {
        float blockX = this.viewport.converter.convertUnscaledPixelsToFloat(this.viewport.getMapViewport().getScreenArea().x);
        float blockY = this.viewport.converter.convertUnscaledPixelsToFloat(this.viewport.getMapViewport().getScreenArea().y);
        return this.viewport.getLatLonOfMapPosition(blockX + x, blockY + y);
    }

    @Override
    public Point2D.Float getMMPositionFromLonLat(float lon, float lat) {
        Position2D posLonLat = new Position2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (double)lon, (double)lat);
        return this.viewport.getMMPositionFromLatLon(posLonLat);
    }

    public Point2D.Float getMMPosFromLatLonRelativeToChartOrigin(float lon, float lat) {
        Position2D posLonLat = new Position2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (double)lon, (double)lat);
        return this.viewport.getMMPositionFromLatLon(posLonLat);
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, float zoom) {
        Object object = this.getObject(x, y, cp, zoom);
        if (object != null) {
            Position2D pos = null;
            Object s = "";
            if (object instanceof Position2D) {
                Position2D p;
                pos = p = (Position2D)object;
            } else if (object instanceof NamedWorldPos) {
                NamedWorldPos p = (NamedWorldPos)object;
                pos = p.worldPos;
                s = p.featureName + "  ";
            }
            if (pos != null) {
                String pointString = String.format(COORD_FORMAT, pos.getX(), pos.getY());
                if (this.map.getCoordinateReferenceSystem() == null) {
                    return (String)s + pointString;
                }
                return (String)s + pointString + " [" + String.valueOf(this.map.getCoordinateReferenceSystem().getName()) + "]";
            }
            return object.toString();
        }
        return "";
    }

    public List<Well> getWellsWithLocation() {
        List<Well> wells = super.getWells().stream().filter(w -> w.getHeader().hasLocation()).toList();
        if (this.prop.isExcludeWellsOutsideDataRange()) {
            wells = new ArrayList<Well>(wells);
            ListIterator<Well> it = wells.listIterator();
            while (it.hasNext()) {
                boolean isWithinRange = false;
                Well well = it.next();
                WellInterp interp = this.getInterp(well);
                switch (this.prop.getDataRangeStyle()) {
                    case BOUNDARIES: {
                        DepthAgeCurve depthAgeCurve = null;
                        LOC loc = interp.getLOC();
                        if (loc != null) {
                            depthAgeCurve = loc.getDepthAgeCurve();
                        } else if (this.getProp().getDataRangeStyle() == MapBlockProperties.DataRangeStyle.BOUNDARIES && this.getProp().getScaleType() == BlockProperties.ScaleType.AGE && this.getProp().isDeriveChronoAge()) {
                            try {
                                depthAgeCurve = interp.getGeneratedDepthAgeCurve().orElse(null);
                            }
                            catch (RuntimeException e) {
                                LOGGER.warning("Error ignored generating depth/age curve: " + e.getMessage());
                            }
                        }
                        if (depthAgeCurve == null || !(depthAgeCurve.getMinAge() < (double)this.prop.getScaleLimit(IBlockProperties.ScaleLimitType.MAX)) || !(depthAgeCurve.getMaxAge() > (double)this.prop.getScaleLimit(IBlockProperties.ScaleLimitType.MIN))) break;
                        isWithinRange = true;
                        break;
                    }
                    case LITHOSTRAT: {
                        if (interp == null) break;
                        isWithinRange = interp.getIGDList(2, this.prop.getLithostratScheme().getID()).stream().anyMatch(zone -> {
                            LithostratUnit upperUnit = this.prop.getUpperLithostratUnit();
                            if (upperUnit != null && zone.getUppZone() == upperUnit.getUnitID() || zone.getLowZone() == upperUnit.getUnitID()) {
                                return true;
                            }
                            LithostratUnit lowerUnit = this.prop.getLowerLithostratUnit();
                            return lowerUnit != null && zone.getUppZone() == lowerUnit.getUnitID() || zone.getLowZone() == lowerUnit.getUnitID();
                        });
                    }
                }
                if (isWithinRange) continue;
                it.remove();
            }
        }
        return wells;
    }

    public List<Well> getChartWells() {
        if (this.chartWells.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<Well>(this.chartWells);
    }

    public void setChartWellsSupplier(Supplier<List<Well>> chartWellsSupplier) {
        this.chartWellsSupplier = chartWellsSupplier;
    }

    public void setChartWells(List<Well> chartWells) {
        this.chartWells.clear();
        this.chartWells.addAll(chartWells);
        if (this.getWellList() == null && !this.singleWellSet) {
            this.setWells(chartWells);
        }
    }

    @Override
    public void setWell(Well well) {
        this.singleWellSet = well != null;
        super.setWell(well);
    }

    public boolean isSingleWellSet() {
        return this.singleWellSet;
    }

    public final void initLayers(ChartProperties cp) {
        List currentLayers = this.map.layers();
        List<Layer> newLayers = this.sbLayers.getMapLayers(cp);
        if (OUTLINE_LAYER.booleanValue() && this.outlineLayer != null) {
            newLayers.add(this.outlineLayer);
        }
        if (currentLayers.isEmpty()) {
            currentLayers.addAll(newLayers);
            return;
        }
        currentLayers.retainAll(newLayers);
        if (!currentLayers.equals(newLayers)) {
            for (int i = 0; i < newLayers.size(); ++i) {
                if (this.map.layers().contains(newLayers.get(i))) continue;
                this.map.layers().add(i, newLayers.get(i));
            }
        }
    }

    public void refreshLayer(SBLayer member, ChartProperties cp) {
        if (!this.sbLayers.contains(member)) {
            throw new IllegalArgumentException("Map block can only replace layers from its own members");
        }
        this.sbLayers.refreshLayer(member, cp);
    }

    @Override
    public Set<CorrelationLine> getCorrelationLines(Correlation c, ChartProperties cp) {
        if (this.prop.getUpperLithostratUnit() != null) {
            return Set.of(new IGDUnitLine(CorrelationType.LITHO, (IGDUnitBase)this.prop.getUpperLithostratUnit(), IGDIntervalZone.BoundaryType.TOP, c.getDefaultLineStyle(), this.getInterpID()), new IGDUnitLine(CorrelationType.LITHO, (IGDUnitBase)this.prop.getLowerLithostratUnit(), IGDIntervalZone.BoundaryType.BASE, c.getDefaultLineStyle(), this.getInterpID()));
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public EnumMap<CorrelationType, HashSet<CorrelationPoint>> getCorrelationLines() {
        return null;
    }

    @Override
    public Set<CorrelationPoint> getCorrelationLines(CorrelationType type) {
        return switch (type) {
            case CorrelationType.LITHO -> this.correlationData;
            default -> Collections.EMPTY_SET;
        };
    }

    @Override
    public void clearCorrelationData() {
        this.correlationData.clear();
    }

    @Override
    public void addCorrelationData(Correlation c, ChartProperties cp) throws SBException, SQLException {
        if (c.getCorrType() != CorrelationType.LITHO || this.prop.getDataRangeStyle() != MapBlockProperties.DataRangeStyle.LITHOSTRAT || this.prop.getUpperLithostratUnit() == null) {
            return;
        }
        c.getLines().stream().filter(line -> line.getObject() == this.prop.getUpperLithostratUnit()).forEach(line -> {
            if (line.getObjectType() == IGDIntervalZone.BoundaryType.TOP) {
                this.correlationData.add(new CorrelationPoint((CorrelationLine)line, 0.0f, Boundary.CONF));
            }
        });
        c.getLines().stream().filter(line -> line.getObject() == this.prop.getLowerLithostratUnit()).forEach(line -> {
            if (line.getObjectType() == IGDIntervalZone.BoundaryType.BASE) {
                this.correlationData.add(new CorrelationPoint((CorrelationLine)line, this.prop.getHeight(), Boundary.CONF));
            }
        });
    }

    @Override
    public List<DrawZone> getBackgroundZones() {
        return this.backgroundZones;
    }

    private void setBackgroundZones(ChartProperties cp) {
        this.backgroundZones.clear();
        if (this.prop.getUpperLithostratUnit() == null) {
            return;
        }
        LithostratUnit unit = this.prop.getUpperLithostratUnit();
        DrawZone zone = new DrawZone(0.0f, this.prop.getHeight(), ColourUtils.getLighterColour((Color)unit.getColour(), (float)cp.bgDensity), null, -1, -1, null, null, null, null, 0.0, 0.0);
        zone.setObject(unit);
        this.backgroundZones.add(zone);
    }

    @Override
    public float getVheaderWidth(int nPanels, boolean drawPanelsWithNoData) {
        return 0.0f;
    }

    @Override
    public float getTotalHeight(ChartProperties p, Chart.Mode hMode) {
        return this.getHeight();
    }

    @Override
    public String getDefaultCaption(ChartProperties p) {
        if (this.getTemplate() != null) {
            return this.getTemplate().getName();
        }
        return "";
    }

    @Override
    public MapBlockProperties getProp() {
        return this.prop;
    }

    public void setPropCrs(CrsCode crsCode) {
        if (this.prop.getCrsCode() == crsCode) {
            return;
        }
        this.prop.setCrsCode(crsCode);
        this.setPropertyChanged();
        this.notifyListeners();
    }

    public void setPropSymbolSize(float symbolSize) {
        if (Math.abs(this.prop.getSymbolSize() - symbolSize) < 1.0f) {
            return;
        }
        this.prop.setSymbolSize(symbolSize);
        this.setPropertyChanged();
        this.notifyListeners();
    }

    public void setChartScaleByIntervalThickness(boolean value) {
        if (value == this.prop.getScaleSymbolWithIntervalThickness()) {
            return;
        }
        this.prop.setScaleSymbolWithIntervalThickness(value);
        this.setPropertyChanged();
        this.notifyListeners();
    }

    public void setShowChartScale(boolean value) {
        if (value == this.prop.getShowScale()) {
            return;
        }
        this.prop.setShowScale(value);
        this.setPropertyChanged();
        this.notifyListeners();
    }

    public void setPropLegendOrientation(MapBlockProperties.LegendOrientation lo) {
        if (this.prop.getLegendOrientation() == lo) {
            return;
        }
        this.prop.setLegendOrientation(lo);
        this.setPropertyChanged();
        this.notifyListeners();
    }

    public void setPropFillLegend(boolean fillLegend) {
        if (this.prop.fillLegend() == fillLegend) {
            return;
        }
        this.prop.setFillLegend(fillLegend);
        this.setPropertyChanged();
        this.notifyListeners();
    }

    public void setPropDimension(boolean isWidth, float dimension) {
        if (Math.abs(this.prop.getDimension(isWidth) - dimension) < 1.0f) {
            return;
        }
        this.prop.setDimension(isWidth, dimension);
        this.setPropertyChanged(new NewMapBlockDimensions(new XDimension2D.Float(this.prop.getWidth(), this.prop.getHeight())));
    }

    public void setMapExtent(ReferencedEnvelope envelope) {
        this.prop.updateExtent(envelope);
        this.buildTestingLayers();
        this.setPropertyChanged(new NewMapBlockBounds(envelope, true));
    }

    public void setPropMapExtent(int boundsIndex, double value) {
        if (Math.abs(this.prop.getMapExtent(boundsIndex) - value) < 0.001) {
            return;
        }
        this.prop.setMapExtent(boundsIndex, value);
        this.setPropertyChanged(new NewMapBlockBounds(this.prop.getReferenceEnvelopeWGS84(), true));
    }

    public void setPropDataRangeStyle(MapBlockProperties.DataRangeStyle style) {
        if (this.prop.getDataRangeStyle() == style) {
            return;
        }
        this.prop.setDataRangeStyle(style);
        if (style != MapBlockProperties.DataRangeStyle.LITHOSTRAT) {
            this.prop.setUpperLithostratUnit(null);
            this.prop.setLowerLithostratUnit(null);
        }
        this.setPropertyChanged(POINT_DATA_FLAG);
        this.notifyListeners();
    }

    public void setPropDataScaleLimit(IBlockProperties.ScaleLimitType limitType, float value) {
        if ((double)Math.abs(this.prop.getScaleLimit(limitType) - value) < 0.001) {
            return;
        }
        this.prop.setScaleLimit(limitType, value);
        this.setPropertyChanged(SCALE_LIMITS_CHANGED_FLAG);
        this.notifyListeners();
    }

    public void setPropLithostratScheme(IGDScheme scheme) {
        if (this.prop.getLithostratScheme() == scheme) {
            return;
        }
        this.prop.setLithostratScheme(scheme);
        this.setPropertyChanged(POINT_DATA_FLAG);
        this.notifyListeners();
    }

    public void setPropUpperLithostratUnit(LithostratUnit unit) {
        if (this.prop.getUpperLithostratUnit() == unit) {
            return;
        }
        this.prop.setUpperLithostratUnit(unit);
        if (this.prop.getLowerLithostratUnit() == null || this.prop.getLowerLithostratUnit().getUage() < unit.getUage()) {
            this.prop.setLowerLithostratUnit(unit);
        }
        this.setPropertyChanged(POINT_DATA_FLAG);
        this.notifyListeners();
    }

    public void setPropLowerLithostratUnit(LithostratUnit unit) {
        if (this.prop.getLowerLithostratUnit() == unit) {
            return;
        }
        this.prop.setLowerLithostratUnit(unit);
        if (this.prop.getUpperLithostratUnit() == null || this.prop.getUpperLithostratUnit().getUage() > unit.getUage()) {
            this.prop.setUpperLithostratUnit(unit);
        }
        this.setPropertyChanged(POINT_DATA_FLAG);
        this.notifyListeners();
    }

    public void setPropDataRangeExclude(boolean excludeWellsOutsideDataRange) {
        if (this.prop.isExcludeWellsOutsideDataRange() == excludeWellsOutsideDataRange) {
            return;
        }
        this.prop.setExcludeWellsOutsideDataRange(excludeWellsOutsideDataRange);
        this.setPropertyChanged(POINT_DATA_FLAG);
        this.notifyListeners();
    }

    public void setDeriveChronoAge(boolean deriveChronoAge) {
        if (this.prop.isDeriveChronoAge() == deriveChronoAge) {
            return;
        }
        this.prop.setDeriveChronoAge(deriveChronoAge);
        this.setPropertyChanged(POINT_DATA_FLAG);
        this.notifyListeners();
    }

    public void zoomMapExtent(boolean in) {
        ReferencedEnvelope env = this.prop.getReferenceEnvelopeWGS84();
        double zoom = in ? 0.6666666666666666 : 1.5;
        double centreX = env.getMedian(0);
        double centreY = env.getMedian(1);
        double w = env.getWidth() * zoom;
        double h = env.getHeight() * zoom;
        ReferencedEnvelope newEnv = new ReferencedEnvelope(centreX - w / 2.0, centreX + w / 2.0, centreY - h / 2.0, centreY + h / 2.0, env.getCoordinateReferenceSystem());
        this.prop.updateExtent(newEnv);
        this.setPropertyChanged(new NewMapBlockBounds(newEnv, true));
        this.notifyListeners();
    }

    @Override
    public String getProperties() {
        return this.prop.getProperties();
    }

    @Override
    public void prepareData(ChartUpdate update) {
        this.setupLegend();
    }

    @Override
    public void setData(ChartEvent e, ChartUpdate update) throws SBException, SQLException, IOException {
        boolean wellsChanged;
        long start = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "{0}.setData(event, update) ({1})", new Object[]{this.getClass().getSimpleName(), update});
        boolean isResizingMapBlock = false;
        if (e.getType() == ChartEvent.ChartEventType.PROPERTY) {
            if (!e.hasArgument()) {
                this.sbLayers.clearCachedLayers();
            } else if (e.getArg() == POINT_DATA_FLAG || e.getArg() == SCALE_LIMITS_CHANGED_FLAG) {
                this.sbLayers.clearCachedPointLayer();
            } else if (e.getArg().getClass() == NewMapBlockBounds.class) {
                if (this.prop.getCrsCode() == CrsCode.UTM && !this.prop.getESPGCode().equals(this.dataLoadedForESPGProjection)) {
                    this.sbLayers.clearCachedLayers();
                }
            } else if (e.getArg().getClass() == NewMapBlockDimensions.class) {
                isResizingMapBlock = true;
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Clearing cached map layers");
                this.sbLayers.clearCachedLayers();
            }
        }
        if (!(wellsChanged = this.updateChartWells()) && e.getType() == ChartEvent.ChartEventType.PROPERTY && e.hasArgument() && e.getArg().getClass() == NewMapBlockBounds.class) {
            LOGGER.log(Level.FINE, "Skipping legend and .setData on each layer as bounds changed event.");
        } else {
            this.setupLegend();
            long s2 = System.currentTimeMillis();
            this.sbLayers.forEach(l -> l.setData(update.getChartProperties()));
            LOGGER.log(Level.FINE, "set data in layers in {0}", new Object[]{System.currentTimeMillis() - s2});
        }
        this.initLayers(update.getChartProperties());
        this.setBackgroundZones(update.getChartProperties());
        if (this.mapAreaInPx != null) {
            if (e.getArg() != null && e.getArg().getClass() == NewMapBlockBounds.class) {
                if (((NewMapBlockBounds)e.getArg()).contextUpdateNeeded()) {
                    this.viewport.setMapAreaAndBounds(this.mapAreaInPx, this.prop);
                }
            } else {
                this.viewport.setMapAreaAndBounds(this.mapAreaInPx, this.prop);
            }
        }
        this.dataLoadedForESPGProjection = this.prop.getESPGCode();
        if (!this.mapIsPanningOrResizing && !isResizingMapBlock) {
            this.startMapLoading();
        }
        LOGGER.log(Level.FINE, "MapBlock.setData(ChartEvent, ChartUpdate) in {0}", new Object[]{System.currentTimeMillis() - start});
    }

    @Override
    public void setData(ChartProperties cp) throws SBException, SQLException, IOException {
        long start = System.currentTimeMillis();
        this.clearCachedLayers();
        this.updateChartWells();
        this.setupLegend();
        long s2 = System.currentTimeMillis();
        this.sbLayers.forEach(l -> l.setData(cp));
        LOGGER.log(Level.FINE, "set data in layers in {0}", new Object[]{System.currentTimeMillis() - s2});
        this.initLayers(cp);
        this.setBackgroundZones(cp);
        this.viewport.setBounds(this.prop);
        this.buildTestingLayers();
        if (!this.mapIsPanningOrResizing && this.mapAreaInPx != null) {
            this.startMapLoading();
        }
    }

    private boolean updateChartWells() {
        boolean wellsChanged = false;
        if (this.chartWellsSupplier != null) {
            boolean clearCacheForChartWellsChange = this.sbLayers.stream().anyMatch(sbLayer -> {
                LayerWellLocation layerWellLocation;
                return sbLayer instanceof LayerWellLocation && (layerWellLocation = (LayerWellLocation)sbLayer).getProperties().showCorrelation();
            });
            List<Well> oldWells = this.getWells();
            List<Well> oldChartWells = List.copyOf(this.chartWells);
            this.setChartWells(this.chartWellsSupplier.get());
            if (!this.getWells().equals(oldWells) || clearCacheForChartWellsChange && !this.chartWells.equals(oldChartWells)) {
                this.sbLayers.clearCachedPointLayer();
                wellsChanged = true;
            }
        }
        return wellsChanged;
    }

    private void setupLegend() {
        this.legend = new MapLegend();
        this.sbLayers.stream().filter(l -> l instanceof SBPointDataLayer).filter(l -> l.getTemplateID() != null).forEach(l -> this.legend.addMapLayerItem(l.getTemplateID(), l.getPanelType(), l.getCaption()));
        this.sbLayers.stream().filter(l -> l instanceof LayerShape).map(l -> (LayerShape)l).forEach(ls -> this.legend.addMapShapeItem(ls.getProperties().getLineColour(), ls.getProperties().getFillColour(), ls.getCaption()));
    }

    public void addLegendItem(int layerID, Object item, String description) {
        this.legend.addDataLayerItem(layerID, item, description);
    }

    public void clearLegendForLayer(int layerID) {
        this.legend.clearLayerData(layerID);
    }

    private void buildTestingLayers() {
        if (OUTLINE_LAYER.booleanValue()) {
            this.outlineLayer = GeotoolsUtils.getEnvelopeLayer(this.prop.getReferenceEnvelopeWGS84(), Color.black);
        }
    }

    @Override
    void initMemberWellObservation(Well well) {
    }

    @Override
    void clearMemberWellObservation(Well well) {
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    public Stream<ChartPanel> members() {
        return new LinkedList<SBLayer>(this.sbLayers).stream();
    }

    public List<SBLayer> getLayers() {
        return new LinkedList<SBLayer>(this.sbLayers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveSelectedPanel(boolean left) {
        if (this.getSelectedPanel().isEmpty()) {
            return false;
        }
        SBLayer selected = (SBLayer)this.getSelectedPanel().get();
        try {
            boolean bl = this.sbLayers.move(selected, left);
            return bl;
        }
        finally {
            this.notifyListeners();
        }
    }

    @Override
    public boolean removeSelectedPanel() {
        if (this.getSelectedPanel().isEmpty()) {
            return false;
        }
        SBLayer selected = (SBLayer)this.getSelectedPanel().get();
        int index = this.sbLayers.indexOf(selected);
        this.removePanel(selected);
        if (!this.sbLayers.isEmpty()) {
            if (index == this.sbLayers.size()) {
                --index;
            }
            this.setSelectedPanel((ChartPanel)this.sbLayers.get(index));
        }
        return true;
    }

    @Override
    public void removePanel(ChartPanel p) {
        if (!(p instanceof SBLayer)) {
            return;
        }
        int indexOfLayer = this.sbLayers.indexOf(p);
        if (indexOfLayer < 0) {
            return;
        }
        SBLayer layerToRemove = (SBLayer)p;
        if (this.sbLayers.remove(layerToRemove)) {
            p.deleteListener(this);
        }
        this.notifyListeners();
    }

    @Override
    public List<ChartPanel> addNewMember(PanelTemplate templ, PanelOcc occ) throws SQLException, SBException {
        SBLayer layer = (SBLayer)PanelFactory.createPanel(this, templ, occ);
        this.addLayer(layer);
        return List.of(layer);
    }

    @Override
    public void addMember(ChartPanel m) {
        if (!(m instanceof SBLayer)) {
            throw new IllegalArgumentException("Cannot add member of type '" + String.valueOf(m.getClass()) + "' to MapBlock");
        }
        this.addLayer((SBLayer)m);
    }

    private void addLayer(SBLayer layer) {
        this.sbLayers.add(layer);
        layer.registerListener(this);
        this.setPropertyChanged();
    }

    @Override
    public void clearMembers() {
        if (this.sbLayers.isEmpty()) {
            return;
        }
        this.sbLayers.stream().forEach(l -> l.deleteListener(this));
        this.sbLayers.clearCachedLayers();
        this.map.layers().clear();
        this.sbLayers.clear();
        this.setPropertyChanged();
    }

    @Override
    public synchronized void updateFromTemplate(BlockTemplate template) {
        Optional<LayerWellLocationWithSelection> selectionLayer = this.getLayers().stream().filter(l -> l instanceof LayerWellLocationWithSelection).map(l -> (LayerWellLocationWithSelection)l).findFirst();
        super.updateFromTemplate(template);
        if (selectionLayer.isPresent()) {
            this.clearDataLayers();
            this.addLocationWithSelectionPanel(selectionLayer.get());
        }
    }

    @Override
    public void setScaleType(BlockProperties.ScaleType scaleType) {
        if (scaleType != this.prop.getScaleType()) {
            this.prop.setScaleType(scaleType);
            this.setPropertyChanged();
            this.notifyListeners();
        }
    }

    @Override
    public void setLabelScaleType(BlockProperties.ScaleType scaleType) {
    }

    public Double getIntervalThickness(Well well, ChartProperties cp) {
        Double thickness = null;
        ScaleConverter sc = this.getScaleConverter(well, cp);
        if (this.getProp().getDataRangeStyle() == MapBlockProperties.DataRangeStyle.BOUNDARIES) {
            float maxLimit = this.getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MAX);
            float minLimit = this.getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MIN);
            Double maxTVD = sc.convert(maxLimit, this.getProp().getScaleType(), BlockProperties.ScaleType.TVD);
            Double minTVD = sc.convert(minLimit, this.getProp().getScaleType(), BlockProperties.ScaleType.TVD);
            if (minTVD != null && maxTVD != null) {
                thickness = maxTVD - minTVD;
            }
        } else {
            LithostratUnit upperUnit = this.getProp().getUpperLithostratUnit();
            LithostratUnit lowerUnit = this.getProp().getLowerLithostratUnit();
            if (lowerUnit == null) {
                lowerUnit = upperUnit;
            }
            WellInterp interp = this.getInterp(well, this.getInterpID());
            if (upperUnit != null && interp != null) {
                DepthRange wellDepthRange = this.findDepthRangeForWell(well, cp, interp, lowerUnit, upperUnit);
                if (wellDepthRange.topDepth != null && wellDepthRange.baseDepth != null) {
                    Double baseTVD = sc.convert(wellDepthRange.baseDepth, BlockProperties.ScaleType.MD, BlockProperties.ScaleType.TVD);
                    Double topTVD = sc.convert(wellDepthRange.topDepth, BlockProperties.ScaleType.MD, BlockProperties.ScaleType.TVD);
                    if (baseTVD != null && topTVD != null) {
                        thickness = baseTVD - topTVD;
                    }
                }
            }
        }
        return thickness;
    }

    public ScaleConverter getScaleConverter(Well well, ChartProperties cp) {
        LithostratUnit upperUnit = this.getProp().getUpperLithostratUnit();
        LithostratUnit lowerUnit = this.getProp().getLowerLithostratUnit();
        if (lowerUnit == null) {
            lowerUnit = upperUnit;
        }
        WellInterp interp = this.getInterp(well, this.getInterpID());
        DepthAgeCurve depthAgeCurve = null;
        if (interp != null) {
            LOC loc = interp.getLOC();
            if (loc != null) {
                depthAgeCurve = loc.getDepthAgeCurve();
            } else if (this.getProp().getDataRangeStyle() == MapBlockProperties.DataRangeStyle.BOUNDARIES && this.getProp().getScaleType() == BlockProperties.ScaleType.AGE && this.getProp().isDeriveChronoAge()) {
                try {
                    depthAgeCurve = interp.getGeneratedDepthAgeCurve().orElse(null);
                }
                catch (RuntimeException e) {
                    LOGGER.warning("Error ignored generating depth/age curve: " + e.getMessage());
                }
            }
        }
        if (upperUnit != null && interp != null) {
            DepthRange wellDepthRange = this.findDepthRangeForWell(well, cp, interp, lowerUnit, upperUnit);
            if (wellDepthRange.topDepth != null && wellDepthRange.baseDepth != null) {
                return new ScaleConverter(this.getTVDList(well), depthAgeCurve, this.getTWTList(well), wellDepthRange.topDepth.floatValue(), wellDepthRange.baseDepth.floatValue(), BlockProperties.ScaleType.MD);
            }
        }
        return new ScaleConverter(this.getTVDList(well), depthAgeCurve, this.getTWTList(well), this.getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MIN), this.getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MAX), this.getProp().getScaleType());
    }

    private DepthRange findDepthRangeForWell(Well well, ChartProperties cp, WellInterp interp, LithostratUnit lowerUnit, LithostratUnit upperUnit) {
        Double topDepth = null;
        Double baseDepth = null;
        List list = interp.getIGDList(2, upperUnit.getSchID());
        for (IGDIntervalZone i : list) {
            try {
                if (i.getUppZone() != upperUnit.getUnitID() && i.getUppZone() != lowerUnit.getUnitID() && i.getLowZone() != upperUnit.getUnitID() && i.getLowZone() != lowerUnit.getUnitID()) continue;
                double zoneTopDepth = well.getDepth(i.getTopSample(), cp.correctDepths, cp.correctCuttings);
                double zoneBaseDepth = well.getDepth(i.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                if (topDepth == null) {
                    topDepth = zoneTopDepth;
                } else if (zoneTopDepth < topDepth) {
                    topDepth = zoneTopDepth;
                }
                if (baseDepth == null) {
                    baseDepth = zoneBaseDepth;
                    continue;
                }
                if (!(zoneBaseDepth > baseDepth)) continue;
                baseDepth = zoneBaseDepth;
            }
            catch (SQLException ex) {
                throw SuppressedSQLException.withoutRollback((SQLException)ex);
            }
        }
        return new DepthRange(baseDepth, topDepth);
    }

    public void zoomInAt(Point2D.Float p, Rectangle2D.Float blockBounds) {
        this.zoomAtPoint(p, 1.5, blockBounds);
    }

    public void zoomOutAt(Point2D.Float p, Rectangle2D.Float blockBounds) {
        this.zoomAtPoint(p, 0.6666666666666666, blockBounds);
    }

    private void zoomAtPoint(Point2D.Float pointInMM, double zoom, Rectangle2D.Float blockBounds) {
        if (this.map == null || pointInMM == null) {
            return;
        }
        float zoomPointXmm = pointInMM.x - blockBounds.x;
        float zoomPointYmm = pointInMM.y - blockBounds.y;
        ReferencedEnvelope newBounds = this.viewport.calculateZoomAtPoint(new Point2D.Float(zoomPointXmm, zoomPointYmm), zoom);
        this.mapImage = null;
        this.setMapExtent(newBounds);
        this.notifyListeners();
    }

    public void setMapViewport() {
        if (this.mapAreaInPx != null) {
            this.viewport.setMapAreaAndBounds(this.mapAreaInPx, this.prop);
        }
    }

    public void zoomToRect(Rectangle2D.Float rect, Rectangle2D.Float blockBounds) {
        if (this.map == null || rect == null) {
            return;
        }
        Rectangle2D.Float rectRelativeToMapBox = new Rectangle2D.Float(rect.x - blockBounds.x, rect.y - blockBounds.y, rect.width, rect.height);
        ReferencedEnvelope newBounds = this.viewport.calculateZoomToRect(rectRelativeToMapBox);
        if (newBounds == null) {
            return;
        }
        this.mapImage = null;
        this.setMapExtent(newBounds);
        this.notifyListeners();
    }

    public void panMap(Point2D.Float dragOrigin, Point2D.Float dragDestination) {
        this.panOffset = new ImageOffset(dragDestination.x - this.startPanPoint.x, dragDestination.y - this.startPanPoint.y);
        ReferencedEnvelope newBounds = this.viewport.calculateMapPan(dragOrigin, dragDestination);
        if (newBounds == null) {
            return;
        }
        this.viewport.setBounds(newBounds);
        ReferencedEnvelope boundsWGS84 = this.viewport.getViewportBoundsInWGS84();
        this.prop.updateExtent(boundsWGS84);
        this.buildTestingLayers();
        this.setPropertyChanged(new NewMapBlockBounds(boundsWGS84, false));
        this.notifyListeners();
    }

    public void clearDataLayers() {
        this.getLayers().stream().filter(l -> l instanceof SBPointDataLayer).filter(l -> !(l instanceof LayerWellLocation) && !(l instanceof LayerWellLocationWithSelection)).forEach(l -> this.removePanel((ChartPanel)l));
    }

    public void clearCachedLayers() {
        this.sbLayers.clearCachedLayers();
    }

    public void addLocationWithSelectionPanel(LayerWellLocationWithSelection selectionPanel) {
        List<LayerWellLocation> locationLayers = this.getLayers().stream().filter(l -> l instanceof LayerWellLocation).map(l -> (LayerWellLocation)l).toList();
        if (!locationLayers.isEmpty()) {
            LayerWellLocation loc = locationLayers.get(0);
            selectionPanel.getProperties().setPropertiesFromLayerWellLocation(loc.getProperties());
            selectionPanel.getProperties().notifyListenerOfPropertyChanged();
            locationLayers.forEach(l -> this.removePanel((ChartPanel)l));
        }
        this.addMember(selectionPanel);
    }

    private void startMapLoading() {
        if (this.blockWorker != null) {
            this.blockWorker.cancel(true);
        }
        this.backgroundDrawContent.setViewport(new MapViewport());
        this.backgroundDrawContent.getViewport().setBounds(this.viewport.getBounds());
        this.backgroundDrawContent.getViewport().setMatchingAspectRatio(this.viewport.getMapViewport().isMatchingAspectRatio());
        this.backgroundDrawContent.getViewport().setScreenArea(this.viewport.getMapViewport().getScreenArea());
        this.copyMapContextWithScaledStyle(this.map, this.backgroundDrawContent, this.graphicsScalingFactor * this.zoomLevel);
        Dimension scaledImageSize = this.calculateScaledImageSize();
        this.blockWorker = new MapBlockSwingWorker(this::setMapImage, this.viewport.getMapViewport(), scaledImageSize, this.backgroundDrawContent);
        this.blockWorker.execute();
        LOGGER.log(Level.FINEST, "Started map loading with dimensions {0}, zoom level {1}", new Object[]{scaledImageSize, Float.valueOf(this.zoomLevel)});
    }

    private Dimension calculateScaledImageSize() {
        if (this.mapAreaInPx == null) {
            return new Dimension(100, 100);
        }
        Dimension scaledImageSize = new Dimension((int)((float)this.mapAreaInPx.width * this.graphicsScalingFactor * this.zoomLevel), (int)((float)this.mapAreaInPx.height * this.graphicsScalingFactor * this.zoomLevel));
        if (scaledImageSize.width * scaledImageSize.height > 50000000) {
            double aspect = (double)this.mapAreaInPx.height / (double)this.mapAreaInPx.width;
            double maxWidth = Math.sqrt(5.0E7 / aspect);
            double maxHeight = aspect * maxWidth;
            scaledImageSize = new Dimension((int)maxWidth, (int)maxHeight);
        }
        return scaledImageSize;
    }

    private void setMapImage(BufferedImage image) {
        this.panOffset = new ImageOffset(0.0f, 0.0f);
        this.existingOffset = new ImageOffset(0.0f, 0.0f);
        this.mapImage = image;
        this.setSoftChanged();
        this.notifyListeners();
    }

    public void panOrResizeMapStart(Point2D.Float startPointMM) {
        this.mapIsPanningOrResizing = true;
        this.startPanPoint = new Point2D.Float(startPointMM.x, startPointMM.y);
        LOGGER.log(Level.FINEST, "Panning/resizing from {0}", new Object[]{this.startPanPoint});
    }

    public void panOrResizeMapEnd() {
        LOGGER.log(Level.FINEST, "Panning/resizing finished", new Object[]{this.startPanPoint});
        this.mapIsPanningOrResizing = false;
        this.existingOffset = new ImageOffset(this.existingOffset.x + this.panOffset.x, this.existingOffset.y + this.panOffset.y);
        this.panOffset = new ImageOffset(0.0f, 0.0f);
        this.startMapLoading();
    }

    private void copyMapContextWithScaledStyle(MapContent contentToCopyFrom, MapContent contentToCopyTo, float styleScalingFactor) {
        contentToCopyTo.layers().clear();
        RescaleStyleVisitor rescaler = new RescaleStyleVisitor((double)styleScalingFactor);
        for (Layer l : contentToCopyFrom.layers()) {
            FeatureLayer fl;
            FeatureSource<?, ?> fs;
            l.getStyle().accept((StyleVisitor)rescaler);
            Style biggerStyle = (Style)rescaler.getCopy();
            if (!(l instanceof FeatureLayer) || (fs = this.scaleChartSizeValues((fl = (FeatureLayer)l).getFeatureSource(), styleScalingFactor)) == null) continue;
            contentToCopyTo.addLayer((Layer)new FeatureLayer(fs, biggerStyle));
        }
    }

    private FeatureSource<?, ?> scaleChartSizeValues(FeatureSource<?, ?> originalSource, float styleScalingFactor) {
        SimpleFeatureSource source;
        block11: {
            source = null;
            try {
                CollectionFeatureSource cfs;
                SimpleFeatureCollection sfc;
                if (!(originalSource instanceof CollectionFeatureSource) || !((SimpleFeatureType)(sfc = (cfs = (CollectionFeatureSource)originalSource).getFeatures()).getSchema()).getName().getLocalPart().equals("Well")) break block11;
                ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
                try (SimpleFeatureIterator sfi = cfs.getFeatures().features();){
                    while (sfi.hasNext()) {
                        SimpleFeature f = (SimpleFeature)sfi.next();
                        SimpleFeature fCopy = SimpleFeatureBuilder.deep((SimpleFeature)f);
                        Object value = f.getAttribute("chart_size");
                        if (value != null) {
                            fCopy.setAttribute("chart_size", (Object)Math.round((float)((Integer)value).intValue() * styleScalingFactor));
                        }
                        features.add(fCopy);
                    }
                }
                source = DataUtilities.source((SimpleFeature[])features.toArray(new SimpleFeature[features.size()]));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Exception while scaling chart size values", e);
            }
        }
        if (source == null) {
            source = originalSource;
        }
        return source;
    }

    public void setViewportPosition(float x, float y) {
        this.viewport.setViewportPosition(x, y);
    }

    private MapContent buildBackgroundMapContent() {
        LayerShape ls = DefaultMapLayerBuilder.buildDefaultMapLayerShape(this, null);
        MapContent mc = new MapContent();
        mc.setTitle("background outline");
        ChartProperties cp = new ChartProperties();
        mc.layers().add(ls.createLayer(cp));
        return mc;
    }

    public String toString() {
        Object string = "";
        if (this.getWellList() != null) {
            string = (String)string + this.getWellList().toString();
        }
        if (this.getTemplate() != null) {
            if (!((String)string).isEmpty()) {
                string = (String)string + " / ";
            }
            string = (String)string + this.getTemplate().getName();
        }
        return string;
    }

    private class LayerList
    extends LinkedList<SBLayer> {
        private final PointDataLayerFactory pointLayerFactory;
        final /* synthetic */ MapBlock this$0;

        private LayerList(MapBlock mapBlock) {
            MapBlock mapBlock2 = mapBlock;
            Objects.requireNonNull(mapBlock2);
            this.this$0 = mapBlock2;
            this.pointLayerFactory = new PointDataLayerFactory(this.this$0);
        }

        public void setSelectedWells(List<Well> selectedWells) {
            this.pointLayerFactory.setSelectedWells(selectedWells);
        }

        List<Layer> getMapLayers(ChartProperties cp) {
            LinkedList<Layer> layers = new LinkedList<Layer>();
            LinkedList<SBPointDataLayer> pointDataLayers = new LinkedList<SBPointDataLayer>();
            for (SBLayer sbLayer : this) {
                if (sbLayer instanceof LayerFactory) {
                    LayerFactory lf = (LayerFactory)((Object)sbLayer);
                    Layer layer = lf.getLayer(cp);
                    if (layer == null) continue;
                    layers.add(layer);
                    continue;
                }
                if (sbLayer instanceof SBPointDataLayer) {
                    SBPointDataLayer dl = (SBPointDataLayer)sbLayer;
                    pointDataLayers.add(dl);
                    continue;
                }
                throw new IllegalStateException("Maybe this is an occasion to use sealed classes?");
            }
            Layer pointDataLayer = this.pointLayerFactory.getLayer(cp, pointDataLayers);
            if (pointDataLayer != null) {
                layers.add(pointDataLayer);
            }
            return layers;
        }

        List<Layer> getCachedMapLayers() {
            LinkedList<Layer> layers = new LinkedList<Layer>();
            this.forEach(sbLayer -> {
                if (sbLayer instanceof LayerFactory) {
                    LayerFactory lf = (LayerFactory)((Object)sbLayer);
                    lf.getCachedLayer().ifPresent(layers::add);
                }
            });
            this.pointLayerFactory.getCachedLayer().ifPresent(layers::add);
            return layers;
        }

        List<SimpleFeatureSource> getFeatureSources() {
            ArrayList<SimpleFeatureSource> sources = new ArrayList<SimpleFeatureSource>();
            this.pointLayerFactory.getFeatureSource().ifPresent(sources::add);
            this.forEach(sbLayer -> {
                if (sbLayer instanceof LayerFactory) {
                    LayerFactory lf = (LayerFactory)((Object)sbLayer);
                    lf.getFeatureSource().ifPresent(sources::add);
                }
            });
            return sources;
        }

        void clearCachedLayers() {
            this.stream().filter(sbLayer -> sbLayer instanceof LayerFactory).map(l -> (LayerFactory)((Object)l)).forEach(LayerFactory::clearCachedLayer);
            this.pointLayerFactory.clearCachedLayer();
            this.this$0.layersHaveChanged = true;
        }

        void clearCachedPointLayer() {
            this.pointLayerFactory.clearCachedLayer();
            this.this$0.layersHaveChanged = true;
        }

        boolean remove(SBLayer layerToRemove) {
            boolean removed = super.remove(layerToRemove);
            if (removed) {
                if (layerToRemove instanceof LayerFactory) {
                    LayerFactory lf = (LayerFactory)((Object)layerToRemove);
                    lf.getCachedLayer().ifPresent(l -> {
                        this.this$0.map.layers().remove(l);
                        this.this$0.setSoftChanged();
                    });
                } else if (layerToRemove instanceof SBPointDataLayer) {
                    if (this.pointLayerFactory.clearCachedLayer()) {
                        this.this$0.setDataChanged(POINT_DATA_FLAG);
                    }
                } else {
                    throw new IllegalStateException("Maybe this is an occasion to use sealed classes?");
                }
            }
            this.this$0.layersHaveChanged = true;
            return removed;
        }

        boolean move(SBLayer layerToMove, boolean left) {
            int newIndex;
            int indexOfSelected = this.this$0.sbLayers.indexOf(layerToMove);
            int n = newIndex = left ? indexOfSelected - 1 : indexOfSelected + 1;
            if (newIndex < 0 || newIndex >= this.this$0.sbLayers.size()) {
                return false;
            }
            this.remove(indexOfSelected);
            this.add(newIndex, layerToMove);
            if (layerToMove instanceof LayerFactory) {
                LayerFactory lf = (LayerFactory)((Object)layerToMove);
                lf.getCachedLayer().ifPresent(cachedMapLayer -> {
                    int actualIndex;
                    List<Layer> cachedMapLayers = this.getCachedMapLayers();
                    int correctIndex = cachedMapLayers.indexOf(cachedMapLayer);
                    if (correctIndex != (actualIndex = this.this$0.map.layers().indexOf(cachedMapLayer))) {
                        if (correctIndex < 0 || actualIndex < 0) {
                            throw new IllegalStateException("Ooops");
                        }
                        this.this$0.map.moveLayer(actualIndex, correctIndex);
                        this.this$0.setSoftChanged();
                    }
                });
            } else if (layerToMove instanceof SBPointDataLayer) {
                if (this.pointLayerFactory.clearCachedLayer()) {
                    this.this$0.setDataChanged(POINT_DATA_FLAG);
                }
            } else {
                throw new IllegalStateException("Maybe this is an occasion to use sealed classes?");
            }
            this.this$0.layersHaveChanged = true;
            return true;
        }

        private LayerFactory getLayerFactory(SBLayer member) {
            if (!this.this$0.sbLayers.contains(member)) {
                throw new IllegalStateException();
            }
            if (member instanceof LayerFactory) {
                LayerFactory lf = (LayerFactory)((Object)member);
                return lf;
            }
            if (member instanceof SBPointDataLayer) {
                SBPointDataLayer dl = (SBPointDataLayer)member;
                return this.pointLayerFactory;
            }
            throw new IllegalStateException("Maybe this is an occasion to use sealed classes?");
        }

        public void refreshLayer(SBLayer member, ChartProperties cp) {
            member.setData(cp);
            LayerFactory lf = this.getLayerFactory(member);
            lf.recreateLayer(cp);
            this.this$0.initLayers(cp);
            this.this$0.layersHaveChanged = true;
        }
    }

    record ImageOffset(float x, float y) {
    }

    private record NamedWorldPos(Position2D worldPos, String featureName) {
    }

    record NewMapBlockDimensions(XDimension2D.Float newDimension) {
    }

    record NewMapBlockBounds(ReferencedEnvelope newBounds, boolean contextUpdateNeeded) {
    }

    record DepthRange(Double baseDepth, Double topDepth) {
    }
}

