/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.IBlockProperties;
import jsbchart.graphics.map.CrsCode;
import jsbchart.util.GeotoolsUtils;
import jsbchart.util.ReferenceEnvelopeTransformHelper;
import model3.IGDScheme;
import model3.LithostratUnit;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import util.SB;

public class MapBlockProperties
implements IBlockProperties {
    private static final Logger LOGGER = Logger.getLogger(MapBlockProperties.class.getName());
    public static final double MAX_LONGITUDE_RANGE = 540.0;
    public static final double MIN_LONGITUDE_RANGE = 0.01;
    public static final double MAX_LATITUDE_RANGE = 270.0;
    public static final double MIN_LATITUDE_RANGE = 0.01;
    public static final double MIN_LATITUDE_VALUE = -80.0;
    public static final double MAX_LATITUDE_VALUE = 80.0;
    public static final double MIN_LONGITUDE_VALUE = -160.0;
    public static final double MAX_LONGITUDE_VALUE = 160.0;
    private CrsCode crsCode = CrsCode.WGS84;
    private float symbolSize = 8.0f;
    public static final float SYMBOL_SIZE_MIN = 3.0f;
    public static final float SYMBOL_SIZE_MAX = 500.0f;
    private LegendOrientation legendOrientation = LegendOrientation.BOTTOMLEFT;
    private boolean fillLegend = false;
    private float width = 150.0f;
    private float height = 150.0f;
    public static final float DIMENSION_MIN = 20.0f;
    public static final double LAT_MIN = -90.0;
    public static final double LAT_MAX = 90.0;
    public static final double LONG_MIN = -180.0;
    public static final double LONG_MAX = 180.0;
    private double longMin = -180.0;
    private double longMax = 180.0;
    private double latMin = -90.0;
    private double latMax = 90.0;
    private DataRangeStyle dataRangeStyle = DataRangeStyle.BOUNDARIES;
    private BlockProperties.ScaleType scaleType = BlockProperties.ScaleType.AGE;
    private float scaleMin;
    private float scaleMax;
    private IGDScheme lithostratScheme;
    private LithostratUnit upperLithostratUnit;
    private LithostratUnit lowerLithostratUnit;
    private int upperLithostratUnitID;
    private int lowerLithostratUnitID;
    private boolean excludeWellsOutsideDataRange = false;
    private boolean deriveChronoAge = false;
    private boolean scaleSymbolWithIntervalThickness = false;
    private boolean showScale = false;
    public static final int BOUNDS_INDEX_LONG_MIN = 0;
    public static final int BOUNDS_INDEX_LONG_MAX = 1;
    public static final int BOUNDS_INDEX_LAT_MIN = 2;
    public static final int BOUNDS_INDEX_LAT_MAX = 3;

    public CrsCode getCrsCode() {
        return this.crsCode;
    }

    public void setCrsCode(CrsCode crsCode) {
        this.crsCode = crsCode;
    }

    public void setSymbolSize(float symbolSize) {
        this.symbolSize = symbolSize;
    }

    public float getSymbolSize() {
        return this.symbolSize;
    }

    public LegendOrientation getLegendOrientation() {
        return this.legendOrientation;
    }

    public void setLegendOrientation(LegendOrientation legendOrientation) {
        this.legendOrientation = legendOrientation;
    }

    public boolean fillLegend() {
        return this.fillLegend;
    }

    public void setFillLegend(boolean fillLegend) {
        this.fillLegend = fillLegend;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getDimension(boolean width) {
        return width ? this.width : this.height;
    }

    public void setDimension(boolean width, float dimension) {
        if (width) {
            this.setWidth(dimension);
        } else {
            this.setHeight(dimension);
        }
    }

    public double getLongMin() {
        return this.longMin;
    }

    public void setLongMin(double longMin) {
        this.longMin = longMin;
    }

    public double getLongMax() {
        return this.longMax;
    }

    public void setLongMax(double longMax) {
        this.longMax = longMax;
    }

    public double getLatMin() {
        return this.latMin;
    }

    public void setLatMin(double latMin) {
        this.latMin = latMin;
    }

    public double getLatMax() {
        return this.latMax;
    }

    public void setLatMax(double latMax) {
        this.latMax = latMax;
    }

    public double getMapExtent(int index) {
        return switch (index) {
            case 0 -> this.getLongMin();
            case 1 -> this.getLongMax();
            case 2 -> this.getLatMin();
            case 3 -> this.getLatMax();
            default -> throw new IllegalArgumentException("Illegal bounds index: " + index);
        };
    }

    public void updateExtent(ReferencedEnvelope env) {
        assert (env.getCoordinateReferenceSystem() == DefaultGeographicCRS.WGS84);
        this.setLatMin(SB.round((double)env.getMinY(), (int)4));
        this.setLatMax(SB.round((double)env.getMaxY(), (int)4));
        this.setLongMin(SB.round((double)env.getMinX(), (int)4));
        this.setLongMax(SB.round((double)env.getMaxX(), (int)4));
    }

    public final void setMapExtent(int index, double value) {
        switch (index) {
            case 0: {
                this.setLongMin(value);
                break;
            }
            case 1: {
                this.setLongMax(value);
                break;
            }
            case 2: {
                this.setLatMin(value);
                break;
            }
            case 3: {
                this.setLatMax(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal bounds index: " + index);
            }
        }
    }

    @Override
    public BlockProperties.ScaleType getScaleType() {
        return this.scaleType;
    }

    public void setScaleType(BlockProperties.ScaleType scaleType) {
        this.scaleType = scaleType;
    }

    @Override
    public BlockProperties.ScaleType getLabelScaleType() {
        return null;
    }

    public void setScaleLimit(IBlockProperties.ScaleLimitType type, float value) {
        switch (type) {
            case MIN: {
                this.scaleMin = value;
                break;
            }
            case MAX: {
                this.scaleMax = value;
            }
        }
    }

    @Override
    public float getScaleLimit(IBlockProperties.ScaleLimitType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case IBlockProperties.ScaleLimitType.MIN -> this.scaleMin;
            case IBlockProperties.ScaleLimitType.MAX -> this.scaleMax;
        };
    }

    public float getScaleMidpoint() {
        return this.scaleMin + (this.scaleMax - this.scaleMin) / 2.0f;
    }

    public DataRangeStyle getDataRangeStyle() {
        return this.dataRangeStyle;
    }

    public void setDataRangeStyle(DataRangeStyle dataRangeStyle) {
        this.dataRangeStyle = dataRangeStyle;
    }

    public IGDScheme getLithostratScheme() {
        return this.lithostratScheme;
    }

    public LithostratUnit getUpperLithostratUnit() {
        return this.upperLithostratUnit;
    }

    public LithostratUnit getLowerLithostratUnit() {
        return this.lowerLithostratUnit;
    }

    public void setLithostratScheme(IGDScheme lithostratScheme) {
        if (this.lithostratScheme != lithostratScheme) {
            this.lithostratScheme = lithostratScheme;
            this.upperLithostratUnit = null;
            this.lowerLithostratUnit = null;
        }
    }

    public void setUpperLithostratUnit(LithostratUnit lithostratUnit) {
        this.upperLithostratUnit = lithostratUnit;
        if (lithostratUnit != null) {
            this.upperLithostratUnitID = lithostratUnit.getUnitID();
        }
    }

    public void setLowerLithostratUnit(LithostratUnit lithostratUnit) {
        this.lowerLithostratUnit = lithostratUnit;
        if (lithostratUnit != null) {
            this.lowerLithostratUnitID = lithostratUnit.getUnitID();
        }
    }

    public void setLithostratScheme(IGDScheme lithostratScheme, LithostratUnit upperUnit, LithostratUnit lowerUnit) {
        if (upperUnit.getSchID() != lithostratScheme.getID() || lowerUnit.getSchID() != lithostratScheme.getID()) {
            throw new IllegalArgumentException("Lithostrat ID mismatch");
        }
        this.lithostratScheme = lithostratScheme;
        this.upperLithostratUnit = upperUnit;
        this.lowerLithostratUnit = lowerUnit;
    }

    public int getUpperLithostratUnitID() {
        return this.upperLithostratUnitID;
    }

    public int getLowerLithostratUnitID() {
        return this.lowerLithostratUnitID;
    }

    public boolean isExcludeWellsOutsideDataRange() {
        return this.excludeWellsOutsideDataRange;
    }

    public void setExcludeWellsOutsideDataRange(boolean excludeWellsOutsideDataRange) {
        this.excludeWellsOutsideDataRange = excludeWellsOutsideDataRange;
    }

    public boolean isDeriveChronoAge() {
        return this.deriveChronoAge;
    }

    public void setDeriveChronoAge(boolean deriveChronoAge) {
        this.deriveChronoAge = deriveChronoAge;
    }

    public boolean getScaleSymbolWithIntervalThickness() {
        return this.scaleSymbolWithIntervalThickness;
    }

    public void setScaleSymbolWithIntervalThickness(boolean value) {
        this.scaleSymbolWithIntervalThickness = value;
    }

    public boolean getShowScale() {
        return this.showScale;
    }

    public void setShowScale(boolean value) {
        this.showScale = value;
    }

    public ReferencedEnvelope getReferenceEnvelope() throws FactoryException, TransformException {
        CoordinateReferenceSystem crs = this.getCRS();
        ReferencedEnvelope re = this.getReferenceEnvelopeWGS84();
        return ReferenceEnvelopeTransformHelper.transformReferencedEnvelope(re, crs);
    }

    public String getESPGCode() {
        String code = this.getCrsCode().getCode(this.getReferenceEnvelopeWGS84());
        return code;
    }

    public CoordinateReferenceSystem getCRS() throws FactoryException {
        return GeotoolsUtils.getCRS(this.getESPGCode());
    }

    public ReferencedEnvelope getReferenceEnvelopeWGS84() {
        return new ReferencedEnvelope(this.getLongMin(), this.getLongMax(), this.getLatMin(), this.getLatMax(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    @Override
    public String getProperties() {
        Object[] props = new String[20];
        props[0] = this.crsCode.name();
        props[1] = "" + this.width;
        props[2] = "" + this.height;
        for (int i = 0; i < 4; ++i) {
            props[3 + i] = "" + this.getMapExtent(i);
        }
        props[7] = this.scaleType.name();
        props[8] = "" + this.scaleMin;
        props[9] = "" + this.scaleMax;
        props[10] = this.dataRangeStyle.name();
        props[11] = "" + (this.upperLithostratUnit != null ? this.upperLithostratUnit.getUnitID() : 0);
        props[12] = "" + (this.excludeWellsOutsideDataRange ? 1 : 0);
        props[13] = "" + this.symbolSize;
        props[14] = this.legendOrientation.name();
        props[15] = "" + (this.lowerLithostratUnit != null ? this.lowerLithostratUnit.getUnitID() : 0);
        props[16] = "" + (this.fillLegend ? 1 : 0);
        props[17] = "" + (this.deriveChronoAge ? 1 : 0);
        props[18] = "" + (this.scaleSymbolWithIntervalThickness ? 1 : 0);
        props[19] = "" + (this.showScale ? 1 : 0);
        return StringUtils.join((Object[])props, (String)"|");
    }

    public MapBlockProperties() {
    }

    public MapBlockProperties(String props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        String[] split = props.split("\\|");
        for (int i = 0; i < split.length; ++i) {
            try {
                switch (i) {
                    case 0: {
                        this.crsCode = CrsCode.valueOf(split[i]);
                        break;
                    }
                    case 1: {
                        this.width = Float.parseFloat(split[i]);
                        break;
                    }
                    case 2: {
                        this.height = Float.parseFloat(split[i]);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        double value = Double.parseDouble(split[i]);
                        this.setMapExtent(i - 3, value);
                        break;
                    }
                    case 7: {
                        this.scaleType = BlockProperties.ScaleType.valueOf(split[i]);
                        break;
                    }
                    case 8: {
                        this.scaleMin = Float.parseFloat(split[i]);
                        break;
                    }
                    case 9: {
                        this.scaleMax = Float.parseFloat(split[i]);
                        break;
                    }
                    case 10: {
                        this.dataRangeStyle = DataRangeStyle.valueOf(split[i]);
                        break;
                    }
                    case 11: {
                        this.lowerLithostratUnitID = this.upperLithostratUnitID = Integer.parseInt(split[i]);
                        break;
                    }
                    case 12: {
                        this.excludeWellsOutsideDataRange = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 13: {
                        this.symbolSize = Float.parseFloat(split[i]);
                        break;
                    }
                    case 14: {
                        this.legendOrientation = LegendOrientation.valueOf(split[i]);
                        break;
                    }
                    case 15: {
                        this.lowerLithostratUnitID = Integer.parseInt(split[i]);
                        break;
                    }
                    case 16: {
                        this.fillLegend = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 17: {
                        this.deriveChronoAge = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 18: {
                        this.scaleSymbolWithIntervalThickness = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 19: {
                        this.showScale = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                }
                continue;
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(MapBlockProperties.class.getName()).log(Level.WARNING, "Exception decoding map block properties: ''{0}''; defaults will be used.", nfe.getMessage());
            }
        }
    }

    public static enum LegendOrientation {
        TOPLEFT("Top-left"),
        TOPRIGHT("Top-right"),
        BOTTOMLEFT("Bottom-left"),
        BOTTOMRIGHT("Bottom-right"),
        NONE("None");

        private final String descr;

        private LegendOrientation(String descr) {
            this.descr = descr;
        }

        public String toString() {
            return this.descr;
        }
    }

    public static enum DataRangeStyle {
        BOUNDARIES("Scale limits"),
        LITHOSTRAT("Lithostratigraphy unit");

        private final String descr;

        private DataRangeStyle(String descr) {
            this.descr = descr;
        }

        public String toString() {
            return this.descr;
        }
    }
}

