/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.IBlockProperties;
import jsbchart.block.SubBlockProperties;
import jsbchart.core.BlockTemplate;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelIsDefaultListener;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.core.PanelWellHeader;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import jsbchart.correlation.EventLine;
import jsbchart.correlation.IGDUnitLine;
import jsbchart.correlation.SurfaceLine;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartUpdate;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelBiozones;
import jsbchart.panel.PanelEvents;
import jsbchart.panel.PanelEventsProperties;
import jsbchart.panel.PanelFactory;
import jsbchart.panel.PanelSQPicks;
import jsbchart.panel.PanelType;
import jsbchart.panel.PanelWellDepthAge;
import jsbchart.panel.PanelZones;
import jsbchart.panel.SBPanel;
import jsbchart.panel.SBPanelHTML;
import jsbchart.util.DrawZone;
import model3.DataType;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.InterpHdr;
import model3.LOC;
import model3.LithBase;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.SampleLithologyUnit;
import model3.Smpdtl;
import model3.TVDList;
import model3.TVDepth;
import model3.TWTDepth;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import org.apache.commons.lang3.StringUtils;
import util.ColourUtils;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class WellBlock
extends ChartBlock
implements PanelIsDefaultListener {
    private static final Logger LOGGER = Logger.getLogger(WellBlock.class.getName());
    public LinkedList<SBPanel> removedPanels = new LinkedList();
    private LinkedList<SubBlockProperties> subBlockProperties = null;
    static final float SUBBLOCK_GAP = 5.0f;
    private boolean needsBzPanelInit = false;
    static final float TEMPLATE_MIN = 0.0f;
    static final float TEMPLATE_MAX = 100.0f;
    static final float TEMPLATE_SCALE = 1000.0f;
    private LinkedList<Sample> templateSamples;
    private LinkedList<DrawZone> intervals;

    public WellBlock(Well well, SBdb db) throws SQLException, SBException {
        super(db, null);
        this.setWell(well);
        this.prop = new BlockProperties(BlockProperties.ScaleType.MD);
        this.prop.units = well.getWellUnits();
    }

    public WellBlock(SBdb db, BlockTemplate template, Well well, BlockProperties bp) throws SQLException, SBException {
        super(db, template);
        if (well == null) {
            this.setTemplateSamples();
        } else {
            this.setWell(well);
        }
        if (bp != null) {
            this.prop = bp;
        } else if (well == null) {
            this.setTemplateProperties();
        } else {
            this.prop = new BlockProperties(BlockProperties.ScaleType.MD);
            this.setDefaultProperties();
            this.prop.setUnits(well.getWellUnits());
        }
        this.getHeight();
    }

    WellBlock(SBdb sbdb, BlockTemplate template) throws SQLException, SBException {
        this(sbdb, template, null, null);
    }

    private void setTemplateProperties() {
        this.prop = new BlockProperties(BlockProperties.ScaleType.MD);
        this.prop.setMin(0.0f);
        this.prop.setMax(100.0f);
        this.prop.setScale(1000.0f);
        this.prop.calcHeight();
    }

    public WellBlock(Well well, SBdb db, BlockProperties bp) throws SQLException, SBException {
        super(db, null);
        if (bp == null) {
            throw new IllegalArgumentException("Properties null in WellBlock constructor");
        }
        this.prop = bp;
        if (well != null) {
            this.setWell(well);
            this.prop.units = well.getWellUnits();
        }
    }

    public String toString() {
        Object string = "";
        if (this.getWell() != null) {
            string = (String)string + this.getWell().toString();
        }
        if (this.getTemplate() != null) {
            if (!((String)string).isEmpty()) {
                string = (String)string + " / ";
            }
            if (this.getTemplate().getParentID() != null) {
                try {
                    string = (String)string + this.getTemplate().getParentName();
                }
                catch (SQLException sqlex) {
                    LOGGER.log(Level.WARNING, "Error loading parent template", sqlex);
                    string = (String)string + this.getTemplate().getName();
                }
            } else {
                string = (String)string + this.getTemplate().getName();
            }
        }
        return string;
    }

    public final void setDefaultProperties() throws SBException, SQLException {
        this.setScale((float)WellBlock.getDefaultScale(this.getWell().getTopSampleDepth(), this.getWell().getBaseSampleDepth(), this.getWell().getWellUnits()));
        float[] depthBnds = WellBlock.getDefaultDepthBounds(this.getWell(), this.getScale());
        this.setTopDepth(depthBnds[0]);
        this.setBaseDepth(depthBnds[1]);
    }

    @Override
    public float[] getTVDLimits(Float minDepth, Float maxDepth) {
        if (this.getWell() == null) {
            return new float[]{19.0f, 85.0f};
        }
        return super.getTVDLimits(minDepth, maxDepth);
    }

    @Override
    public float[] getAgeLimits(Float minDepth, Float maxDepth) {
        if (this.getWell() == null) {
            return new float[]{0.0f, 85.0f};
        }
        return super.getAgeLimits(minDepth, maxDepth);
    }

    @Override
    synchronized float draw(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines, Chart.Mode vMode) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            try {
                WellInterp interp;
                if (this.getWell() != null && (interp = this.getWell().getInterp(this.getInterpID())) != null) {
                    interp.loadLOC(this.getWell().getWellID());
                }
            }
            catch (SQLException | SBException sbe) {
                LOGGER.log(Level.SEVERE, "Error getting interp in WellBlock.draw()" + sbe.getMessage(), sbe);
                System.out.println();
            }
        }
        LinkedList disconformities = null;
        LinkedList disconformityText = null;
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            LinkedList[] arr = this.setDisconformityClip(g, x, y, p, mode);
            if (arr != null) {
                disconformities = arr[0];
                disconformityText = arr[1];
            }
        } else if (p.drawDisconformities) {
            disconformities = new LinkedList();
            disconformityText = new LinkedList();
            this.getDisconformityPaths(g, x, y, p, mode, disconformities, disconformityText);
            if (disconformities.isEmpty()) {
                disconformities = null;
            }
            if (disconformityText.isEmpty()) {
                disconformityText = null;
            }
        }
        float xpos = x;
        LinkedList<SBPanel> pipers = new LinkedList<SBPanel>();
        if (this.subBlockProperties != null && !this.subBlockProperties.isEmpty()) {
            for (SBPanel panel : this.getPanels()) {
                if (!panel.pipe()) {
                    float newxpos = panel.draw(g, xpos, y, p, this.prop, mode, cLines);
                    panel.drawFrame(g, xpos, y, p, (ChartBlock)this, panel.getTemplatedCaption(p, this.prop), panel.getTemplatedSubCaption(p));
                    panel.drawSubHeader(g, xpos, y, p, this.prop);
                    xpos = newxpos;
                    continue;
                }
                pipers.add(panel);
            }
            if (pipers.isEmpty()) {
                return xpos;
            }
            ScaleConverter sc = this.getScaleConverter(this.getWell());
            int i = 0;
            Float lastBase = null;
            for (SubBlockProperties bp : this.subBlockProperties) {
                float ypos = y;
                float scaledMin = i == 0 ? 0.0f : this.scaleMeasuredDepth(bp.getMin(), sc);
                float scaledMax = i == this.subBlockProperties.size() - 1 ? this.scale(this.prop.getMax(), this.prop.getScaleType(), sc) : this.scaleMeasuredDepth(bp.getMax(), sc);
                bp.setHeight(Math.abs(scaledMax - scaledMin));
                if (i > 0) {
                    ypos += Math.min(scaledMin, scaledMax);
                }
                float[] panelXPos = new float[pipers.size()];
                for (int j = 0; j < pipers.size(); ++j) {
                    SBPanel panel = (SBPanel)pipers.get(j);
                    panelXPos[j] = xpos;
                    if (!p.drawEmptyPanels && !panel.hasData(this.prop)) continue;
                    panel.drawBackground(g, xpos, y, p, bp, mode);
                    xpos += panel.getWidth(this.prop);
                }
                for (CorrelationType cType : cLines.keySet()) {
                    if (cLines.get(cType) == null) continue;
                    HashSet<CorrelationPoint> lines = new HashSet<CorrelationPoint>((Collection)cLines.get(cType));
                    Iterator it = lines.iterator();
                    while (it.hasNext()) {
                        CorrelationPoint point = (CorrelationPoint)it.next();
                        if (!(point.measuredDepth() < (double)bp.getMin()) && !(point.measuredDepth() > (double)bp.getMax())) continue;
                        it.remove();
                    }
                    if (lines.isEmpty()) continue;
                    int start = 0;
                    if (i >= pipers.size()) continue;
                    for (int j = 0; j < pipers.size(); ++j) {
                        if (!((SBPanel)pipers.get(j)).drawsLines(cType) && j != pipers.size() - 1) continue;
                        this.drawCorrelationLines(g, panelXPos[start], ((SBPanel)pipers.get(i)).drawsLines(cType) ? panelXPos[j] : xpos, y, p, mode, lines);
                        start = j + 1;
                    }
                }
                for (int k = 0; k < 2; ++k) {
                    block13: for (int j = 0; j < pipers.size(); ++j) {
                        SBPanel panel = (SBPanel)pipers.get(j);
                        if (!p.drawEmptyPanels && !panel.hasData(this.prop)) continue;
                        switch (k) {
                            case 0: {
                                panel.draw(g, panelXPos[j], y, p, bp, mode, cLines);
                                continue block13;
                            }
                            case 1: {
                                if (i == 0 && mode != Chart.Mode.NO_HEADER) {
                                    panel.drawFrame(g, panelXPos[j], ypos, p, (ChartBlock)this, (BlockProperties)bp, panel.getTemplatedCaption(p, this.prop), panel.getTemplatedSubCaption(p));
                                    panel.drawSubHeader(g, panelXPos[j], ypos, p, this.prop);
                                    continue block13;
                                }
                                panel.drawOutline(g, panelXPos[j], ypos, p, bp, mode);
                            }
                        }
                    }
                }
                if (i > 0) {
                    this.drawPipeArrows(bp, this.subBlockProperties.get(i - 1), p, mode, g, xpos, ypos, lastBase.floatValue());
                }
                xpos += 5.0f;
                lastBase = Float.valueOf(ypos + bp.getHeight());
                ++i;
            }
        } else {
            xpos = this.drawPanels(g, xpos, y, p, mode, cLines, vMode);
        }
        if (disconformities != null) {
            if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
                g.clearClip();
            }
            g.setColor(p.foreground);
            g.setStroke(0.8f);
            for (GeneralPath path : disconformities) {
                g.drawShape(path);
            }
        }
        if (disconformityText != null) {
            g.setFont(p.font, 1, p.getFontSizePanel());
            for (DisconformityText t : disconformityText) {
                g.drawStringBox(t.text, (float)t.area.getX(), (float)t.area.getY(), (float)t.area.getWidth(), (float)t.area.getHeight(), false);
            }
        }
        return xpos;
    }

    private void drawPipeArrows(SubBlockProperties bp, SubBlockProperties lastProp, ChartProperties p, Chart.Mode mode, SBGraphics g, float xpos, float ypos, float lastBase) {
        float[] arrowY;
        if (this.getSubBlockWidth(false, p) <= 0.0f) {
            return;
        }
        if ((double)Math.abs(bp.getMin() - lastProp.getMax()) > 0.1) {
            return;
        }
        g.setStroke(0.2f);
        g.setColor(p.foreground);
        float x1 = xpos - this.getSubBlockWidth(false, p) * 1.5f - 5.0f;
        float x2 = xpos - this.getSubBlockWidth(false, p) / 2.0f;
        float[] arrowX = new float[]{x2, x2 + 2.5f, x2 - 2.5f};
        if (bp.normal ^ lastProp.normal) {
            float y2;
            float y1;
            boolean up = lastProp.normal;
            if (up) {
                y1 = ypos + bp.getHeight() + this.getPanelHeaderHeight(p, mode);
                y2 = y1 + 10.0f;
                arrowY = new float[]{y1, y1 + 3.0f, y1 + 3.0f};
            } else {
                y1 = ypos + this.getPanelHeaderHeight(p, mode);
                y2 = y1 - 10.0f;
                arrowY = new float[]{y1, y1 - 3.0f, y1 - 3.0f};
            }
            g.drawLine(x1, y1, x1, y2);
            g.drawLine(x1, y2, x2, y2);
            g.drawLine(x2, y2, x2, y1);
        } else {
            float y1 = lastBase + p.getPanelHeaderHeight();
            float y2 = y1 + 10.0f;
            g.drawLine(x1, y1, x1, y2);
            g.drawLine(x1, y2, x1 + (x2 - x1) / 2.0f, y2);
            float y3 = ypos + this.getPanelHeaderHeight(p, mode) - 10.0f;
            float y4 = y3 + 10.0f;
            g.drawLine(x1 + (x2 - x1) / 2.0f, y2, x1 + (x2 - x1) / 2.0f, y3);
            g.drawLine(x1 + (x2 - x1) / 2.0f, y3, x2, y3);
            g.drawLine(x2, y3, x2, y4);
            arrowY = new float[]{y4, y4 - 3.0f, y4 - 3.0f};
        }
        g.fillPolygon(arrowX, arrowY, 3);
    }

    private void setSubBlocks() {
        double[][] reversals;
        this.subBlockProperties = null;
        switch (this.prop.scaleType) {
            default: {
                return;
            }
            case AGE: {
                if (this.getInterp() == null || this.getInterp().getLOC() == null) {
                    return;
                }
                reversals = this.getInterp().getLOC().getReversals();
                break;
            }
            case TVD: {
                if (this.getTVDList() == null) {
                    return;
                }
                reversals = this.getTVDList().getReversals();
            }
        }
        if (reversals != null) {
            ScaleConverter sc = this.getScaleConverter(this.getWell());
            this.subBlockProperties = new LinkedList();
            double minMD = sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN).orElse(0.0);
            double maxMD = sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MAX).orElse(0.0);
            for (double[] rev : reversals) {
                if (rev[1] < minMD || rev[0] > maxMD) continue;
                if (Math.abs(minMD - rev[0]) > 0.01) {
                    this.subBlockProperties.add(new SubBlockProperties((float)minMD, (float)rev[0], true));
                }
                if (Math.abs(rev[0] - rev[1]) > 0.01) {
                    this.subBlockProperties.add(new SubBlockProperties((float)rev[0], (float)rev[1], false));
                }
                minMD = (float)rev[1];
            }
            if (Math.abs(minMD - maxMD) > 0.001) {
                this.subBlockProperties.add(new SubBlockProperties((float)minMD, (float)maxMD, true));
            }
            LinkedList<SubBlockProperties> newProp = new LinkedList<SubBlockProperties>();
            for (SubBlockProperties sbp : this.subBlockProperties) {
                float convertedSbpMax;
                float convertedSbpMin = (float)sc.convertAndTrimMeasuredDepth(sbp.getMin());
                if ((double)Math.abs(convertedSbpMin - (convertedSbpMax = (float)sc.convertAndTrimMeasuredDepth(sbp.getMax()))) < 0.01) continue;
                if ((double)Math.abs(convertedSbpMin - this.prop.getMin()) < 0.001) {
                    sbp.setMin(sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN).orElse(0.0).floatValue());
                } else if ((double)Math.abs(convertedSbpMin - this.prop.getMax()) < 0.001) {
                    sbp.setMin(sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MAX).orElse(0.0).floatValue());
                }
                if ((double)Math.abs(convertedSbpMax - this.prop.getMin()) < 0.001) {
                    sbp.setMax(sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN).orElse(0.0).floatValue());
                } else if ((double)Math.abs(convertedSbpMax - this.prop.getMax()) < 0.001) {
                    sbp.setMax(sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MAX).orElse(0.0).floatValue());
                }
                if (sbp.getMin() > sbp.getMax()) {
                    LOGGER.log(Level.WARNING, "FOR: " + String.valueOf(this.getWell()) + " min is " + sbp.getMin() + " max is " + sbp.getMax());
                }
                newProp.add(sbp);
            }
            this.subBlockProperties = newProp;
        } else {
            this.subBlockProperties = null;
        }
    }

    @Override
    public String getDefaultCaption(ChartProperties p) {
        if (this.getWell() != null) {
            Object blockCaption = p.blockCapWellNameDisplay != null && p.blockCapWellNameDisplay == PanelWellHeader.WellNameDisplay.ALTERNATIVE && StringUtils.isNotBlank((CharSequence)this.getWell().getHeader().getWellAltName()) ? this.getWell().getHeader().getWellAltName() : this.getWell().getWellName();
            if (p.blockCapWellNameDisplay != null && p.blockCapWellNameDisplay == PanelWellHeader.WellNameDisplay.CONCAT && StringUtils.isNotBlank((CharSequence)this.getWell().getHeader().getWellAltName())) {
                blockCaption = (String)blockCaption + "  " + this.getWell().getHeader().getWellAltName();
            }
            return blockCaption;
        }
        return CaptionTemplate.WELLNAME.toDisplayString();
    }

    private LinkedList[] setDisconformityClip(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode mode) {
        if (this.getInterp() == null || this.getInterp().getLOC() == null) {
            return null;
        }
        assert (this.prop.scaleType == BlockProperties.ScaleType.AGE);
        LinkedList<GeneralPath> disconformities = null;
        LinkedList<DisconformityText> disconformityTexts = null;
        LOC.Disconformity[] discnfs = this.getInterp().getLOC().getDisconformities();
        if (discnfs != null) {
            disconformities = new LinkedList<GeneralPath>();
            disconformityTexts = new LinkedList<DisconformityText>();
            try {
                float x1 = x - 1.0f;
                GeneralPath path = null;
                for (LOC.Disconformity u : discnfs) {
                    float y2;
                    float y1;
                    float x2;
                    int i;
                    double[] d = u.getAges();
                    if (d[1] < (double)this.prop.getMin() || d[0] > (double)this.prop.getMax()) continue;
                    float uDepth = (float)u.getDepth();
                    boolean foundSubBlock = true;
                    if (this.subBlockProperties != null && !this.subBlockProperties.isEmpty()) {
                        foundSubBlock = false;
                        for (i = 0; i < this.subBlockProperties.size(); ++i) {
                            SubBlockProperties sbp = this.subBlockProperties.get(i);
                            if (sbp.normal != u.getNormal() || !(uDepth >= sbp.getMin()) || !(uDepth <= sbp.getMax())) continue;
                            x1 = x + (float)i * this.getSubBlockWidth(false, p) + (float)i * 5.0f - 1.0f;
                            foundSubBlock = true;
                            break;
                        }
                    }
                    if (!foundSubBlock) {
                        for (i = 0; i < this.subBlockProperties.size(); ++i) {
                            if (!((double)Math.abs(uDepth - this.subBlockProperties.get(i).getMax()) < 0.1)) continue;
                            x1 += (float)i * this.getSubBlockWidth(false, p) + (float)i * 5.0f - 1.0f;
                            break;
                        }
                        x2 = x1 + this.getSubBlockWidth(false, p) + 2.0f;
                        float x3 = x2 + 5.0f - 2.0f;
                        float x4 = x3 + this.getSubBlockWidth(false, p) + 2.0f;
                        if (u.getNormal()) {
                            y1 = this.prop.scaleAge((float)d[0]) + y + this.getPanelHeaderHeight(p, mode);
                            y2 = this.prop.scaleAge((float)d[1]) + y + this.getPanelHeaderHeight(p, mode);
                        } else {
                            y2 = this.prop.scaleAge((float)d[0]) + y + this.getPanelHeaderHeight(p, mode);
                            y1 = this.prop.scaleAge((float)d[1]) + y + this.getPanelHeaderHeight(p, mode);
                        }
                        GeneralPath gp = SBGraphics.createGeneralPath(x1, y1);
                        if (IGDIntervalZone.isUnconformableBnd((int)u.getBnd())) {
                            g.appendUnconf(gp, x1, x2, y1, false, true, true, false);
                        } else {
                            SBGraphics.appendLine(gp, x2, y1);
                        }
                        disconformities.add(gp);
                        gp = SBGraphics.createGeneralPath(x4, y2);
                        if (IGDIntervalZone.isUnconformableBnd((int)u.getBnd())) {
                            g.appendUnconf(gp, x4, x3, y2, false, true, true, false);
                        } else {
                            SBGraphics.appendLine(gp, x3, y2);
                        }
                        disconformities.add(gp);
                        continue;
                    }
                    x2 = x1 + this.getSubBlockWidth(true, p) + 2.0f;
                    y1 = this.prop.scaleAge((float)Math.max(d[0], (double)this.prop.getMin())) + y + this.getPanelHeaderHeight(p, mode);
                    y2 = this.prop.scaleAge((float)d[1]) + y + this.getPanelHeaderHeight(p, mode);
                    if (path == null) {
                        path = SBGraphics.createGeneralPath(x1, y1);
                    } else {
                        SBGraphics.appendMove(path, x1, y1);
                    }
                    GeneralPath gp = SBGraphics.createGeneralPath(x1, y1);
                    if (IGDIntervalZone.isUnconformableBnd((int)u.getBnd()) && !(d[0] < (double)this.prop.getMin())) {
                        SBGraphics.appendLine(path, x2, y1);
                        g.appendUnconf(gp, x1, x2, y1, false, true, true, false);
                    } else {
                        SBGraphics.appendLine(path, x2, y1);
                        SBGraphics.appendLine(gp, x2, y1);
                    }
                    disconformities.add(gp);
                    SBGraphics.appendLine(path, x2, y2);
                    gp = SBGraphics.createGeneralPath(x2, y2);
                    if (IGDIntervalZone.isUnconformableBnd((int)u.getBnd())) {
                        SBGraphics.appendLine(path, x1, y2);
                        g.appendUnconf(gp, x2, x1, y2, false, true, true, false);
                    } else {
                        SBGraphics.appendLine(path, x1, y2);
                        SBGraphics.appendLine(gp, x1, y2);
                    }
                    if (y2 <= y + this.getPanelHeaderHeight(p, mode) + this.getHeight()) {
                        disconformities.add(gp);
                    }
                    SBGraphics.appendLine(path, x1, y1);
                    if (!p.drawDisconfDuration && u.getBnd() != 5) continue;
                    DisconformityText dt = new DisconformityText();
                    double length = Math.abs(d[0] - d[1]);
                    dt.text = (u.getBnd() == 5 ? "? " : "") + (String)(p.drawDisconfDuration ? SB.round((double)length, (int)2) + " Ma" : "");
                    dt.area = new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1);
                    disconformityTexts.add(dt);
                }
                if (path != null) {
                    Area unconfArea = new Area(path);
                    Area outside = g.getVisibleRect() != null ? new Area(g.getVisibleRect()) : new Area(g.createRect(x - 1.0f, y - 1.0f, this.getWidth(p) + 3.0f, this.getHeight() + this.getPanelHeaderHeight(p, mode) + 2.0f));
                    outside.subtract(unconfArea);
                    g.setClip(outside);
                }
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error setting unconformities", (Throwable)e);
            }
        }
        return new LinkedList[]{disconformities, disconformityTexts};
    }

    private void getDisconformityPaths(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode mode, List<GeneralPath> disconformities, List<DisconformityText> disconformityText) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE || this.subBlockProperties != null && this.subBlockProperties.isEmpty()) {
            return;
        }
        if (this.getInterp() == null || this.getInterp().getLOC() == null) {
            return;
        }
        LOC.Disconformity[] discnfs = this.getInterp().getLOC().getDisconformities();
        if (discnfs != null) {
            float x1 = x - 1.0f;
            float x2 = x + this.getWidth(p) + 1.0f;
            try {
                for (LOC.Disconformity u : discnfs) {
                    float md = (float)u.getDepth();
                    if (md < this.getMDLimit(true) || md > this.getMDLimit(false)) continue;
                    float ypos = this.scaleDepth(md) + y + this.getPanelHeaderHeight(p, mode);
                    GeneralPath gp = SBGraphics.createGeneralPath(x1, ypos);
                    if (IGDIntervalZone.isUnconformableBnd((int)u.getBnd())) {
                        g.appendUnconf(gp, x1, x2, ypos, u.getBnd() == 5, true, true, true);
                    } else {
                        SBGraphics.appendLine(gp, x2, ypos);
                    }
                    disconformities.add(gp);
                    if (!IGDIntervalZone.isQuestionableBnd((int)u.getBnd())) continue;
                    DisconformityText t = new DisconformityText();
                    float textRectHeight = p.getFontSizePanel() * 1.5f;
                    t.text = "?";
                    t.area = new Rectangle2D.Float(x1, ypos - textRectHeight, x2 - x1, textRectHeight);
                    disconformityText.add(t);
                }
            }
            catch (RuntimeException re) {
                re.printStackTrace();
            }
        }
    }

    private double[][] getDataSections() {
        if (this.prop.scaleType == BlockProperties.ScaleType.MD || this.prop.scaleType == BlockProperties.ScaleType.SUBSIDENCE || this.getWell() == null || this.getWells().size() != 1) {
            this.subBlockProperties = null;
            return null;
        }
        this.setSubBlocks();
        LOC.Disconformity[] discnfs = null;
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            if (this.getInterp().getLOC() == null) {
                return null;
            }
            discnfs = this.getInterp().getLOC().getDisconformities();
        }
        if ((this.subBlockProperties == null || this.subBlockProperties.isEmpty()) && discnfs == null) {
            return null;
        }
        LinkedList<SubBlockProperties> sbp = this.subBlockProperties;
        if (sbp == null || sbp.isEmpty()) {
            sbp = new LinkedList();
            sbp.add(new SubBlockProperties(this.getTopDepth(), this.getBaseDepth(), true));
        }
        LinkedList<double[]> sections = new LinkedList<double[]>();
        for (int j = 0; j < sbp.size(); ++j) {
            SubBlockProperties p = sbp.get(j);
            if (j == 0) {
                if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
                    sections.add(new double[]{this.prop.scaleAge((float)this.getInterp().getLOC().getAge(p.getMin(), !p.normal)), p.getMin()});
                } else {
                    sections.add(new double[]{this.scaleDepth(p.getMin()), p.getMin()});
                }
            } else if (this.prop.scaleType == BlockProperties.ScaleType.AGE && p.normal && sbp.get((int)(j - 1)).normal) {
                sections.add(new double[]{this.prop.scaleAge((float)this.getInterp().getLOC().getAge(p.getMin(), p.normal)), p.getMin()});
            }
            if (discnfs != null) {
                for (LOC.Disconformity u : discnfs) {
                    if (u.getNormal() != p.normal) continue;
                    if (u.getDepth() > (double)p.getMax()) break;
                    if (!(u.getDepth() >= (double)p.getMin()) || !(u.getDepth() <= (double)p.getMax())) continue;
                    if (u.getNormal()) {
                        sections.add(new double[]{this.prop.scaleAge((float)u.getAges()[0]), u.getDepth()});
                        sections.add(new double[]{this.prop.scaleAge((float)u.getAges()[1]), u.getDepth()});
                        continue;
                    }
                    sections.add(new double[]{this.prop.scaleAge((float)u.getAges()[1]), u.getDepth()});
                    sections.add(new double[]{this.prop.scaleAge((float)u.getAges()[0]), u.getDepth()});
                }
            }
            if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
                sections.add(new double[]{this.prop.scaleAge((float)this.getInterp().getLOC().getAge(p.getMax(), !p.normal)), p.getMax()});
                continue;
            }
            sections.add(new double[]{this.scaleDepth(p.getMax()), p.getMax()});
        }
        double[][] sectionArr = new double[sections.size()][];
        for (int i = 0; i < sections.size(); ++i) {
            sectionArr[i] = (double[])sections.get(i);
        }
        return sectionArr;
    }

    @Override
    public synchronized void setData(ChartProperties cp) throws SBException, SQLException, IOException {
        if (this.getWell() != null) {
            for (SBPanel panel : this.getPanels()) {
                if (panel instanceof PanelBiozones) break;
            }
        }
        double[][] sections = this.getDataSections();
        for (SBPanel panel : this.getPanels()) {
            panel.setData(cp, sections);
        }
        this.setDataIntervals(cp, sections);
    }

    @Override
    public void setData(ChartEvent e, ChartUpdate update) throws SBException, SQLException, IOException {
        if (e.getArg() == IGDInterval.class) {
            this.setDataIntervals(update.getChartProperties(), update.getDataSections());
            return;
        }
        super.setData(e, update);
        this.setDataIntervals(update.getChartProperties(), update.getDataSections());
    }

    synchronized void setDataIntervals(ChartProperties cp) throws SQLException, SBException {
        this.setDataIntervals(cp, this.getDataSections());
    }

    private float getSubBlockWidth(boolean includeNonPipers, ChartProperties cp) {
        float width = 0.0f;
        ChartPanel lastPlottedPanel = null;
        for (SBPanel panel : this.getPanels()) {
            float panelWidth;
            if (!includeNonPipers && !panel.pipe()) continue;
            List<SBPanel> overplotPanels = panel.getOverplotPanels(cp);
            if (!cp.drawEmptyPanels && !panel.hasData(this.prop) && overplotPanels.isEmpty() || panel.isOverplot() || cp.hideAdjacentBlankPanels && panel.getPanelType() == PanelType.BLANK && lastPlottedPanel != null && lastPlottedPanel.getPanelType() == PanelType.BLANK || (panelWidth = panel.getWidth(this.prop, cp.drawEmptyPanels)) < 1.0f) continue;
            width += panelWidth;
            lastPlottedPanel = panel;
        }
        if (lastPlottedPanel != null && lastPlottedPanel.getPanelType() == PanelType.BLANK) {
            width -= ((SBPanel)lastPlottedPanel).getWidth(this.prop);
        }
        return width;
    }

    @Override
    public float getWidth(ChartProperties cp) {
        float width = this.getSubBlockWidth(true, cp);
        if (this.subBlockProperties != null && this.getNPipers() > 0) {
            width = this.getSubBlockWidth(false, cp) * (float)this.subBlockProperties.size() + 5.0f * (float)(this.subBlockProperties.size() - 1);
            for (SBPanel p : this.getPanels()) {
                if (p.pipe()) continue;
                width += p.getWidth(this.prop, cp.drawEmptyPanels);
            }
        }
        return width;
    }

    private int getNPipers() {
        int pipers = 0;
        for (SBPanel p : this.getPanels()) {
            if (!p.pipe()) continue;
            ++pipers;
        }
        return pipers;
    }

    @Override
    public void prepareData(ChartUpdate update) {
        update.setDataSections(this.getDataSections());
    }

    public ScaleConverter getScaleConverter() {
        return super.getScaleConverter(this.getWell());
    }

    public float scaleDepth(float depth) {
        return this.scaleDepth(depth, true);
    }

    public float scaleDepth(float depth, Well well) {
        return this.scaleDepth(depth, true, well);
    }

    public float scaleDepth(float depth, boolean minPrefered) {
        return this.scaleDepth(depth, minPrefered, this.getWell());
    }

    float scaleDepth(float depth, boolean minPrefered, Well well) {
        switch (this.prop.scaleType) {
            case AGE: {
                if (this.getInterp(well) != null && this.getInterp(well).getLOC() != null) {
                    float age = (float)this.getInterp(well).getLOC().getAge(depth, minPrefered);
                    return this.prop.scaleAge(age);
                }
                return 0.0f;
            }
            case TVD: {
                try {
                    if (well == null || well.getTVDlist(false) == null) break;
                    depth = well.getTVDlist(false).getTVDwithExtrapolation((double)depth).getTVDepth().floatValue();
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
                break;
            }
            case SUBSIDENCE: {
                try {
                    Double depthAsTVD;
                    LOC loc;
                    if (well != null && well.getTVDlist(false) != null) {
                        depth = well.getTVDlist(false).getTVDwithExtrapolation((double)depth).getTVDepth().floatValue();
                    }
                    if (this.getInterp(well) == null || (loc = this.getInterp(well).getLOC()) == null) break;
                    float maxLOCDepth = (float)loc.getMaxDepth();
                    TVDList tvdList = well.getTVDlist(false);
                    if (tvdList != null && (depthAsTVD = tvdList.getTVDwithExtrapolation((double)maxLOCDepth).getTVDepth()) != null) {
                        maxLOCDepth = depthAsTVD.floatValue();
                    }
                    if (!(this.prop.getMax() > maxLOCDepth)) break;
                    float shift = this.prop.getMax() - maxLOCDepth;
                    depth += shift;
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
                break;
            }
            case TWT: {
                try {
                    if (well == null || well.getTWTlist() == null) break;
                    depth = (float)well.getTWTlist().getTWT((double)depth).getTWT();
                    break;
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        }
        return this.prop.scaleDepth(depth);
    }

    public float scaleTVD(double depth) {
        return this.prop.scaleDepth((float)depth);
    }

    public float getDepth(float yPos) {
        return this.getDepth(yPos, null);
    }

    public float getDepth(float yPos, BlockProperties sbp) {
        TVDepth depth;
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            if (!(sbp instanceof SubBlockProperties)) {
                sbp = null;
            }
            float age = this.prop.getAge(yPos);
            LOC loc = this.getInterp().getLOC();
            if (loc == null) {
                return 0.0f;
            }
            return (float)loc.getDepth((double)age, sbp != null ? Double.valueOf(sbp.getMin()) : null, sbp != null ? Double.valueOf(sbp.getMax()) : null, true);
        }
        if (this.prop.scaleType == BlockProperties.ScaleType.TVD && sbp instanceof SubBlockProperties && this.getTVDList() != null && (depth = this.getTVDList().getDepth((double)this.prop.getDepth(yPos), true, Double.valueOf(Float.valueOf(sbp.getMin()).doubleValue()), Double.valueOf(Float.valueOf(sbp.getMax()).doubleValue()))) != null) {
            return (float)depth.getDDepth();
        }
        float depth2 = this.prop.getDepth(yPos);
        return Float.isNaN(depth2) ? -1.0f : depth2;
    }

    public float getBracket(float bracketBase, float zoom, float depth) {
        Float scale = null;
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            if (this.prop.getnScaleSections() > 1) {
                scale = this.prop.getScale(this.getAge(depth, true));
            }
            if (scale == null) {
                scale = Float.valueOf(this.prop.getScale(this.prop.getLongestSection()));
            }
            float ma = bracketBase / scale.floatValue() / zoom;
            return ma * Math.abs(this.getInterp().getLOC().getSedimentationRate((double)depth));
        }
        scale = this.prop.getScale(depth);
        return bracketBase * (scale != null ? scale.floatValue() : this.prop.getScale(this.prop.getLongestSection())) / 1000.0f / zoom;
    }

    @Override
    public synchronized ChartPanel getPanel(float x, float y, ChartProperties cp) {
        PanelData panelData = this.getPanelData(x, y, cp);
        if (panelData != null) {
            return panelData.panel;
        }
        return null;
    }

    @Override
    public Point2D.Float getPanelOrigin(SBPanel panel, float x, float y, Chart.Mode mode, float xPos, ChartProperties cp) {
        PanelData panelData = this.getPanelData(xPos - x, y, cp);
        if (panelData != null && panelData.panel == panel) {
            return new Point2D.Float(x + panelData.xOrigin, y);
        }
        return null;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, float zoom) {
        PanelData panelData = this.getPanelData(x, y, cp);
        if (panelData != null) {
            return panelData.panel.getObject(x - panelData.xOrigin, y, cp, panelData.sbp != null ? panelData.sbp : this.prop, zoom);
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, float zoom) {
        PanelData panelData = this.getPanelData(x, y, cp);
        if (panelData != null) {
            return panelData.panel.getTooltip(x - panelData.xOrigin, y, cp, panelData.sbp != null ? panelData.sbp : this.prop, zoom);
        }
        return null;
    }

    private PanelData getPanelData(float x, float y, ChartProperties cp) {
        AbstractList panelOrder;
        float xLeft = 0.0f;
        SubBlockProperties sbp = null;
        if (this.subBlockProperties != null && this.subBlockProperties.size() > 1) {
            int n = 0;
            while (true) {
                boolean bl = n == 0;
                if (!(x > xLeft + this.getSubBlockWidth(bl, cp))) break;
                if (x < (xLeft += this.getSubBlockWidth(n == 0, cp)) + 5.0f) {
                    return null;
                }
                xLeft += 5.0f;
                ++n;
            }
            sbp = this.subBlockProperties.get(n);
        }
        if (sbp != null && sbp == this.subBlockProperties.get(0)) {
            panelOrder = new ArrayList();
            for (int i = 0; i < 2; ++i) {
                for (SBPanel p : this.getPanels()) {
                    if ((i != 0 || p.pipe()) && (i != 1 || !p.pipe())) continue;
                    panelOrder.add(p);
                }
            }
        } else {
            panelOrder = this.panels;
        }
        for (SBPanel panel : panelOrder) {
            if (sbp != null && sbp != this.subBlockProperties.get(0) && !panel.pipe() || !cp.drawEmptyPanels && !panel.hasData(this.prop) || panel.isOverplot()) continue;
            float xRight = xLeft + panel.getWidth(this.prop);
            if (x < xRight) {
                return new PanelData(panel, sbp, xLeft);
            }
            xLeft = xRight;
        }
        return null;
    }

    @Override
    public SBPanel createPanel(PanelTemplate panelTemplate, PanelOcc po) throws SQLException, SBException {
        if (panelTemplate.getType().isInterpPanel() && this.getWell() != null) {
            this.getWell().loadInterps();
            WellInterp wellInterp = this.getWell().getAddInterp(this.getDb().getInterp(po.getInterpID() != null ? po.getInterpID().intValue() : this.getInterpID()));
            this.getWell().loadInterp(wellInterp);
        }
        return super.createPanel(panelTemplate, po);
    }

    @Override
    public void update(Observable o, Object arg) {
        try {
            if (o instanceof WellInterp) {
                if (o == this.getInterp()) {
                    if (arg instanceof Integer) {
                        IGDIntervalZone zone;
                        Integer i = (Integer)arg;
                        if ((i == 3 || i == 4 || i == 2) && this.intervals != null && !this.intervals.isEmpty() && arg.equals((zone = (IGDIntervalZone)this.intervals.getFirst().getObject()).getIGDType())) {
                            this.setDataChanged(IGDIntervalZone.class);
                        }
                    } else if (arg instanceof IGDIntervalZone) {
                        IGDIntervalZone argZ = (IGDIntervalZone)arg;
                        if (this.intervals != null && !this.intervals.isEmpty()) {
                            IGDIntervalZone zone = (IGDIntervalZone)this.intervals.getFirst().getObject();
                            if (argZ.getIGDType() == zone.getIGDType()) {
                                this.setDataChanged(IGDIntervalZone.class);
                            }
                        }
                    }
                    this.notifyListeners();
                    return;
                }
                ((WellInterp)o).deleteWeakObserver((Observer)this);
            }
            if (o == this.getWell()) {
                if (arg instanceof LithBase) {
                    return;
                }
                if (arg instanceof Sample || arg == Sample.class) {
                    this.setDataChanged();
                    this.notifyListeners();
                    return;
                }
                if (arg instanceof Smpdtl || arg == Smpdtl.class) {
                    this.setDataChanged();
                    this.notifyListeners();
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.update(o, arg);
    }

    public float getTopDepth() {
        return this.getTopDepth(true, this.getWell());
    }

    public float getTopDepth(int wellID) {
        return this.getTopDepth(true, this.getWell(wellID));
    }

    private float getTopDepth(boolean first, Well well) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            if (this.getInterp(well).getLOC() == null) {
                return 0.0f;
            }
            if ((double)this.prop.getMin() < this.getInterp(well).getLOC().getMinAge()) {
                return (float)this.getInterp(well).getLOC().getMinDepth();
            }
            return (float)this.getInterp(well).getLOC().getDepth((double)this.prop.getMin(), null, null, first);
        }
        if (this.prop.scaleType == BlockProperties.ScaleType.TVD && this.getTVDList(well) != null) {
            TVDepth d = this.getTVDList(well).getDepthWithExtrapolation((double)this.prop.getMin(), first);
            if (d != null) {
                return (float)d.getDDepth();
            }
            try {
                return this.prop.getMin();
            }
            catch (Exception e) {
                StackError.showStackError(null, (Throwable)e);
            }
        } else if (this.prop.scaleType == BlockProperties.ScaleType.TWT && this.getTWTList(well) != null) {
            TWTDepth[] d = this.getTWTList(well).getDepths((double)this.prop.getMin());
            if (d != null && d.length > 0) {
                return (float)d[0].getDepth();
            }
            try {
                return (float)well.getTWTlist().getTopDD();
            }
            catch (Exception e) {
                StackError.showStackError(null, (Throwable)e);
            }
        }
        return this.prop.getMin();
    }

    public void setTopDepth(float topDepth) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            throw new UnsupportedOperationException("Attempt to set wellBlock topDepth in age scale");
        }
        this.prop.setMin(topDepth);
    }

    public float getBaseDepth() {
        return this.getBaseDepth(this.subBlockProperties != null && this.subBlockProperties.size() == 1, this.getWell());
    }

    public float getBaseDepth(int wellID) {
        return this.getBaseDepth(this.subBlockProperties != null && this.subBlockProperties.size() == 1, this.getWell(wellID));
    }

    public Well getWell(int wellID) {
        for (Well w : this.getWells()) {
            if (w.getWellID() != wellID) continue;
            return w;
        }
        return null;
    }

    private float getBaseDepth(boolean first, Well well) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            if (this.getInterp(well) == null || this.getInterp(well).getLOC() == null) {
                return 0.0f;
            }
            float depth = (float)this.getInterp(well).getLOC().getDepth((double)this.prop.getMax(), null, null, first);
            if (depth < 0.0f) {
                depth = (float)this.getInterp(well).getLOC().getMaxDepth();
            }
            return depth;
        }
        if (this.prop.scaleType == BlockProperties.ScaleType.TVD && this.getTVDList(well) != null) {
            TVDepth depth;
            if (this.getTVDList() != null && (depth = this.getTVDList().getDepthWithExtrapolation((double)this.prop.getMax(), first)) != null) {
                return (float)depth.getDDepth();
            }
            try {
                if (well.getTVDlist(false) != null) {
                    return (float)well.getTVDlist(false).getBaseDD();
                }
            }
            catch (Exception e) {
                StackError.showStackError(null, (Throwable)e);
            }
        } else if (this.prop.scaleType == BlockProperties.ScaleType.TWT && this.getTWTList(well) != null) {
            TWTDepth[] d = this.getTWTList(well).getDepths((double)this.prop.getMax());
            if (d != null && d.length > 0) {
                return (float)d[0].getDepth();
            }
            try {
                return (float)well.getTWTlist().getBaseDD();
            }
            catch (Exception e) {
                StackError.showStackError(null, (Throwable)e);
            }
        }
        return this.prop.getMax();
    }

    public void setBaseDepth(float baseDepth) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            this.prop.setMax((float)this.getInterp().getLOC().getMaxAge(Double.valueOf(baseDepth)));
            if ((double)this.prop.getMax() > this.getInterp().getLOC().getMaxAge()) {
                this.prop.setMax((float)this.getInterp().getLOC().getMaxAge());
            }
            return;
        }
        this.prop.setMax(baseDepth);
    }

    float getAge(float depth, boolean minPref) {
        return (float)this.getInterp().getLOC().getAge(depth, minPref);
    }

    @Override
    public void setWell(Well well) {
        if (well == null) {
            this.subBlockProperties = null;
        }
        if (this.getInterp() != null) {
            this.getInterp().deleteWeakObserver((Observer)this);
        }
        super.setWell(well);
        if (this.getInterp() != null) {
            this.getInterp().addWeakObserver((Observer)this);
        }
    }

    public char getWellType() {
        if (this.getWell() == null) {
            return 'W';
        }
        return this.getWell().getType();
    }

    public void writeHTML(FileWriter out, ChartProperties cp) throws IOException, SBException {
        Object row;
        LinkedList<SBPanelHTML> outPanels = new LinkedList<SBPanelHTML>();
        for (SBPanel panel : this.getPanels()) {
            if (!(panel instanceof SBPanelHTML)) continue;
            outPanels.add((SBPanelHTML)panel);
        }
        LinkedList<Sample> samples = new LinkedList<Sample>();
        Iterator it = outPanels.iterator();
        while (it.hasNext()) {
            SBPanelHTML panel = (SBPanelHTML)it.next();
            int nSamples = panel.addSamples(samples, cp);
            if (nSamples >= 1) continue;
            it.remove();
        }
        if (samples.isEmpty()) {
            throw new SBException("No data to export");
        }
        out.write("<head>\n");
        out.write("<style type=\"text/css\"> table.SBTable {font-family:" + cp.font + "; border-collapse:collapse; }table.SBTable td,th { border:1px solid black; }</style>");
        out.write("\n</head>\n\n");
        out.write("<body>\n");
        out.write("<table class=\"SBTable\">\n");
        for (int j = 0; j < 2; ++j) {
            row = "<tr>";
            for (SBPanelHTML p : outPanels) {
                switch (j) {
                    case 0: {
                        row = (String)row + p.getCaptionString();
                        break;
                    }
                    case 1: {
                        row = (String)row + p.getSubHeaderString();
                    }
                }
            }
            row = (String)row + "</tr>\n";
            out.write((String)row);
        }
        for (int i = 0; i < samples.size(); ++i) {
            row = "<tr>";
            for (SBPanelHTML p : outPanels) {
                row = (String)row + p.getRowString(samples, i, cp);
            }
            row = (String)row + "</tr>\n";
            out.write((String)row);
        }
        out.write("</table>\n");
        out.write("</body>");
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.WELL;
    }

    public InterpHdr getVersion(int interpID) {
        try {
            return this.getDb().getInterp(interpID);
        }
        catch (SQLException sql) {
            return null;
        }
    }

    private void setTemplateSamples() throws SBException, SQLException {
        LinkedList<Sample> tempList = new LinkedList<Sample>();
        boolean sampleTops = this.getDb().useSampleTops();
        Sample cutting = new Sample(this.getDb(), 'W', Double.valueOf(10.0), Double.valueOf(20.0), SampleType.CU, "cutting", new SampleLithologyUnit[]{new SampleLithologyUnit(this.getDb().getLithdesc().getLithology(1064), 100)});
        tempList.add(cutting);
        tempList.add(new Sample(this.getDb(), 'W', sampleTops ? Double.valueOf(35.0) : null, sampleTops ? null : Double.valueOf(35.0), SampleType.CO, "core", new SampleLithologyUnit[]{new SampleLithologyUnit(this.getDb().getLithdesc().getLithology(1064), 50), new SampleLithologyUnit(this.getDb().getLithdesc().getLithology(1000), 50)}));
        tempList.add(new Sample(this.getDb(), 'W', sampleTops ? Double.valueOf(40.0) : null, sampleTops ? null : Double.valueOf(40.0), SampleType.SC, "sidewall core", new SampleLithologyUnit[]{new SampleLithologyUnit(this.getDb().getLithdesc().getLithology(1000), 100)}));
        tempList.add(new Sample(this.getDb(), 'W', Double.valueOf(50.0), Double.valueOf(60.0), SampleType.OC, "outcrop", (SampleLithologyUnit[])null));
        tempList.add(new Sample(this.getDb(), 'W', sampleTops ? Double.valueOf(85.0) : null, sampleTops ? null : Double.valueOf(85.0), SampleType.LOG, "log", (SampleLithologyUnit[])null));
        this.templateSamples = tempList;
    }

    public LinkedList<Sample> getTemplateSamples() {
        return this.templateSamples;
    }

    public static double getDefaultDepthBound(boolean isTop, double topDepth, double baseDepth, char units) {
        double depthRange = DepthUtils.convFromM((double)Math.abs(baseDepth - topDepth), (char)units);
        if (depthRange < (double)0.0029f) {
            return topDepth;
        }
        int log = (int)Math.log10(depthRange);
        double mult = Math.pow(10.0, log - 1);
        log *= 10;
        if (isTop) {
            return DepthUtils.convToM((double)((double)((int)(DepthUtils.convFromM((double)topDepth, (char)units) / mult)) * mult), (char)units);
        }
        return DepthUtils.convToM((double)(Math.ceil(DepthUtils.convFromM((double)baseDepth, (char)units) / mult) * mult), (char)units);
    }

    private boolean hasEventsPanel(int interpID) {
        for (SBPanel panel : this.getPanels()) {
            PanelEvents pEvents;
            if (!(panel instanceof PanelEvents) || (pEvents = (PanelEvents)panel).getInterpID(this) != interpID) continue;
            return true;
        }
        return false;
    }

    private boolean hasPicksPanel(int interpID) {
        for (SBPanel panel : this.getPanels()) {
            PanelSQPicks panelPicks;
            if (!(panel instanceof PanelSQPicks) || (panelPicks = (PanelSQPicks)panel).getInterpID(this) != interpID) continue;
            return true;
        }
        return false;
    }

    boolean hasZonesPanel(int igdType, int interpID, int schID) {
        for (SBPanel panel : this.getPanels()) {
            PanelZones panelZones;
            if (!(panel instanceof PanelZones) || (panelZones = (PanelZones)panel).getInterpID(this) != interpID || panelZones.getIGDType() != igdType) continue;
            if (panelZones instanceof PanelBiozones) {
                PanelBiozones panelBiozones = (PanelBiozones)panelZones;
                if (panelBiozones.getSchID() != 0 && panelBiozones.getSchID() != schID) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public Collection<CorrelationPoint> getYPos(final CorrelationLine line, boolean visibleOnly, boolean useBlockInterp, final ChartProperties cp, final int maxUnconfidence, final boolean correlateRangedIntervals) throws SQLException, SBException {
        WellInterp interp;
        block29: {
            if (this.getWell() == null || this.getWells().size() > 1) {
                return null;
            }
            if (visibleOnly && !this.hasPanel(line.getCorrelationType(), line.getInterpID(), line.getObject() instanceof IGDUnitBase ? ((IGDUnitBase)line.getObject()).getSchID() : 0)) {
                if (useBlockInterp) {
                    if (!this.hasPanel(line.getCorrelationType(), this.getInterpID(), line.getObject() instanceof IGDUnitBase ? ((IGDUnitBase)line.getObject()).getSchID() : 0)) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            this.getWell().loadInterps();
            interp = null;
            try {
                interp = this.getWell().getInterp(line.getInterpID());
            }
            catch (SBException e) {
                if (!useBlockInterp) {
                    return null;
                }
                if (this.getInterp() != null) break block29;
                return null;
            }
        }
        this.getWell().loadInterp(interp);
        if (useBlockInterp) {
            this.getWell().loadInterp(this.getInterp());
        }
        class DepthBndPair {
            final double depth;
            final Boundary bnd;
            final boolean isObserved;
            boolean scaleMinPreferred;

            DepthBndPair(WellBlock this$0, double depth, Boundary bnd, boolean isObserved) {
                Objects.requireNonNull(this$0);
                this.scaleMinPreferred = true;
                this.depth = depth;
                this.bnd = bnd;
                this.isObserved = isObserved;
            }
        }
        ArrayList<DepthBndPair> depths = new ArrayList<DepthBndPair>();
        Boundary bnd = line.getStyle().getBnd();
        switch (line.getCorrelationType()) {
            case EVENT: {
                EventLine eLine = (EventLine)line;
                if (useBlockInterp && (interp == null || interp != null && interp.getEvents().isEmpty())) {
                    interp = this.getInterp();
                }
                for (WellEvent e : interp.getEvents()) {
                    if (visibleOnly) {
                        boolean found = false;
                        for (SBPanel panel : this.getPanels()) {
                            if (!(panel instanceof PanelEvents)) continue;
                            PanelEventsProperties pEp = (PanelEventsProperties)panel.getProperties();
                            if (pEp.plotEventDisc(e.getDiscIDTaxon())) {
                                found = true;
                                break;
                            }
                            if (pEp.plotEventCategory(e.getEvent().getCatMnem())) {
                                found = true;
                                break;
                            }
                            if (pEp.plotEventType(e.getCharType())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                    if (e.getEvent() != eLine.getObject() || e.getTypeObj() != eLine.getEventType() || e.getConfidence().getDBint() > maxUnconfidence) continue;
                    depths.add(new DepthBndPair(this, this.getWell().getDepth(e.getSample(), cp.correctDepths, cp.correctCuttings), bnd == null ? e.getConfidenceAsBoundary() : null, true));
                }
                break;
            }
            case SURFACE: {
                if (useBlockInterp && (interp == null || interp != null && interp.getSQPicks().isEmpty())) {
                    interp = this.getInterp();
                }
                for (SQPick pick : interp.getSQPicks()) {
                    if (pick.getSurface() != line.getObject()) continue;
                    depths.add(new DepthBndPair(this, this.getWell().getDepth(pick.getSample(), cp.correctDepths, cp.correctCuttings), bnd == null ? Boundary.getBnd((int)pick.getBndInt()) : null, pick.isObserved()));
                }
                break;
            }
            case CHRONO: 
            case LITHO: 
            case BIOZONE: {
                IGDListSearcher searcher;
                DepthBndPair dbp;
                List<IGDIntervalZone> igdList = this.getYposIGDList(line, interp);
                if (useBlockInterp && (interp == null || interp != null && igdList.isEmpty())) {
                    igdList = this.getYposIGDList(line, this.getInterp());
                }
                class IGDListSearcher {
                    final /* synthetic */ WellBlock this$0;

                    IGDListSearcher() {
                        WellBlock wellBlock = this$0;
                        Objects.requireNonNull(wellBlock);
                        this.this$0 = wellBlock;
                    }

                    DepthBndPair searchList(List<IGDIntervalZone> igdList, IGDUnitBase lookForMe, Boundary boundary) throws SQLException {
                        IGDIntervalZone.BoundaryType bndType = (IGDIntervalZone.BoundaryType)line.getObjectType();
                        Sample sample = null;
                        block0 : switch (bndType) {
                            default: {
                                assert (false);
                            }
                            case TOP: {
                                for (IGDIntervalZone zone : igdList) {
                                    IGDScheme scheme;
                                    if (zone.getUppZone() == 0 && zone.getLowZone() == 0 || (scheme = this.this$0.getDb().getIGDScheme(zone.getSchID())).findUnitBase(zone.getUppZone()) != lookForMe && (!correlateRangedIntervals || zone.getLowZone() <= 0 || scheme.findUnitBase(zone.getLowZone()) != lookForMe) || maxUnconfidence == 0 && (zone.isQUzone() && zone.getUppZone() == lookForMe.getUnitID() || zone.getLowZone() > 0 && zone.isQLzone() && zone.getLowZone() == lookForMe.getUnitID())) continue;
                                    sample = zone.getTopSample();
                                    if (boundary != null) break block0;
                                    boundary = Boundary.getBnd((int)zone.getTopBndInt());
                                    break block0;
                                }
                                break;
                            }
                            case BASE: {
                                for (int i = igdList.size() - 1; i >= 0; --i) {
                                    IGDScheme scheme;
                                    IGDIntervalZone zone = igdList.get(i);
                                    if (zone.getUppZone() == 0 && zone.getLowZone() == 0 || ((scheme = this.this$0.getDb().getIGDScheme(zone.getSchID())).findUnitBase(zone.getUppZone()) != lookForMe || !correlateRangedIntervals && zone.getLowZone() > 0) && (zone.getLowZone() <= 0 || scheme.findUnitBase(zone.getLowZone()) != lookForMe) || maxUnconfidence == 0 && (zone.isQUzone() && zone.getUppZone() == lookForMe.getUnitID() || zone.getLowZone() > 0 && zone.isQLzone() && zone.getLowZone() == lookForMe.getUnitID())) continue;
                                    sample = zone.getBaseSample();
                                    if (boundary != null) break block0;
                                    boundary = Boundary.getBnd((int)zone.getBaseBndInt());
                                    break block0;
                                }
                            }
                        }
                        if (sample != null && boundary != null) {
                            return new DepthBndPair(this.this$0, this.this$0.getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings), boundary, true);
                        }
                        return null;
                    }
                }
                if ((dbp = (searcher = new IGDListSearcher()).searchList(igdList, (IGDUnitBase)line.getObject(), bnd)) == null) {
                    IGDUnitBase lineUnit = (IGDUnitBase)line.getObject();
                    IGDScheme scheme = this.getDb().getIGDScheme(lineUnit.getSchID());
                    DepthBndPair potential = null;
                    for (IGDUnit similar : scheme.findMatchingUnits((IGDUnitBase)line.getObject(), (IGDIntervalZone.BoundaryType)line.getObjectType())) {
                        DepthBndPair p = searcher.searchList(igdList, (IGDUnitBase)similar, bnd);
                        if (p == null) continue;
                        if (potential == null || Math.abs(potential.depth - p.depth) < 0.001) {
                            potential = p;
                            continue;
                        }
                        potential = null;
                        break;
                    }
                    dbp = potential;
                }
                if (dbp == null) break;
                IGDIntervalZone.BoundaryType bndType = (IGDIntervalZone.BoundaryType)line.getObjectType();
                if (bndType == IGDIntervalZone.BoundaryType.TOP) {
                    dbp.scaleMinPreferred = false;
                }
                depths.add(dbp);
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        ArrayList<CorrelationPoint> ypos = new ArrayList<CorrelationPoint>();
        for (DepthBndPair pair : depths) {
            if (!(pair.depth >= (double)this.getTopDepth()) || !(pair.depth <= (double)this.getBaseDepth())) continue;
            ypos.add(new CorrelationPoint(line, this.scaleDepth((float)pair.depth, pair.scaleMinPreferred), pair.bnd, pair.depth, pair.isObserved));
        }
        return ypos.isEmpty() ? null : ypos;
    }

    private List<IGDIntervalZone> getYposIGDList(CorrelationLine line, WellInterp interp) {
        switch (line.getCorrelationType()) {
            case CHRONO: {
                return interp.getIGDList(3);
            }
            case LITHO: {
                return interp.getIGDList(2);
            }
            case BIOZONE: {
                return interp.getIGDList(4, ((IGDUnit)line.getObject()).getSchID());
            }
        }
        assert (false);
        return null;
    }

    @Override
    public Set<CorrelationLine> getCorrelationLines(Correlation c, ChartProperties cp) throws SQLException, SBException {
        WellInterp interp;
        block21: {
            if (this.getWell() == null || this.getWells().size() > 1) {
                return null;
            }
            if (c.getVisibleOnly() && !this.hasPanel(c.getCorrType(), c.getInterpID(), c.getSchID())) {
                if (c.getUseBlockInterp()) {
                    if (!this.hasPanel(c.getCorrType(), this.getInterpID(), c.getSchID())) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            this.getWell().loadInterps();
            interp = null;
            try {
                interp = this.getWell().getInterp(c.getInterpID());
            }
            catch (SBException e) {
                if (!c.getUseBlockInterp()) {
                    return null;
                }
                if (this.getInterp() != null) break block21;
                return null;
            }
        }
        HashSet<CorrelationLine> lines = new HashSet<CorrelationLine>();
        float topDepth = this.getTopDepth();
        float baseDepth = this.getBaseDepth();
        switch (c.getCorrType()) {
            case EVENT: {
                if (c.getUseBlockInterp() && (interp == null || interp != null && interp.getEvents().isEmpty())) {
                    interp = this.getInterp();
                }
                for (WellEvent e : interp.getEvents()) {
                    float depth;
                    if (!c.includesType(e.getTypeObj()) || !((depth = (float)this.getWell().getDepth(e.getSample(), cp.correctDepths, cp.correctCuttings)) >= topDepth) || !(depth <= baseDepth) || e.getConfidence().getDBint() > c.getMaxUnconfidence()) continue;
                    lines.add(new EventLine(e.getEvent(), e.getTypeObj(), c.getDefaultLineStyle(), c.getInterpID()));
                }
                break;
            }
            case SURFACE: {
                if (c.getUseBlockInterp() && (interp == null || interp != null && interp.getSQPicks().isEmpty())) {
                    interp = this.getInterp();
                }
                for (SQPick p : interp.getSQPicks()) {
                    float depth;
                    if (!c.includesType(p.getSurfaceType()) || !((depth = (float)this.getWell().getDepth(p.getSample(), cp.correctDepths, cp.correctCuttings)) >= topDepth) || !(depth <= baseDepth)) continue;
                    lines.add(new SurfaceLine(p.getSurface(), c.getDefaultLineStyle(), (Integer)c.getInterpID()));
                }
                break;
            }
            case CHRONO: 
            case LITHO: 
            case BIOZONE: {
                int igdType = DataType.getIGDType((DataType)c.getCorrType().getDataType());
                if (c.getUseBlockInterp() && (interp == null || interp != null && interp.getIGDList(igdType).isEmpty())) {
                    interp = this.getInterp();
                }
                for (IGDIntervalZone zone : interp.getIGDList(igdType)) {
                    float depth;
                    IGDScheme scheme;
                    IGDUnitBase uppZone;
                    if (zone.getSchID() != c.getSchID() || zone.getUppZone() == 0 || (uppZone = (scheme = this.getDb().getIGDScheme(zone.getSchID())).findUnitBase(zone.getUppZone())).getHier() != c.getHier()) continue;
                    if (c.includesType(IGDIntervalZone.BoundaryType.TOP) && (depth = (float)this.getWell().getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings)) >= topDepth && depth <= baseDepth) {
                        lines.add(new IGDUnitLine(c.getCorrType(), uppZone, IGDIntervalZone.BoundaryType.TOP, c.getDefaultLineStyle(), c.getInterpID()));
                    }
                    if (!c.includesType(IGDIntervalZone.BoundaryType.BASE) || !((depth = (float)this.getWell().getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings)) >= topDepth) || !(depth <= baseDepth)) continue;
                    lines.add(new IGDUnitLine(c.getCorrType(), uppZone, IGDIntervalZone.BoundaryType.BASE, c.getDefaultLineStyle(), c.getInterpID()));
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return lines;
    }

    private boolean hasPanel(CorrelationType ct, int interpID, int schID) {
        switch (ct) {
            case EVENT: {
                return this.hasEventsPanel(interpID);
            }
            case SURFACE: {
                return this.hasPicksPanel(interpID);
            }
            case CHRONO: {
                return this.hasZonesPanel(interpID, 3, 0);
            }
            case LITHO: {
                return this.hasZonesPanel(interpID, 2, 0);
            }
            case BIOZONE: {
                return this.hasZonesPanel(interpID, 4, schID);
            }
        }
        return false;
    }

    synchronized void setDataIntervals(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        if (cp.bgSchID <= 0 || this.getWell() == null || this.getInterpID() < 0 || this.getWells().size() > 1) {
            this.intervals = null;
            return;
        }
        final IGDScheme scheme = this.getWell().getDataModel().getIGDScheme(cp.bgSchID);
        WellInterp interp = this.getWell().getInterp(this.getInterpID());
        if (scheme != null && interp != null) {
            this.getWell().loadInterp(interp);
            List list = interp.getIGDList(scheme.getIGDType(), scheme.getID(), true);
            if (list == null) {
                return;
            }
            this.intervals = new LinkedList();
            for (IGDIntervalZone zone : list) {
                IGDUnitBase lowUnit;
                IGDUnitBase unit;
                if (zone.getUppZone() <= 0 || (unit = scheme.findUnitBase(zone.getUppZone())) == null || unit.getHier() > cp.bgHier) continue;
                double topSampleDepth = this.getWell().getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                double baseSampleDepth = this.getWell().getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                if (!(baseSampleDepth >= (double)this.getTopDepth()) || !(topSampleDepth <= (double)this.getBaseDepth())) continue;
                double topDepth = Math.max(topSampleDepth, (double)this.getTopDepth());
                double baseDepth = Math.min(baseSampleDepth, (double)this.getBaseDepth());
                float yTop = this.scaleDepth((float)topDepth);
                float yBase = this.scaleDepth((float)baseDepth);
                Color lowColour = null;
                if (zone.getLowZone() > 0 && (lowUnit = scheme.findUnitBase(zone.getLowZone())) != null) {
                    lowColour = ColourUtils.getLighterColour((Color)unit.getColour(), (float)cp.bgDensity);
                }
                DrawZone i = new DrawZone(yTop, yBase, ColourUtils.getLighterColour((Color)unit.getColour(), (float)cp.bgDensity), lowColour, zone.getTopBndInt(), zone.getBaseBndInt(), null, null, null, null, topSampleDepth, baseSampleDepth);
                i.setObject(zone);
                this.intervals.add(i);
            }
            if (sections != null) {
                this.intervals = DrawZone.divideDrawZones(this.intervals, sections);
            }
            Collections.sort(this.intervals, new Comparator<DrawZone>(){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public int compare(DrawZone o1, DrawZone o2) {
                    IGDIntervalZone z1 = (IGDIntervalZone)o1.getObject();
                    IGDIntervalZone z2 = (IGDIntervalZone)o2.getObject();
                    try {
                        IGDUnitBase u1 = scheme.findUnitBase(z1.getUppZone());
                        IGDUnitBase u2 = scheme.findUnitBase(z2.getUppZone());
                        if (u1.getHier() > u2.getHier()) {
                            return 1;
                        }
                        if (u1.getHier() < u2.getHier()) {
                            return -1;
                        }
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                    return 0;
                }
            });
        } else {
            this.intervals = null;
        }
    }

    @Override
    public List<DrawZone> getBackgroundZones() {
        if (this.intervals == null) {
            return Collections.EMPTY_LIST;
        }
        return this.intervals;
    }

    @Override
    public float getHeaderHeight(ChartProperties cp) {
        float maxHeight = 0.0f;
        for (SBPanel panel : this.getPanels()) {
            if (!(panel instanceof PanelWellDepthAge)) continue;
            PanelWellDepthAge daPanel = (PanelWellDepthAge)panel;
            maxHeight = Math.max(daPanel.getHeaderHeight(cp), maxHeight);
        }
        return Math.max(maxHeight + cp.panelCaptionHeight, cp.getPanelHeaderHeight());
    }

    @Override
    public void defaultTemplateChanged(PanelTemplate newDefault) {
        if (this.getTemplate() != null) {
            return;
        }
        ListIterator<SBPanel> it = this.panels.listIterator();
        while (it.hasNext()) {
            SBPanel panel = (SBPanel)it.next();
            if (panel.getPanelType() != newDefault.getType() || panel.getTemplate() == newDefault) continue;
            panel.deleteListener(this);
            it.remove();
            try {
                SBPanel replacement = (SBPanel)PanelFactory.createPanel(this, newDefault, new PanelOcc(newDefault.getID()));
                replacement.registerListener(this);
                it.add(replacement);
                this.setPropertyChanged(replacement);
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error", (Throwable)e);
            }
        }
        this.notifyListeners();
    }

    private static class DisconformityText {
        String text;
        Rectangle2D area;

        private DisconformityText() {
        }
    }

    private static class PanelData {
        final SBPanel panel;
        final SubBlockProperties sbp;
        final float xOrigin;

        PanelData(SBPanel panel, SubBlockProperties sbp, float xOrigin) {
            this.panel = panel;
            this.sbp = sbp;
            this.xOrigin = xOrigin;
        }
    }
}

