/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.text.AttributedString;
import java.util.List;
import jsbchart.core.ChartProperties;
import jsbchart.core.LithologyPattern;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.graphics.SBGraphics;
import jsbchart.util.DrawingUtils;
import model3.Lithology;
import model3.TxGroup;

public abstract class AbstractLegend {
    private static final float PAD = 3.0f;

    protected float calcIdealHeight(List<TextItem> items, ChartProperties cp) {
        return (float)items.stream().mapToDouble(item -> item.getHeight(cp.getFontSize()) + (float)(item.value == null ? 2 : 1)).sum() + 6.0f;
    }

    protected float calcIdealWidth(List<TextItem> items, SBGraphics g, ChartProperties cp) {
        g.setFontSize(cp.getFontSize());
        float maxItemWidth = (float)items.stream().mapToDouble(item -> item.getWidth(g, cp.getFontSize())).max().orElse(3.0);
        return maxItemWidth + 6.0f;
    }

    protected float draw(SBGraphics g, float x, float y, float w, float h, ChartProperties cp, List<TextItem> items, boolean border) {
        float ytop;
        float fontSize = cp.getFontSize();
        float ypos = ytop = y + 3.0f;
        float xpos = x + 3.0f;
        g.setColor(cp.foreground);
        g.setFont(cp.font, 0, fontSize);
        g.setStroke(0.1f);
        float maxYpos = y + h;
        float maxXpos = x + w;
        float colWidth = 0.0f;
        for (TextItem item : items) {
            ypos += item.getHeight(fontSize);
            if (colWidth > 0.0f) {
                ypos += 1.0f;
            }
            if (ypos > maxYpos - 3.0f || item.value == null && items.indexOf(item) < items.size() - 1 && ypos + items.get(items.indexOf(item) + 1).getHeight(fontSize) + 1.0f > maxYpos - 3.0f) {
                ypos = ytop + item.getHeight(fontSize);
                if ((xpos += colWidth + 3.0f + 3.0f) > maxXpos) break;
                colWidth = 0.0f;
            }
            if (item.value == null) {
                g.setFontStyle(1);
                g.drawString(item.item.toString(), xpos, ypos);
                ypos += 1.0f;
            } else {
                this.drawItem(item, g, xpos, ypos, fontSize, maxXpos, cp);
            }
            colWidth = Math.max(colWidth, item.getWidth(g, fontSize));
        }
        g.setStroke(0.4f);
        if (border) {
            g.drawRect(x, y, w, h);
        }
        return y + h;
    }

    private void drawItem(TextItem item, SBGraphics g, float xpos, float ypos, float fontSize, float maxXpos, ChartProperties cp) {
        Object object = item.item;
        if (object instanceof Boundary) {
            Boundary bnd = (Boundary)object;
            DrawingUtils.drawBoundary(bnd.getBndInt(), xpos, xpos + item.getItemWidth(g, fontSize), ypos - 1.5f, g, 0.15f);
        } else {
            object = item.item;
            if (object instanceof CorrLineStyle) {
                CorrLineStyle style = (CorrLineStyle)object;
                c = g.getColor();
                g.setColor(style.getColour());
                DrawingUtils.drawBoundary(3, xpos, xpos + item.getItemWidth(g, fontSize), ypos - 1.5f, g, style.getWeight());
                g.setColor((Color)c);
            } else {
                c = item.item;
                if (c instanceof Lithology) {
                    float[] yPoints;
                    Lithology lith = (Lithology)c;
                    xPoints = new float[]{xpos, xpos + item.getItemWidth(g, fontSize), xpos + item.getItemWidth(g, fontSize), xpos};
                    if (g.isVisible((float)xPoints[0], (yPoints = new float[]{ypos - item.getHeight(fontSize), ypos - item.getHeight(fontSize), ypos, ypos})[0], (float)(xPoints[1] - xPoints[0]), yPoints[2] - yPoints[1])) {
                        if (!lith.isQual()) {
                            LithologyPattern.draw((Lithology)item.item, g, (float[])xPoints, yPoints, 4, false, g.getColor(), false);
                        } else {
                            if (lith.getCmp() == 'S') {
                                LithologyPattern.drawStringer(lith, g, xpos, ypos - item.getHeight(fontSize) / 2.0f, item.getItemWidth(g, fontSize), false, true, false);
                            } else {
                                LithologyPattern.draw(lith, g, xpos + item.getItemWidth(g, fontSize) / 2.0f, ypos - item.getHeight(fontSize) / 2.0f, false, true, false);
                            }
                            g.setStroke(0.1f);
                            g.drawRect(xpos, ypos - item.getHeight(fontSize), item.getItemWidth(g, fontSize), item.getHeight(fontSize));
                        }
                    }
                    ypos = ypos - item.getHeight(fontSize) / 2.0f + g.stringHeightSB() / 2.0f;
                } else {
                    xPoints = item.item;
                    if (xPoints instanceof Color) {
                        Color c = (Color)xPoints;
                        g.fillRect(xpos, ypos - item.getHeight(fontSize), item.getItemWidth(g, fontSize), item.getHeight(fontSize), c);
                        ypos = ypos - item.getHeight(fontSize) / 2.0f + g.stringHeightSB() / 2.0f;
                    } else {
                        xPoints = item.item;
                        if (xPoints instanceof ColorPair) {
                            ColorPair colorPair = (ColorPair)xPoints;
                            current = g.getColor();
                            if (colorPair.line() == null) {
                                g.setColor(colorPair.fill());
                            } else {
                                g.setColor(colorPair.line());
                            }
                            g.fillRect(xpos, ypos - item.getHeight(fontSize), item.getItemWidth(g, fontSize), item.getHeight(fontSize), colorPair.fill());
                            ypos = ypos - item.getHeight(fontSize) / 2.0f + g.stringHeightSB() / 2.0f;
                            g.setColor((Color)current);
                        } else if (item.item instanceof SampleType) {
                            g.setStroke(0.1f);
                            g.drawLine(xpos, ypos - item.getHeight(fontSize) / 2.0f, xpos + item.getItemWidth(g, fontSize), ypos - item.getHeight(fontSize) / 2.0f);
                            DrawingUtils.drawSampleSymbol(item.item.toString(), g, xpos + item.getItemWidth(g, fontSize) - 3.0f, ypos - item.getHeight(fontSize) / 2.0f);
                        } else if (item.item instanceof String) {
                            g.setFontStyle(0);
                            g.drawString(String.valueOf(item.item), xpos, ypos);
                        } else {
                            current = item.item;
                            if (current instanceof FloatColor) {
                                FloatColor floatColor = (FloatColor)current;
                                float width = floatColor.width;
                                g.fillRect(xpos + item.getItemWidth(g, fontSize) / 2.0f - width / 2.0f, ypos - item.getHeight(fontSize), width, item.getHeight(fontSize), floatColor.colour != null ? floatColor.colour : cp.foreground);
                            }
                        }
                    }
                }
            }
        }
        g.setFontStyle(0);
        g.setFontSize(fontSize);
        float x = xpos + item.getItemWidth(g, fontSize) + 1.5f;
        Object object2 = item.value;
        if (object2 instanceof AttributedString) {
            AttributedString attStr = (AttributedString)object2;
            g.drawString(attStr, x, ypos, maxXpos - x - 1.5f, true);
            return;
        }
        g.drawString(item.value.toString(), x, ypos, maxXpos - x - 1.5f, 1, true);
    }

    public static class TextItem {
        static final float PAD = 1.5f;
        final Object item;
        final Object value;
        private Float valueWidth;

        public TextItem(Object item, Object value) {
            assert (item != null);
            this.item = item;
            this.value = value;
        }

        public static TextItem newTitleItem(String title) {
            return new TextItem(title, null);
        }

        public static TextItem newValueItem(Object item, String description) {
            return new TextItem(item, description);
        }

        float getItemWidth(SBGraphics g, float fontSize) {
            float itemWidth;
            if (this.item instanceof String && this.value == null) {
                g.setFontStyle(1);
                itemWidth = g.stringWidth(this.item.toString());
            } else if (this.item instanceof Boundary || this.item instanceof CorrLineStyle) {
                itemWidth = fontSize * 3.0f;
            } else if (this.item instanceof SampleType) {
                itemWidth = fontSize * 2.0f;
            } else {
                if (this.item instanceof Lithology || this.item instanceof FloatColor || this.item instanceof Color || this.item instanceof ColorPair) {
                    return fontSize * 1.2f;
                }
                g.setFontStyle(0);
                itemWidth = g.stringWidth(this.item.toString());
            }
            return itemWidth;
        }

        float getValueWidth(SBGraphics g) {
            if (this.valueWidth == null) {
                if (this.value != null) {
                    Object object = this.value;
                    if (object instanceof AttributedString) {
                        AttributedString as = (AttributedString)object;
                        this.valueWidth = Float.valueOf(g.stringWidth(as));
                    } else {
                        this.valueWidth = Float.valueOf(g.stringWidth(this.value.toString()));
                    }
                } else {
                    this.valueWidth = Float.valueOf(0.0f);
                }
            }
            return this.valueWidth.floatValue();
        }

        float getWidth(SBGraphics g, float fontSize) {
            return this.getItemWidth(g, fontSize) + this.getValueWidth(g) + 1.5f;
        }

        float getHeight(float fontSize) {
            if (this.item instanceof Lithology || this.item instanceof TxGroup) {
                return fontSize * 1.2f;
            }
            if (this.value == null) {
                return fontSize * 1.5f;
            }
            if (this.item instanceof Float) {
                return 2.5f;
            }
            return fontSize;
        }
    }

    public record ColorPair(Color line, Color fill) {
    }

    public record FloatColor(float width, Color colour) {
    }
}

