/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplateLoadingHelper;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartPanelSnapshot;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.core.TemplateFactory;
import jsbchart.core.TemplateNotifierService;
import model3.Audit;
import model3.SBdb;
import org.jdom2.Element;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.listener.WeakListenerList;

public abstract class BlockTemplate
extends ChartTemplateBase
implements Observer {
    private static final String TABLE_NAME = "CHTBLOCK";
    private static final String TABLE_NAME_MBR = "CHTBLOCKMBR";
    private static final String TABLE_ID_FIELD = "block_id";
    private final WeakListenerList<Listener> listeners = new WeakListenerList();
    private final BlockType type;
    private LinkedList<PanelOcc> panels;
    private BlockTemplate link;

    BlockTemplate(ChartManager manager, int ID, BlockType type, String descr, String comments, int projID, Audit audit, int acm) {
        super(manager, ID, descr, comments, projID, audit, TABLE_NAME, TABLE_ID_FIELD, acm);
        this.type = type;
        if (ID == 0) {
            this.panels = new LinkedList();
            this.setAcm(0);
        }
    }

    public abstract Integer getParentID();

    public abstract int getWellID();

    public String getParentName() throws SQLException {
        if (this.getParentID() == null) {
            return null;
        }
        BlockTemplate parentTemplate = this.getBlockTemplate(this.getParentID());
        return parentTemplate.getName();
    }

    @Override
    public BlockType getType() {
        return this.type;
    }

    @Override
    public boolean hasWellList() {
        return false;
    }

    @Override
    public int getWellListID() {
        return 0;
    }

    @Override
    public String getTypeDescr() {
        return "template";
    }

    public synchronized List<PanelOcc> getPanels() {
        return new LinkedList<PanelOcc>(this.panels);
    }

    public synchronized List<Integer> getPanelIDs() {
        return this.panels.stream().map(PanelOcc::getPanelID).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadPanels(SBdb sbdb, Statement stmt) throws SQLException {
        if (this.panels != null) {
            return;
        }
        BlockTemplate blockTemplate = this;
        synchronized (blockTemplate) {
            List<PanelOcc> panelOccs = BlockTemplateLoadingHelper.loadPanelOccs(sbdb, stmt, this.getID());
            this.setPanelOccs(panelOccs);
        }
    }

    void setPanelOccs(List<PanelOcc> panelOccs) {
        if (panelOccs == null) {
            return;
        }
        for (PanelOcc occ : panelOccs) {
            occ.addObserver(this);
        }
        this.panels = new LinkedList<PanelOcc>(panelOccs);
    }

    public void addPanel(PanelOcc occ) {
        if (this.getID() > 0 && this.isConnected()) {
            throw new IllegalStateException("Attempt to add PanelOcc to stored BlockTemplate");
        }
        if (this.panels == null) {
            this.panels = new LinkedList();
        }
        this.panels.add(occ);
    }

    public synchronized void updatePanels(SBdb sbdb, List<ChartPanelSnapshot> newPanels) throws SQLException, SBPermissionException, SBException {
        if (this.getID() > 0) {
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                if (!this.canWrite(sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(sbdb, "template", true));
                }
                String sql = "DELETE FROM " + sbdb.DBTableName(TABLE_NAME_MBR) + " WHERE block_id=" + this.getID();
                stmt.executeUpdate(sbdb.modQuery(sql));
                for (PanelOcc panelOcc : this.panels) {
                    PanelTemplate panelTemplate = this.getPanelTemplate(panelOcc.getPanelID());
                    if (panelTemplate == null) {
                        if (this.getParentID() != null) continue;
                        throw new IllegalStateException("Could not find panel template for ID " + panelOcc.getPanelID());
                    }
                    if (panelTemplate.isVisible() || this.getParentID() != null || !newPanels.stream().map(ChartPanelSnapshot::getActivePanelOcc).noneMatch(activeOcc -> activeOcc.getPanelID() == panelTemplate.getID())) continue;
                    this.deletePanelTemplate(panelTemplate.getID());
                }
                if (this.getParentID() == null) {
                    for (ChartPanelSnapshot chartPanelSnapshot : newPanels) {
                        if (chartPanelSnapshot.getPanelTemplate() == null || !chartPanelSnapshot.getPanelTemplate().isEditing() || chartPanelSnapshot.getPanelTemplate().isVisible()) continue;
                        chartPanelSnapshot.getPanelTemplate().update(sbdb);
                    }
                }
                this.clearPanelList();
                int n = 0;
                sql = "INSERT INTO " + sbdb.DBTableName(TABLE_NAME_MBR) + " (block_id,panel_id,panel_no,interp_id,caption,subcaption,sch_id,overplot) VALUES (" + this.getID() + ",";
                for (ChartPanelSnapshot u : newPanels) {
                    PanelOcc a = u.getActivePanelOcc();
                    stmt.executeUpdate(sbdb.modQuery(sql + a.getPanelID() + "," + n + "," + a.getInterpID() + "," + SB.DBString((String)CaptionTemplate.getDbString(a.getCaption())) + "," + SB.DBString((String)CaptionTemplate.getDbString(a.getSubCaption())) + "," + String.valueOf(a.getSchID() > 0 ? Integer.valueOf(a.getSchID()) : "NULL") + "," + SB.DBString((String)a.getCapOrient().getDBstring()) + ")"));
                    PanelOcc realOcc = u.getRealPanelOcc();
                    realOcc.setPanelNo(n);
                    realOcc.addObserver(this);
                    this.panels.add(realOcc);
                    ++n;
                }
                this.updateAudit(sbdb, stmt);
            }
        } else {
            for (PanelOcc occ : this.panels) {
                occ.deleteObserver(this);
            }
            this.panels.clear();
            int panelNo = 0;
            for (ChartPanelSnapshot p : newPanels) {
                p.getRealPanelOcc().addObserver(this);
                PanelOcc panelOcc = p.getRealPanelOcc();
                panelOcc.setPanelNo(panelNo++);
                this.panels.add(panelOcc);
            }
        }
        this.setChanged();
        this.listeners.notify(Listener::onTemplateMembersUpdated);
    }

    public boolean hasEditingPanels() throws SQLException, SBException {
        for (PanelOcc pOcc : this.panels) {
            if (!this.getPanelTemplate(pOcc.panelID).isEditing()) continue;
            return true;
        }
        return false;
    }

    public static List<ChartPanelSnapshot> createPanelOccUpdates(List<PanelOcc> occs) {
        LinkedList<ChartPanelSnapshot> l = new LinkedList<ChartPanelSnapshot>();
        for (PanelOcc o : occs) {
            l.add(new ChartPanelSnapshot(o, null, null));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replacePanel(SBdb sbdb, int panelToReplaceID, int newPanelID) throws SQLException, SBPermissionException, SBException {
        if (panelToReplaceID == newPanelID) {
            return;
        }
        BlockTemplate blockTemplate = this;
        synchronized (blockTemplate) {
            LinkedList<PanelOcc> newPanels = new LinkedList<PanelOcc>();
            for (PanelOcc occ : this.panels) {
                if (occ.panelID == panelToReplaceID) {
                    newPanels.add(new PanelOcc(newPanelID, occ.getInterpID(), occ.getCaption(), occ.getSubCaption(), occ.getCapOrient(), occ.getSchID()));
                    continue;
                }
                newPanels.add(occ);
            }
            if (!newPanels.equals(this.panels)) {
                this.updatePanels(sbdb, BlockTemplate.createPanelOccUpdates(newPanels));
            }
        }
    }

    void replacePanelAt(int index, PanelOcc replacement) {
        if (this.getID() > 0) {
            throw new IllegalStateException("Cannot replace panelOccs after saving");
        }
        this.panels.remove(index);
        this.panels.add(index, replacement);
    }

    void excludePanel(int panelID) {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to exclude panel from stored block template");
        }
        ListIterator it = this.panels.listIterator();
        while (it.hasNext()) {
            PanelOcc pOcc = (PanelOcc)((Object)it.next());
            if (pOcc.panelID != panelID) continue;
            it.remove();
        }
    }

    public synchronized boolean equals(List<ChartPanelSnapshot> panelSnapshot) {
        List activePanelOccs = panelSnapshot.stream().map(ChartPanelSnapshot::getActivePanelOcc).collect(Collectors.toList());
        if (activePanelOccs.equals(this.getPanels())) {
            return panelSnapshot.stream().map(ChartPanelSnapshot::getPanelTemplate).noneMatch(t -> !t.isVisible() && t.isEditing());
        }
        return false;
    }

    private synchronized void clearPanelList() {
        for (PanelOcc o : this.panels) {
            o.deleteObserver(this);
        }
        this.panels.clear();
    }

    @Override
    String getTableName() {
        return TABLE_NAME;
    }

    @Override
    String getTableNameMbr() {
        return TABLE_NAME_MBR;
    }

    @Override
    String getTableIDField() {
        return TABLE_ID_FIELD;
    }

    @Override
    public synchronized int getnMbrs() {
        return this.panels.size();
    }

    @Override
    public String getTypeString() {
        return this.type.toString();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof PanelOcc) {
            if (!this.panels.contains((Object)((PanelOcc)((Object)o)))) {
                System.out.println("something bad has happened");
            }
            System.out.println("PanelOcc changed in " + String.valueOf(this));
            this.setChanged();
            this.notifyObservers(o);
        }
    }

    @Override
    void checkProjectChange(SBdb sbdb, Statement stmt, int newProjID, boolean forCopy) throws SQLException, InvalidFieldException {
        int max;
        String sql = "SELECT max(p.proj_id) as max from " + sbdb.DBTableName("CHTPANL") + " p, " + sbdb.DBTableName(TABLE_NAME_MBR) + " b WHERE b.block_id=" + this.getID() + " AND p.panel_id=b.panel_id AND p.isvisible='Y'";
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        if (rs.next() && (max = rs.getInt("max")) > 0) {
            throw new InvalidFieldException("Cannot update project: this block uses non-global panel templates");
        }
        sql = "SELECT g.name from " + sbdb.DBTableName("CHTPANL") + " p, " + sbdb.DBTableName(TABLE_NAME_MBR) + " b, " + sbdb.DBTableName("CHTPANLMBR") + " m, " + sbdb.DBTableName("TXGROUP") + " g WHERE b.block_id=" + this.getID() + " AND p.panel_id=b.panel_id  AND p.panel_id=m.panel_id AND m.grp_id=g.grp_id AND g.proj_id > 0";
        rs = stmt.executeQuery(sbdb.modQuery(sql));
        if (rs.next()) {
            String name = rs.getString("name");
            throw new InvalidFieldException("Cannot update project: this block uses panels that contain non-global groups (e.g. '" + name + "') ");
        }
        sql = "SELECT g.name from " + sbdb.DBTableName("CHTPANL") + " p, " + sbdb.DBTableName(TABLE_NAME_MBR) + " b, " + sbdb.DBTableName("CHTPANLMBR") + " m, " + sbdb.DBTableName("GROUPSET") + " g WHERE b.block_id=" + this.getID() + " AND p.panel_id=b.panel_id  AND p.panel_id=m.panel_id AND m.grpset_id=g.grpset_id AND g.proj_id > 0";
        rs = stmt.executeQuery(sbdb.modQuery(sql));
        if (rs.next()) {
            String name = rs.getString("name");
            throw new InvalidFieldException("Cannot update project: this block uses inner panels that contain non-global group sets (e.g. '" + name + "') ");
        }
        sql = "SELECT g.name from " + sbdb.DBTableName("CHTPANL") + " p, " + sbdb.DBTableName(TABLE_NAME_MBR) + " b, " + sbdb.DBTableName("GROUPSET") + " g WHERE b.block_id=" + this.getID() + " AND p.panel_id=b.panel_id  AND p.grpset_id=g.grpset_id AND g.proj_id > 0 ";
        rs = stmt.executeQuery(sbdb.modQuery(sql));
        if (rs.next()) {
            String name = rs.getString("name");
            throw new InvalidFieldException("Cannot update project: this block uses outer panels that contain non-global group sets (e.g. '" + name + "')");
        }
        if (!forCopy && newProjID > 0) {
            sql = "SELECT DISTINCT c.proj_id as proj_id from " + sbdb.DBTableName("CHART") + " c, " + sbdb.DBTableName("CHTMBR") + " m WHERE m.block_id=" + this.getID() + " AND c.chart_id=m.chart_id";
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int projID = rs.getInt("proj_id");
                if (projID == 0 || projID == newProjID) continue;
                throw new InvalidFieldException("Can't update project: this block is a member of charts in a different project.");
            }
        }
    }

    @Override
    void preDelete(SBdb sbdb, Statement stmt) throws SQLException {
        String sql = "DELETE FROM " + sbdb.DBTableName("CHTPREF_BLK") + " WHERE block_id=" + this.getID();
        stmt.executeUpdate(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("CHTPREF_SCH") + " WHERE block_id=" + this.getID();
        stmt.executeUpdate(sbdb.modQuery(sql));
    }

    synchronized void refresh(BlockTemplate updated) {
        if (updated.getID() != this.getID()) {
            throw new IllegalArgumentException("Attempt to update block template " + String.valueOf(this) + " from different template");
        }
        super.refreshDescr(updated);
        if (!this.panels.equals(updated.panels)) {
            LinkedList<PanelOcc> orig = this.panels;
            for (PanelOcc p : this.panels) {
                p.deleteObserver(this);
            }
            this.panels = updated.panels;
            for (PanelOcc p : this.panels) {
                p.addObserver(this);
            }
            this.setChanged();
            TemplateNotifierService.submitNotify((Observable)((Object)this), orig);
        }
    }

    @Override
    synchronized BlockTemplate copy(ChartManager chartManager, String descr, String comments, int projID) {
        BlockTemplate copy = TemplateFactory.newBlockTemplate(chartManager, this.type, descr, comments, projID);
        return copy;
    }

    @Override
    void storeMembers(SBdb sbdb) throws SQLException, SBPermissionException, SBException {
        ArrayList<PanelOcc> panelOccs = new ArrayList<PanelOcc>(this.panels);
        this.panels.clear();
        this.updatePanels(sbdb, BlockTemplate.createPanelOccUpdates(panelOccs));
    }

    synchronized void writeXML(BufferedWriter out, int indent, SBdb ws, int singleUserID) throws IOException {
        String ind = SB.getXMLIndent((int)indent);
        out.write(ind + "<Description>" + SB.getXMLstring((String)this.getName()) + "</Description>\n");
        if (this.getComments() != null && !this.getComments().trim().isEmpty()) {
            out.write(ind + "<Comments>" + SB.getXMLstring((String)this.getComments().trim()) + "</Comments>\n");
        }
        this.writeAuditXML(out, indent, singleUserID);
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        for (PanelOcc panelOcc : this.panels) {
            out.write(ind + "<Panel PanelTemplateID=\"" + panelOcc.panelID + "\">");
            if (panelOcc.getCaption() != null || panelOcc.getSubCaption() != null || panelOcc.getSchID() > 0 || panelOcc.getInterpID() != null || panelOcc.getCapOrient() != CaptionOrientation.getDefault()) {
                out.write("\n");
                if (panelOcc.getCaption() != null) {
                    out.write(ind2 + "<Caption>" + SB.getXMLstring((String)panelOcc.getCaption()) + "</Caption>\n");
                }
                if (panelOcc.getSubCaption() != null) {
                    out.write(ind2 + "<SubCaption>" + SB.getXMLstring((String)panelOcc.getSubCaption()) + "</SubCaption>\n");
                }
                out.write(ind2 + "<CaptionOrientation>" + panelOcc.getCapOrient().name() + "</CaptionOrientation>\n");
                if (panelOcc.getInterpID() != null) {
                    try {
                        out.write(ind2 + "<WellInterpretationID ID=\"" + panelOcc.getInterpID() + "\" Description=\"" + SB.getXMLstring((String)ws.getInterp(panelOcc.getInterpID().intValue()).getDescription()) + "\"/>\n");
                    }
                    catch (SQLException sql) {
                        throw new RuntimeException("Unexpected SQL error", sql);
                    }
                }
                if (panelOcc.getSchID() > 0) {
                    out.write(ind2 + "<StratigraphicSchemeID>" + panelOcc.getSchID() + "</StratigraphicSchemeID>\n");
                }
                out.write(ind);
            }
            out.write("</Panel>\n");
        }
    }

    static BlockTemplate parseXML(ChartManager wsCM, SBdb ws, Element xml, int projID) throws SQLException, ParseException, SBException {
        BlockTemplate templ = TemplateFactory.newBlockTemplateFromResults(wsCM, Integer.parseInt(xml.getAttributeValue("BlockID")), BlockType.valueOf(xml.getAttributeValue("Type")), xml.getChildText("Description"), xml.getChildText("Comments"), projID, new Audit(ws, xml.getChild("Audit")), 0);
        templ.panels = new LinkedList();
        for (Object o : xml.getChildren("Panel")) {
            Element panelChild = (Element)o;
            Integer interpID = null;
            Element el = panelChild.getChild("WellInterpretationID");
            if (el != null) {
                interpID = ChartManager.parseInterpIDelement(ws, el);
            }
            int schID = 0;
            String strg = panelChild.getChildText("StratigraphicSchemeID");
            if (strg != null) {
                schID = Integer.parseInt(strg);
            }
            templ.panels.add(new PanelOcc(Integer.parseInt(panelChild.getAttributeValue("PanelTemplateID")), interpID, panelChild.getChildText("Caption"), panelChild.getChildText("SubCaption"), panelChild.getChildText("CaptionOrientation") != null ? CaptionOrientation.valueOf(panelChild.getChildText("CaptionOrientation")) : null, schID));
        }
        return templ;
    }

    BlockTemplate getLink() {
        return this.link;
    }

    void setLink(BlockTemplate link) {
        this.link = link;
    }

    public void addListener(Listener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void deleteListener(Listener listener) {
        this.listeners.deleteListener((Object)listener);
    }

    public synchronized void addObserver(Observer o) {
        Logger.getLogger(BlockTemplate.class.getName()).log(Level.WARNING, "Observer added to BlockTemplate: " + String.valueOf(o) + "; use listener list instead");
    }

    public static enum CaptionOrientation {
        TOP("Top", "LEFT"),
        VERT("Vertical", "RIGHT"),
        CENTRE("Centre", "CENTRE");

        private final String dbString;
        private final String displayString;

        private CaptionOrientation(String displayString, String dbString) {
            this.displayString = displayString;
            this.dbString = dbString;
        }

        String getDBstring() {
            return this.dbString;
        }

        public String toString() {
            return this.displayString;
        }

        static CaptionOrientation parseDBstring(String dbString) {
            if (dbString == null) {
                return TOP;
            }
            switch (dbString) {
                default: {
                    return TOP;
                }
                case "RIGHT": {
                    return VERT;
                }
                case "CENTRE": 
            }
            return CENTRE;
        }

        public static CaptionOrientation getDefault() {
            return TOP;
        }

        public static CaptionOrientation getNotDefault() {
            return CENTRE;
        }
    }

    public static interface Listener {
        public void onTemplateMembersUpdated();
    }
}

