/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import jsbchart.core.BlockTemplateLoadingHelper;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.ChartManager;
import model3.SBdb;

public class BlockTemplateBulkLoadTask
extends SwingWorker<Collection<BlockTemplateParent>, Void> {
    private static final Logger LOGGER = Logger.getLogger(BlockTemplateBulkLoadTask.class.getName());
    private final ChartManager chartManager;
    private final Consumer<Collection<BlockTemplateParent>> onComplete;

    public BlockTemplateBulkLoadTask(ChartManager chartManager, Consumer<Collection<BlockTemplateParent>> onComplete) {
        this.chartManager = chartManager;
        this.onComplete = onComplete;
    }

    @Override
    protected Collection<BlockTemplateParent> doInBackground() throws Exception {
        Collection<BlockTemplateParent> templates;
        SBdb sbdb = this.chartManager.sbdb;
        try (Connection conn = sbdb.getNewConnection();
             Statement stmt = conn.createStatement();){
            templates = BlockTemplateLoadingHelper.loadAllBlockTemplates(this.chartManager, sbdb, stmt);
            conn.commit();
        }
        LOGGER.log(Level.INFO, "Preloaded {0} block templates", new Object[]{templates.size()});
        return templates;
    }

    @Override
    public void done() {
        if (this.onComplete != null) {
            try {
                this.onComplete.accept((Collection)this.get());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Exception sending results to consumer", ex);
            }
        }
    }
}

