/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.util.Date;
import jsbchart.block.BlockType;
import jsbchart.core.TemplateDescr;
import model3.Audit;
import model3.SBRestrictable;

public class BlockTemplateInfo
extends SBRestrictable
implements TemplateDescr {
    private static final String TABLE_NAME = "CHTBLOCK";
    private static final String TABLE_ID_FIELD = "block_id";
    private final int blockID;
    private int projectID;
    private final BlockType type;
    private String description;
    private String comments;
    private final Audit audit;
    private int nMbrs;

    public BlockTemplateInfo(int blockID, int projectID, BlockType type, String description, String comments, Audit audit, int acm) {
        super(TABLE_NAME, TABLE_ID_FIELD, false, true);
        this.blockID = blockID;
        this.projectID = projectID;
        this.type = type;
        this.description = description;
        this.comments = comments;
        this.audit = audit == null ? new Audit() : audit;
        this.setAcm(acm);
    }

    public String toString() {
        return this.description;
    }

    public int getBlockID() {
        return this.blockID;
    }

    @Override
    public int getProjID() {
        return this.projectID;
    }

    @Override
    public BlockType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    protected int getID() {
        return this.blockID;
    }

    @Override
    public boolean hasWellList() {
        return false;
    }

    @Override
    public int getWellListID() {
        return 0;
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public String getName() {
        return this.description;
    }

    @Override
    public Date getModified() {
        return this.audit.getModified();
    }

    @Override
    public Date getCreated() {
        return this.audit.getCreated();
    }

    @Override
    public int getModifier() {
        return this.audit.getModifier();
    }

    @Override
    public int getCreator() {
        return this.audit.getCreator();
    }

    public Date getUpdated() {
        return this.audit.getUpdated();
    }

    @Override
    public String toParentString() {
        return this.toString();
    }

    public void updateDescr(String name, String comments, int projID) {
        this.description = name;
        this.comments = comments;
        this.projectID = projID;
    }

    @Override
    public int getnMbrs() {
        return this.nMbrs;
    }

    public void setnMbrs(int nMbrs) {
        this.nMbrs = nMbrs;
    }
}

