/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import com.stratadata.util.DateUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateChild;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelOcc;
import jsbchart.core.TemplateFactory;
import model3.Audit;
import model3.ConnectionProvider;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;

public class BlockTemplateLoadingHelper {
    private static final Logger LOGGER = Logger.getLogger(BlockTemplateLoadingHelper.class.getName());

    public static Collection<BlockTemplateParent> loadAllBlockTemplates(ChartManager cm, SBdb sbdb, Statement stmt) throws SQLException {
        Map<Integer, List<PanelOcc>> panelOccHash = BlockTemplateLoadingHelper.loadAllPanelOccs((ConnectionProvider)sbdb, stmt);
        HashMap<Integer, BlockTemplateParent> parentById = new HashMap<Integer, BlockTemplateParent>();
        ArrayList<BlockTemplateChild> childTemplates = new ArrayList<BlockTemplateChild>();
        String sql = BlockTemplateLoadingHelper.getBlockSelectString((ConnectionProvider)sbdb);
        try (ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));){
            while (rs.next()) {
                BlockTemplate template = BlockTemplateLoadingHelper.createBlockTemplateFromResultSet(cm, rs);
                List<PanelOcc> occs = panelOccHash.get(template.getID());
                if (occs == null) {
                    occs = new ArrayList<PanelOcc>();
                }
                template.setPanelOccs(occs);
                if (template.getParentID() == null) {
                    parentById.put(template.getID(), (BlockTemplateParent)template);
                    continue;
                }
                childTemplates.add((BlockTemplateChild)template);
            }
        }
        for (BlockTemplateChild child : childTemplates) {
            ((BlockTemplateParent)parentById.get(child.getParentID())).addChild(child);
        }
        return parentById.values();
    }

    public static BlockTemplate createBlockTemplateFromResultSet(ChartManager manager, ResultSet rs) throws SQLException {
        return BlockTemplateLoadingHelper.createBlockTemplateFromResultSet(manager, rs, "");
    }

    public static BlockTemplate createBlockTemplateFromResultSet(ChartManager manager, ResultSet rs, String alias) throws SQLException {
        int ID = rs.getInt("block_id");
        String rsType = rs.getString("type");
        BlockType type = BlockType.valueOf(rsType);
        String descr = rs.getString("descr");
        String comments = rs.getString("comments");
        int projID = rs.getInt("proj_id");
        Audit audit = new Audit(rs, alias);
        int acm = rs.getInt("acm");
        int parentID = rs.getInt("parent_id");
        int wellID = rs.getInt("well_id");
        return TemplateFactory.newBlockTemplateFromResults(manager, ID, type, descr, comments, projID, audit, acm, parentID, wellID);
    }

    public static String getBlockSelectString(ConnectionProvider conn) {
        return "SELECT block_id,type,descr,comments,proj_id," + Audit.sqlFieldString() + ",acm,parent_id,well_id FROM " + conn.DBTableName("CHTBLOCK");
    }

    public static String getBlockSelectStringWithPanels(ConnectionProvider conn, int blockID) {
        return "SELECT b.block_id,b.type,b.descr,b.comments,b.proj_id," + Audit.sqlFieldString((String)"b") + ",b.acm,b.parent_id,b.well_id,m.panel_id,m.panel_no,m.interp_id,m.caption,m.subcaption,m.sch_id,m.overplot FROM " + conn.DBTableName("CHTBLOCK") + " b LEFT JOIN " + conn.DBTableName("CHTBLOCKMBR") + " m on b.BLOCK_ID = m.BLOCK_ID WHERE b.BLOCK_ID=" + blockID + " OR b.PARENT_ID=" + blockID + " ORDER BY b.BLOCK_ID, m.PANEL_NO";
    }

    private static Map<Integer, List<PanelOcc>> loadAllPanelOccs(ConnectionProvider conn, Statement stmt) throws SQLException {
        String sql = BlockTemplateLoadingHelper.getPanelOccSelectString(conn) + " ORDER BY panel_no";
        HashMap<Integer, List<PanelOcc>> panels = new HashMap<Integer, List<PanelOcc>>();
        try (ResultSet rs = stmt.executeQuery(conn.modQuery(sql));){
            while (rs.next()) {
                int blockID = rs.getInt("block_id");
                PanelOcc occ = BlockTemplateLoadingHelper.getPanelOccFromResultSet(rs);
                if (!panels.containsKey(blockID)) {
                    panels.put(blockID, new ArrayList());
                }
                ((List)panels.get(blockID)).add(occ);
            }
        }
        return panels;
    }

    public static List<PanelOcc> loadPanelOccs(SBdb sbdb, Statement stmt, int blockID) throws SQLException {
        LinkedList<PanelOcc> panels = new LinkedList<PanelOcc>();
        String sql = BlockTemplateLoadingHelper.getPanelOccSelectString((ConnectionProvider)sbdb) + " WHERE block_id=" + blockID + " ORDER BY panel_no";
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            panels.add(BlockTemplateLoadingHelper.getPanelOccFromResultSet(rs));
        }
        return panels;
    }

    private static String getPanelOccSelectString(ConnectionProvider conn) {
        return "SELECT block_id, panel_id, panel_no,interp_id,caption,subcaption,sch_id,overplot FROM " + conn.DBTableName("CHTBLOCKMBR");
    }

    public static PanelOcc getPanelOccFromResultSet(ResultSet rs) throws SQLException {
        int panelID = rs.getInt("panel_id");
        if (panelID == 0) {
            throw new NullPanelException("Panel ID 0 in getPanelOccFromResultSet");
        }
        int panelNo = rs.getInt("panel_no");
        Integer interpID = rs.getInt("interp_id");
        if (rs.wasNull()) {
            interpID = null;
        }
        String caption = CaptionTemplate.getDisplayString(rs.getString("caption"));
        String subCaption = CaptionTemplate.getDisplayString(rs.getString("subcaption"));
        PanelOcc occ = new PanelOcc(panelID, interpID, caption, subCaption, panelNo);
        int schID = rs.getInt("sch_id");
        if (!rs.wasNull()) {
            occ.setProperty(5, schID);
        }
        occ.setProperty(2, (Object)BlockTemplate.CaptionOrientation.parseDBstring(rs.getString("overplot")));
        return occ;
    }

    public static String getBlockSearchString(ConnectionProvider conn, BlockType type, String name, Integer projID, LocalDate dateFrom, LocalDate dateTo, Integer modifier) {
        ArrayList<Object> wheres = new ArrayList<Object>();
        if (type != null) {
            wheres.add("type='" + type.name() + "'");
        }
        if (projID != null) {
            wheres.add("proj_id" + (String)(projID > 0 ? "=" + projID : " IS NULL"));
        }
        if (!StringUtils.isBlank((CharSequence)name)) {
            wheres.add("ucase(descr) like '" + name.toUpperCase().trim() + "'");
        }
        if (dateFrom != null) {
            if (dateTo != null) {
                wheres.add("modified BETWEEN '" + dateFrom.format(DateUtils.DB_DATE_FORMAT) + "' AND '" + dateTo.format(DateUtils.DB_DATE_FORMAT) + "'");
            } else {
                wheres.add("modified > '" + dateFrom.format(DateUtils.DB_DATE_FORMAT) + "'");
            }
        }
        if (modifier != null) {
            wheres.add("modifier=" + modifier);
        }
        wheres.add("parent_id IS NULL");
        return "SELECT b.block_id,b.type,b.descr,b.comments,b.proj_id," + Audit.sqlFieldString((String)"b") + ",b.acm,count(m.panel_no) as nmbrs FROM " + conn.DBTableName("CHTBLOCK") + " b  LEFT JOIN " + conn.DBTableName("CHTBLOCKMBR") + " m on b.BLOCK_ID = m.BLOCK_ID WHERE " + StringUtils.join(wheres, (String)" AND ") + " GROUP BY b.block_id,b.type,b.descr,b.comments,b.proj_id," + Audit.sqlFieldStringNoAlias((String)"b") + ",b.acm";
    }

    public static class NullPanelException
    extends RuntimeException {
        public NullPanelException(String message) {
            super(message);
        }
    }
}

