/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import com.stratadata.model3.scheme.Boundary;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.BlockUtils;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.LocationBlock;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.block.SchemeBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.BlockColumn;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateChild;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.ChartBlockColumn;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartLayout;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.MapColumn;
import jsbchart.core.PanelKey;
import jsbchart.core.PanelWellHeader;
import jsbchart.core.TemplatedBlockListener;
import jsbchart.core.WellBlockOrder;
import jsbchart.correlation.CorrDrawUtils;
import jsbchart.correlation.CorrStdOcc;
import jsbchart.correlation.CorrTemplateOcc;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationScope;
import jsbchart.correlation.CorrelationTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartNode;
import jsbchart.listener.ChartNodeListener;
import jsbchart.listener.ChartPropertyChangedNotification;
import jsbchart.listener.ChartTreeNode;
import jsbchart.listener.ChartUpdate;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelLithostratScheme;
import jsbchart.panel.SBPanel;
import jsbchart.panel.panelIGDScheme.PanelIGDScheme;
import jsbchart.tag.ChartTag;
import jsbchart.tag.ChartTagArtist;
import jsbchart.tag.ChartTagTemplate;
import jsbchart.util.DrawZone;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import model3.project.WellList;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;
import util.listener.WeakListenerList;

public class Chart
implements ChartNodeListener {
    private static final Logger LOGGER = Logger.getLogger(Chart.class.getName());
    private ChartProperties chartProperties = new ChartProperties();
    private ChartLayout layout;
    List<ChartBlockBase> blocks = new LinkedList<ChartBlockBase>();
    private final List<Correlation> correlations = new LinkedList<Correlation>();
    private final List<Correlation> corrStds = new LinkedList<Correlation>();
    private List<ChartTag> tags = new ArrayList<ChartTag>();
    private boolean drawTags = true;
    private final ChartTagArtist tagArtist = new ChartTagArtist();
    private ChartTemplate template;
    private final Collection<ChartEvent> updatesPending = new ArrayList<ChartEvent>();
    private static final int REFRESH_INTERVAL = 10000;
    private ScheduledFuture future;
    private static final ScheduledExecutorService UPDATE_SCHEDULER = Executors.newScheduledThreadPool(2);
    private boolean updatingTemplate = false;
    private TemplatedBlockListener templatedBlockListener;
    private WeakListenerList<Listener> listeners = new WeakListenerList();
    private boolean hasChanged;

    public Chart() {
        this.init();
    }

    public Chart(ChartTemplate template) {
        this.template = template;
        this.init();
    }

    private void init() {
        if (this.template != null) {
            this.template.registerChartListener(this);
        }
        this.startRefresh();
    }

    public void terminate() {
        if (this.template != null) {
            this.template.removeChartListener(this);
        }
        this.blocks.forEach(block -> block.terminate());
        this.correlations.forEach(correlation -> correlation.terminate());
        this.listeners.clearListeners();
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public void setTemplate(ChartTemplate template) {
        if (template == null) {
            throw new NullPointerException("Can't set chart template to null");
        }
        template.removeChartListener(this);
        template.registerChartListener(this);
        this.template = template;
    }

    public void resetTemplatedBlocks(int wellID, int interpID, BlockProperties sharedProperties, SBdb sbdb) throws SQLException, SBException {
        assert (sharedProperties != null);
        for (int i = 0; i < this.blocks.size(); ++i) {
            ChartBlock block;
            ChartBlockBase b = this.blocks.get(i);
            if (!(b instanceof ChartBlock) || !BlockType.inheritsWell((block = (ChartBlock)b).getBlockType()) || block.getWell() != null) continue;
            this.removeBlock(block);
            block = (ChartBlock)ChartFactory.createBlock(sbdb, block.getTemplate(), new ChartTemplate.BlockOcc(0, wellID, 0, interpID, null, block.getCaption()));
            block.setProperties(sharedProperties);
            this.insertBlock(block, i);
        }
    }

    public String getTooltip(Point2D p, float zoom, Mode hMode, Mode vMode) {
        Point2D.Float positionInBlock = new Point2D.Float();
        ChartBlockBase block = this.getBlockPosition(p, hMode, vMode, positionInBlock);
        if (block != null) {
            String tooltip = block.getTooltip((float)((Point2D)positionInBlock).getX(), (float)((Point2D)positionInBlock).getY(), this.chartProperties, zoom);
            if (tooltip != null && block instanceof WellBlock && this.blocks.size() == 1 && block.getWell() != null) {
                if (tooltip.startsWith("<html>")) {
                    return "<html>(" + block.getWell().getWellName() + ") " + tooltip.substring("<html>".length());
                }
                return "(" + block.getWell().getWellName() + ") " + tooltip;
            }
            return tooltip;
        }
        return null;
    }

    public Object getObject(Point2D p, float zoom, Mode hMode, Mode vMode) {
        Optional<ChartTag> tagAtPoint = this.tagArtist.getTagOrderForSelection(this.tags).stream().filter(t -> t.contains(p)).findFirst();
        if (tagAtPoint.isPresent()) {
            return tagAtPoint.get();
        }
        Point2D.Float positionInBlock = new Point2D.Float();
        ChartBlockBase block = this.getBlockPosition(p, hMode, vMode, positionInBlock);
        if (block == null) {
            return null;
        }
        return block.getObject((float)((Point2D)positionInBlock).getX(), (float)((Point2D)positionInBlock).getY(), this.chartProperties, zoom);
    }

    public void addBlock(ChartBlockBase block) {
        this.insertBlock(block, this.blocks.size());
    }

    public void insertBlock(ChartBlockBase block, int index) {
        if (this.template != null && !block.getWells().isEmpty() && this.template.getProjID() > 0) {
            for (Well well : block.getWells()) {
                if (well.getDataModel().getWellListService().isWellProjectMember(this.template.getProjID(), well.getWellID())) continue;
                throw new IllegalArgumentException("Cannot add block '" + String.valueOf(block) + "' to chart: project ID mismatch");
            }
        }
        this.blocks.add(index, block);
        block.registerListener(this);
        if (block instanceof MapBlock) {
            MapBlock mapBlock = (MapBlock)block;
            mapBlock.setChartWellsSupplier(() -> this.getChartWells());
        }
        this.setChanged();
    }

    public void addCorrelation(Correlation corr) {
        assert (corr != null);
        if (corr.getScope() == CorrelationScope.SINGLE) {
            if (this.correlations.add(corr)) {
                corr.registerListener(this);
                this.setChanged();
            }
        } else if (this.corrStds.add(corr)) {
            corr.registerListener(this);
            this.setChanged();
        }
    }

    public ChartBlockBase getBlockSingle() {
        if (this.blocks.size() == 1) {
            return this.blocks.get(0);
        }
        return null;
    }

    public ChartBlock getChartBlockSingle() {
        if (this.blocks.size() == 1 && this.blocks.get(0) instanceof ChartBlock) {
            return (ChartBlock)this.blocks.get(0);
        }
        return null;
    }

    public void updateChartTag(ChartTag tag, ChartTag updatedTag) {
        if (this.tags.contains((Object)tag)) {
            this.tags.remove((Object)tag);
            this.tags.add(updatedTag);
        }
    }

    public void setSelectedTag(ChartTag t) {
        this.clearSelectedTags();
        if (this.tags.contains((Object)t)) {
            t.setSelected(true);
        }
    }

    public void clearSelectedTags() {
        for (ChartTag t : this.getTags()) {
            t.setSelected(false);
        }
    }

    public void bringChartTagToFront(ChartTag tag) {
        if (tag == null || tag.getOrder() == 0 || !this.tags.contains((Object)tag)) {
            return;
        }
        List<ChartTag> sorted = this.tags.stream().filter(a -> !a.equals((Object)tag)).sorted(Comparator.comparing(ChartTag::getOrder)).toList();
        tag.setOrder(0);
        for (int i = 0; i < sorted.size(); ++i) {
            ChartTag t = sorted.get(i);
            t.setOrder(i + 1);
        }
    }

    public void sendChartTagToBack(ChartTag tag) {
        if (tag == null || tag.getOrder() == this.tags.size() - 1 || !this.tags.contains((Object)tag)) {
            return;
        }
        List<ChartTag> sorted = this.tags.stream().filter(a -> !a.equals((Object)tag)).sorted(Comparator.comparing(ChartTag::getOrder)).toList();
        for (int i = 0; i < sorted.size(); ++i) {
            ChartTag t = sorted.get(i);
            t.setOrder(i);
        }
        tag.setOrder(sorted.size());
    }

    public void enableTags() {
        this.drawTags = true;
    }

    public void disableTags() {
        this.drawTags = false;
    }

    public boolean equalsTemplate() {
        LinkedList<ChartTemplate.BlockOcc> bOccs = new LinkedList<ChartTemplate.BlockOcc>();
        for (ChartBlockBase chartBlockBase : this.blocks) {
            if (chartBlockBase.hasLocalChanges()) {
                return false;
            }
            if (chartBlockBase.getTemplate() == null) continue;
            int templateID = chartBlockBase.getTemplate().getParentID() != null ? chartBlockBase.getTemplate().getParentID().intValue() : chartBlockBase.getTemplate().getID();
            bOccs.add(new ChartTemplate.BlockOcc(templateID, chartBlockBase.getWellID(), chartBlockBase.getWellListID(), chartBlockBase.getInterpID(), chartBlockBase.getProperties(), chartBlockBase.getCaption()));
        }
        if (!this.template.getBlocks().equals(bOccs)) {
            return false;
        }
        HashSet<CorrTemplateOcc> cOccs = new HashSet<CorrTemplateOcc>();
        for (Correlation c : this.correlations) {
            cOccs.add(new CorrTemplateOcc(c.getTemplateID(), c.getInterpID(), c.getVisibleOnly(), c.getDefaultStyle(), c.getDatumString(), c.getMaxUnconfidence(), c.getCorrelateRangedIntervals(), c.getUseBlockInterp()));
        }
        if (!this.template.getCorrOccs().equals(cOccs)) {
            return false;
        }
        HashSet<CorrStdOcc> hashSet = new HashSet<CorrStdOcc>();
        for (Correlation c : this.corrStds) {
            hashSet.add(new CorrStdOcc(c.getCorrType(), c.getScope(), c.getDataTypes(), c.getVisibleOnly(), c.getDefaultStyle(), c.getInterpID(), c.getSchID(), c.getHier(), c.getMaxUnconfidence(), c.getCorrelateRangedIntervals(), c.getUseBlockInterp()));
        }
        if (!this.template.getCorrStdOccs().equals(hashSet)) {
            return false;
        }
        Set cTagTemplates = this.tags.stream().map(t -> new ChartTagTemplate(this.getTemplate().getID(), (ChartTag)((Object)((Object)t)), this)).collect(Collectors.toSet());
        return cTagTemplates.equals(this.template.getTagTemplates());
    }

    public List<ChartBlockBase> getBlocks() {
        return new LinkedList<ChartBlockBase>(this.blocks);
    }

    public int getnBlocks(BlockType blockType) {
        return (int)this.blocks.stream().filter(b -> b.getBlockType() == blockType).count();
    }

    public boolean hasDifferentBlockTypes() {
        return this.blocks.stream().collect(Collectors.groupingBy(ChartBlockBase::getBlockType)).size() > 1;
    }

    public ChartBlockBase getBlock(Point2D p, Mode hMode, Mode vMode) {
        return this.getBlockPosition(p, hMode, vMode, null);
    }

    public ChartBlockBase getBlockPosition(Point2D p, Mode hMode, Mode vMode, Point2D positionInBlock) {
        if (p == null) {
            return null;
        }
        if (this.layout == null || this.layout.blockPositions == null || this.layout.blockPositions.length != this.blocks.size()) {
            return null;
        }
        ChartLayout.Position pos = ChartLayout.translateToBlockPos(new ChartLayout.Position((float)p.getX(), (float)p.getY()), vMode, hMode, this.chartProperties, this.getRowHeaderWidth());
        float x = pos.x();
        float y = pos.y();
        for (int i = 0; i < this.blocks.size(); ++i) {
            ChartBlockBase block = this.blocks.get(i);
            ChartLayout.Position bp = this.layout.blockPositions[i];
            float blockWidth = block.getWidth(this.chartProperties);
            if (!(x > bp.x()) || !(x < bp.x() + blockWidth) || !(y > bp.y()) || !(y < bp.y() + block.getTotalHeight(this.chartProperties, hMode))) continue;
            if (positionInBlock != null) {
                positionInBlock.setLocation(x - bp.x(), y - (bp.y() + (hMode == Mode.NO_HEADER ? 0.0f : block.getHeaderHeight(this.chartProperties))));
            }
            return block;
        }
        return null;
    }

    public Point2D.Float getBlockTopLeftPosition(ChartBlockBase block) {
        if (this.layout == null || block == null || this.blocks.indexOf(block) < 0 || this.blocks.indexOf(block) > this.layout.blockPositions.length) {
            return null;
        }
        ChartLayout.Position p = this.layout.blockPositions[this.blocks.indexOf(block)];
        return new Point2D.Float(p.x(), p.y());
    }

    public ChartTag getTag(Point2D p) {
        for (ChartTag tag : this.tagArtist.getTagOrderForSelection(this.tags)) {
            if (!tag.contains(p)) continue;
            return tag;
        }
        return null;
    }

    public Object getTagOrBlock(Point2D p) {
        ChartTag t = this.getTag(p);
        if (t != null) {
            return t;
        }
        ChartBlockBase block = this.getBlock(p, Mode.NORMAL, Mode.NORMAL);
        return block;
    }

    public ChartPanel getPanel(Point2D p, Mode hMode, Mode vMode) {
        return this.getPanel(p, hMode, vMode, null, null);
    }

    public ChartPanel getPanel(Point2D p, Mode hMode, Mode vMode, Point2D pointInPanel) {
        return this.getPanel(p, hMode, vMode, pointInPanel, null);
    }

    public ChartPanel getPanel(Point2D p, Mode hMode, Mode vMode, Point2D pointInPanel, Point2D panelOrigin) {
        Point2D.Float positionInBlock = new Point2D.Float();
        ChartBlockBase block = this.getBlockPosition(p, hMode, vMode, positionInBlock);
        if (block != null) {
            if (block instanceof ChartBlock) {
                ChartBlock chartBlock = (ChartBlock)block;
                ChartPanel panel = chartBlock.getPanel(positionInBlock.x, positionInBlock.y, this.chartProperties);
                if (panel != null && pointInPanel != null) {
                    float panelOriginInBlockX = chartBlock.getPanelOrigin((SBPanel)panel, this.chartProperties, false).floatValue();
                    pointInPanel.setLocation(positionInBlock.x - panelOriginInBlockX, positionInBlock.y);
                    if (panelOrigin != null) {
                        panelOrigin.setLocation(panelOriginInBlockX, positionInBlock.y);
                    }
                }
                return panel;
            }
            return block.getSelectedPanel().orElse(block.members().findFirst().orElse(null));
        }
        return null;
    }

    private String getScaleString() {
        class ScalePair {
            Float floatScale;
            boolean variable;

            public ScalePair(Chart this$0, float floatScale, boolean variable) {
                Objects.requireNonNull(this$0);
                this.floatScale = Float.valueOf(floatScale);
                this.variable = variable;
            }
        }
        BlockProperties.ScaleType[] types;
        HashMap map = new HashMap();
        map.put(BlockProperties.ScaleType.MD, null);
        map.put(BlockProperties.ScaleType.AGE, null);
        map.put(BlockProperties.ScaleType.TWT, null);
        this.chartBlocks(null).forEach(block -> {
            BlockProperties.ScaleType type = block.getProp().getScaleType();
            if (type != BlockProperties.ScaleType.AGE && type != BlockProperties.ScaleType.TWT) {
                type = BlockProperties.ScaleType.MD;
            }
            if (map.containsKey((Object)type)) {
                if (map.get((Object)type) == null) {
                    ScalePair value = new ScalePair(this, block.getProp().getScale(block.getProp().getLongestSection()), block.getProp().getnScaleSections() > 1);
                    map.put(type, value);
                } else if (Math.abs(((ScalePair)map.get((Object)((Object)((Object)type)))).floatScale.floatValue() - block.getProp().getScale(block.getProp().getLongestSection())) > 1.0f) {
                    map.remove((Object)type);
                }
            }
        });
        Object scaleString = "";
        for (BlockProperties.ScaleType type : types = new BlockProperties.ScaleType[]{BlockProperties.ScaleType.MD, BlockProperties.ScaleType.AGE, BlockProperties.ScaleType.TWT}) {
            if (map.get((Object)type) == null) continue;
            if (!((String)scaleString).isEmpty()) {
                scaleString = (String)scaleString + ", ";
            }
            switch (type) {
                case MD: {
                    scaleString = (String)scaleString + "1:" + ((ScalePair)map.get((Object)((Object)BlockProperties.ScaleType.MD))).floatScale.intValue();
                    break;
                }
                case AGE: {
                    scaleString = (String)scaleString + ((ScalePair)map.get((Object)((Object)BlockProperties.ScaleType.AGE))).floatScale.intValue() + "mm/Ma";
                    break;
                }
                case TWT: {
                    scaleString = (String)scaleString + "1:" + ((ScalePair)map.get((Object)((Object)BlockProperties.ScaleType.TWT))).floatScale.intValue() + " m/msec";
                }
            }
            if (!((ScalePair)map.get((Object)((Object)type))).variable) continue;
            scaleString = (String)scaleString + " (variable)";
        }
        if (((String)scaleString).isEmpty()) {
            scaleString = "various";
        }
        return scaleString;
    }

    private ChartLayout translateLayout(Mode hMode, Mode vMode) {
        ChartLayout t = new ChartLayout();
        float headerHeight = this.getHeaderHeight();
        float rowHeaderWidth = this.getRowHeaderWidth();
        t.blankPanelWidths = this.layout.blankPanelWidths;
        t.chartWidth = switch (vMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.layout.chartWidth;
            case 2 -> this.layout.chartWidth - rowHeaderWidth;
            case 1 -> rowHeaderWidth;
        };
        t.chartHeight = switch (hMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.layout.chartHeight;
            case 2 -> this.layout.chartHeight - headerHeight;
            case 1 -> headerHeight;
        };
        t.blockPositions = (ChartLayout.Position[])Arrays.stream(this.layout.blockPositions).map(pos -> ChartLayout.translateBlockPos(pos, vMode, hMode, this.chartProperties)).toArray(ChartLayout.Position[]::new);
        if (this.layout.blockCaptionPositions != null) {
            t.blockCaptionPositions = (ChartLayout.Position[])Arrays.stream(this.layout.blockCaptionPositions).map(pos -> ChartLayout.translateBlockCaptionPos(pos, vMode, hMode, this.chartProperties.blockCapTop, this.chartProperties.margin, headerHeight)).toArray(ChartLayout.Position[]::new);
        }
        if (this.layout.keyPos != null && this.chartProperties.key != null) {
            t.keyPos = this.layout.keyPos;
            Consumer<ChartLayout> keyTranslator = ChartLayout.getKeyTranslator(t, this.chartProperties.key.orientation, hMode, vMode, this.chartProperties.margin, rowHeaderWidth, headerHeight);
            if (keyTranslator != null) {
                keyTranslator.accept(t);
            }
        }
        if (this.layout.headerPos != null && this.chartProperties.header != null) {
            t.headerPos = this.layout.headerPos;
            t.headerWidth = this.layout.headerWidth;
            Consumer<ChartLayout> headerTranslator = ChartLayout.getHeaderTranslator(t, this.chartProperties.header.orientation, hMode, vMode, this.chartProperties.margin, rowHeaderWidth, headerHeight);
            if (headerTranslator != null) {
                headerTranslator.accept(t);
            }
        }
        return t;
    }

    public void draw(SBGraphics g, Mode hMode, Mode vMode) {
        List<BlockColumn> columns;
        Set wellSet;
        ChartBlock blockSingle;
        SBdb sbdb;
        if (this.layout == null || this.layout.blockPositions == null || this.blocks.size() != this.layout.blockPositions.length) {
            return;
        }
        if (this.blocks.size() != this.layout.blockPositions.length) {
            return;
        }
        ChartLayout tLayout = this.translateLayout(hMode, vMode);
        g.setGreyscale(this.chartProperties.greyscale);
        g.setColor(this.chartProperties.foreground);
        g.setStroke(0.4f);
        float halfLine = 0.0f;
        if (this.chartProperties.border) {
            g.drawRect(0.0f, 0.0f, tLayout.chartWidth - 0.4f, tLayout.chartHeight - 0.4f);
        }
        this.chartProperties.getKeyData().clear();
        this.chartProperties.keyIsVisible = this.chartProperties.key != null && tLayout.keyPos != null ? g.isVisible(tLayout.keyPos.pos().x(), tLayout.keyPos.pos().y(), tLayout.keyPos.w(), tLayout.keyPos.h()) : false;
        Well well = null;
        Object depthIntervalStr = "";
        Object tdStr = "";
        ChartTemplateBase templ = this.getTemplate();
        String wellListName = null;
        if (templ != null && templ.getWellListID() > 0 && (sbdb = (SBdb)this.blocks.stream().map(b -> b.getDb()).findFirst().orElse(null)) != null) {
            wellListName = ((WellList)sbdb.getWellListService().getWellList(templ.getWellListID())).getName();
        }
        if (this.getBlockSingle() != null && this.getBlockSingle() instanceof ChartBlock && (blockSingle = (ChartBlock)this.getBlockSingle()).getWells().size() == 1) {
            well = blockSingle.getWell();
            if (templ == null) {
                templ = blockSingle.getTemplate();
            }
            float min = blockSingle.getMDLimit(true);
            float max = blockSingle.getMDLimit(false);
            char blockUnits = blockSingle.getProp().getUnits();
            String unitChar = DepthUnits.getUnits((char)blockUnits).getIndicatorStr();
            if (well.getType() == 'O') {
                min = -min;
                max = -max;
            } else if (well.getTD() > 0.0) {
                tdStr = DepthUtils.convFromM((double)well.getTD(), (char)blockUnits) + unitChar;
            }
            depthIntervalStr = min > 0.0f && (double)Math.abs(min) < 1.0 || max > 0.0f && (double)Math.abs(max) < 1.0 ? DepthUtils.convFromM((float)min, (char)blockUnits) + unitChar + " - " + DepthUtils.convFromM((float)max, (char)blockUnits) + unitChar : (int)DepthUtils.convFromM((float)min, (char)blockUnits) + unitChar + " - " + (int)DepthUtils.convFromM((float)max, (char)blockUnits) + unitChar;
        }
        if (well == null && (wellSet = this.blocks.stream().filter(b -> b.getWells().size() == 1).flatMap(b -> b.getWells().stream()).collect(Collectors.toSet())).size() == 1) {
            well = (Well)wellSet.iterator().next();
        }
        if (this.chartProperties.header != null && tLayout.headerPos != null) {
            this.chartProperties.header.draw(g, tLayout.headerPos.x(), tLayout.headerPos.y(), tLayout.headerWidth, this.chartProperties, well, this.getScaleString(), templ, (String)depthIntervalStr, (String)tdStr, wellListName);
        }
        if ((columns = ChartLayout.getColumns(this.blocks)).size() > 1) {
            if (this.chartProperties.bgSchID > 0) {
                for (int i = 0; i < columns.size() - 1; ++i) {
                    BlockColumn col1 = columns.get(i);
                    BlockColumn col2 = columns.get(i + 1);
                    if (col1 instanceof ChartBlockColumn) {
                        ChartBlockColumn cbc1 = (ChartBlockColumn)col1;
                        if (col2 instanceof ChartBlockColumn) {
                            ChartBlockColumn cbc2 = (ChartBlockColumn)col2;
                            ChartBlockBase block1 = cbc1.getBlocks().get(0);
                            ChartBlockBase block2 = cbc2.getBlocks().get(0);
                            if (block1 instanceof WellBlock) {
                                WellBlock wb0 = (WellBlock)block1;
                                if (block2 instanceof WellBlock) {
                                    WellBlock wb1 = (WellBlock)block2;
                                    if (wb0.getWellID() == wb1.getWellID() && wb0.getTemplate().getID() == wb1.getTemplate().getID()) continue;
                                }
                            }
                        }
                    }
                    float xLeft = tLayout.blockPositions[this.blocks.indexOf(col1.getBlocks().get(0))].x() + col1.getWidth(this.chartProperties);
                    float xRight = tLayout.blockPositions[this.blocks.indexOf(col2.getBlocks().get(0))].x();
                    Function<BlockColumn, List> getDrawZonesFromColumn = t -> {
                        ArrayList drawZones = new ArrayList();
                        for (ChartBlockBase b : t.getBlocks()) {
                            float blockypos = tLayout.blockPositions[this.blocks.indexOf(b)].y();
                            List<DrawZone> bZones = b.getBackgroundZones();
                            bZones.forEach(z -> drawZones.add(z.transformed(z.getYTop() + blockypos + b.getHeaderHeight(this.chartProperties), z.getYBase() + blockypos + b.getHeaderHeight(this.chartProperties))));
                        }
                        return drawZones;
                    };
                    List zones1 = getDrawZonesFromColumn.apply(col1);
                    List zones2 = getDrawZonesFromColumn.apply(col2);
                    if (zones1 == null || zones1.isEmpty() || zones2 == null || zones2.isEmpty()) continue;
                    if (this.chartProperties.bgPinchouts && col1.plotPinchouts() && col2.plotPinchouts()) {
                        SBdb sbdb2 = this.blocks.stream().map(b -> b.getDb()).findFirst().orElse(null);
                        this.drawBackgroundIGDPinchout(g, zones1, zones2, tLayout, xLeft, xRight, sbdb2);
                        continue;
                    }
                    this.drawBackgroundIGD(g, zones1, zones2, tLayout, xLeft, xRight);
                }
            }
            this.drawCorrelationPanels(g, tLayout);
        }
        for (int i = 0; i < this.blocks.size(); ++i) {
            ChartBlockBase block = this.blocks.get(i);
            ChartLayout.Position pos = tLayout.blockPositions[i];
            block.drawBlock(g, pos.x(), tLayout.blockPositions[i].y(), this.chartProperties, hMode, i == 0 ? vMode : Mode.NORMAL);
            if (tLayout.blockCaptionPositions == null || tLayout.blockCaptionPositions[i] == null) continue;
            ChartLayout.Position capPos = tLayout.blockCaptionPositions[i];
            block.drawCaption(g, capPos.x(), capPos.y(), this.chartProperties, i == 0 && vMode == Mode.NO_HEADER);
        }
        if (this.chartProperties.keyIsVisible) {
            this.corrStds.stream().filter(corrStd -> !corrStd.getLines().isEmpty()).forEach(c -> this.chartProperties.keyData.putCorrelation((Correlation)c));
            this.correlations.forEach(c -> c.getLines().forEach(line -> this.blocks.stream().filter(b -> b instanceof ChartBlock).map(b -> (ChartBlock)b).forEach(block -> {
                if (block.getYPos((CorrelationLine)line) != null) {
                    this.chartProperties.keyData.putCorrLine((CorrelationLine)line, line.getStyle() != null ? line.getStyle() : c.getDefaultLineStyle());
                }
            })));
            if (this.chartProperties.key != null && tLayout.keyPos != null) {
                this.chartProperties.key.draw(g, tLayout.keyPos.pos().x(), tLayout.keyPos.pos().y(), tLayout.keyPos.w(), tLayout.keyPos.h(), this.chartProperties);
            }
        }
        if (this.drawTags && this.tags != null && !this.tags.isEmpty() && this.blocks != null && !this.blocks.isEmpty()) {
            this.drawChartTags(g);
        }
    }

    private void drawChartTags(SBGraphics g) {
        this.tagArtist.drawChartTags(g, this.tags, this);
    }

    private void drawCorrelationPanels(SBGraphics g, ChartLayout tLayout) {
        record CorrelationPointBlock(CorrelationPoint p, float xLeft, float xRight) {
        }
        g.setFont(this.chartProperties.font, 0, this.chartProperties.getFontSize());
        record CorrelationColumn(BlockColumn column, Set<CorrelationPointBlock> positionedLines) {
            private final Set<CorrelationPointBlock> positionedLines;

            CorrelationColumn(BlockColumn column, Set<CorrelationPointBlock> positionedLines) {
                this.column = column;
                this.positionedLines = positionedLines;
            }

            public Set<CorrelationPointBlock> positionedLines() {
                return this.positionedLines;
            }
        }
        ArrayList<CorrelationColumn> corrColumns = new ArrayList<CorrelationColumn>();
        List<BlockColumn> columns = ChartLayout.getColumns(this.blocks);
        for (BlockColumn blockColumn : columns) {
            HashSet<CorrelationPointBlock> positionedLinesForColumn = new HashSet<CorrelationPointBlock>();
            for (ChartBlockBase block : blockColumn.getBlocks()) {
                int blockIndex = this.blocks.indexOf(block);
                float blockYpos = tLayout.blockPositions[blockIndex].y() + block.getHeaderHeight(this.chartProperties);
                float xLeft = tLayout.blockPositions[blockIndex].x();
                float xRight = xLeft + block.getWidth(this.chartProperties);
                for (CorrelationType cType : CorrelationType.values()) {
                    for (CorrelationPoint p : block.getCorrelationLines(cType)) {
                        positionedLinesForColumn.add(new CorrelationPointBlock(new CorrelationPoint(p, p.ypos() + blockYpos), xLeft, xRight));
                    }
                }
            }
            corrColumns.add(new CorrelationColumn(blockColumn, positionedLinesForColumn));
        }
        for (int i = 0; i < columns.size(); ++i) {
            CorrelationColumn correlationColumn = (CorrelationColumn)corrColumns.get(i);
            block5: for (CorrelationPointBlock p : correlationColumn.positionedLines) {
                float ypos1 = p.p.ypos();
                if (i < columns.size() - 1) {
                    int maxCol = this.chartProperties.isDrawCorrelationTicks() ? columns.size() - 1 : i + 1;
                    for (int r = i + 1; r <= maxCol; ++r) {
                        CorrelationColumn column2 = (CorrelationColumn)corrColumns.get(r);
                        boolean foundInCol = false;
                        for (CorrelationPointBlock p2 : column2.positionedLines) {
                            if (p2.p.line() != p.p.line()) continue;
                            if (p2.p.isObserved() || p.p.isObserved()) {
                                float xpos1 = p.xRight;
                                float xpos2 = p2.xLeft;
                                float ypos2 = p2.p.ypos();
                                Color c = null;
                                if (r > i + 1) {
                                    ypos2 = ypos1 + this.chartProperties.blankPanel / 4.0f * (ypos2 - ypos1) / Math.abs(xpos2 - xpos1);
                                    xpos2 = xpos1 + this.chartProperties.blankPanel / 4.0f;
                                    c = this.chartProperties.background;
                                }
                                if (p.p.line().getStyle().getBnd() == null) {
                                    CorrDrawUtils.drawCorrelationLine(g, p.p.line(), xpos1, xpos2, ypos1, ypos2, c, true, this.chartProperties, p.p.bnd(), p2.p.bnd());
                                } else {
                                    CorrDrawUtils.drawCorrelationLine(g, p.p.line(), xpos1, xpos2, ypos1, ypos2, c, true, this.chartProperties, new Boundary[0]);
                                }
                            }
                            foundInCol = true;
                        }
                        if (foundInCol) break;
                    }
                }
                if (i <= 1 || !this.chartProperties.isDrawCorrelationTicks()) continue;
                for (int j = i - 1; j >= 0; --j) {
                    CorrelationColumn column2 = (CorrelationColumn)corrColumns.get(j);
                    boolean foundInBlock = false;
                    for (CorrelationPointBlock p2 : column2.positionedLines) {
                        if (p2.p.line() != p.p.line()) continue;
                        if (j != i - 1 && (p2.p.isObserved() || p.p.isObserved())) {
                            float xpos1 = p.xLeft;
                            float xpos2 = p2.xRight;
                            float ypos2 = p2.p.ypos();
                            Color c = this.chartProperties.background;
                            ypos2 = ypos1 + this.chartProperties.blankPanel / 4.0f * (ypos2 - ypos1) / Math.abs(xpos2 - xpos1);
                            xpos2 = xpos1 - this.chartProperties.blankPanel / 4.0f;
                            if (p.p.line().getStyle().getBnd() == null) {
                                CorrDrawUtils.drawCorrelationLine(g, p.p.line(), xpos1, xpos2, ypos1, ypos2, c, true, this.chartProperties, p.p.bnd(), p2.p.bnd());
                            } else {
                                CorrDrawUtils.drawCorrelationLine(g, p.p.line(), xpos1, xpos2, ypos1, ypos2, c, true, this.chartProperties, new Boundary[0]);
                            }
                        }
                        foundInBlock = true;
                    }
                    if (foundInBlock) continue block5;
                }
            }
        }
    }

    private void drawBackgroundIGD(SBGraphics g, List<DrawZone> zones1, List<DrawZone> zones2, ChartLayout tLayout, float xLeft, float xRight) {
        for (DrawZone dz1 : zones1) {
            int u1;
            Object object = dz1.getObject();
            if (object instanceof IGDUnitBase) {
                IGDUnitBase unitBase = (IGDUnitBase)object;
                u1 = unitBase.getUnitID();
            } else {
                object = dz1.getObject();
                if (object instanceof IGDIntervalZone) {
                    IGDIntervalZone zone = (IGDIntervalZone)object;
                    u1 = zone.getUppZone();
                } else {
                    assert (false);
                    continue;
                }
            }
            for (DrawZone dz2 : zones2) {
                int u2;
                Object object2 = dz2.getObject();
                if (object2 instanceof IGDUnitBase) {
                    IGDUnitBase unitBase = (IGDUnitBase)object2;
                    u2 = unitBase.getUnitID();
                } else {
                    object2 = dz2.getObject();
                    if (object2 instanceof IGDIntervalZone) {
                        IGDIntervalZone zone = (IGDIntervalZone)object2;
                        u2 = zone.getUppZone();
                    } else {
                        assert (false);
                        continue;
                    }
                }
                if (u1 != u2) continue;
                float[] xp = new float[]{xLeft, xRight, xRight, xLeft};
                float[] yp = new float[]{dz1.getYTop(), dz2.getYTop(), dz2.getYBase(), dz1.getYBase()};
                assert (dz1.getUppColour().equals(dz2.getUppColour()));
                g.setColor(dz1.getUppColour());
                g.fillPolygon(xp, yp, 4);
            }
        }
    }

    private void drawBackgroundIGDPinchout(SBGraphics g, List<DrawZone> zones1, List<DrawZone> zones2, ChartLayout tLayout, float xLeft, float xRight, SBdb sbdb) {
        IGDScheme scheme;
        Comparator drawZoneComparator = (o1, o2) -> {
            if (o1.getYTop() < o2.getYTop()) {
                return -1;
            }
            if (o1.getYTop() > o2.getYTop()) {
                return 1;
            }
            return 0;
        };
        Collections.sort(zones1, drawZoneComparator);
        Collections.sort(zones2, drawZoneComparator);
        try {
            scheme = sbdb.getIGDScheme(this.chartProperties.bgSchID);
        }
        catch (SQLException sql) {
            sql.printStackTrace();
            return;
        }
        class MeltingPot
        implements Comparator<DrawZone[]> {
            List<DrawZone[]> pairs;
            List<DrawZone> lhs;
            List<DrawZone> rhs;
            final IGDScheme scheme;

            MeltingPot(Chart this$0, IGDScheme scheme) {
                Objects.requireNonNull(this$0);
                this.pairs = new LinkedList<DrawZone[]>();
                this.scheme = scheme;
            }

            private List<DrawZone> getList(boolean left) {
                return left ? this.lhs : this.rhs;
            }

            private List<DrawZone> getOtherList(boolean left) {
                return left ? this.rhs : this.lhs;
            }

            private void createList(boolean left, DrawZone firstElement) {
                if (left) {
                    this.lhs = new LinkedList<DrawZone>();
                } else {
                    this.rhs = new LinkedList<DrawZone>();
                }
                this.getList(left).add(firstElement);
            }

            private int getDrawZoneInt(DrawZone dz) {
                int u = 0;
                Object object = dz.getObject();
                if (object instanceof IGDUnitBase) {
                    IGDUnitBase unitBase = (IGDUnitBase)object;
                    u = unitBase.getUnitID();
                } else {
                    object = dz.getObject();
                    if (object instanceof IGDIntervalZone) {
                        IGDIntervalZone zone = (IGDIntervalZone)object;
                        u = zone.getUppZone();
                    } else assert (false);
                }
                return u;
            }

            void throwIn(DrawZone toAdd, boolean left) {
                if (this.getList(left) == null) {
                    this.createList(left, toAdd);
                    if (this.getList(!left) == null) {
                        return;
                    }
                }
                int toAddU = this.getDrawZoneInt(toAdd);
                if (!this.pairs.isEmpty()) {
                    assert (this.pairs.get(this.pairs.size() - 1)[0] != null && this.pairs.get(this.pairs.size() - 1)[1] != null);
                    int lastU = this.getDrawZoneInt(this.pairs.get(this.pairs.size() - 1)[0]);
                    if (toAddU == lastU) {
                        DrawZone[] drawZoneArray;
                        if (left) {
                            DrawZone[] drawZoneArray2 = new DrawZone[2];
                            drawZoneArray2[0] = toAdd;
                            drawZoneArray = drawZoneArray2;
                            drawZoneArray2[1] = this.pairs.get(this.pairs.size() - 1)[1];
                        } else {
                            DrawZone[] drawZoneArray3 = new DrawZone[2];
                            drawZoneArray3[0] = this.pairs.get(this.pairs.size() - 1)[0];
                            drawZoneArray = drawZoneArray3;
                            drawZoneArray3[1] = toAdd;
                        }
                        this.pairs.add(drawZoneArray);
                        return;
                    }
                }
                List<DrawZone> toSearch = this.getOtherList(left);
                for (int i = 0; i < toSearch.size(); ++i) {
                    DrawZone zone = toSearch.get(i);
                    int zoneU = this.getDrawZoneInt(zone);
                    if (zoneU != toAddU) continue;
                    assert (!left ? toSearch == this.lhs : toSearch == this.rhs);
                    List<DrawZone> subList = toSearch.subList(0, i);
                    this.addLopsidedPairs(left ? this.lhs : subList, left ? subList : this.rhs);
                    if (left) {
                        assert (this.rhs == toSearch);
                        this.rhs = this.rhs.subList(i + 1, this.rhs.size());
                        this.lhs.clear();
                    } else {
                        this.lhs = this.lhs.subList(i + 1, this.lhs.size());
                        this.rhs.clear();
                    }
                    this.pairs.add(new DrawZone[]{left ? toAdd : zone, left ? zone : toAdd});
                    return;
                }
                this.getList(left).add(toAdd);
            }

            private void addLopsidedPairs(List<DrawZone> leftList, List<DrawZone> rightList) {
                LinkedList<DrawZone[]> listToAdd = new LinkedList<DrawZone[]>();
                for (DrawZone z : leftList) {
                    listToAdd.add(new DrawZone[]{z, null});
                }
                for (DrawZone z : rightList) {
                    listToAdd.add(new DrawZone[]{null, z});
                }
                Collections.sort(listToAdd, this);
                this.pairs.addAll(listToAdd);
            }

            void finish() {
                this.addLopsidedPairs(this.lhs, this.rhs);
            }

            @Override
            public int compare(DrawZone[] o1, DrawZone[] o2) {
                DrawZone z1 = o1[0] != null ? o1[0] : o1[1];
                DrawZone z2 = o2[0] != null ? o2[0] : o2[1];
                try {
                    double age1 = Optional.ofNullable(this.scheme.findUnitBase(this.getDrawZoneInt(z1)).getUage()).orElse(0.0);
                    double age2 = Optional.ofNullable(this.scheme.findUnitBase(this.getDrawZoneInt(z2)).getUage()).orElse(0.0);
                    if (age1 < age2) {
                        return -1;
                    }
                    if (age2 > age1) {
                        return 1;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return 0;
            }

            private void printStatus(DrawZone toAdd, boolean left) {
                System.out.println("------------------------------after " + (left ? "lhs" : "rhs") + " throwIn " + String.valueOf(toAdd.getObject()) + "***");
                System.out.println("PAIRS (" + this.pairs.size() + ")");
                for (DrawZone[] pair : this.pairs) {
                    System.out.println(String.valueOf(pair[0] != null ? pair[0].getObject() : "null") + "    " + String.valueOf(pair[1] != null ? pair[1].getObject() : "null"));
                }
                System.out.println("***");
                System.out.println("lhs: " + String.valueOf(this.lhs));
                System.out.println("rhs: " + String.valueOf(this.rhs));
                System.out.println("***");
            }
        }
        MeltingPot pot = new MeltingPot(this, scheme);
        int maxItems = Math.max(zones1.size(), zones2.size());
        for (int i = 0; i < maxItems; ++i) {
            if (zones1.size() > i) {
                pot.throwIn(zones1.get(i), true);
            }
            if (zones2.size() <= i) continue;
            pot.throwIn(zones2.get(i), false);
        }
        pot.finish();
        List<DrawZone[]> pairs = pot.pairs;
        float[] xp = new float[]{xLeft, xRight, xRight, xLeft};
        boolean U1 = false;
        boolean U2 = true;
        int L2 = 2;
        int L1 = 3;
        for (int i = 0; i < pairs.size(); ++i) {
            Float below;
            Float above;
            float[] yp = new float[4];
            DrawZone[] pair = pairs.get(i);
            if (pair[0] != null) {
                yp[0] = pair[0].getYTop();
                yp[3] = pair[0].getYBase();
            } else {
                float pinchPoint;
                above = null;
                for (int j = i; j >= 0; --j) {
                    if (pairs.get(j)[0] == null) continue;
                    if (!pairs.get(j)[0].baseBoundary().map(Boundary::isDisconformable).orElse(false).booleanValue()) break;
                    above = Float.valueOf(pairs.get(j)[0].getYBase());
                    break;
                }
                below = null;
                for (int j = i; j < pairs.size(); ++j) {
                    if (pairs.get(j)[0] == null) continue;
                    if (!pairs.get(j)[0].topBoundary().map(Boundary::isDisconformable).orElse(false).booleanValue() && !(pairs.get(j)[0].getTopDepth() < (double)0.0029f)) break;
                    below = Float.valueOf(pairs.get(j)[0].getYTop());
                    break;
                }
                if (above != null && below != null) {
                    pinchPoint = above.floatValue() + (below.floatValue() - above.floatValue()) / 2.0f;
                } else if (above != null) {
                    pinchPoint = above.floatValue();
                } else {
                    if (below == null) continue;
                    pinchPoint = below.floatValue();
                }
                yp[0] = pinchPoint;
                yp[3] = pinchPoint;
            }
            if (pair[1] != null) {
                yp[1] = pair[1].getYTop();
                yp[2] = pair[1].getYBase();
            } else {
                float pinchPoint;
                above = null;
                for (int j = i; j >= 0; --j) {
                    if (pairs.get(j)[1] == null) continue;
                    if (!pairs.get(j)[1].baseBoundary().map(Boundary::isDisconformable).orElse(false).booleanValue()) break;
                    above = Float.valueOf(pairs.get(j)[1].getYBase());
                    break;
                }
                below = null;
                for (int j = i; j < pairs.size(); ++j) {
                    if (pairs.get(j)[1] == null) continue;
                    if (!pairs.get(j)[1].topBoundary().map(Boundary::isDisconformable).orElse(false).booleanValue() && !(pairs.get(j)[1].getTopDepth() < (double)0.0029f)) break;
                    below = Float.valueOf(pairs.get(j)[1].getYTop());
                    break;
                }
                if (above != null && below != null) {
                    pinchPoint = above.floatValue() + (below.floatValue() - above.floatValue()) / 2.0f;
                } else if (above != null) {
                    pinchPoint = above.floatValue();
                } else {
                    if (below == null) continue;
                    pinchPoint = below.floatValue();
                }
                yp[1] = pinchPoint;
                yp[2] = pinchPoint;
            }
            if (pair[0] != null && pair[1] != null) assert (pair[0].getUppColour().equals(pair[1].getUppColour()));
            g.setColor(pair[0] != null ? pair[0].getUppColour() : pair[1].getUppColour());
            g.fillPolygon(xp, yp, 4);
        }
    }

    public void drawWatermark(SBGraphics g, boolean useAlpha) {
        this.draw(g, Mode.NORMAL, Mode.NORMAL);
        if (useAlpha) {
            g.setColor(new Color(192, 192, 192, 100));
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        g.setFontSize(Math.min(this.layout.chartWidth / 4.0f, 300.0f));
        for (float ypos = this.chartProperties.margin + g.stringHeightSB() * 2.0f; ypos < this.layout.chartHeight; ypos += g.stringHeightSB() * 2.0f) {
            g.drawString("DEMO", this.layout.chartWidth / 2.0f - SBGraphics.stringWidth("DEMO", this.layout.chartWidth / 4.0f) / 2.0f, ypos);
        }
    }

    public static RenderedImage getChartImage(Chart chart, boolean demoLicence) {
        int nPix = (int)(chart.getMMheight() * chart.getMMwidth());
        long maxMemory = Runtime.getRuntime().maxMemory();
        System.out.println("maxMemory: " + maxMemory + " nPix: " + nPix);
        float scale = (float)Math.sqrt(maxMemory / (long)(nPix * 20));
        if (scale > 10.0f) {
            scale = 10.0f;
        } else if (scale < 1.0f) {
            return null;
        }
        System.out.println("Using scale : " + scale);
        int width = (int)(chart.getMMwidth() * scale);
        int height = (int)(chart.getMMheight() * scale);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setClip(0, 0, width, height);
        AffineTransform tnf = new AffineTransform();
        tnf.scale(scale / 100.0f, scale / 100.0f);
        g.transform(tnf);
        SBGraphics sbg = new SBGraphics(g, null, true, true);
        sbg.setColor(Color.WHITE);
        sbg.fillRect(0.0f, 0.0f, width, height);
        g.setColor(Color.BLACK);
        ChartBlockBase selectedBlock = null;
        for (ChartBlockBase block : chart.getBlocks()) {
            if (block.isSelected()) {
                selectedBlock = block;
            }
            block.setSelected(false);
            block.setTemplateSelected(false);
        }
        if (demoLicence) {
            chart.drawWatermark(sbg, true);
        } else {
            chart.draw(sbg, Mode.NORMAL, Mode.NORMAL);
        }
        chart.draw(sbg, Mode.NORMAL, Mode.NORMAL);
        chart.setSelectedBlock(selectedBlock);
        return bufferedImage;
    }

    public Point2D.Float getMmPanelOrigin(SBPanel panel, Mode hMode, Mode vMode, float xInPanel) {
        ChartLayout tLayout = this.translateLayout(hMode, vMode);
        for (int i = 0; i < this.blocks.size(); ++i) {
            ChartBlock chartBlock;
            Float panelOriginX;
            ChartBlockBase block = this.blocks.get(i);
            if (!(block instanceof ChartBlock) || (panelOriginX = (chartBlock = (ChartBlock)block).getPanelOrigin(panel, this.chartProperties, vMode == Mode.NO_HEADER && block == this.blocks.get(0))) == null) continue;
            float x = tLayout.blockPositions[i].x() + panelOriginX.floatValue();
            float y = tLayout.blockPositions[i].y();
            if (hMode != Mode.NO_HEADER) {
                y += block.getHeaderHeight(this.chartProperties);
            }
            return new Point2D.Float(x, y);
        }
        return null;
    }

    public Point2D.Float getMmPoint(Point2D.Float pointInPanel, SBPanel panel, Mode hMode, Mode vMode, float xInPanel) {
        Point2D.Float panelOrigin = this.getMmPanelOrigin(panel, hMode, vMode, xInPanel);
        return new Point2D.Float(panelOrigin.x + pointInPanel.x, panelOrigin.y + pointInPanel.y);
    }

    public Optional<ChartBlockBase> getSelectedBlock() {
        return this.blocks.stream().filter(b -> b.isSelected()).findFirst();
    }

    public Optional<ChartTag> getSelectedTag() {
        return this.tags.stream().filter(ChartTag::isSelected).findFirst();
    }

    public float getMMwidth() {
        if (this.layout.chartWidth < 0.0f) {
            this.calcChartSize();
        }
        return this.layout.chartWidth;
    }

    public float getMMheight() {
        if (this.layout.chartHeight < 0.0f) {
            this.calcChartSize();
        }
        return this.layout.chartHeight;
    }

    public float getMMheight(Mode mode) {
        if (this.layout.chartHeight < 0.0f) {
            this.calcChartSize();
        }
        switch (mode.ordinal()) {
            default: {
                return this.layout.chartHeight;
            }
            case 2: {
                return this.layout.chartHeight - this.getHeaderHeight();
            }
            case 1: 
        }
        return this.getHeaderHeight() + 0.2f;
    }

    public float getMMwidth(Mode mode) {
        if (this.layout.chartWidth < 0.0f) {
            this.calcChartSize();
        }
        switch (mode.ordinal()) {
            default: {
                return this.layout.chartWidth;
            }
            case 2: {
                return this.layout.chartWidth - this.getRowHeaderWidth();
            }
            case 1: 
        }
        return this.getRowHeaderWidth() + 0.2f;
    }

    public void doLayout() {
        this.layout = new ChartLayout();
        float halfLine = 0.0f;
        float xpos = this.chartProperties.margin + halfLine;
        float ypos = this.chartProperties.margin + halfLine;
        if (this.chartProperties.key != null) {
            switch (this.chartProperties.key.orientation) {
                case LEFT: {
                    xpos += this.chartProperties.key.height;
                    break;
                }
                case TOP: {
                    ypos += this.chartProperties.key.height;
                }
            }
        }
        if (this.chartProperties.header != null && this.chartProperties.header.orientation == PanelWellHeader.Orientation.TOP) {
            ypos += this.chartProperties.header.height;
        }
        float maxHdrHeight = (float)this.blocks.stream().mapToDouble(block -> block.getHeaderHeight(this.chartProperties)).max().orElse(0.0);
        List<BlockColumn> columns = ChartLayout.getColumns(this.blocks);
        for (BlockColumn col2 : columns) {
            if (!(col2 instanceof ChartBlockColumn)) continue;
            ChartBlockColumn cbc = (ChartBlockColumn)col2;
            col2.ypos = cbc.block.getDatumOffset() + (maxHdrHeight - cbc.block.getHeaderHeight(this.chartProperties));
        }
        this.layout.blankPanelWidths = ChartLayout.calcBlankPanels(this.chartProperties, columns);
        float minOffset = (float)columns.stream().mapToDouble(pb -> pb.ypos).min().orElse(0.0);
        for (int i = 0; i < columns.size(); ++i) {
            BlockColumn column2 = columns.get(i);
            column2.ypos = ypos + column2.ypos - minOffset;
            column2.xpos = xpos;
            xpos += column2.getWidth(this.chartProperties);
            if (i >= this.layout.blankPanelWidths.length) continue;
            xpos += this.layout.blankPanelWidths[i];
        }
        float maxBlockPos = (float)columns.stream().mapToDouble(col -> col.ypos + col.getTotalHeight(this.chartProperties)).max().orElse(ypos);
        if (this.chartProperties.alignMaps) {
            for (int i = 0; i < columns.size(); ++i) {
                BlockColumn blockColumn;
                BlockColumn column3 = columns.get(i);
                if (!(column3 instanceof MapColumn)) continue;
                MapColumn mapCol = (MapColumn)column3;
                ChartBlockColumn referenceColumn = null;
                if (i > 0 && (blockColumn = columns.get(i - 1)) instanceof ChartBlockColumn) {
                    ChartBlockColumn lhCol;
                    referenceColumn = lhCol = (ChartBlockColumn)blockColumn;
                } else if (i < columns.size() - 1 && (blockColumn = columns.get(i + 1)) instanceof ChartBlockColumn) {
                    ChartBlockColumn rhCol;
                    referenceColumn = rhCol = (ChartBlockColumn)blockColumn;
                }
                if (referenceColumn == null) continue;
                Float[] preferredYPositions = new Float[mapCol.mapBlocks.size()];
                for (int j = 0; j < mapCol.mapBlocks.size(); ++j) {
                    MapBlock mapBlock = mapCol.mapBlocks.get(j);
                    preferredYPositions[j] = switch (mapBlock.getProp().getDataRangeStyle()) {
                        default -> throw new MatchException(null, null);
                        case MapBlockProperties.DataRangeStyle.BOUNDARIES -> referenceColumn.getYPos(mapBlock.getProp().getScaleMidpoint(), this.chartProperties);
                        case MapBlockProperties.DataRangeStyle.LITHOSTRAT -> referenceColumn.getYPos(mapBlock.getProp().getUpperLithostratUnit(), this.chartProperties);
                    };
                }
                mapCol.setBlockPositions(preferredYPositions, maxBlockPos, this.chartProperties);
            }
        }
        ArrayList blockPositions = new ArrayList();
        columns.forEach(column -> blockPositions.addAll(column.getBlockPositions(this.chartProperties)));
        this.layout.blockPositions = blockPositions.toArray(new ChartLayout.Position[blockPositions.size()]);
        this.layout.chartHeight = maxBlockPos + this.chartProperties.getHeaderFooterHeight(false) + (this.chartProperties.plotBlockCaptions && !this.chartProperties.blockCapTop ? this.chartProperties.blockCapHeight : 0.0f) + this.chartProperties.margin + halfLine;
        if (this.chartProperties.key != null && this.chartProperties.key.orientation == PanelKey.Orientation.RIGHT) {
            xpos += this.chartProperties.key.height;
        }
        this.layout.chartWidth = Math.max(xpos, this.findRightmostTagEdge()) + this.chartProperties.margin + halfLine;
        if (this.chartProperties.key != null) {
            float keyX = switch (this.chartProperties.key.orientation) {
                default -> throw new MatchException(null, null);
                case PanelKey.Orientation.LEFT, PanelKey.Orientation.TOP, PanelKey.Orientation.BOTTOM -> this.chartProperties.margin + halfLine;
                case PanelKey.Orientation.RIGHT -> this.layout.chartWidth - this.chartProperties.margin - this.chartProperties.key.height - halfLine;
            };
            float keyY = switch (this.chartProperties.key.orientation) {
                default -> throw new MatchException(null, null);
                case PanelKey.Orientation.LEFT, PanelKey.Orientation.TOP, PanelKey.Orientation.RIGHT -> this.chartProperties.margin + halfLine + (this.chartProperties.header != null && this.chartProperties.header.orientation == PanelWellHeader.Orientation.TOP ? this.chartProperties.header.height : 0.0f);
                case PanelKey.Orientation.BOTTOM -> this.layout.chartHeight - this.chartProperties.margin - this.chartProperties.key.height - halfLine;
            };
            float keyWidth = switch (this.chartProperties.key.orientation) {
                default -> throw new MatchException(null, null);
                case PanelKey.Orientation.TOP, PanelKey.Orientation.BOTTOM -> this.layout.chartWidth - this.chartProperties.margin * 2.0f;
                case PanelKey.Orientation.LEFT, PanelKey.Orientation.RIGHT -> this.chartProperties.key.height;
            };
            float keyHeight = switch (this.chartProperties.key.orientation) {
                default -> throw new MatchException(null, null);
                case PanelKey.Orientation.TOP, PanelKey.Orientation.BOTTOM -> this.chartProperties.key.height;
                case PanelKey.Orientation.LEFT, PanelKey.Orientation.RIGHT -> this.layout.chartHeight - this.chartProperties.margin * 2.0f - (this.chartProperties.header != null ? this.chartProperties.header.height : 0.0f);
            };
            this.layout.keyPos = new ChartLayout.KeyLayout(new ChartLayout.Position(keyX, keyY), keyWidth, keyHeight);
        }
        if (this.chartProperties.header != null) {
            float headerX = this.chartProperties.margin;
            float headerY = switch (this.chartProperties.header.orientation) {
                default -> throw new MatchException(null, null);
                case PanelWellHeader.Orientation.TOP -> this.chartProperties.margin + halfLine;
                case PanelWellHeader.Orientation.BOTTOM -> this.layout.chartHeight - this.chartProperties.margin - halfLine - this.chartProperties.header.height - (this.chartProperties.key != null && this.chartProperties.key.orientation == PanelKey.Orientation.BOTTOM ? this.chartProperties.key.height : 0.0f);
            };
            this.layout.headerPos = new ChartLayout.Position(headerX, headerY);
            this.layout.headerWidth = this.layout.chartWidth - this.chartProperties.margin * 2.0f - halfLine * 2.0f;
        }
        if (this.chartProperties.plotBlockCaptions) {
            this.layout.blockCaptionPositions = new ChartLayout.Position[this.layout.blockPositions.length];
            for (int i = 0; i < this.layout.blockPositions.length; ++i) {
                float capY;
                ChartLayout.Position pos = this.layout.blockPositions[i];
                boolean isMap = this.blocks.get(i) instanceof MapBlock;
                float capX = pos.x();
                if (!isMap && this.chartProperties.blockCapAlignChart) {
                    capY = this.chartProperties.blockCapTop ? this.chartProperties.margin + this.chartProperties.getHeaderFooterHeight(true) : this.layout.chartHeight - this.chartProperties.getHeaderFooterHeight(false) - this.chartProperties.blockCapHeight;
                } else {
                    capY = pos.y();
                    capY = this.chartProperties.blockCapTop ? (capY -= this.chartProperties.blockCapHeight) : (capY += this.blocks.get(i).getTotalHeight(this.chartProperties, Mode.NORMAL));
                }
                this.layout.blockCaptionPositions[i] = new ChartLayout.Position(capX, capY);
            }
        }
    }

    private float findRightmostTagEdge() {
        float furthestX = 0.0f;
        Comparator<ChartTag> compareRightEdge = Comparator.comparing(t -> Float.valueOf(t.x + t.width));
        Optional<ChartTag> rightmost = this.tags.stream().sorted(compareRightEdge.reversed()).findFirst();
        if (rightmost.isPresent()) {
            furthestX = rightmost.get().x + rightmost.get().width;
        }
        return furthestX;
    }

    public boolean calcChartSize() {
        ChartLayout originalLayout = this.layout;
        this.doLayout();
        return originalLayout == null || (double)Math.abs(this.layout.chartWidth - originalLayout.chartWidth) > 0.1 || (double)Math.abs(this.layout.chartHeight - originalLayout.chartHeight) > 0.1;
    }

    public Rectangle2D.Float getBlockBounds(ChartBlockBase block) {
        if (!this.blocks.contains(block) || this.layout.blockPositions.length != this.blocks.size()) {
            return null;
        }
        ChartLayout.Position pos = this.layout.blockPositions[this.blocks.indexOf(block)];
        return new Rectangle2D.Float(pos.x(), pos.y(), block.getWidth(this.chartProperties), block.getTotalHeight(this.chartProperties, Mode.NORMAL));
    }

    public float getHeaderHeight() {
        float h = (float)this.blocks.stream().mapToDouble(b -> b.getHeaderHeight(this.chartProperties)).max().orElse(0.0);
        if (this.chartProperties.plotBlockCaptions && this.chartProperties.blockCapTop) {
            h += this.chartProperties.blockCapHeight;
        }
        if (this.chartProperties.header != null && this.chartProperties.header.orientation == PanelWellHeader.Orientation.TOP) {
            h += this.chartProperties.header.height;
        }
        if (this.chartProperties.key != null && this.chartProperties.key.orientation == PanelKey.Orientation.TOP) {
            h += this.chartProperties.key.height;
        }
        return this.chartProperties.margin + h;
    }

    public float getRowHeaderWidth() {
        float w = 0.0f;
        if (this.blocks.isEmpty()) {
            return w;
        }
        return w + this.blocks.get(0).getVheaderWidth(this.chartProperties.getnVfreeze(), this.chartProperties.drawEmptyPanels) + this.chartProperties.margin;
    }

    public SchemeBlock getSchemeBlock() {
        return this.blocks.stream().filter(b -> b.getClass().equals(SchemeBlock.class)).findFirst().map(b -> (SchemeBlock)b).orElse(null);
    }

    public WellBlock getWellBlock() {
        return this.blocks.stream().filter(b -> b.getClass().equals(WellBlock.class)).findFirst().map(b -> (WellBlock)b).orElse(null);
    }

    public LocationBlock getLocationBlock() {
        return this.blocks.stream().filter(b -> b.getClass().equals(LocationBlock.class)).findFirst().map(b -> (LocationBlock)b).orElse(null);
    }

    public SchemeBlock getAddSchemeBlock() {
        SchemeBlock block = this.getSchemeBlock();
        if (block == null) {
            block = new SchemeBlock((SBdb)null);
            this.blocks.add(block);
        }
        return block;
    }

    public Point2D getSchemeOrigin(IGDScheme scheme) {
        for (ChartBlockBase block : this.blocks) {
            if (!(block instanceof SchemeBlock)) continue;
            SchemeBlock schemeBlock = (SchemeBlock)block;
            for (SBPanel panel : schemeBlock.getPanels()) {
                PanelLithostratScheme schemePanel;
                PanelIGDScheme schemePanel2;
                if (!(panel instanceof PanelIGDScheme ? (schemePanel2 = (PanelIGDScheme)panel).getScheme() == scheme : panel instanceof PanelLithostratScheme && (schemePanel = (PanelLithostratScheme)panel).getScheme() == scheme)) continue;
                return schemeBlock.getPanelOrigin(panel);
            }
        }
        return null;
    }

    public void setData() throws SBException, SQLException, IOException {
        for (ChartBlockBase block : this.blocks) {
            block.setData(this.chartProperties);
        }
        this.setCorrelationData();
        this.triggerRepaint();
        this.setTagPositionData();
    }

    public void setData(ChartBlockBase block) throws SBException, SQLException, IOException {
        for (ChartBlockBase b : this.blocks) {
            if (b != block) continue;
            b.setData(this.chartProperties);
            this.setCorrelationData();
            this.setTagPositionData();
            return;
        }
    }

    public void setData(Correlation corr) throws SBException, SQLException {
        this.setCorrelationData();
    }

    private List<Well> getChartWells() {
        return this.chartBlocks(BlockType.WELL).map(b -> ((WellBlock)b).getWell()).collect(Collectors.toList());
    }

    private void triggerRepaint() {
        this.setChanged();
        this.notifyListeners();
    }

    @Override
    public void onChartEvent(ChartEvent e) {
        if (e == null) {
            LOGGER.log(Level.WARNING, "Chart.onChartEvent: {0}", e);
            return;
        }
        boolean tagsUpdated = false;
        switch (e.getType()) {
            case SOFT: {
                this.triggerRepaint();
                return;
            }
            case PROPERTY: {
                if (e.getSource() != null) {
                    ChartNode chartNode;
                    boolean datumSet;
                    if (e.getSource() instanceof Correlation) {
                        try {
                            this.setCorrelationData();
                        }
                        catch (RuntimeException | SQLException | SBException ex) {
                            StackError.showStackError((String)"Error", (Throwable)ex);
                        }
                        this.triggerRepaint();
                        return;
                    }
                    boolean correlationPresent = !this.correlations.isEmpty() || !this.corrStds.isEmpty();
                    boolean bl = datumSet = this.chartProperties.getChartDatum() != ChartProperties.ChartDatum.NONE && this.blocks.size() > 1;
                    if (e.getSource() instanceof ChartBlockBase && (correlationPresent || datumSet)) {
                        try {
                            this.setCorrelationData();
                        }
                        catch (RuntimeException | SQLException | SBException ex) {
                            StackError.showStackError((String)"Error", (Throwable)ex);
                        }
                    }
                    if ((chartNode = e.getSource()) instanceof MapBlock) {
                        MapBlock mp = (MapBlock)chartNode;
                        if (e.getArg() == MapBlock.SCALE_LIMITS_CHANGED_FLAG) {
                            this.doLayout();
                            this.updateChartTagPositionsFromDepth(mp);
                            tagsUpdated = true;
                        }
                    }
                }
                this.fireChartUpdate(e);
                if (!tagsUpdated) {
                    this.setTagPositionData(e);
                }
                this.triggerRepaint();
                break;
            }
            case DATA: {
                if (e.isUrgent()) {
                    this.fireChartUpdate(e);
                    this.triggerRepaint();
                    break;
                }
                this.updatesPending.add(e);
            }
        }
    }

    private void fireChartUpdate(ChartEvent e) {
        ChartUpdate update = new ChartUpdate(this.chartProperties);
        Iterator<ChartNode> pathIterator = e.getPathIterator();
        while (pathIterator.hasNext()) {
            ChartNode node = pathIterator.next();
            node.prepareData(update);
            if (pathIterator.hasNext()) continue;
            try {
                node.setData(e, update);
            }
            catch (IOException | RuntimeException | SQLException | SBException ex) {
                StackError.showStackError((String)"Error", (Throwable)ex);
            }
        }
    }

    public void updateTagAnchorBlocks() {
        this.setTagAnchorBlocks();
        this.updateTagDepthData();
    }

    private void setTagAnchorBlocks() {
        if (this.layout == null) {
            return;
        }
        this.tags.stream().filter(t -> t.getAnchorBlock() == null || !(t.getAnchorBlock() instanceof MapBlock)).forEach(t -> {
            Point2D.Float point = t.hasTargetSet() ? t.getTarget() : t.getPosition();
            ChartBlockBase block = this.getBlock(point, Mode.NORMAL, Mode.NORMAL);
            t.setAnchorBlock(block);
        });
    }

    private void setTagPositionData(ChartEvent e) {
        if (e.getArg() != null && e.getArg() instanceof ChartPropertyChangedNotification) {
            for (ChartTag t : this.tags) {
                t.updateDepthIfScaleTypeChanged(this, e);
            }
        }
        this.setTagPositionData();
    }

    private void setTagPositionData() {
        if (this.layout == null) {
            return;
        }
        for (ChartTag t : this.tags) {
            Point2D.Float p = this.getBlockTopLeftPosition(t.getAnchorBlock());
            if (p == null) continue;
            t.updateYPosFromDepth(this, p);
        }
    }

    private void updateTagDepthData() {
        for (ChartTag t : this.tags) {
            Point2D.Float p = this.getBlockTopLeftPosition(t.getAnchorBlock());
            if (p == null) continue;
            t.updateDepthFromYPos(this, p);
        }
    }

    private void startRefresh() {
        Runnable checker = new Runnable(this){
            final /* synthetic */ Chart this$0;
            {
                Chart chart = this$0;
                Objects.requireNonNull(chart);
                this.this$0 = chart;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (this.this$0.updatesPending.isEmpty()) {
                        return;
                    }
                    ChartTreeNode root = new ChartTreeNode(null);
                    for (ChartEvent chartEvent : this.this$0.updatesPending) {
                        ChartTreeNode currentRoot = root;
                        Iterator<ChartNode> pathIterator = chartEvent.getPathIterator();
                        block9: while (pathIterator.hasNext()) {
                            ChartNode chartNode = pathIterator.next();
                            try {
                                for (ChartTreeNode treeNode : currentRoot.getChildren()) {
                                    if (treeNode.getNode() != chartNode) continue;
                                    currentRoot = treeNode;
                                    continue block9;
                                }
                                ChartTreeNode newTreeNode = new ChartTreeNode(chartNode);
                                currentRoot.addChild(newTreeNode);
                                currentRoot = newTreeNode;
                            }
                            finally {
                                if (pathIterator.hasNext()) continue;
                                currentRoot.setArg(chartEvent.getArg());
                                currentRoot.clearChildren();
                            }
                        }
                    }
                    ChartUpdate update = new ChartUpdate(this.this$0.chartProperties);
                    for (ChartTreeNode treeNode : root.getChildren()) {
                        treeNode.prepareAndUpdate(ChartEvent.createDataChangeChartEvent(null, treeNode.getArg()), update);
                    }
                    this.this$0.updatesPending.clear();
                    try {
                        this.this$0.setCorrelationData();
                    }
                    catch (RuntimeException | SQLException | SBException throwable) {
                        StackError.showStackError((String)"Error", (Throwable)throwable);
                    }
                    this.this$0.triggerRepaint();
                }
                catch (Exception ex) {
                    System.out.println("Exception in refresh.run");
                    ex.printStackTrace();
                }
            }
        };
        this.future = UPDATE_SCHEDULER.scheduleAtFixedRate(checker, 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    public void writeHTML(FileWriter out) throws IOException, SBException {
        for (ChartBlockBase block : this.blocks) {
            if (!(block instanceof WellBlock)) continue;
            ((WellBlock)block).writeHTML(out, this.chartProperties);
            return;
        }
        throw new SBException("No well block to export");
    }

    public List<Correlation> getCorrelations() {
        LinkedList<Correlation> list = new LinkedList<Correlation>();
        list.addAll(this.correlations);
        list.addAll(this.corrStds);
        return list;
    }

    public boolean hasCorrelations() {
        if (!this.correlations.isEmpty()) {
            return true;
        }
        return !this.corrStds.isEmpty();
    }

    public void setDatum(Correlation c, CorrelationLine[] datum) {
        assert (this.correlations.contains(c));
        if (c.hasDatum() && datum != null && c.getDatumPrimary() == datum[0] && c.getDatumSecondary() == datum[1]) {
            return;
        }
        for (Correlation correlation : this.correlations) {
            if (correlation == c && datum != null) {
                correlation.setDatum(datum);
                continue;
            }
            correlation.clearDatum();
        }
        BlockUtils.setBlockDatumOffsets(this.blocks, this.correlations, this.chartProperties);
        this.setChanged();
        this.notifyListeners();
    }

    public boolean doesBlockNeedRefreshAfterWellChange() {
        LOGGER.log(Level.WARNING, "checking for template chage");
        for (ChartBlock block : this.getChartBlocks()) {
            BlockTemplateChild childTemplate;
            BlockTemplateParent parentTemplate;
            if (!(block instanceof WellBlock)) continue;
            WellBlock wb = (WellBlock)block;
            int wellId = wb.getWellID();
            BlockTemplate blockTemplate = wb.getTemplate();
            if (!(blockTemplate instanceof BlockTemplateParent ? (parentTemplate = (BlockTemplateParent)blockTemplate).getChildWellIDs().contains(wellId) : (blockTemplate = wb.getTemplate()) instanceof BlockTemplateChild && (childTemplate = (BlockTemplateChild)blockTemplate).getWellID() != wellId)) continue;
            return true;
        }
        return false;
    }

    public ChartTemplate getTemplate() {
        return this.template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTemplate(SBdb sbdb) throws SQLException, SBException, IOException, SBPermissionException {
        if (this.template == null) {
            throw new IllegalStateException("Chart has null template");
        }
        if (this.template.getID() == 0) {
            throw new IllegalStateException("Chart template has ID 0");
        }
        LinkedList<ChartTemplate.BlockOcc> bOccs = new LinkedList<ChartTemplate.BlockOcc>();
        for (ChartBlockBase chartBlockBase : this.blocks) {
            int templateID = chartBlockBase.getTemplate().getParentID() != null ? chartBlockBase.getTemplate().getParentID().intValue() : chartBlockBase.getTemplate().getID();
            bOccs.add(new ChartTemplate.BlockOcc(templateID, chartBlockBase.getWellID(), chartBlockBase.getWellListID(), chartBlockBase.getInterpID(), chartBlockBase.getProperties(), chartBlockBase.getCaption()));
        }
        HashSet<CorrTemplateOcc> cOccs = new HashSet<CorrTemplateOcc>();
        for (Correlation c : this.correlations) {
            cOccs.add(new CorrTemplateOcc(c.getTemplateID(), c.getInterpID(), c.getVisibleOnly(), c.getDefaultStyle(), c.getDatumString(), c.getMaxUnconfidence(), c.getCorrelateRangedIntervals(), c.getUseBlockInterp()));
        }
        HashSet<CorrStdOcc> hashSet = new HashSet<CorrStdOcc>();
        for (Correlation c : this.corrStds) {
            hashSet.add(new CorrStdOcc(c.getCorrType(), c.getScope(), c.getDataTypes(), c.getVisibleOnly(), c.getDefaultStyle(), c.getInterpID(), c.getSchID(), c.getHier(), c.getMaxUnconfidence(), c.getCorrelateRangedIntervals(), c.getUseBlockInterp()));
        }
        this.updateTagDepthData();
        HashSet<ChartTagTemplate> cTagTemplates = new HashSet<ChartTagTemplate>();
        this.tags.forEach(t -> cTagTemplates.add(new ChartTagTemplate(this.getTemplate().getID(), (ChartTag)((Object)((Object)t)), this)));
        this.updatingTemplate = true;
        try {
            this.template.update(sbdb, bOccs, cOccs, hashSet, cTagTemplates, this.chartProperties.getProperties(), this.chartProperties.getHeader(), this.chartProperties.getKey(), this.chartProperties.bgSchID);
        }
        finally {
            this.updatingTemplate = false;
        }
    }

    public void updateFromTemplate(SBdb sbdb) throws SQLException, SBException, IOException {
        if (this.updatingTemplate) {
            return;
        }
        System.out.println(String.valueOf(this) + " Chart updating from template...");
        if (!(this.template.getProperties().equals(this.chartProperties.getProperties()) && this.template.getSchID() == this.chartProperties.bgSchID && SB.equal((Object)this.template.getHeaderProperties(), (Object)this.chartProperties.getHeader()) && SB.equal((Object)this.template.getKeyProperties(), (Object)this.chartProperties.getKey()))) {
            this.chartProperties = new ChartProperties(this.template.getProperties(), this.template.getSchID());
            if (this.template.getHeaderProperties() != null) {
                this.chartProperties.header = new PanelWellHeader(this.template.getHeaderProperties());
            }
            if (this.template.getKeyProperties() != null) {
                this.chartProperties.key = new PanelKey(this.template.getKeyProperties());
            }
            this.setChanged();
        }
        LinkedList<ChartTemplate.BlockOcc> bOccs = new LinkedList<ChartTemplate.BlockOcc>();
        for (ChartBlockBase chartBlockBase : this.blocks) {
            bOccs.add(new ChartTemplate.BlockOcc(chartBlockBase.getTemplate().getID(), chartBlockBase.getWellID(), chartBlockBase.getWellListID(), chartBlockBase.getInterpID(), chartBlockBase.getProperties(), chartBlockBase.getCaption()));
        }
        if (!bOccs.equals(this.template.getBlocks())) {
            this.blocks.clear();
            for (ChartTemplate.BlockOcc blockOcc : this.template.getBlocks()) {
                ChartBlockBase block = ChartFactory.createBlock(sbdb, this.template.getBlockTemplate(blockOcc.getBlockID()), blockOcc);
                this.addBlock(block);
            }
            this.setChanged();
            if (this.templatedBlockListener != null) {
                this.templatedBlockListener.blocksBlatted(this);
            }
        }
        HashSet<CorrTemplateOcc> cOccs = new HashSet<CorrTemplateOcc>();
        for (Correlation c : this.correlations) {
            cOccs.add(new CorrTemplateOcc(c.getTemplateID(), c.getInterpID(), c.getVisibleOnly(), c.getDefaultStyle(), c.getDatumString(), c.getMaxUnconfidence(), c.getCorrelateRangedIntervals(), c.getUseBlockInterp()));
        }
        if (!cOccs.equals(this.template.getCorrOccs())) {
            this.correlations.clear();
            for (CorrTemplateOcc occ : this.template.getCorrOccs()) {
                CorrelationTemplate cTempl = this.template.getCorrelationTemplate(occ.getCorrschID());
                this.addCorrelation(Correlation.createCorrelation(cTempl, occ));
            }
            this.setChanged();
        }
        HashSet<CorrStdOcc> hashSet = new HashSet<CorrStdOcc>();
        for (Correlation c : this.corrStds) {
            hashSet.add(new CorrStdOcc(c.getCorrType(), c.getScope(), c.getDataTypes(), c.getVisibleOnly(), c.getDefaultStyle(), c.getInterpID(), c.getSchID(), c.getHier(), c.getMaxUnconfidence(), c.getCorrelateRangedIntervals(), c.getUseBlockInterp()));
        }
        if (!hashSet.equals(this.template.getCorrStdOccs())) {
            this.corrStds.clear();
            for (CorrStdOcc occ : this.template.getCorrStdOccs()) {
                this.addCorrelation(Correlation.createCorrelation(occ, sbdb));
            }
            this.setChanged();
        }
        if (this.hasChanged) {
            this.setData();
        }
        this.notifyListeners();
    }

    public void putTemplatedBlockListener(TemplatedBlockListener l) {
        this.templatedBlockListener = l;
    }

    public void wellDeleted(int wellID) {
        ListIterator<ChartBlockBase> blockIt = this.blocks.listIterator();
        while (blockIt.hasNext()) {
            ChartBlockBase block = blockIt.next();
            if (block.getWell() == null) continue;
            List<Well> wells = block.getWells();
            ListIterator<Well> it = wells.listIterator();
            while (it.hasNext()) {
                Well well = it.next();
                if (well.getWellID() != wellID) continue;
                it.remove();
            }
            if (wells.size() == block.getWells().size()) continue;
            if (wells.isEmpty() && block instanceof WellBlock) {
                block.deleteListener(this);
                blockIt.remove();
            } else {
                try {
                    if (wells.isEmpty()) {
                        block.setWell(null);
                    } else {
                        block.setWells(wells.iterator());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error setting wells", e);
                }
            }
            this.setChanged();
        }
        this.notifyListeners();
    }

    public void setSelectedBlock(ChartBlockBase selected) {
        this.blocks.forEach(block -> {
            block.setSelected(block == selected);
            block.setTemplateSelected(selected != null && block.getTemplate() == selected.getTemplate());
        });
    }

    public void setSelectedBlocks(BlockTemplate template) {
        this.blocks.forEach(block -> block.setTemplateSelected(block.getTemplate() == template));
    }

    public void setSelectedCorrelation(Correlation correlation) {
        this.correlations.forEach(c -> c.setSelected(c == correlation));
        this.corrStds.forEach(c -> c.setSelected(c == correlation));
    }

    public Correlation getSelectedCorrelation() {
        for (Correlation c : this.correlations) {
            if (!c.isSelected()) continue;
            return c;
        }
        for (Correlation c : this.corrStds) {
            if (!c.isSelected()) continue;
            return c;
        }
        return null;
    }

    public Correlation getCorrelationWithDatum() {
        return this.correlations.stream().filter(c -> c.hasDatum()).findFirst().orElse(null);
    }

    public void removeBlock(ChartBlockBase block) {
        this.blocks.remove(block);
        block.deleteListener(this);
        this.setChanged();
    }

    public void removeCorrelation(Correlation correlation) throws SBException, SQLException {
        if (this.correlations.remove(correlation) || this.corrStds.remove(correlation)) {
            System.out.println("Removing " + String.valueOf(correlation));
            correlation.deleteListener(this);
            this.setCorrelationData();
            this.setChanged();
            this.notifyListeners();
        }
    }

    public boolean hasCorrelation(Correlation correlation) {
        Predicate<Correlation> correlationPredicate = correlation.getTemplateID() > 0 ? c -> c.getTemplateID() == correlation.getTemplateID() && c.getInterpID() == correlation.getInterpID() : c -> c.getCorrType() == correlation.getCorrType() && c.getDataTypes().containsAll(correlation.getDataTypes()) && c.getInterpID() == correlation.getInterpID() && c.getScope().compareTo(correlation.getScope()) >= 0 && c.getSchID() == correlation.getSchID() && c.getHier() == correlation.getHier();
        return this.correlations.stream().anyMatch(correlationPredicate);
    }

    public boolean removeSelectedBlock() {
        Optional<ChartBlockBase> selected = this.blocks.stream().filter(ChartBlockBase::isSelected).findFirst();
        if (selected.isPresent()) {
            this.removeAnnotationsAnchoredToBlock(selected.get());
            this.blocks.remove(selected.get());
            return true;
        }
        return false;
    }

    private void removeAnnotationsAnchoredToBlock(ChartBlockBase block) {
        this.tags.removeIf(t -> block.equals(t.getAnchorBlock()));
    }

    public boolean moveSelectedBlock(boolean left) {
        Optional<ChartBlockBase> selectedOpt = this.blocks.stream().filter(ChartBlockBase::isSelected).findFirst();
        if (selectedOpt.isEmpty()) {
            return false;
        }
        ChartBlockBase selected = selectedOpt.get();
        int index = this.blocks.indexOf(selected);
        if (left && index == 0 || !left && index == this.blocks.size() - 1) {
            return false;
        }
        ChartLayout.Position oldPos = this.layout.blockPositions[index];
        this.blocks.remove(selected);
        int newIndex = index;
        newIndex = left ? --newIndex : ++newIndex;
        this.blocks.add(newIndex, selected);
        this.doLayout();
        ChartLayout.Position newPos = this.layout.blockPositions[newIndex];
        if (selected instanceof MapBlock) {
            MapBlock mapBlock = (MapBlock)selected;
            mapBlock.setViewportPosition(newPos.x(), newPos.y());
        }
        float xShift = newPos.x() - oldPos.x();
        float yShift = newPos.y() - oldPos.y();
        this.tags.stream().filter(t -> t.getAnchorBlock() == selected).forEach(t -> {
            t.y += yShift;
            t.x += xShift;
            if (t.hasTargetSet()) {
                t.getTarget().x += xShift;
                t.getTarget().y += yShift;
            }
        });
        return true;
    }

    public void updateChartTagPositionsFromDepth(MapBlock block) {
        int index = this.blocks.indexOf(block);
        if (index <= 0) {
            return;
        }
        ChartLayout.Position p = this.layout.blockPositions[index];
        Point2D.Float position = new Point2D.Float(p.x(), p.y());
        block.setViewportPosition(p.x(), p.y());
        this.tags.stream().filter(t -> t.getAnchorBlock() == block).forEach(t -> t.updateYPosFromDepth(this, position));
    }

    public boolean organiseBlocks(WellBlockOrder order) {
        if (this.blocks.size() < 2) {
            return false;
        }
        LinkedList<ChartBlockBase> orig = new LinkedList<ChartBlockBase>(this.blocks);
        WellBlockOrder.sortList(this.blocks, order);
        this.calcChartSize();
        return !this.blocks.equals(orig);
    }

    public void setProperties(ChartProperties chartProperties) {
        this.chartProperties = chartProperties;
        this.setChanged();
        this.notifyListeners();
    }

    public ChartProperties getProperties() {
        return this.chartProperties;
    }

    private void setCorrelationData() throws SBException, SQLException {
        if (!this.corrStds.isEmpty() || !this.correlations.isEmpty()) {
            LOGGER.config((this.getTemplate() != null ? this.getTemplate().getName() : "(No template)") + ": Setting correlation data...");
        }
        for (Correlation c : this.corrStds) {
            HashSet<CorrelationLine> hashSet = new HashSet<CorrelationLine>();
            HashSet<CorrelationLine> tempLines = null;
            if (c.getScope() == CorrelationScope.OCCTWO) {
                tempLines = new HashSet<CorrelationLine>();
            }
            block6: for (ChartBlockBase block : this.blocks) {
                Set<CorrelationLine> blockLines = block.getCorrelationLines(c, this.chartProperties);
                if (blockLines == null) continue;
                switch (c.getScope()) {
                    case ALL: {
                        hashSet.addAll(blockLines);
                        break;
                    }
                    case OCCALL: {
                        if (hashSet.isEmpty()) {
                            hashSet.addAll(blockLines);
                            break;
                        }
                        hashSet.retainAll(blockLines);
                        break;
                    }
                    case OCCTWO: {
                        for (CorrelationLine line : blockLines) {
                            if (tempLines.add(line)) continue;
                            hashSet.add(line);
                        }
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Attempt to add standard lines when scope is " + String.valueOf((Object)c.getScope()));
                    }
                }
            }
            c.setLines(hashSet);
        }
        LinkedList<List<Correlation>> corrs = new LinkedList<List<Correlation>>();
        corrs.add(this.correlations);
        corrs.add(this.corrStds);
        for (List list : corrs) {
            for (ChartBlockBase block : this.blocks) {
                if (list == this.correlations) {
                    block.clearCorrelationData();
                }
                for (Correlation c : list) {
                    block.addCorrelationData(c, this.chartProperties);
                }
            }
        }
        if (this.blocks.size() > 1) {
            BlockUtils.setBlockDatumOffsets(this.blocks, this.correlations, this.chartProperties);
        }
    }

    public List<ChartBlock> getChartBlocks() {
        return this.chartBlocks(null).collect(Collectors.toList());
    }

    private Stream<ChartBlock> chartBlocks(BlockType blockType) {
        return this.blocks.stream().filter(block -> block instanceof ChartBlock && (blockType == null || block.getBlockType() == blockType)).map(block -> (ChartBlock)block);
    }

    private Stream<MapBlock> mapBlocks() {
        return this.blocks.stream().filter(block -> block instanceof MapBlock).map(block -> (MapBlock)block);
    }

    public void loadLOCForBlocks(BlockType blockType) throws SBException, SQLException {
        for (ChartBlockBase b : this.blocks) {
            WellInterp i;
            if (b.getBlockType() != blockType || b.getWell() == null || (i = b.getWell().getInterp(b.getInterpID())) == null || i.getLOC() != null) continue;
            i.loadLOC(b.getWellID());
        }
    }

    public void setInterpID(int interpID) throws SQLException, SBException {
        for (ChartBlockBase block : this.blocks) {
            block.setInterpID(interpID);
        }
    }

    public void setUnits(BlockType blockType, DepthUnits units) throws InvalidFieldException {
        this.chartBlocks(blockType).forEachOrdered(block -> block.setUnits(units));
    }

    public void setWell(BlockType blockType, Well well) {
        assert (blockType == BlockType.SCHEME);
        this.chartBlocks(blockType).forEach(block -> block.setWell(well));
    }

    public HashSet<IGDScheme> getIGDSchemes(int igdType, int interpID, boolean visibleOnly, SBdb sbdb) throws SBException, SQLException {
        HashSet<Integer> schIds = new HashSet<Integer>();
        for (ChartBlockBase bBlock : this.blocks) {
            if (!(bBlock instanceof ChartBlock)) continue;
            ChartBlockBase block = (ChartBlock)bBlock;
            for (ChartPanel chartPanel : ((ChartBlock)block).getPanels()) {
                schIds.addAll(chartPanel.getVisibleSchemes(igdType));
            }
        }
        HashSet<IGDScheme> schemes = new HashSet<IGDScheme>();
        for (Integer id : schIds) {
            schemes.add(sbdb.getIGDScheme(id.intValue()));
        }
        if (!visibleOnly) {
            for (ChartBlockBase block : this.blocks) {
                if (block.getWell() == null) continue;
                WellInterp interp = block.getWell().getInterp(interpID);
                schemes.addAll(interp.getIGDSchemes(igdType));
            }
        }
        return schemes;
    }

    void setTags(List<ChartTag> tagsForChart) {
        this.tags = tagsForChart;
    }

    public void addTag(ChartTag tag) {
        this.tags.add(tag);
    }

    public boolean removeTag(ChartTag tag) {
        return this.tags.remove((Object)tag);
    }

    public List<ChartTag> getTags() {
        return new ArrayList<ChartTag>(this.tags);
    }

    public void addListener(Listener l) {
        this.listeners.addListener((Object)l);
    }

    public void deleteListener(Listener l) {
        this.listeners.deleteListener((Object)l);
    }

    public void notifyListeners() {
        if (this.hasChanged) {
            this.listeners.stream().forEach(Listener::chartChanged);
            this.hasChanged = false;
        }
    }

    private void setChanged() {
        this.hasChanged = true;
    }

    static {
        ((ScheduledThreadPoolExecutor)UPDATE_SCHEDULER).setRemoveOnCancelPolicy(true);
    }

    public static enum Mode {
        NORMAL,
        HEADER_ONLY,
        NO_HEADER;

    }

    public static interface Listener {
        public void chartChanged();
    }

    public static class ChartPref
    implements Comparable<ChartPref> {
        public String key;
        String value;
        int panelType = -1;
        int identifier = -1;
        int identifier2 = -1;

        public ChartPref(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(ChartPref o) {
            return this.key.compareTo(o.key);
        }

        public String toString() {
            return this.key + " " + this.value;
        }
    }
}

