/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.IBlockProperties;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.block.ProjectBlock;
import jsbchart.block.SchemeBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateChildException;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.Chart;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartPropertiesFactory;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelKey;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.core.PanelWellHeader;
import jsbchart.correlation.CorrStdOcc;
import jsbchart.correlation.CorrTemplateOcc;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationTemplate;
import jsbchart.graphics.map.WellEnvelopeHelper;
import jsbchart.tag.ChartTag;
import model3.IGDScheme;
import model3.LithostratUnit;
import model3.SBdb;
import model3.Well;
import model3.exception.SuppressedSQLException;
import model3.project.WellList;
import org.geotools.geometry.jts.ReferencedEnvelope;
import util.SBException;

public class ChartFactory {
    private static final Logger LOGGER = Logger.getLogger(ChartFactory.class.getName());

    public static Chart createChart(ChartTemplateBase template, ChartManager chartManager, SBdb sbdb, int wellID, int projID, int interpID, String blockProperties, String chartProp, String hdrProp, String keyProp, int schID) throws SQLException, SBException {
        Chart chart;
        if (template instanceof BlockTemplate) {
            BlockTemplate bt = (BlockTemplate)template;
            chart = new Chart();
            ChartFactory.setChartProperties(chart, sbdb, chartProp, hdrProp, keyProp, schID);
            ChartBlockBase block = ChartFactory.createBlock(bt, sbdb, wellID, projID, interpID, blockProperties, null);
            chart.addBlock(block);
        } else if (template instanceof ChartTemplate) {
            ChartTemplate ct = (ChartTemplate)template;
            ChartTemplate.BlockOcc blockOcc = new ChartTemplate.BlockOcc(0, wellID, projID, interpID, blockProperties, null);
            chart = ChartFactory.createChart(ct, sbdb, chartManager, blockOcc);
        } else {
            assert (false);
            return null;
        }
        return chart;
    }

    public static Chart createChart(BlockTemplate template, ChartManager chartManager, SBdb sbdb, String chartProp, String hdrProp, String keyProp, int schID, ChartTemplate.BlockOcc occ) throws SQLException, SBException {
        Chart chart = new Chart();
        ChartFactory.setChartProperties(chart, sbdb, chartProp, hdrProp, keyProp, schID);
        ChartBlockBase block = ChartFactory.createBlock(sbdb, template, occ);
        chart.addBlock(block);
        return chart;
    }

    private static void setChartProperties(Chart chart, SBdb sbdb, String chartProp, String hdrProp, String keyProp, int schID) {
        if (chartProp != null) {
            chart.setProperties(new ChartProperties(chartProp, schID));
        } else {
            ChartProperties decoded = ChartPropertiesFactory.newDecodedInstance(sbdb);
            if (decoded != null) {
                chart.setProperties(decoded);
            } else {
                chart.getProperties().margin = 5.0f;
                chart.getProperties().setPanelHeaderHeight(75.0f);
                chart.getProperties().setPanelCaptionHeight(9.0f);
                chart.getProperties().plotBlockCaptions = false;
            }
        }
        if (hdrProp != null && !hdrProp.isEmpty()) {
            chart.getProperties().header = new PanelWellHeader(hdrProp);
        }
        if (keyProp != null && !keyProp.isEmpty()) {
            chart.getProperties().key = new PanelKey(keyProp);
        }
    }

    public static Chart createChart(ChartTemplate templ, SBdb sbdb, ChartManager manager) throws SQLException, SBException {
        return ChartFactory.createChart(templ, sbdb, manager, null);
    }

    public static Chart createChart(ChartTemplate templ, SBdb sbdb, ChartManager manager, ChartTemplate.BlockOcc templOcc) throws SQLException, SBException {
        String keyProps;
        String string;
        Chart chart = new Chart(templ);
        BlockProperties sharedProperties = null;
        for (ChartTemplate.BlockOcc blockOcc : templ.getBlocks()) {
            ChartBlockBase block;
            BlockTemplate blockTemplate;
            try {
                blockTemplate = manager.getBlockTemplate(blockOcc.getBlockID());
            }
            catch (BlockTemplateChildException ex) {
                LOGGER.log(Level.WARNING, "Caught BlockTemplateChildException (id:{0}) - loading parent instead", ex.getChildTemplateID());
                blockTemplate = manager.getParentBlockTemplate(blockOcc.getBlockID());
            }
            if (templOcc != null && BlockType.inheritsWell(blockTemplate.getType()) && blockOcc.getWellID() == 0) {
                block = ChartFactory.createBlock(sbdb, blockTemplate, new ChartTemplate.BlockOcc(blockOcc.getBlockID(), templOcc.getWellID(), 0, templOcc.getInterpID(), templOcc.getProps(), blockOcc.getCaption()));
                if (sharedProperties == null) {
                    sharedProperties = ((ChartBlock)block).getProp();
                }
                ((ChartBlock)block).setProperties(sharedProperties);
            } else {
                block = ChartFactory.createBlock(sbdb, blockTemplate, blockOcc);
            }
            chart.addBlock(block);
        }
        for (CorrTemplateOcc corrTemplateOcc : templ.getCorrOccs()) {
            CorrelationTemplate cTempl = manager.getCorrTemplate(corrTemplateOcc.getCorrschID());
            chart.addCorrelation(Correlation.createCorrelation(cTempl, corrTemplateOcc));
        }
        for (CorrStdOcc corrStdOcc : templ.getCorrStdOccs()) {
            chart.addCorrelation(Correlation.createCorrelation(corrStdOcc, sbdb));
        }
        String props = templ.getProperties();
        if (props != null && !props.isEmpty()) {
            chart.setProperties(new ChartProperties(props, templ.getSchID()));
        }
        if ((string = templ.getHeaderProperties()) != null && !string.isEmpty()) {
            chart.getProperties().header = new PanelWellHeader(string);
        }
        if ((keyProps = templ.getKeyProperties()) != null && !keyProps.isEmpty()) {
            chart.getProperties().key = new PanelKey(keyProps);
        }
        chart.setTags(new ArrayList<ChartTag>(templ.getTags(chart)));
        return chart;
    }

    public static ChartBlockBase createBlock(BlockTemplate template, SBdb sbdb, int wellID, int projID, int interpID, String blockProperties, String caption) throws SQLException, SBException {
        ChartTemplate.BlockOcc blockOcc = new ChartTemplate.BlockOcc(template.getID(), wellID, projID, interpID, blockProperties, caption);
        return ChartFactory.createBlock(sbdb, template, blockOcc);
    }

    public static ChartBlockBase createBlock(SBdb sbdb, BlockTemplate templ) throws SQLException, SBException {
        return ChartFactory.createBlock(sbdb, templ, null);
    }

    public static ChartBlockBase createBlock(SBdb sbdb, BlockTemplate templ, ChartTemplate.BlockOcc occ) throws SQLException, SBException {
        return ChartFactory.createBlock(sbdb, templ, occ, null);
    }

    public static ChartBlockBase createBlock(SBdb sbdb, BlockTemplate templ, ChartTemplate.BlockOcc occ, Chart existingChartContext) throws SQLException, SBException {
        ChartBlockBase block;
        IBlockProperties bp = ChartFactory.createBlockProperties(templ.getType(), occ != null ? occ.getProps() : null, sbdb, existingChartContext);
        Well well = null;
        if (occ != null && occ.getWellID() > 0) {
            well = sbdb.getWell(occ.getWellID());
            well.initSamples();
            well.loadInterps();
        }
        WellList wellList = null;
        if (occ != null && occ.getWellListID() > 0) {
            wellList = (WellList)sbdb.getWellListService().getWellList(occ.getWellListID());
        }
        switch (templ.getType()) {
            case WELL: {
                BlockTemplateParent parent;
                if (well != null && (parent = (BlockTemplateParent)templ).getChild(well.getWellID()) != null) {
                    templ = parent.getChild(well.getWellID());
                }
                block = new WellBlock(sbdb, templ, well, (BlockProperties)bp);
                break;
            }
            case SCHEME: {
                block = new SchemeBlock(sbdb, templ, (BlockProperties)bp);
                if (well != null) {
                    block.setWell(well);
                    break;
                }
                if (wellList == null) break;
                block.setWellList(wellList);
                break;
            }
            case PROJECT: {
                ProjectBlock pBlock = new ProjectBlock(templ, wellList, sbdb, (BlockProperties)bp);
                if (pBlock.getProp().getScaleType() == BlockProperties.ScaleType.AGE) {
                    pBlock.loadInterps();
                }
                block = pBlock;
                break;
            }
            case MAP: {
                MapBlock mBlock = new MapBlock(sbdb, templ, (MapBlockProperties)bp);
                if (wellList != null) {
                    mBlock.setWellList(wellList);
                } else if (well != null) {
                    mBlock.setWell(well);
                }
                mBlock.loadInterps();
                if (!(occ != null && occ.getProps() != null || existingChartContext != null && existingChartContext.getBlocks().stream().filter(b -> b.getBlockType() == BlockType.MAP).count() != 0L)) {
                    ChartFactory.setDefaultMapBlockArea(mBlock.getProp(), mBlock.getWells());
                }
                block = mBlock;
                break;
            }
            default: {
                assert (false);
                throw new NullPointerException("No block created");
            }
        }
        if (occ != null) {
            block.setInterpID(occ.getInterpID());
        }
        for (PanelOcc po : templ.getPanels()) {
            try {
                PanelTemplate panelTemplate = templ.getPanelTemplate(po.getPanelID());
                block.addNewMember(panelTemplate, po);
            }
            catch (SBException se) {
                LOGGER.log(Level.SEVERE, "Caught SBException while loading panel template: ", se.getMessage());
            }
        }
        if (bp == null && templ.getType() == BlockType.SCHEME) {
            ((SchemeBlock)block).setTemplateProperties();
        }
        if (occ != null) {
            block.setCaption(occ.getCaption());
        }
        block.enable();
        return block;
    }

    private static IBlockProperties createBlockProperties(BlockType blockType, String propString, SBdb sbdb, Chart existingChartContext) {
        switch (blockType) {
            case MAP: {
                MapBlockProperties mapProp;
                List<MapBlock> mapBlocks;
                if (propString == null && existingChartContext != null && !(mapBlocks = existingChartContext.getBlocks().stream().filter(b -> b.getBlockType() == BlockType.MAP).map(b -> (MapBlock)b).toList()).isEmpty()) {
                    if (mapBlocks.size() == 1) {
                        propString = mapBlocks.get(0).getProperties();
                    } else {
                        MapBlockProperties defaultProp = new MapBlockProperties();
                        MapBlockProperties firstProp = mapBlocks.get(0).getProp();
                        Supplier<Stream> sup = () -> mapBlocks.stream().map(b -> b.getProp());
                        if (sup.get().allMatch(p -> p.getCrsCode() == firstProp.getCrsCode())) {
                            defaultProp.setCrsCode(firstProp.getCrsCode());
                        }
                        if (sup.get().allMatch(p -> (double)Math.abs(p.getSymbolSize() - firstProp.getSymbolSize()) < 0.1)) {
                            defaultProp.setSymbolSize(firstProp.getSymbolSize());
                        }
                        if (sup.get().allMatch(p -> (double)Math.abs(p.getDimension(true) - firstProp.getDimension(true)) < 0.1)) {
                            defaultProp.setDimension(true, firstProp.getDimension(true));
                        }
                        if (sup.get().allMatch(p -> (double)Math.abs(p.getDimension(false) - firstProp.getDimension(false)) < 0.1)) {
                            defaultProp.setDimension(false, firstProp.getDimension(false));
                        }
                        for (int i = 0; i < 4; ++i) {
                            int j = i;
                            if (!sup.get().allMatch(p -> Math.abs(p.getMapExtent(j) - firstProp.getMapExtent(j)) < 0.01)) continue;
                            defaultProp.setMapExtent(j, firstProp.getMapExtent(j));
                        }
                        propString = defaultProp.getProperties();
                    }
                }
                if ((mapProp = new MapBlockProperties(propString)).getUpperLithostratUnitID() > 0) {
                    try {
                        for (IGDScheme lithostratScheme : sbdb.getIGDSchemes(2, true)) {
                            LithostratUnit upperUnit = (LithostratUnit)lithostratScheme.findUnitBase(mapProp.getUpperLithostratUnitID());
                            LithostratUnit lowerUnit = (LithostratUnit)lithostratScheme.findUnitBase(mapProp.getLowerLithostratUnitID());
                            if (upperUnit == null) continue;
                            mapProp.setLithostratScheme(lithostratScheme, upperUnit, lowerUnit);
                            break;
                        }
                    }
                    catch (SQLException sqlex) {
                        throw SuppressedSQLException.withoutRollback((SQLException)sqlex);
                    }
                }
                return mapProp;
            }
        }
        if (propString == null || propString.isEmpty()) {
            return null;
        }
        return new BlockProperties(propString);
    }

    private static void setDefaultMapBlockArea(MapBlockProperties prop, Collection<Well> wells) {
        ReferencedEnvelope e = WellEnvelopeHelper.getWellEnvelope(wells);
        prop.updateExtent(e);
    }

    public static boolean replaceBlock(Chart chart, BlockTemplate templateToReplace, int wellID, SBdb sbdb) throws SQLException, SBException, IOException {
        boolean replacementMade = false;
        List<ChartBlockBase> copyOfBlocks = chart.getBlocks();
        for (int index = 0; index < copyOfBlocks.size(); ++index) {
            ChartBlockBase block = copyOfBlocks.get(index);
            if (block.getTemplate().getID() != templateToReplace.getID() || block.getWell().getWellID() != wellID) continue;
            BlockTemplate parentTemplate = templateToReplace;
            if (parentTemplate.getParentID() != null) {
                parentTemplate = templateToReplace.getBlockTemplate(templateToReplace.getParentID());
            }
            ChartBlockBase replacementBlock = ChartFactory.createBlock(parentTemplate, sbdb, block.getWellID(), block.getWellListID(), block.getInterpID(), block.getProperties(), block.getCaption());
            assert (replacementBlock.getTemplate().getID() != templateToReplace.getID());
            chart.removeBlock(block);
            chart.insertBlock(replacementBlock, index);
            chart.setData(replacementBlock);
            replacementMade = true;
        }
        return replacementMade;
    }
}

