/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.Date;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplate;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.core.TemplateDescr;
import jsbchart.correlation.CorrelationTemplate;
import jsbchart.panel.PanelType;
import model3.Audit;
import model3.SBRestrictable;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.listener.WeakListenerList;

public abstract class ChartTemplateBase
extends SBRestrictable
implements TemplateDescr {
    private final ChartManager manager;
    private int ID;
    private String descr;
    private String comments;
    private int projID;
    private Audit audit;
    private final WeakListenerList<TemplateDescr.Listener> templateDescrListeners = new WeakListenerList();

    ChartTemplateBase(ChartManager manager, int ID, String descr, String comments, int projID, Audit audit, String table, String IDfield, int acm) {
        super(table, IDfield, false, true);
        this.manager = manager;
        this.ID = ID;
        this.descr = descr;
        this.comments = comments;
        this.projID = projID;
        this.audit = audit == null ? new Audit() : audit;
        if (ID == 0) assert (acm == 0);
        this.setAcm(acm);
    }

    public int getID() {
        return this.ID;
    }

    @Override
    public String getName() {
        return this.descr;
    }

    public String toString() {
        return this.descr;
    }

    public abstract String getTypeDescr();

    @Override
    public String toParentString() {
        return this.toString();
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public int getProjID() {
        return this.projID;
    }

    @Override
    public void addListener(TemplateDescr.Listener listener) {
        this.templateDescrListeners.addListener((Object)listener);
    }

    abstract String getTableName();

    abstract String getTableNameMbr();

    abstract String getTableIDField();

    abstract String getInsertFields(SBdb var1, int var2);

    abstract String getInsertValues(SBdb var1, int var2);

    abstract void preDelete(SBdb var1, Statement var2) throws SQLException;

    void delete(SBdb sbdb) throws SQLException, SBException, SBPermissionException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            if (!this.canWrite(sbdb, stmt)) {
                throw new SBPermissionException(this.getDeniedReason(sbdb, "template", true));
            }
            this.preDelete(sbdb, stmt);
            String sql = "DELETE FROM " + sbdb.DBTableName(this.getTableNameMbr()) + " WHERE " + this.getTableIDField() + "=" + this.ID;
            stmt.executeUpdate(sbdb.modQuery(sql));
            if (this instanceof BlockTemplateParent) {
                for (PanelOcc panelOcc : ((BlockTemplate)this).getPanels()) {
                    if (this.manager.getPanelTemplate(panelOcc.getPanelID()).isVisible()) continue;
                    this.manager.deletePanelTemplate(panelOcc.getPanelID());
                }
            }
            sql = "DELETE FROM " + sbdb.DBTableName(this.getTableName() + "_ACL") + " WHERE " + this.getTableIDField() + "=" + this.ID;
            stmt.executeUpdate(sbdb.modQuery(sql));
            sql = "DELETE FROM " + sbdb.DBTableName(this.getTableName()) + " WHERE " + this.getTableIDField() + "=" + this.ID;
            int nRows = stmt.executeUpdate(sbdb.modQuery(sql));
            if (nRows != 1) {
                throw new SBException("Rows updated when deleting template " + this.ID + ": " + nRows);
            }
        }
    }

    public void store(SBdb sbdb) throws SQLException, SBException, InvalidFieldException {
        block16: {
            if (this.ID > 0) {
                throw new IllegalArgumentException("Attempt to store template with ID");
            }
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                ChartManager.checkNewTemplateName(sbdb, this.descr, this instanceof BlockTemplate ? ((BlockTemplate)this).getType() : null, this.projID);
                int id = sbdb.nextControl(this.getTableName(), this.getTableIDField(), stmt);
                String sql = this.getInsertFields(sbdb, id) + "," + Audit.sqlFieldString() + ") VALUES (" + this.getInsertValues(sbdb, id) + "," + this.audit.sqlInsert(sbdb, stmt) + ")";
                try (PreparedStatement pStmt = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));){
                    pStmt.setString(1, this.descr);
                    pStmt.setString(2, this.comments);
                    pStmt.executeUpdate();
                }
                this.ID = id;
                if (this.getnMbrs() <= 0) break block16;
                try {
                    this.storeMembers(sbdb);
                }
                catch (SBPermissionException pe) {
                    throw new IllegalStateException("Something went wrong", pe);
                }
            }
        }
    }

    abstract void storeMembers(SBdb var1) throws SQLException, SBPermissionException, SBException;

    public synchronized boolean updateDescr(SBdb sbdb, String descr, String comments, int projID, int wellListID) throws SQLException, InvalidFieldException, SBPermissionException, SBException {
        if (descr.equals(this.descr) && comments.equals(this.comments) && projID == this.projID) {
            if (this instanceof ChartTemplate) {
                if (wellListID == ((ChartTemplate)this).getWellListID()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            PanelTemplate templ;
            if (!this.canWrite(sbdb, stmt)) {
                throw new SBPermissionException(this.getDeniedReason(sbdb, "template", true));
            }
            if (!descr.equalsIgnoreCase(this.descr)) {
                ChartManager.checkNewTemplateName(sbdb, descr, this instanceof BlockTemplate ? ((BlockTemplate)this).getType() : null, projID);
            }
            if (projID != this.projID) {
                this.checkProjectChange(sbdb, stmt, projID, false);
            }
            if (this.ID > 0) {
                String sql = "UPDATE " + sbdb.DBTableName(this.getTableName()) + " set descr=?,comments=?,";
                if (this instanceof ChartTemplate && wellListID > 0) {
                    sql = sql + "wellist_id=" + wellListID + ",";
                }
                sql = sql + "proj_id=" + ChartManager.getIDString(projID) + "," + this.audit.sqlUpdate(sbdb, stmt, false) + " WHERE " + this.getTableIDField() + "=" + this.ID;
                try (PreparedStatement pStmt = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));){
                    pStmt.setString(1, descr);
                    pStmt.setString(2, comments);
                    pStmt.executeUpdate();
                }
                if (this instanceof BlockTemplate && projID != this.projID) {
                    for (PanelOcc occ : ((BlockTemplate)this).getPanels()) {
                        templ = this.manager.getPanelTemplate(occ.getPanelID());
                        if (templ.isVisible()) continue;
                        if (templ.getProjID() != this.projID) {
                            System.out.println("WARNING: local panel property project does not match. ProjID=" + templ.getProjID());
                        }
                        templ.updateDescr(sbdb, templ.getName(), templ.getComments(), projID);
                    }
                }
            }
            if (this instanceof BlockTemplate && !descr.equals(this.descr)) {
                String newComments = "Local to " + ((BlockTemplate)this).getType().getShortDescr() + " block template [" + descr + "]";
                for (PanelOcc occ : ((BlockTemplate)this).getPanels()) {
                    templ = this.manager.getPanelTemplate(occ.getPanelID());
                    if (templ == null || templ.isVisible()) continue;
                    templ.updateDescr(sbdb, templ.getName(), newComments, projID);
                }
            }
        }
        this.descr = descr;
        this.comments = comments;
        this.projID = projID;
        if (this instanceof ChartTemplate) {
            ((ChartTemplate)this).setWellListID(wellListID);
        }
        this.setChanged();
        this.notifyObservers(String.class);
        this.templateDescrListeners.getListeners().forEach(l -> l.onTemplateDescriptionChanged(this));
        return true;
    }

    @Override
    public abstract int getnMbrs();

    public abstract String getTypeString();

    abstract void checkProjectChange(SBdb var1, Statement var2, int var3, boolean var4) throws SQLException, InvalidFieldException;

    public PanelTemplate getPanelTemplate(int panelTemplID) throws SQLException, SBException {
        return this.manager.getPanelTemplate(panelTemplID);
    }

    public PanelTemplate getPanelTemplate(PanelType type) throws SQLException, SBException {
        try {
            return this.manager.getDefaultPanelTemplate(type);
        }
        catch (SBPermissionException pe) {
            throw new SBException("Unexpected PermissionException", (Throwable)pe);
        }
    }

    void deletePanelTemplate(int panelID) throws SQLException, SBException, SBPermissionException {
        this.manager.deletePanelTemplate(panelID);
    }

    CorrelationTemplate getCorrelationTemplate(int ID) throws SQLException {
        return this.manager.getCorrTemplate(ID);
    }

    BlockTemplate getBlockTemplate(int ID) throws SQLException {
        return this.manager.getBlockTemplate(ID);
    }

    void setGlobal() {
        this.projID = 0;
    }

    @Override
    public Date getModified() {
        return this.audit.getModified();
    }

    @Override
    public Date getCreated() {
        return this.audit.getCreated();
    }

    @Override
    public int getModifier() {
        return this.audit.getModifier();
    }

    @Override
    public int getCreator() {
        return this.audit.getCreator();
    }

    public Date getUpdated() {
        return this.audit.getUpdated();
    }

    public int getUpdater() {
        return this.audit.getUpdater();
    }

    Audit getAuditCopy() {
        return new Audit(this.audit);
    }

    public String getAuditString(boolean includeCreated) {
        return this.audit.toString(this.manager.sbdb, includeCreated);
    }

    void updateAudit(SBdb sbdb, Statement stmt) throws SQLException {
        String sql = "UPDATE " + sbdb.DBTableName(this.getTableName()) + " SET " + this.audit.sqlUpdate(sbdb, stmt, false) + " WHERE " + this.getTableIDField() + "=" + this.getID();
        stmt.executeUpdate(sbdb.modQuery(sql));
    }

    void refreshDescr(ChartTemplateBase updated) {
        this.descr = updated.descr;
        this.comments = updated.comments;
        this.projID = updated.projID;
        this.audit = updated.audit;
    }

    abstract ChartTemplateBase copy(ChartManager var1, String var2, String var3, int var4);

    boolean isConnected() {
        return this.manager.isConnected();
    }

    void writeAuditXML(BufferedWriter out, int indent, int singleUserID) throws IOException {
        this.audit.writeXML(out, indent, singleUserID);
    }

    static class AuditComparator
    implements Comparator<ChartTemplateBase> {
        AuditComparator() {
        }

        @Override
        public int compare(ChartTemplateBase o1, ChartTemplateBase o2) {
            return o1.audit.compareTo(o2.audit);
        }
    }
}

