/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jsbchart.block.ChartBlockBase;
import model3.Well;

public enum WellBlockOrder {
    ALPHA("Alphabetical"),
    NS("North - South"),
    SN("South - North"),
    WE("West - East"),
    EW("East - West");

    final String descr;

    private WellBlockOrder(String descr) {
        this.descr = descr;
    }

    public String toString() {
        return this.descr;
    }

    public static void sortList(List<ChartBlockBase> bList, final WellBlockOrder order) {
        Collections.sort(bList, new Comparator<ChartBlockBase>(){

            @Override
            public int compare(ChartBlockBase o1, ChartBlockBase o2) {
                Well well2;
                Well well1 = o1.getWells().size() == 1 ? o1.getWell() : null;
                Well well = well2 = o2.getWells().size() == 1 ? o2.getWell() : null;
                if (well1 == null || well2 == null) {
                    if (well1 == null && well2 == null) {
                        return 0;
                    }
                    return well1 == null ? -1 : 1;
                }
                switch (order.ordinal()) {
                    case 1: {
                        if (well1.getHeader().getLat_dec() == null || well2.getHeader().getLat_dec() == null) break;
                        return well2.getHeader().getLat_dec().compareTo(well1.getHeader().getLat_dec());
                    }
                    case 2: {
                        if (well1.getHeader().getLat_dec() == null || well2.getHeader().getLat_dec() == null) break;
                        return well1.getHeader().getLat_dec().compareTo(well2.getHeader().getLat_dec());
                    }
                    case 3: {
                        if (well1.getHeader().getLong_dec() == null || well2.getHeader().getLong_dec() == null) break;
                        return well1.getHeader().getLong_dec().compareTo(well2.getHeader().getLong_dec());
                    }
                    case 4: {
                        if (well1.getHeader().getLong_dec() == null || well2.getHeader().getLong_dec() == null) break;
                        return well2.getHeader().getLong_dec().compareTo(well1.getHeader().getLong_dec());
                    }
                }
                return well1.compareTo((Object)well2);
            }
        });
    }
}

