/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core.process;

import com.stratadata.util.process.AbstractMultiStageProcess;
import com.stratadata.util.process.ProcessMessage;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelType;
import jsbchart.panel.PanelWellDepthAgeProperties;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import util.SBException;
import util.SBPermissionException;

public class BlockTemplateMerge
extends AbstractMultiStageProcess<BlockTemplateMergeStep> {
    private static final Logger LOGGER = Logger.getLogger(BlockTemplateMerge.class.getName());
    private final ChartManager chartManager;
    private final SBdb sbdb;
    private final BlockTemplateParent target;
    private final List<BlockTemplateParent> donors;
    private int currentStep = 0;
    private final Map<Integer, BlockTemplateUsage> donorUsage = new HashMap<Integer, BlockTemplateUsage>();
    private final Set<Integer> chartsUpdated = new HashSet<Integer>();
    private final List<BlockTemplateParent> deletedBlocks = new LinkedList<BlockTemplateParent>();

    public BlockTemplateMerge(ChartManager chartManager, SBdb sbdb, BlockTemplateParent target, List<BlockTemplateParent> donors) {
        this.chartManager = Objects.requireNonNull(chartManager);
        this.sbdb = Objects.requireNonNull(sbdb);
        this.target = Objects.requireNonNull(target);
        this.donors = new ArrayList<BlockTemplateParent>((Collection)Objects.requireNonNull(donors));
    }

    protected void process() {
        if (this.getResponse(this.getCurrentStep()) == ProcessMessage.Response.YES) {
            ++this.currentStep;
        }
        switch (this.getCurrentStep().ordinal()) {
            case 0: {
                this.validate();
                break;
            }
            case 1: {
                this.findUsages();
                break;
            }
            case 2: {
                this.confirm();
                break;
            }
            case 3: {
                this.updateUsagesInCharts();
                break;
            }
            case 4: {
                this.updateUsagesInPanels();
                break;
            }
            case 5: {
                this.updateTabs();
                break;
            }
            case 6: {
                this.deleteDonors();
            }
        }
    }

    public BlockTemplateMergeStep getCurrentStep() {
        return BlockTemplateMergeStep.values()[this.currentStep];
    }

    private void validate() {
        this.donors.remove(this.target);
        if (this.donors.isEmpty()) {
            super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "No templates to merge"));
            return;
        }
        if (this.donors.stream().map(BlockTemplate::getType).collect(Collectors.toSet()).size() > 1) {
            super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "Block templates must all be of the same type"));
            return;
        }
        if (this.donors.stream().map(ChartTemplateBase::getProjID).filter(projID -> projID > 0).collect(Collectors.toSet()).size() > 1) {
            super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "Block templates must all be in the same project or global"));
            return;
        }
        if (this.target.getProjID() > 0) {
            for (BlockTemplate blockTemplate : this.donors) {
                if (blockTemplate.getProjID() != 0) continue;
                super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "Cannot replace global template '" + blockTemplate.getName() + "' with template from project."));
                return;
            }
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            for (BlockTemplate blockTemplate : this.donors) {
                if (blockTemplate.canWrite(this.sbdb, stmt)) continue;
                super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "You do not have permission to edit template '" + blockTemplate.getName() + "'."));
                return;
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Error checking permissions", e);
            super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "Error checking permissions" + e.getMessage()));
            return;
        }
        ++this.currentStep;
    }

    private void findUsages() {
        Map<PanelType, Long> targetPanelTypes = this.toPanelTypeMap(this.target);
        try {
            for (BlockTemplateParent blockTemplate : this.donors) {
                Set<Integer> childWellIDs = blockTemplate.getChildWellIDs();
                List<ChartTemplate> chartTemplates = this.chartManager.searchCharts(blockTemplate.getID(), true);
                List<PanelTemplate> panelTemplates = this.chartManager.searchPanels(blockTemplate.getID());
                List<String[]> tabs = this.chartManager.getTabs(blockTemplate);
                Map<PanelType, Long> panelTypes = this.toPanelTypeMap(blockTemplate);
                int panelsInTargetByType = 0;
                for (Map.Entry<PanelType, Long> entry : panelTypes.entrySet()) {
                    if (targetPanelTypes.get(entry.getKey()) == null) continue;
                    int nInDonor = entry.getValue().intValue();
                    int nInTarget = targetPanelTypes.get(entry.getKey()).intValue();
                    panelsInTargetByType += Math.min(nInTarget, nInDonor);
                }
                String panelTypesInTarget = panelsInTargetByType + "/" + blockTemplate.getPanels().size();
                this.donorUsage.put(blockTemplate.getID(), new BlockTemplateUsage(childWellIDs.size(), chartTemplates, panelTemplates, tabs, panelTypesInTarget));
            }
            ++this.currentStep;
        }
        catch (RuntimeException | SQLException | SBException ex) {
            LOGGER.log(Level.SEVERE, "Error finding usages", ex);
            super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "Error searching for usages: " + ex.getMessage()));
        }
    }

    private Map<PanelType, Long> toPanelTypeMap(BlockTemplate blockTemplate) {
        return blockTemplate.getPanels().stream().map(this::getPanelType).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    private PanelType getPanelType(PanelOcc pOcc) {
        try {
            return this.chartManager.getPanelTemplate(pOcc.getPanelID()).getType();
        }
        catch (SQLException | SBException e) {
            LOGGER.log(Level.WARNING, "Error getting panel type", e);
            return PanelType.BLANK;
        }
    }

    private void confirm() {
        Object message;
        if (this.donors.size() > 1) {
            message = "<html>These block templates will be replaced with '" + this.target.getName() + "':<br>";
            message = (String)message + "<table>";
            message = (String)message + "<tr><th></th><th align=\"left\">Usages</th><th align=\"left\">Panel types in target</th></tr>";
            for (BlockTemplate blockTemplate : this.donors) {
                message = (String)message + "<tr><td><b>" + blockTemplate.getName() + "</b></td><td>" + this.donorUsage.get(blockTemplate.getID()).toString() + "</td><td>" + this.donorUsage.get((Object)Integer.valueOf((int)blockTemplate.getID())).panelTypesInTarget + "</td></tr>";
            }
            message = (String)message + "</table>";
        } else {
            message = "All usages of";
            BlockTemplateUsage usage = this.donorUsage.get(this.donors.get(0).getID());
            message = (String)message + " '" + this.donors.get(0).getName() + "' (" + usage.toString() + ", " + usage.panelTypesInTarget + " panel types in target) ";
            message = (String)message + "will be updated to use '" + this.target.getName() + "'.";
        }
        message = (String)message + "\n\nMerged templates will be deleted. This operation cannot be undone.";
        message = (String)message + "\n\nAre you sure you want to continue?";
        super.addProcessMessage((Enum)BlockTemplateMergeStep.CONFIRM, (String)message, "Merge Block Templates");
    }

    private void updateUsagesInCharts() {
        for (BlockTemplate blockTemplate : this.donors) {
            for (ChartTemplate chartTemplate : this.donorUsage.get((Object)Integer.valueOf((int)blockTemplate.getID())).chartTemplates) {
                List<ChartTemplate.BlockOcc> blockOccs = chartTemplate.getBlocks();
                for (int i = 0; i < blockOccs.size(); ++i) {
                    ChartTemplate.BlockOcc bOcc = blockOccs.get(i);
                    if (bOcc.getBlockID() != blockTemplate.getID()) continue;
                    blockOccs.set(i, new ChartTemplate.BlockOcc(this.target.getID(), bOcc.getWellID(), bOcc.getWellListID(), bOcc.getInterpID(), bOcc.getProps(), bOcc.getCaption()));
                }
                try {
                    chartTemplate.update(this.sbdb, blockOccs, chartTemplate.getCorrOccs(), chartTemplate.getCorrStdOccs(), chartTemplate.getTagTemplates(), chartTemplate.getProperties(), chartTemplate.getHeaderProperties(), chartTemplate.getKeyProperties(), chartTemplate.getSchID());
                    this.sbdb.commit();
                    this.chartsUpdated.add(chartTemplate.getID());
                }
                catch (IOException | SQLException | SBException | SBPermissionException e) {
                    this.sbdb.doRollback();
                    LOGGER.log(Level.SEVERE, "Error updating chart template " + chartTemplate.getID(), e);
                    super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "Error updating chart template: " + e.getMessage()));
                    return;
                }
            }
        }
        ++this.currentStep;
    }

    private void updateUsagesInPanels() {
        for (BlockTemplate blockTemplate : this.donors) {
            for (PanelTemplate panelTemplate : this.donorUsage.get((Object)Integer.valueOf((int)blockTemplate.getID())).panelTemplates) {
                if (!(panelTemplate.getProperties() instanceof PanelWellDepthAgeProperties)) {
                    throw new IllegalStateException("Unexpected panel type with scheme block header");
                }
                try {
                    panelTemplate.updateProperty(this.target, 0);
                    panelTemplate.update(this.sbdb);
                    this.sbdb.commit();
                }
                catch (SQLException | SBPermissionException e) {
                    this.sbdb.doRollback();
                    LOGGER.log(Level.SEVERE, "Error updating panel template " + panelTemplate.getID(), e);
                    super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "Error updating panel template: " + e.getMessage()));
                }
            }
        }
        ++this.currentStep;
    }

    private void updateTabs() {
        String tableName;
        if (this.donorUsage.values().stream().allMatch(blockTemplateUsage -> blockTemplateUsage.tabs.isEmpty()) || this.target.getType() != BlockType.WELL && this.target.getType() != BlockType.SCHEME) {
            ++this.currentStep;
            return;
        }
        switch (this.target.getType()) {
            case WELL: {
                tableName = this.sbdb.DBTableName("CHTPREF_BLK");
                break;
            }
            case SCHEME: {
                tableName = this.sbdb.DBTableName("CHTPREF_SCH");
                break;
            }
            default: {
                ++this.currentStep;
                return;
            }
        }
        String sql = "SELECT user_id, well_id FROM " + tableName;
        sql = sql + " WHERE ";
        sql = sql + StringUtils.join(this.donors.stream().map(b -> "BLOCK_ID=" + b.getID()).toList(), (String)" OR ");
        try (Statement stmt = this.sbdb.getDatabase().createStatement();
             Statement targetStmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int userID = rs.getInt("user_id");
                int wellID = rs.getInt("well_id");
                boolean exists = false;
                ResultSet rsTarget = targetStmt.executeQuery(this.sbdb.modQuery("SELECT block_id FROM " + tableName + " WHERE block_id=" + this.target.getID()));
                if (rsTarget.next()) {
                    exists = true;
                }
                rsTarget.close();
                if (!exists) continue;
                String sqlDelete = "DELETE FROM " + tableName + " WHERE user_id=" + userID + " AND well_id=" + wellID + " AND (";
                sqlDelete = sqlDelete + StringUtils.join(this.donors.stream().map(b -> "BLOCK_ID=" + b.getID()).toList(), (String)" OR ");
                sqlDelete = sqlDelete + ")";
                int nRows = targetStmt.executeUpdate(this.sbdb.modQuery(sqlDelete));
                System.out.println("Chart pref blocks deleted: " + nRows);
            }
            this.sbdb.commit();
        }
        catch (SQLException e) {
            this.sbdb.doRollback();
            LOGGER.log(Level.SEVERE, "Error querying/deleting open tabs", e);
            super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "Error querying/deleting open tabs: " + e.getMessage()));
        }
        String sqlUpd = "UPDATE " + tableName + " SET BLOCK_ID=" + this.target.getID() + " WHERE ";
        sqlUpd = sqlUpd + StringUtils.join(this.donors.stream().map(b -> "BLOCK_ID=" + b.getID()).toList(), (String)" OR ");
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sqlUpd));
            this.sbdb.commit();
        }
        catch (SQLException e) {
            this.sbdb.doRollback();
            LOGGER.log(Level.SEVERE, "Error updating open tabs", e);
            super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "Error updating open tabs: " + e.getMessage()));
        }
        ++this.currentStep;
    }

    private void deleteDonors() {
        for (BlockTemplateParent donor : this.donors) {
            try {
                this.chartManager.deleteTemplate(donor);
                this.sbdb.commit();
                this.deletedBlocks.add(donor);
            }
            catch (SQLException | SBException | SBPermissionException e) {
                this.sbdb.doRollback();
                LOGGER.log(Level.SEVERE, "Error deleting template: " + donor.getName(), e);
                super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, "Error deleting template: " + e.getMessage()));
                return;
            }
        }
        String successMessage = "Merge successful.\n" + this.deletedBlocks.size() + " block templates deleted.\n" + this.chartsUpdated.size() + " charts updated.";
        super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.SUCCESS, successMessage));
    }

    public static enum BlockTemplateMergeStep {
        VALIDATE,
        FIND_USAGES,
        CONFIRM,
        UPDATE_CHARTS,
        UPDATE_PANELS,
        UPDATE_TABS,
        DELETE;

    }

    private record BlockTemplateUsage(int nOverrides, List<ChartTemplate> chartTemplates, List<PanelTemplate> panelTemplates, List<String[]> tabs, String panelTypesInTarget) {
        @Override
        public String toString() {
            LinkedList<CallSite> s = new LinkedList<CallSite>();
            if (this.nOverrides > 0) {
                s.add((CallSite)((Object)(this.nOverrides + " well overrides")));
            }
            if (!this.chartTemplates.isEmpty()) {
                s.add((CallSite)((Object)(this.chartTemplates.size() + " chart templates")));
            }
            if (!this.panelTemplates().isEmpty()) {
                s.add((CallSite)((Object)(this.panelTemplates.size() + " panel template headers")));
            }
            if (!this.tabs.isEmpty()) {
                Set users = this.tabs.stream().map(strings -> strings[1]).collect(Collectors.toSet());
                s.add((CallSite)((Object)(this.tabs().size() + " chart tabs for " + users.size() + " users")));
            }
            String description = s.isEmpty() ? "no usages" : StringUtils.join(s, (String)", ");
            return description;
        }
    }
}

