/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import com.stratadata.model3.event.EventType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Set;
import jsbchart.core.ChartManager;
import jsbchart.core.TemplateDescr;
import jsbchart.core.TemplateNotifierService;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import jsbchart.correlation.EventLine;
import jsbchart.correlation.IGDUnitLine;
import jsbchart.correlation.SurfaceLine;
import model3.Audit;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.LithostratUnit;
import model3.SBEvent;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Surface;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.listener.WeakListenerList;
import util.process.ModelProcess;

public class CorrelationTemplate
extends SBRestrictable
implements TemplateDescr {
    private final WeakListenerList<Listener> listeners = new WeakListenerList();
    private final int ID;
    private final CorrelationType type;
    private Audit audit;
    private String descr;
    private String comments;
    private int projID;
    private final Set<CorrelationLine> lines = new HashSet<CorrelationLine>();
    private Set<CorrelationLine> editing;
    private boolean refreshed = false;
    private CorrelationTemplate link;

    private CorrelationTemplate(int ID, CorrelationType type, String descr, String comments, int projID, Audit audit) {
        super("CHARTCORR", "CORRSCH_ID", false);
        this.ID = ID;
        this.type = type;
        this.descr = descr;
        this.comments = comments;
        this.projID = projID;
        this.audit = Objects.requireNonNullElseGet(audit, Audit::new);
    }

    public static CorrelationTemplate newStoredInstance(SBdb sbdb, CorrelationType type, String descr, String comments, int projID) throws SQLException, InvalidFieldException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ChartManager.checkNewTemplateName(sbdb, descr, type, projID);
            Audit audit = new Audit();
            int id = sbdb.nextControl("CHARTCORR", "corrsch_id", stmt);
            String sql = "INSERT INTO " + sbdb.DBTableName("CHARTCORR") + " (corrsch_id,corr_type,descr,comments,proj_id," + Audit.sqlFieldString() + ") VALUES (" + id + "," + SB.DBString((String)type.name()) + ",?,?," + String.valueOf(projID > 0 ? Integer.valueOf(projID) : "NULL") + "," + audit.sqlInsert(sbdb, stmt) + ")";
            try (PreparedStatement pStmt = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));){
                pStmt.setString(1, descr);
                pStmt.setString(2, comments);
                pStmt.executeUpdate();
            }
            CorrelationTemplate template = new CorrelationTemplate(id, type, descr, comments, projID, audit);
            template.setAcm(0);
            CorrelationTemplate correlationTemplate = template;
            return correlationTemplate;
        }
    }

    public static CorrelationTemplate load(SBdb sbdb, int ID) throws SQLException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            CorrelationTemplate correlationTemplate = CorrelationTemplate.load(stmt, sbdb, ID);
            return correlationTemplate;
        }
    }

    public static CorrelationTemplate loadFromConnection(Connection conn, SBdb sbdb, int ID) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            CorrelationTemplate correlationTemplate = CorrelationTemplate.load(stmt, sbdb, ID);
            return correlationTemplate;
        }
    }

    private static CorrelationTemplate load(Statement stmt, SBdb sbdb, int ID) throws SQLException {
        String sql = "SELECT corr_type,descr,comments,proj_id," + Audit.sqlFieldString() + ",acm FROM " + sbdb.DBTableName("CHARTCORR") + " WHERE corrsch_id=" + ID;
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        if (rs.next()) {
            CorrelationType type = CorrelationType.valueOf(rs.getString("corr_type"));
            String descr = rs.getString("descr");
            String comments = rs.getString("comments");
            int projID = rs.getInt("proj_id");
            Audit audit = new Audit(rs);
            CorrelationTemplate templ = new CorrelationTemplate(ID, type, descr, comments, projID, audit);
            templ.setAcm(rs.getInt("acm"));
            CorrelationTemplate.loadLines(templ, stmt, sbdb);
            return templ;
        }
        return null;
    }

    public static List<CorrelationTemplate> load(SBdb sbdb, CorrelationType type) throws SQLException {
        LinkedList<CorrelationTemplate> templates = new LinkedList<CorrelationTemplate>();
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "SELECT corrsch_id,descr,comments,proj_id," + Audit.sqlFieldString() + ",acm FROM " + sbdb.DBTableName("CHARTCORR") + " WHERE corr_type=" + SB.DBString((String)type.name());
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("corrsch_id");
                String descr = rs.getString("descr");
                String comments = rs.getString("comments");
                int projID = rs.getInt("proj_id");
                Audit audit = new Audit(rs);
                CorrelationTemplate templ = new CorrelationTemplate(ID, type, descr, comments, projID, audit);
                templ.setAcm(rs.getInt("acm"));
                templates.add(templ);
            }
            for (CorrelationTemplate cs : templates) {
                CorrelationTemplate.loadLines(cs, stmt, sbdb);
            }
        }
        return templates;
    }

    public static CorrelationTemplate copyToDB(SBdb ws, SBdb db, CorrelationTemplate wsCorr, String name, int dbProjID) throws SQLException, SBException, InvalidFieldException, SBPermissionException {
        CorrelationTemplate dbCorr = CorrelationTemplate.newStoredInstance(db, wsCorr.getType(), name, wsCorr.getComments(), dbProjID);
        dbCorr.audit = new Audit(db, ws, wsCorr.audit);
        wsCorr.setLink(dbCorr);
        for (CorrelationLine wsLine : wsCorr.getLineList()) {
            dbCorr.addCorrelationLine(wsLine.copyLink());
        }
        dbCorr.storeLines(db);
        return dbCorr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLines(CorrelationTemplate t, Statement stmt, SBdb sbdb) throws SQLException {
        if (!t.lines.isEmpty()) {
            throw new IllegalStateException("Attempt to re-load correlation lines");
        }
        ResultSet rs2 = null;
        CorrelationTemplate correlationTemplate = t;
        synchronized (correlationTemplate) {
            switch (t.type) {
                case EVENT: {
                    String sql = "SELECT ev_id,ev_type,style FROM " + sbdb.DBTableName("CHTLN_EV") + " where corrsch_id=" + t.ID;
                    rs2 = stmt.executeQuery(sbdb.modQuery(sql));
                    while (rs2.next()) {
                        int ev_id = rs2.getInt("ev_id");
                        SBEvent event = sbdb.getSBEvent(ev_id);
                        EventType ev_type = EventType.valueOf((String)rs2.getString("ev_type"));
                        String style = rs2.getString("style");
                        t.lines.add(new EventLine(event, ev_type, style));
                    }
                    break;
                }
                case SURFACE: {
                    String sql = "SELECT l.surface_id,l.style,s.sch_id FROM " + sbdb.DBTableName("CHTLN_SURFACE") + " l, " + sbdb.DBTableName("SURFACE") + " s where l.corrsch_id=" + t.ID + " AND l.surface_id=s.surface_id";
                    rs2 = stmt.executeQuery(sbdb.modQuery(sql));
                    while (rs2.next()) {
                        int surfaceID = rs2.getInt("surface_id");
                        String style = rs2.getString("style");
                        int schID = rs2.getInt("sch_id");
                        Surface surface = sbdb.getIGDScheme(schID).getSurface(surfaceID);
                        if (surface == null) {
                            throw new IllegalStateException("Surface null, you messed up");
                        }
                        t.lines.add(new SurfaceLine(surface, style));
                    }
                    break;
                }
                case LITHO: {
                    String sql = "SELECT l.unit_id,l.style,l.bnd_type,d.sch_id FROM " + sbdb.DBTableName("CHTLN_UNIT_LSTRAT") + " l, " + sbdb.DBTableName("IGD_DICT_LSTRAT") + " d where l.corrsch_id=" + t.ID + " AND l.unit_id=d.unit_id";
                    rs2 = stmt.executeQuery(sbdb.modQuery(sql));
                }
                case CHRONO: 
                case BIOZONE: {
                    String sql;
                    if (rs2 == null) {
                        sql = "SELECT l.igd_id,l.style,l.bnd_type,d.sch_id FROM " + sbdb.DBTableName("CHTLN_UNIT") + " l, " + sbdb.DBTableName("IGD_DICT") + " d where l.corrsch_id=" + t.ID + " AND l.igd_id=d.igd_id";
                        rs2 = stmt.executeQuery(sbdb.modQuery(sql));
                    }
                    while (rs2.next()) {
                        int unitID = rs2.getInt(t.type == CorrelationType.LITHO ? "unit_id" : "igd_id");
                        String style = rs2.getString("style");
                        IGDIntervalZone.BoundaryType bndType = IGDIntervalZone.BoundaryType.valueOf((String)rs2.getString("bnd_type"));
                        int schID = rs2.getInt("sch_id");
                        IGDUnitBase unit = sbdb.getIGDScheme(schID).findUnitBase(unitID);
                        if (unit == null) {
                            throw new IllegalStateException("Unit null, you messed up");
                        }
                        t.lines.add(new IGDUnitLine(t.type, unit, bndType, style));
                    }
                    break;
                }
            }
        }
    }

    public static CorrelationTemplate copyToWorkspace(SBdb ws, SBdb db, CorrelationTemplate dbTempl) throws SQLException, SBException {
        if (ws.isConnected() || !db.isConnected()) {
            throw new IllegalArgumentException("Illegal attempt to copy to workspace");
        }
        ws.fillUser(db, dbTempl.getCreator());
        ws.fillUser(db, dbTempl.getModifier());
        CorrelationTemplate wsTempl = new CorrelationTemplate(dbTempl.ID, dbTempl.type, dbTempl.descr, dbTempl.comments, 0, new Audit(dbTempl.audit));
        for (CorrelationLine line : dbTempl.getLineList()) {
            IGDScheme wsScheme;
            String lineStyle;
            Object o = line.getObject();
            String string = lineStyle = line.getStyle() != null ? line.getStyle().getProperties() : null;
            if (o instanceof SBEvent) {
                SBEvent wsEvent = ws.fillEvent(db, (SBEvent)o);
                wsTempl.lines.add(new EventLine(wsEvent, ((EventLine)line).getEventType(), lineStyle));
                continue;
            }
            if (o instanceof Surface) {
                wsScheme = ws.fillIGDScheme(db, ((Surface)o).getSchID());
                Surface wsSurface = wsScheme.getSurface(((Surface)o).getSurfaceID());
                wsTempl.lines.add(new SurfaceLine(wsSurface, lineStyle));
                continue;
            }
            if (!(o instanceof IGDUnitBase)) continue;
            wsScheme = ws.fillIGDScheme(db, ((IGDUnitBase)o).getSchID());
            IGDUnitBase wsUnit = wsScheme.findUnitBase(((IGDUnitBase)o).getUnitID());
            wsTempl.lines.add(new IGDUnitLine(line.getCorrelationType(), wsUnit, (IGDIntervalZone.BoundaryType)line.getObjectType(), lineStyle));
        }
        return wsTempl;
    }

    @Override
    public synchronized int getProjID() {
        return this.projID;
    }

    @Override
    public boolean hasWellList() {
        return false;
    }

    @Override
    public int getWellListID() {
        return 0;
    }

    @Override
    public synchronized String getComments() {
        return this.comments;
    }

    public int getID() {
        return this.ID;
    }

    @Override
    public CorrelationType getType() {
        return this.type;
    }

    public String toString() {
        return this.descr;
    }

    @Override
    public synchronized String getName() {
        return this.descr;
    }

    @Override
    public String toParentString() {
        return this.toString();
    }

    public void addListener(Listener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void deleteListener(Listener listener) {
        this.listeners.deleteListener((Object)listener);
    }

    public synchronized List<CorrelationLine> getLineList() {
        LinkedList<CorrelationLine> list = new LinkedList<CorrelationLine>((Collection)Objects.requireNonNullElse(this.editing, this.lines));
        Collections.sort(list);
        return list;
    }

    public boolean isDirty() {
        return this.editing != null;
    }

    public boolean addCorrelationLine(CorrelationLine line) {
        boolean includeStyle = true;
        if (this.editing == null) {
            this.editing = new HashSet<CorrelationLine>(this.lines);
            includeStyle = false;
        }
        boolean added = this.editing.add(line);
        this.checkDirty(includeStyle);
        if (added) {
            // empty if block
        }
        return added;
    }

    public boolean addCorrelationLines(Collection<CorrelationLine> newLines) {
        boolean includeStyle = true;
        if (this.editing == null) {
            this.editing = new HashSet<CorrelationLine>(this.lines);
            includeStyle = false;
        }
        boolean added = false;
        for (CorrelationLine newLine : newLines) {
            added = this.editing.add(newLine) || added;
        }
        this.checkDirty(includeStyle);
        return added;
    }

    public boolean deleteCorrelationLine(CorrelationLine line) {
        boolean includeStyle = true;
        if (this.editing == null) {
            this.editing = new HashSet<CorrelationLine>(this.lines);
            includeStyle = false;
        }
        boolean removed = this.editing.remove(line);
        this.checkDirty(includeStyle);
        return removed;
    }

    public boolean containsLine(Object corrObj, Object type) {
        return this.getLineList().stream().filter(correlationLine -> correlationLine.getObject() == corrObj).anyMatch(line -> line.getObjectType() == type);
    }

    public ModelProcess deleteLinesLinkedToUnits(final Collection<IGDUnitBase> units, final SBdb sbdb, final Statement stmt) {
        if (units.isEmpty()) {
            return ModelProcess.emptyProcess();
        }
        return new ModelProcess(this){
            private Audit.AuditUpdate auditUpdate;
            final /* synthetic */ CorrelationTemplate this$0;
            {
                CorrelationTemplate correlationTemplate = this$0;
                Objects.requireNonNull(correlationTemplate);
                this.this$0 = correlationTemplate;
            }

            public void doDatabaseProcess() throws SQLException {
                String sql;
                LinkedList<Integer> unitIDs = new LinkedList<Integer>();
                LinkedList<Integer> lstratUnitIDs = new LinkedList<Integer>();
                for (IGDUnitBase unit : units) {
                    if (unit instanceof LithostratUnit) {
                        lstratUnitIDs.add(unit.getUnitID());
                        continue;
                    }
                    unitIDs.add(unit.getUnitID());
                }
                if (!unitIDs.isEmpty()) {
                    sql = "DELETE FROM " + sbdb.DBTableName("CHTLN_UNIT") + " WHERE igd_id in(" + StringUtils.join(unitIDs, (String)",") + ")";
                    stmt.executeUpdate(sbdb.modQuery(sql));
                }
                if (!lstratUnitIDs.isEmpty()) {
                    sql = "DELETE FROM " + sbdb.DBTableName("CHTLN_UNIT_LSTRAT") + " WHERE unit_id in(" + StringUtils.join(lstratUnitIDs, (String)",") + ")";
                    stmt.executeUpdate(sbdb.modQuery(sql));
                }
                this.auditUpdate = this.this$0.audit.createUpdate(sbdb, stmt, false);
                sql = "UPDATE " + sbdb.DBTableName("CHARTCORR") + " SET " + this.auditUpdate.getSql() + " WHERE corrsch_id=" + this.this$0.ID;
                stmt.executeUpdate(sbdb.modQuery(sql));
            }

            public void doModelProcess() {
                LinkedList<CorrelationLine> toRemove = new LinkedList<CorrelationLine>();
                for (CorrelationLine l : this.this$0.lines) {
                    if (!(l.getObject() instanceof IGDUnitBase) || !units.contains((IGDUnitBase)l.getObject())) continue;
                    toRemove.add(l);
                }
                this.this$0.lines.removeAll(toRemove);
                this.auditUpdate.doUpdate();
            }
        };
    }

    public ModelProcess deleteLinesLinkedToSurfaces(final Collection<Surface> surfaces, final SBdb sbdb, final Statement stmt) {
        if (surfaces.isEmpty()) {
            return ModelProcess.emptyProcess();
        }
        return new ModelProcess(this){
            private Audit.AuditUpdate auditUpdate;
            final /* synthetic */ CorrelationTemplate this$0;
            {
                CorrelationTemplate correlationTemplate = this$0;
                Objects.requireNonNull(correlationTemplate);
                this.this$0 = correlationTemplate;
            }

            public void doDatabaseProcess() throws SQLException {
                LinkedList<Integer> surfaceIDs = new LinkedList<Integer>();
                for (Surface surface : surfaces) {
                    surfaceIDs.add(surface.getSurfaceID());
                }
                String sql = "DELETE FROM " + sbdb.DBTableName("CHTLN_SURFACE") + " WHERE surface_id in(" + StringUtils.join(surfaceIDs, (String)",") + ")";
                stmt.executeUpdate(sbdb.modQuery(sql));
                this.auditUpdate = this.this$0.audit.createUpdate(sbdb, stmt, false);
                sql = "UPDATE " + sbdb.DBTableName("CHARTCORR") + " SET " + this.auditUpdate.getSql() + " WHERE corrsch_id=" + this.this$0.ID;
                stmt.executeUpdate(sbdb.modQuery(sql));
            }

            public void doModelProcess() {
                LinkedList<CorrelationLine> toRemove = new LinkedList<CorrelationLine>();
                for (CorrelationLine l : this.this$0.lines) {
                    if (!(l.getObject() instanceof Surface) || !surfaces.contains((Surface)l.getObject())) continue;
                    toRemove.add(l);
                }
                this.this$0.lines.removeAll(toRemove);
                this.auditUpdate.doUpdate();
            }
        };
    }

    private synchronized void checkDirty(boolean includeStyle) {
        if (this.editing == null) {
            return;
        }
        if (this.editing.equals(this.lines)) {
            if (!includeStyle) {
                this.clearEditing();
                return;
            }
            block0: for (CorrelationLine l : this.lines) {
                for (CorrelationLine e : this.editing) {
                    if (!l.equals(e)) continue;
                    if (!(l.getStyle() == null ^ e.getStyle() == null) && (l.getStyle() == null || e.getStyle() == null || l.getStyle().equals(e.getStyle()))) continue block0;
                    return;
                }
            }
            this.clearEditing();
        }
    }

    public boolean updateCorrelationLine(CorrelationLine line, Object type, CorrLineStyle style) {
        if (!this.getLineList().contains(line)) {
            return false;
        }
        CorrelationLine copyLine = line.copy();
        boolean change = false;
        if (copyLine.getStyle() == null ^ style == null || !SB.equal((Object)copyLine.getStyle(), (Object)style)) {
            copyLine.setStyle(style);
            change = true;
        }
        if (copyLine.updateObjectType(type)) {
            change = true;
        }
        if (change) {
            if (this.editing == null) {
                this.editing = new HashSet<CorrelationLine>(this.lines);
            }
            this.editing.remove(line);
            this.editing.add(copyLine);
            return true;
        }
        return false;
    }

    public synchronized void storeLines(SBdb sbdb) throws SQLException, SBPermissionException {
        if (!this.isDirty()) {
            return;
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            if (!this.canWrite(sbdb, stmt)) {
                throw new SBPermissionException("Correlation line template is ready-only");
            }
            String sql = "DELETE FROM " + sbdb.DBTableName(this.getMbrTableName()) + " WHERE corrsch_id=" + this.ID;
            stmt.executeUpdate(sbdb.modQuery(sql));
            for (CorrelationLine line : this.editing) {
                line.store(this.ID, sbdb, stmt);
            }
            sql = "UPDATE " + sbdb.DBTableName("CHARTCORR") + " SET " + this.audit.sqlUpdate(sbdb, stmt, false) + " WHERE corrsch_id=" + this.ID;
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        this.lines.clear();
        this.lines.addAll(this.editing);
        this.clearEditing();
        this.listeners.notify(Listener::onCorrelationTemplateUpdated);
    }

    synchronized Set<CorrelationLine> getImplementedLines(CorrLineStyle defaultStyle, int interpID) {
        HashSet<CorrelationLine> cLines = new HashSet<CorrelationLine>();
        Iterator<CorrelationLine> it = this.lines.iterator();
        while (it.hasNext()) {
            switch (this.type) {
                case EVENT: {
                    EventLine l = (EventLine)it.next();
                    cLines.add(EventLine.createImplementedCopy(l, defaultStyle, interpID));
                    break;
                }
                case SURFACE: {
                    SurfaceLine sl = (SurfaceLine)it.next();
                    cLines.add(SurfaceLine.createImplementedCopy(sl, defaultStyle, interpID));
                    break;
                }
                case LITHO: 
                case CHRONO: 
                case BIOZONE: {
                    IGDUnitLine ul = (IGDUnitLine)it.next();
                    cLines.add(IGDUnitLine.createImplementedCopy(ul, defaultStyle, interpID));
                }
            }
        }
        return cLines;
    }

    public synchronized void updateDescr(SBdb sbdb, String descr, String comments, int projID) throws InvalidFieldException, SQLException, SBPermissionException {
        if (descr.equals(this.descr) && comments.equals(this.comments) && projID == this.projID) {
            return;
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            PreparedStatement pStmt;
            String sql;
            if (!this.canWrite(sbdb, stmt)) {
                throw new SBPermissionException("Correlation line template is ready-only");
            }
            if (!this.descr.equals(descr)) {
                sql = "SELECT corrsch_id FROM " + sbdb.DBTableName("CHARTCORR") + " WHERE descr=? AND corr_type=" + SB.DBString((String)this.type.toString());
                pStmt = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
                try {
                    pStmt.setString(1, descr);
                    ResultSet rs = pStmt.executeQuery();
                    if (rs.next()) {
                        throw new InvalidFieldException("Name is already in use");
                    }
                }
                finally {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
            }
            if (projID != this.projID && projID != 0) {
                sql = "SELECT DISTINCT c.proj_id as proj_id from " + sbdb.DBTableName("CHART") + " c, " + sbdb.DBTableName("CHTCORROCC") + " m WHERE m.corrsch_id=" + this.ID + " AND c.chart_id=m.chart_id";
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                while (rs.next()) {
                    int pID = rs.getInt("proj_id");
                    if (pID == 0 || pID == projID) continue;
                    throw new InvalidFieldException("Can't update project: this correaltion template is a member of non-global charts");
                }
            }
            sql = "UPDATE " + sbdb.DBTableName("CHARTCORR") + " SET descr=?,comments=?,proj_id=" + String.valueOf(projID > 0 ? Integer.valueOf(projID) : "NULL") + "," + this.audit.sqlUpdate(sbdb, stmt, false) + " WHERE corrsch_id=" + this.ID;
            pStmt = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
            try {
                pStmt.setString(1, descr);
                pStmt.setString(2, comments);
                pStmt.executeUpdate();
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        this.descr = descr;
        this.comments = comments;
        this.projID = projID;
    }

    private String getMbrTableName() {
        switch (this.type) {
            case EVENT: {
                return "CHTLN_EV";
            }
            case SURFACE: {
                return "CHTLN_SURFACE";
            }
            case CHRONO: 
            case BIOZONE: {
                return "CHTLN_UNIT";
            }
            case LITHO: {
                return "CHTLN_UNIT_LSTRAT";
            }
        }
        assert (false);
        return "";
    }

    public void delete(SBdb sbdb) throws SQLException, SBException, SBPermissionException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            if (!this.canWrite(sbdb, stmt)) {
                throw new SBPermissionException("Correlation line template is ready-only");
            }
            String sql = "DELETE FROM " + sbdb.DBTableName(this.getMbrTableName()) + " WHERE corrsch_id=" + this.ID;
            stmt.executeUpdate(sbdb.modQuery(sql));
            sql = "DELETE FROM " + sbdb.DBTableName("CHARTCORR_ACL") + " WHERE corrsch_id=" + this.ID;
            stmt.executeUpdate(sbdb.modQuery(sql));
            sql = "DELETE FROM " + sbdb.DBTableName("CHARTCORR") + " WHERE corrsch_id=" + this.ID;
            int nRows = stmt.executeUpdate(sbdb.modQuery(sql));
            if (nRows != 1) {
                throw new SBException("Rows updated when deleting correlation template " + this.ID + ": " + nRows);
            }
        }
    }

    private void clearEditing() {
        this.editing = null;
        this.refreshed = false;
    }

    public void restoreSavedProperties() {
        if (this.editing == null) {
            return;
        }
        this.clearEditing();
    }

    public void setGlobal() {
        this.projID = 0;
    }

    @Override
    public synchronized Date getModified() {
        return this.audit.getModified();
    }

    @Override
    public synchronized Date getCreated() {
        return this.audit.getCreated();
    }

    @Override
    public synchronized int getModifier() {
        return this.audit.getModifier();
    }

    @Override
    public synchronized int getCreator() {
        return this.audit.getCreator();
    }

    public synchronized Date getUpdated() {
        return this.audit.getUpdated();
    }

    public boolean hasBeenRefreshed() {
        return this.refreshed;
    }

    public synchronized void refresh(CorrelationTemplate updated) {
        if (updated.getID() != this.ID) {
            throw new IllegalArgumentException("Attempt to update correlation template " + String.valueOf(this) + " from different template");
        }
        assert (updated.type == this.type);
        this.descr = updated.descr;
        this.comments = updated.comments;
        this.projID = updated.projID;
        this.audit = updated.audit;
        if (!this.lines.equals(updated.lines)) {
            this.lines.clear();
            this.lines.addAll(updated.lines);
            this.setChanged();
            TemplateNotifierService.submitNotify((Observable)((Object)this), null);
            this.refreshed = true;
            return;
        }
        boolean update = false;
        block0: for (CorrelationLine line : this.lines) {
            for (CorrelationLine comp : updated.lines) {
                if (!comp.equals(line)) continue;
                if (SB.equal((Object)line.getStyle(), (Object)comp.getStyle())) continue block0;
                update = true;
                break block0;
            }
        }
        if (update) {
            this.lines.clear();
            this.lines.addAll(updated.lines);
            this.setChanged();
            TemplateNotifierService.submitNotify((Observable)((Object)this), null);
            this.refreshed = true;
        }
    }

    public void mergeEvents(SBEvent donorEvent, SBEvent targetEvent) {
        Set<CorrelationLine> lineSet = this.lines;
        boolean changed = false;
        while (lineSet != null) {
            ArrayList<EventLine> toAdd = new ArrayList<EventLine>();
            Iterator<CorrelationLine> it = lineSet.iterator();
            while (it.hasNext()) {
                CorrelationLine line = it.next();
                if (line.getObject() != donorEvent) continue;
                it.remove();
                toAdd.add(new EventLine(targetEvent, ((EventLine)line).getEventType(), line.getStyle() == null ? null : line.getStyle().getProperties()));
                changed = true;
            }
            lineSet.addAll(toAdd);
            if (lineSet == this.lines && this.editing != null) {
                lineSet = this.editing;
                continue;
            }
            lineSet = null;
        }
        if (changed) {
            this.listeners.notify(Listener::onCorrelationTemplateUpdated);
        }
    }

    public void unloadEvent(SBEvent event) {
        Set<CorrelationLine> lineSet = this.lines;
        boolean changed = false;
        while (lineSet != null) {
            ArrayList toAdd = new ArrayList();
            Iterator<CorrelationLine> it = lineSet.iterator();
            while (it.hasNext()) {
                CorrelationLine line = it.next();
                if (line.getObject() != event) continue;
                it.remove();
                changed = true;
            }
            lineSet.addAll(toAdd);
            if (lineSet == this.lines && this.editing != null) {
                lineSet = this.editing;
                continue;
            }
            lineSet = null;
        }
        if (changed) {
            this.listeners.notify(Listener::onCorrelationTemplateUpdated);
        }
    }

    public void writeXML(BufferedWriter out, int indent, int singleUserID) throws IOException {
        String ind = SB.getXMLIndent((int)indent);
        out.write(ind + "<Description>" + SB.getXMLstring((String)this.getName()) + "</Description>\n");
        if (this.getComments() != null && !this.getComments().trim().isEmpty()) {
            out.write(ind + "<Comments>" + SB.getXMLstring((String)this.getComments().trim()) + "</Comments>\n");
        }
        this.audit.writeXML(out, indent, singleUserID);
        for (CorrelationLine line : this.lines) {
            line.writeXML(out, indent);
        }
    }

    public static CorrelationTemplate parseXML(ChartManager wsCM, SBdb ws, Element xml, int projID) throws SQLException, ParseException, SBException {
        CorrelationType type = null;
        HashSet<CorrelationLine> lines = new HashSet<CorrelationLine>();
        IteratorIterable it = xml.getDescendants((Filter)new ElementFilter("EventCorrelationLine"));
        while (it.hasNext()) {
            if (type == null) {
                type = CorrelationType.EVENT;
            } else if (type != CorrelationType.EVENT) {
                throw new IllegalStateException("Element contains more than one type of line!");
            }
            Element evEl = (Element)it.next();
            lines.add(new EventLine(ws.getSBEvent(Integer.parseInt(evEl.getChildText("EventID"))), EventType.parseType((String)evEl.getChildText("EventType")), evEl.getChildText("Properties")));
        }
        it = xml.getDescendants((Filter)new ElementFilter("SurfaceCorrelationLine"));
        while (it.hasNext()) {
            IGDScheme scheme;
            if (type == null) {
                type = CorrelationType.SURFACE;
            } else if (type != CorrelationType.SURFACE) {
                throw new IllegalStateException("Element contains more than one type of line!");
            }
            Element surfaceEl = (Element)it.next();
            int surfaceID = Integer.parseInt(surfaceEl.getChildText("SurfaceID"));
            Surface surface = null;
            Iterator iterator = ws.getIGDSchemes(10, true).iterator();
            while (iterator.hasNext() && (surface = (scheme = (IGDScheme)iterator.next()).findSurface(surfaceID)) == null) {
            }
            if (surface == null) {
                throw new IllegalStateException("No surface in file for surface correlation line");
            }
            lines.add(new SurfaceLine(surface, surfaceEl.getChildText("Properties")));
        }
        it = xml.getDescendants((Filter)new ElementFilter("IGDUnitCorrelationLine"));
        while (it.hasNext()) {
            Element unitEl = (Element)it.next();
            int unitID = Integer.parseInt(unitEl.getChildText("UnitID"));
            IGDUnitBase unit = null;
            IGDScheme scheme = null;
            for (IGDScheme sch : ws.getIGDSchemes()) {
                unit = sch.findUnitBase(unitID);
                if (unit == null) continue;
                scheme = sch;
                break;
            }
            if (unit == null || scheme == null) {
                throw new IllegalStateException("No unit in file for unit correlation line");
            }
            if (type == null) {
                type = CorrelationType.getType(scheme.getIGDType());
            } else if (type != CorrelationType.getType(scheme.getIGDType())) {
                throw new IllegalStateException("Element contains more than one type of line!");
            }
            lines.add(new IGDUnitLine(type, unit, IGDIntervalZone.BoundaryType.valueOf((String)unitEl.getChildText("BoundaryType")), unitEl.getChildText("Properties")));
        }
        if (type == null) {
            assert (lines.isEmpty());
            type = CorrelationType.CHRONO;
        }
        CorrelationTemplate templ = new CorrelationTemplate(Integer.parseInt(xml.getAttributeValue("CorrelationID")), type, xml.getChildText("Description"), xml.getChildText("Comments"), projID, new Audit(ws, xml.getChild("Audit")));
        templ.setAcm(0);
        templ.lines.addAll(lines);
        return templ;
    }

    public CorrelationTemplate getLink() {
        return this.link;
    }

    public void setLink(CorrelationTemplate link) {
        this.link = link;
    }

    public static interface Listener {
        public void onCorrelationTemplateUpdated();
    }
}

