/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import com.stratadata.model3.event.EventType;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jsbchart.core.TemplateType;
import model3.DataType;
import model3.IGDIntervalZone;
import model3.Surface;

public final class CorrelationType
extends Enum<CorrelationType>
implements TemplateType {
    public static final /* enum */ CorrelationType EVENT = new CorrelationType("Event Correlation", "events", true, "corrline_event.png", "corrline_event_folder.png", "addCorrEvDict.png", DataType.EVENT);
    public static final /* enum */ CorrelationType SURFACE = new CorrelationType("Surface Correlation", "surfaces", true, "corrline_surface.png", "corrline_surface_folder.png", "addCorrDict.png", DataType.SEQUENCE);
    public static final /* enum */ CorrelationType CHRONO = new CorrelationType("Chronostratigraphy Correlation", "chrono intervals", true, "corrline_interval.png", "corrline_interval_folder.png", "addCorrDict.png", DataType.CHRONOSTRAT);
    public static final /* enum */ CorrelationType LITHO = new CorrelationType("Lithostratigraphy Correlation", "lith intervals", true, "corrline_interval.png", "corrline_interval_folder.png", "addCorrDict.png", DataType.LITHOSTRAT);
    public static final /* enum */ CorrelationType BIOZONE = new CorrelationType("Biozone Correlation", "biozones", true, "corrline_interval.png", "corrline_interval_folder.png", "addCorrDict.png", DataType.BIOZONE);
    private static final String ICON_PATH = "/icon/correlation/";
    private final String descr;
    private final String shortDescr;
    private final boolean canScope;
    private final ImageIcon icon;
    private final ImageIcon iconFolder;
    private final ImageIcon iconDict;
    private final DataType dataType;
    private static final /* synthetic */ CorrelationType[] $VALUES;

    public static CorrelationType[] values() {
        return (CorrelationType[])$VALUES.clone();
    }

    public static CorrelationType valueOf(String name) {
        return Enum.valueOf(CorrelationType.class, name);
    }

    private CorrelationType(String descr, String shortDescr, boolean canScope, String iconString, String iconFolderString, String iconDictString, DataType dataType) {
        this.descr = descr;
        this.shortDescr = shortDescr;
        this.canScope = canScope;
        this.icon = CorrelationType.getIcon(iconString);
        this.iconFolder = CorrelationType.getIcon(iconFolderString);
        this.iconDict = CorrelationType.getIcon(iconDictString);
        this.dataType = dataType;
    }

    private static ImageIcon getIcon(String pathSuffix) {
        String path = ICON_PATH + pathSuffix;
        try {
            return new ImageIcon(CorrelationType.class.getResource(path));
        }
        catch (Exception e) {
            Logger.getLogger(CorrelationType.class.getName()).log(Level.WARNING, "Failed to load icon from path: {0}", path);
            return null;
        }
    }

    public String toString() {
        return this.descr;
    }

    public String toShortString() {
        return this.shortDescr;
    }

    public boolean canScope() {
        return this.canScope;
    }

    public static EnumSet getDataTypes(CorrelationType cType) {
        switch (cType.ordinal()) {
            case 0: {
                return EnumSet.allOf(EventType.class);
            }
            case 1: {
                return EnumSet.allOf(Surface.SurfaceType.class);
            }
            case 2: 
            case 3: 
            case 4: {
                return EnumSet.allOf(IGDIntervalZone.BoundaryType.class);
            }
        }
        assert (false);
        return null;
    }

    public static EnumSet getDataTypes(CorrelationType cType, String dataTypes) {
        if (dataTypes.isEmpty()) {
            return null;
        }
        String[] s = dataTypes.split(",");
        EnumSet<EventType> tSet = null;
        for (String string : s) {
            EventType e = null;
            switch (cType.ordinal()) {
                case 0: {
                    e = EventType.valueOf((String)string);
                    break;
                }
                case 1: {
                    e = Surface.SurfaceType.valueOf((String)string);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    e = IGDIntervalZone.BoundaryType.valueOf((String)string);
                }
            }
            if (e == null) continue;
            if (tSet == null) {
                tSet = EnumSet.of(e);
                continue;
            }
            tSet.add(e);
        }
        return tSet;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Icon getIconFolder() {
        return this.iconFolder;
    }

    public Icon getIconDict() {
        return this.iconDict;
    }

    public static boolean isUnitType(CorrelationType type) {
        switch (type.ordinal()) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
        }
        return true;
    }

    public static CorrelationType getType(int igdType) {
        switch (igdType) {
            case 3: {
                return CHRONO;
            }
            case 2: {
                return LITHO;
            }
            case 4: {
                return BIOZONE;
            }
            case 20: {
                return EVENT;
            }
            case 10: 
            case 21: {
                return SURFACE;
            }
        }
        assert (false);
        return null;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getNoun() {
        return this.descr;
    }

    private static /* synthetic */ CorrelationType[] $values() {
        return new CorrelationType[]{EVENT, SURFACE, CHRONO, LITHO, BIOZONE};
    }

    static {
        $VALUES = CorrelationType.$values();
    }
}

