/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import com.stratadata.model3.event.EventType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import model3.SBEvent;
import model3.SBdb;
import util.SB;

public class EventLine
extends CorrelationLine {
    private final SBEvent event;
    private EventType ev_type;

    public EventLine(SBEvent event, EventType type, String props) {
        super(props, CorrelationType.EVENT);
        this.event = event;
        this.ev_type = type;
    }

    public EventLine(SBEvent event, EventType evType, CorrLineStyle style, Integer interpID) {
        super(CorrelationType.EVENT, style, interpID);
        this.event = event;
        this.ev_type = evType;
    }

    static EventLine createImplementedCopy(EventLine rhs, CorrLineStyle defaultStyle, int interpID) {
        if (rhs.getStyle() != null) {
            defaultStyle = new CorrLineStyle(rhs.getStyle().getProperties());
        }
        EventLine l = new EventLine(rhs.event, rhs.ev_type, defaultStyle, interpID);
        return l;
    }

    @Override
    public Object getObject() {
        return this.event;
    }

    @Override
    public Object getObjectType() {
        return this.ev_type;
    }

    public EventType getEventType() {
        return this.ev_type;
    }

    public int getEventID() {
        return this.event.getEvID();
    }

    @Override
    CorrLineStyle.LabelPosition getDefaultLabelPosition() {
        switch (this.ev_type) {
            case TOP: {
                return CorrLineStyle.LabelPosition.BELOW;
            }
            default: {
                return CorrLineStyle.LabelPosition.ABOVE;
            }
            case SINGLE: 
        }
        return CorrLineStyle.LabelPosition.THROUGH;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EventLine)) {
            return false;
        }
        EventLine rhs = (EventLine)o;
        if (!this.canEqual(rhs)) {
            return false;
        }
        if (!this.event.equals(rhs.event)) {
            return false;
        }
        if (this.ev_type != rhs.ev_type) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public boolean canEqual(Object o) {
        return o instanceof EventLine;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.event != null ? this.event.hashCode() : 0);
        hash = 29 * hash + (this.ev_type != null ? this.ev_type.hashCode() : 0);
        hash = 29 * hash + super.hashCode();
        return hash;
    }

    @Override
    void store(int corrID, SBdb sbdb, Statement stmt) throws SQLException {
        String sql = "INSERT INTO " + sbdb.DBTableName("CHTLN_EV") + " (corrsch_id,ev_id,ev_type,style) VALUES (" + corrID + "," + this.event.getEvID() + "," + SB.DBString((String)this.ev_type.name()) + "," + (this.getStyle() != null ? SB.DBString((String)this.getStyle().getProperties()) : "NULL") + ")";
        stmt.executeUpdate(sbdb.modQuery(sql));
    }

    public String toString() {
        return this.event.toString(this.ev_type, true, this.getStyle() != null && this.getStyle().getLabelAbr(), false);
    }

    @Override
    String getDatumString() {
        return this.event.getEvID() + "-" + this.ev_type.name();
    }

    @Override
    boolean updateObjectType(Object newType) {
        if (!(newType instanceof EventType)) {
            throw new IllegalArgumentException("Attempt to update EventLine type to " + String.valueOf(newType));
        }
        EventType type = (EventType)newType;
        if (this.ev_type != type) {
            this.ev_type = type;
            return true;
        }
        return false;
    }

    @Override
    CorrelationLine copy() {
        return new EventLine(this.event, this.ev_type, this.getStyle() != null ? new CorrLineStyle(this.getStyle().getProperties()) : null, null);
    }

    @Override
    CorrelationLine copyLink() {
        return new EventLine(this.event.getLink(), this.ev_type, this.getStyle() != null ? new CorrLineStyle(this.getStyle().getProperties()) : null, null);
    }

    @Override
    public boolean hasLink() {
        return this.event.getLink() != null;
    }

    @Override
    public int compareTo(CorrelationLine o) {
        if (!(o instanceof EventLine)) {
            return this.getCorrelationType().compareTo(o.getCorrelationType());
        }
        EventLine l = (EventLine)o;
        if (this.event == l.event) {
            return this.ev_type.compareTo((Enum)l.ev_type);
        }
        return this.event.compareTo((Object)l.event);
    }

    @Override
    void writeXML(BufferedWriter out, int indent) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<EventCorrelationLine Name=\"" + SB.getXMLstring((String)this.toString()) + "\">\n");
        String ind = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<EventID>" + this.event.getEvID() + "</EventID>\n");
        out.write(ind + "<EventType>" + this.ev_type.name() + "</EventType>\n");
        if (this.getStyle() != null) {
            out.write(ind + "<Properties>" + this.getStyle().getProperties() + "</Properties>\n");
        }
        out.write(ind1 + "</EventCorrelationLine>\n");
    }
}

