/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import model3.IGDIntervalZone;
import model3.IGDUnitBase;
import model3.SBdb;
import util.SB;

public class IGDUnitLine
extends CorrelationLine {
    private final IGDUnitBase unit;
    private IGDIntervalZone.BoundaryType boundaryType;

    public IGDUnitLine(CorrelationType type, IGDUnitBase zone, IGDIntervalZone.BoundaryType bndType, String props) {
        super(props, type);
        this.unit = zone;
        this.boundaryType = bndType;
        assert (this.unit != null && this.boundaryType != null);
    }

    public IGDUnitLine(CorrelationType type, IGDUnitBase zone, IGDIntervalZone.BoundaryType bndType, CorrLineStyle style, Integer interpID) {
        super(type, style, interpID);
        assert (type == CorrelationType.CHRONO || type == CorrelationType.LITHO || type == CorrelationType.BIOZONE);
        this.unit = zone;
        this.boundaryType = bndType;
        assert (this.unit != null && this.boundaryType != null);
    }

    static IGDUnitLine createImplementedCopy(IGDUnitLine rhs, CorrLineStyle defaultStyle, int interpID) {
        if (rhs.getStyle() != null) {
            defaultStyle = new CorrLineStyle(rhs.getStyle().getProperties());
        }
        IGDUnitLine l = new IGDUnitLine(rhs.getCorrelationType(), rhs.unit, rhs.boundaryType, defaultStyle, interpID);
        return l;
    }

    @Override
    public Object getObject() {
        return this.unit;
    }

    @Override
    public Object getObjectType() {
        return this.boundaryType;
    }

    public String toString() {
        return (this.getStyle() != null && !this.getStyle().getShowLabelType() ? "" : this.boundaryType.toString()) + " " + (this.getStyle() != null && this.getStyle().getLabelAbr() && !this.unit.getAbr().isEmpty() ? this.unit.getAbr() : this.unit.getName());
    }

    @Override
    public Color getColour() {
        Color colour = this.getStyle().getColour();
        if (colour == null) {
            colour = !this.unit.getColour().equals(Color.WHITE) ? this.unit.getColour() : Color.DARK_GRAY;
        }
        return colour;
    }

    @Override
    CorrLineStyle.LabelPosition getDefaultLabelPosition() {
        switch (this.boundaryType) {
            case TOP: {
                return CorrLineStyle.LabelPosition.BELOW;
            }
        }
        return CorrLineStyle.LabelPosition.ABOVE;
    }

    @Override
    void store(int corrID, SBdb sbdb, Statement stmt) throws SQLException {
        String sql = "INSERT INTO " + sbdb.DBTableName(this.getCorrelationType() == CorrelationType.LITHO ? "CHTLN_UNIT_LSTRAT" : "CHTLN_UNIT") + " (corrsch_id, " + (this.getCorrelationType() == CorrelationType.LITHO ? "unit_id" : "igd_id") + ",bnd_type,style) VALUES (" + corrID + "," + this.unit.getUnitID() + "," + SB.DBString((String)this.boundaryType.name()) + "," + (this.getStyle() != null ? SB.DBString((String)this.getStyle().getProperties()) : "NULL") + ")";
        stmt.executeUpdate(sbdb.modQuery(sql));
    }

    @Override
    String getDatumString() {
        return this.unit.getUnitID() + "-" + this.boundaryType.name();
    }

    @Override
    boolean updateObjectType(Object newType) {
        if (!(newType instanceof IGDIntervalZone.BoundaryType)) {
            throw new IllegalArgumentException("Attempt to update IGDUnitLine type to " + String.valueOf(newType));
        }
        IGDIntervalZone.BoundaryType type = (IGDIntervalZone.BoundaryType)newType;
        if (this.boundaryType != type) {
            this.boundaryType = type;
            return true;
        }
        return false;
    }

    @Override
    CorrelationLine copy() {
        return new IGDUnitLine(this.getCorrelationType(), this.unit, this.boundaryType, this.getStyle() != null ? new CorrLineStyle(this.getStyle().getProperties()) : null, null);
    }

    @Override
    CorrelationLine copyLink() {
        return new IGDUnitLine(this.getCorrelationType(), this.unit.getLink(), this.boundaryType, this.getStyle() != null ? new CorrLineStyle(this.getStyle().getProperties()) : null, null);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.unit != null ? this.unit.hashCode() : 0);
        hash = 47 * hash + (this.boundaryType != null ? this.boundaryType.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IGDUnitLine)) {
            return false;
        }
        IGDUnitLine other = (IGDUnitLine)obj;
        if (!(this.unit == other.unit || this.unit != null && this.unit.equals(other.unit))) {
            return false;
        }
        if (this.boundaryType != other.boundaryType) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public boolean canEqual(Object o) {
        return o instanceof IGDUnitLine;
    }

    @Override
    public int compareTo(CorrelationLine o) {
        if (!(o instanceof IGDUnitLine)) {
            return this.getCorrelationType().compareTo(o.getCorrelationType());
        }
        IGDUnitLine l = (IGDUnitLine)o;
        if (this.unit == l.unit) {
            return this.boundaryType.compareTo((Enum)l.boundaryType);
        }
        if (this.unit.getSchID() != l.unit.getSchID()) {
            if (this.unit.getSchID() < l.unit.getSchID()) {
                return -1;
            }
            return 1;
        }
        return this.unit.compareTo((Object)l.unit);
    }

    @Override
    void writeXML(BufferedWriter out, int indent) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<IGDUnitCorrelationLine Name=\"" + SB.getXMLstring((String)this.toString()) + "\">\n");
        String ind = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<UnitID>" + this.unit.getUnitID() + "</UnitID>\n");
        out.write(ind + "<BoundaryType>" + this.boundaryType.name() + "</BoundaryType>\n");
        if (this.getStyle() != null) {
            out.write(ind + "<Properties>" + this.getStyle().getProperties() + "</Properties>\n");
        }
        out.write(ind1 + "</IGDUnitCorrelationLine>\n");
    }
}

