/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.MapBlockProperties;
import jsbchart.core.ChartProperties;
import jsbchart.graphics.map.DirectionArrow;
import jsbchart.graphics.map.SBMapViewport;
import jsbchart.graphics.map.ScaleBar;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class ChartDecorationBuilder {
    private static final Logger LOGGER = Logger.getLogger(ChartDecorationBuilder.class.getName());
    private float maxScaleBarLength = 30.0f;
    private float scaleBarMarginX = 14.0f;
    private float scaleBarMarginY = 12.0f;

    public ScaleBar buildScaleBar(SBMapViewport sbViewport, ChartProperties cp, MapBlockProperties.LegendOrientation legendOrientation) {
        ScaleBar scaleBar = null;
        try {
            int oneUnit;
            Point2D.Float midpointOfMap = new Point2D.Float(sbViewport.getMapArea().x + sbViewport.getMapArea().width * 0.5f, sbViewport.getMapArea().y + sbViewport.getMapArea().height * 0.5f);
            Point2D.Float topLeftPointMM = new Point2D.Float(sbViewport.getMapArea().x, sbViewport.getMapArea().y);
            Point2D.Float leftPointMM = new Point2D.Float(midpointOfMap.x - this.maxScaleBarLength * 0.5f, midpointOfMap.y);
            Point2D.Float rightPointMM = new Point2D.Float(midpointOfMap.x + this.maxScaleBarLength * 0.5f, midpointOfMap.y);
            Position2D topLeftPointLL = sbViewport.getLatLonOfMapPosition(topLeftPointMM);
            Position2D midpointLL = sbViewport.getLatLonOfMapPosition(midpointOfMap);
            Position2D leftPointLL = sbViewport.getLatLonOfMapPosition(leftPointMM);
            Position2D rightPointLL = sbViewport.getLatLonOfMapPosition(rightPointMM);
            GeodeticCalculator gc = new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            gc.setStartingPosition((Position)leftPointLL);
            gc.setDestinationPosition((Position)rightPointLL);
            double maxDistance = gc.getOrthodromicDistance();
            String units = "m";
            if (maxDistance >= 1000.0) {
                units = "km";
                maxDistance /= 1000.0;
            }
            int[] nums = new int[]{2, 5};
            int numZeros = (int)Math.floor(Math.log10(maxDistance));
            int barDist = oneUnit = (int)Math.pow(10.0, numZeros);
            int numSteps = 1;
            for (int n : nums) {
                if (!(maxDistance >= (double)(oneUnit * n))) break;
                barDist = oneUnit * n;
                numSteps = n;
            }
            GeodeticCalculator gc2 = new GeodeticCalculator(leftPointLL.getCoordinateReferenceSystem());
            gc2.setStartingPosition((Position)leftPointLL);
            if (units == "km") {
                gc2.setDirection(90.0, (double)(barDist * 1000));
            } else {
                gc2.setDirection(90.0, (double)barDist);
            }
            Point2D newRightPos = gc2.getDestinationGeographicPoint();
            Point2D.Float newRightPosMM = sbViewport.getMMPositionFromLatLon(new Position2D((CoordinateReferenceSystem)gc2.getGeographicCRS(), newRightPos.getX(), newRightPos.getY()));
            Point2D.Float lPosMM = sbViewport.getMMPositionFromLatLon(leftPointLL);
            Point2D.Float rPosMM = sbViewport.getMMPositionFromLatLon(rightPointLL);
            Point2D.Float midMM = sbViewport.getMMPositionFromLatLon(midpointLL);
            Point2D.Float tlMM = sbViewport.getMMPositionFromLatLon(topLeftPointLL);
            float scaleBarLengthMm = newRightPosMM.x - leftPointMM.x;
            Point2D.Float position = this.calculateScaleBarPosition(sbViewport.getMapArea(), scaleBarLengthMm, legendOrientation, cp.getFontSizeSmall());
            int numSections = Math.max(numSteps, 2);
            scaleBar = new ScaleBar(scaleBarLengthMm, 3.0f, Integer.toString(barDist), numSections, units, position, cp.getFontSizeSmall(), cp.foreground, cp.background);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.WARNING, "An IllegalArgumentException occurred while generating the scale bar: " + ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "An error occurred while generating the scale bar", ex);
        }
        return scaleBar;
    }

    private Point2D.Float calculateScaleBarPosition(Rectangle2D.Float mapArea, float actualScaleBarLength, MapBlockProperties.LegendOrientation legendPosition, float fontSize) {
        float posX = mapArea.x + mapArea.width - actualScaleBarLength - fontSize * 1.2f - 3.0f;
        if (legendPosition == MapBlockProperties.LegendOrientation.BOTTOMRIGHT) {
            posX = mapArea.x + 3.0f;
        }
        float posY = mapArea.y + mapArea.height - 2.0f * fontSize - 3.0f;
        return new Point2D.Float(posX, posY);
    }

    public float getMaxScaleBarLength() {
        return this.maxScaleBarLength;
    }

    public void setMaxScaleBarLength(float maxScaleBarLength) {
        this.maxScaleBarLength = maxScaleBarLength;
    }

    public DirectionArrow buildDirectionArrow(ScaleBar sb, ChartProperties cp, MapBlockProperties.LegendOrientation legendOrientation) {
        float width = sb.getHeight() + 1.0f;
        float height = sb.getHeight() + 1.0f;
        float topMargin = 0.5f * cp.getFontSizeSmall() - 1.5f;
        Point2D.Float arrowPos = legendOrientation != MapBlockProperties.LegendOrientation.BOTTOMRIGHT ? new Point2D.Float(sb.getPosition().x - width - 2.5f, sb.getPosition().y + topMargin) : new Point2D.Float(sb.getPosition().x + sb.getWidth() + width + 2.5f, sb.getPosition().y + topMargin);
        return new DirectionArrow(arrowPos, width, height, cp.foreground);
    }
}

