/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.map.MapPositionCalculator;
import jsbchart.graphics.map.ScaleBarDetails;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextLayoutPreferences;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DirectLayer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class MapScaleBar
extends DirectLayer {
    private float maximumWidthOfScaleBar = 50.0f;
    private float border = 4.0f;
    private float height = 1.0f;
    private final MapPositionCalculator calculator;

    public MapScaleBar(MapPositionCalculator calculator) {
        this.calculator = calculator;
    }

    public void draw(Graphics2D graphics, MapContent map, MapViewport viewport) {
        float barWidth;
        String[] labels;
        String units;
        SBGraphics sg = new SBGraphics(graphics, null, true, true);
        sg.setColor(Color.black);
        Position2D posStart = this.calculator.getWorldPosInWGS84(this.border, this.border);
        Position2D posEnd = this.calculator.getWorldPosInWGS84(this.maximumWidthOfScaleBar + this.border, this.border);
        GeodeticCalculator gc = new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        gc.setStartingGeographicPoint((Point2D)posStart);
        gc.setDestinationGeographicPoint((Point2D)posEnd);
        sg.setFontSize(5.0f);
        double maxScaleBarDistance = gc.getOrthodromicDistance();
        if (maxScaleBarDistance < 1000.0) {
            units = "m";
            ScaleBarDetails details = ScaleBarDetails.calculateBarDetails(maxScaleBarDistance);
            labels = details.getLabels();
            barWidth = this.calcBarWidth(this.border, details.getBarWidth());
        } else {
            float distanceKm = (float)(maxScaleBarDistance / 1000.0);
            units = "km";
            ScaleBarDetails details = ScaleBarDetails.calculateBarDetails(distanceKm);
            barWidth = this.calcBarWidth(this.border, (float)((double)details.getBarWidth() * 1000.0));
            labels = details.getLabels();
        }
        this.drawScaleBar(sg, this.border, this.border, barWidth, this.height, labels, units);
    }

    private float calcBarWidth(float border, float distance) {
        GeodeticCalculator gc = new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Position2D posStart = this.calculator.calculateWorldPos(border, border);
        gc.setStartingGeographicPoint((Point2D)posStart);
        gc.setDirection(90.0, (double)distance);
        Point2D dest = gc.getDestinationGeographicPoint();
        Point2D.Float startM = this.calculator.getMMPositionFromLonLat((float)posStart.getX(), (float)posStart.getY());
        Point2D.Float destmm = this.calculator.getMMPositionFromLonLat((float)dest.getX(), (float)dest.getY());
        float width = (float)destmm.getX() - (float)startM.getX();
        return width;
    }

    private String[] buildLabels(int num, int step) {
        String[] labels = new String[num + 1];
        for (int i = 0; i < num + 1; ++i) {
            labels[i] = Integer.toString(step * i);
        }
        return labels;
    }

    private void drawScaleBar(SBGraphics sg, float x, float y, float width, float height, String[] labels, String units) {
        sg.setStroke(0.1f);
        sg.setColor(Color.black);
        sg.drawRect(x, y, width, height);
        int numSections = labels.length - 1;
        if (numSections < 1) {
            numSections = 1;
        }
        float[] positions = new float[numSections];
        float sectionWidth = width / (float)numSections;
        TextLayoutPreferences tlp = new TextLayoutPreferences();
        tlp.setFont(SBFont.buildFontFromGraphics(sg, 5.0f));
        boolean fill = true;
        for (int i = 0; i < numSections; ++i) {
            float sectionEnd;
            float sectionStart = sectionWidth * (float)i;
            positions[i] = sectionEnd = sectionWidth * (float)(i + 1);
            if (fill) {
                sg.fillRect(x + sectionStart, y, sectionEnd - sectionStart, height);
            }
            boolean bl = fill = !fill;
            if (i != 0) continue;
            this.drawScaleLabel(sg, tlp, x + sectionStart, y + height, labels[i]);
        }
        this.drawScaleLabel(sg, tlp, x + width, y + height, labels[labels.length - 1]);
        sg.drawString(units, x + width + 1.0f, y + 1.5f);
    }

    private void drawScaleLabel(SBGraphics sg, TextLayoutPreferences tlp, float x, float y, String label) {
        DimensionF dim = sg.measureText(label, tlp);
        float textX = (float)((double)x - 0.5 * (double)dim.getWidth());
        float textY = y + dim.getHeight() - 1.5f;
        sg.drawString(label, textX, textY);
    }

    public ReferencedEnvelope getBounds() {
        return null;
    }

    public void dispose() {
        this.preDispose();
    }

    public static enum ScaleBarPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CENTER;

    }
}

