/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

public class ScaleBarDetails {
    private final int barWidth;
    private final int numSteps;

    public ScaleBarDetails(int barWidth, int numSteps) {
        this.barWidth = barWidth;
        this.numSteps = numSteps;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public String[] getLabels() {
        String[] labels = new String[this.numSteps + 1];
        int step = this.barWidth / this.numSteps;
        for (int i = 0; i < this.numSteps + 1; ++i) {
            labels[i] = Integer.toString(step * i);
        }
        return labels;
    }

    public static ScaleBarDetails calculateBarDetails(double maximumScaleBarDistance) {
        int oneUnit;
        int[] nums = new int[]{1, 2, 5, 10};
        int numZeros = (int)Math.floor(Math.log10(maximumScaleBarDistance));
        int barDist = oneUnit = (int)Math.pow(10.0, numZeros);
        int numSteps = 1;
        for (int n : nums) {
            if (!(maximumScaleBarDistance >= (double)(oneUnit * n))) break;
            barDist = oneUnit * n;
            numSteps = n;
        }
        return new ScaleBarDetails(barDist, numSteps);
    }
}

