/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.util.Collection;
import java.util.List;
import model3.Well;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class WellEnvelopeHelper {
    public static ReferencedEnvelope getWellEnvelope(Collection<Well> wells) {
        List<Well> wellsWithLocation = wells.stream().filter(w -> w.getHeader().hasLocation()).toList();
        Envelope wellRegion = new Envelope(-178.0, 178.0, -89.0, 89.0);
        if (!wellsWithLocation.isEmpty()) {
            wellRegion = WellEnvelopeHelper.generateEnvelopeFromWellList(wellsWithLocation);
        }
        return new ReferencedEnvelope(wellRegion, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    private static Envelope generateEnvelopeFromWellList(List<Well> wells) {
        Envelope e = new Envelope();
        wells.forEach(w -> e.expandToInclude(WellEnvelopeHelper.getWellCoordinate(w)));
        e.expandBy(e.getWidth() * 0.2, e.getHeight() * 0.2);
        double minWidth = 2.0;
        double minHeight = 2.0;
        double extraWidth = Math.max(0.0, minWidth - e.getWidth()) * 0.5;
        double extraHeight = Math.max(0.0, minHeight - e.getHeight()) * 0.5;
        if (extraWidth > 0.0 || extraHeight > 0.0) {
            e.expandBy(extraWidth, extraHeight);
        }
        return e;
    }

    public static Coordinate getWellCoordinate(Well w) {
        if (w.getHeader().hasLocation()) {
            return new Coordinate(w.getHeader().getLong_dec().doubleValue(), w.getHeader().getLat_dec().doubleValue());
        }
        return null;
    }
}

