/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jsbchart.graphics.map.SelectedWellFunction;
import model3.Well;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.map.FeatureLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.StyleBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class WellSelectionFeatureBuilder {
    private static int MAX_NUM_WELLS_TO_SHOW_ALL_LABELS = 100;

    public FeatureLayer buildWellsLayer(List<Well> wells) {
        SimpleFeatureType cityFeatureType = this.buildWellsFeatureType();
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(cityFeatureType);
        for (Well w : wells) {
            if (w.getHeader() == null || !w.getHeader().hasLocation()) continue;
            Point point = this.getPoint(geometryFactory, w);
            featureBuilder.set("the_geom", (Object)point);
            featureBuilder.set("well_id", (Object)w.getWellID());
            featureBuilder.set("well_name", (Object)w.getWellName());
            featureBuilder.set("has_data", (Object)Boolean.TRUE);
            features.add(featureBuilder.buildFeature(null));
        }
        SimpleFeatureSource featureSource = DataUtilities.source((SimpleFeature[])features.toArray(new SimpleFeature[features.size()]));
        boolean showAllLabels = wells.size() < MAX_NUM_WELLS_TO_SHOW_ALL_LABELS;
        Style style = this.createSelectedStyle(showAllLabels);
        FeatureLayer wellLayer = new FeatureLayer((FeatureSource)featureSource, style);
        return wellLayer;
    }

    private SimpleFeatureType buildWellsFeatureType() {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName("Well");
        ftBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ftBuilder.add("the_geom", Point.class);
        ftBuilder.length(15).add("well_name", String.class);
        ftBuilder.add("well_id", Integer.class);
        ftBuilder.add("has_data", Boolean.class);
        SimpleFeatureType type = ftBuilder.buildFeatureType();
        return type;
    }

    private Point getPoint(GeometryFactory geometryFactory, Well w) {
        Coordinate c = new Coordinate(0.0, 0.0);
        if (w.getHeader().hasLocation()) {
            c = new Coordinate(w.getHeader().getLong_dec().doubleValue(), w.getHeader().getLat_dec().doubleValue());
        }
        Point point = geometryFactory.createPoint(c);
        return point;
    }

    private static Symbolizer createTextSymbolizer() {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        TextSymbolizer ts = sf.createTextSymbolizer();
        String labelAttributeName = "well_name";
        PropertyName pn = ff.property(labelAttributeName);
        ts.setLabel((Expression)pn);
        ts.setFill(sf.createFill((Expression)ff.literal((Object)Color.black)));
        float fontSize = 387.97f;
        Literal family = ff.literal((Object)"Arial");
        Literal style = ff.literal((Object)"normal");
        Literal weight = ff.literal((Object)"normal");
        Literal size = ff.literal(fontSize);
        Font font = sf.createFont((Expression)family, (Expression)style, (Expression)weight, (Expression)size);
        ts.setFont(font);
        AnchorPoint anchorPoint = sf.createAnchorPoint((Expression)ff.literal(0.5), (Expression)ff.literal(0));
        Displacement displacement = sf.createDisplacement((Expression)ff.literal(0), (Expression)ff.literal(fontSize / 2.0f));
        PointPlacement labelPlacement = sf.createPointPlacement(anchorPoint, displacement, null);
        ts.setLabelPlacement((LabelPlacement)labelPlacement);
        Map options = ts.getOptions();
        options.put("maxDisplacement", "1000");
        return ts;
    }

    public Style createSelectedStyle(boolean showAllLabels) {
        StyleBuilder sb = new StyleBuilder();
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        LinkedList<Symbolizer> defaultSymbolizers = new LinkedList<Symbolizer>();
        Rule primaryRule = sf.createRule();
        primaryRule.setName("select_well_id");
        Function func = ff.function(SelectedWellFunction.NAME.getFunctionName(), new Expression[]{ff.property("well_id")});
        PropertyIsEqualTo functionFilter = ff.equals((Expression)func, (Expression)ff.literal(true));
        primaryRule.setFilter((Filter)functionFilter);
        primaryRule.symbolizers().addAll(List.of(WellSelectionFeatureBuilder.createPointSymbolizer(Color.blue, 3.0f), WellSelectionFeatureBuilder.createTextSymbolizer()));
        if (showAllLabels) {
            defaultSymbolizers.addAll(List.of(WellSelectionFeatureBuilder.createPointSymbolizer(Color.red, 2.0f), WellSelectionFeatureBuilder.createTextSymbolizer()));
        } else {
            defaultSymbolizers.add(WellSelectionFeatureBuilder.createPointSymbolizer(Color.red, 2.0f));
        }
        Rule elseRule = sf.rule("default", null, null, Double.MIN_VALUE, Double.MAX_VALUE, defaultSymbolizers, null);
        FeatureTypeStyle featureTypeStyle = sb.createFeatureTypeStyle("Well", new Rule[]{primaryRule, elseRule});
        Style style = sb.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }

    private static Symbolizer createPointSymbolizer(Color c, float size) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Literal fillColour = ff.literal((Object)c);
        Fill fill = sf.fill(null, (Expression)fillColour, (Expression)ff.literal(1.0));
        ArrayList<Mark> symbols = new ArrayList<Mark>();
        symbols.add(sf.mark((Expression)ff.literal((Object)"circle"), fill, null));
        Expression opacity = null;
        Literal pointSize = ff.literal(size * 100.0f);
        Expression rotation = null;
        AnchorPoint anchor = null;
        Displacement displacement = null;
        Graphic wellGraphic = sf.graphic(symbols, opacity, (Expression)pointSize, rotation, anchor, displacement);
        return sf.pointSymbolizer("point", (Expression)ff.property("the_geom"), null, null, wellGraphic);
    }
}

