/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import java.util.ArrayList;
import java.util.List;
import jsbchart.graphics.text.IHorizontalTextWrapper;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextSettings;

public class HorizontalTextWrapper
implements IHorizontalTextWrapper {
    private static final String ELLIPSIS = "...";
    private static final char HYPHEN = '-';
    private static final int MIN_SUBTOKEN_WIDTH = 3;
    public static char SYLLABLE_SEPARATION_CHAR = (char)92;
    private boolean truncateToWholeToken = false;
    private final ITextMeasurer measurer;
    private String truncationMarker = "...";

    public HorizontalTextWrapper(ITextMeasurer measurer) {
        this.measurer = measurer;
    }

    @Override
    public void setTruncationMarker(String value) {
        this.truncationMarker = value;
    }

    @Override
    public String getTruncationMarker() {
        return this.truncationMarker;
    }

    @Override
    public void setTruncateToWholeToken(boolean value) {
        this.truncateToWholeToken = value;
    }

    public boolean getTruncateToWholeToken() {
        return this.truncateToWholeToken;
    }

    @Override
    public List<String> wrap(String text, float width, float height, TextSettings settings) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text == null) {
            lines.add(null);
            return lines;
        }
        String t = text;
        t = t.replaceAll("\n", " \n ");
        String[] tokens = t.trim().split(" ");
        tokens = this.clearEmptyTokens(tokens);
        int numLines = this.howManyLinesWillFit(height, settings.getFont());
        Object line = "";
        for (int tokenIndex = 0; tokenIndex < tokens.length; ++tokenIndex) {
            String tok = tokens[tokenIndex];
            if (lines.size() + 1 >= numLines) {
                if (tok.equals("\n")) {
                    if (tokenIndex == tokens.length - 1) break;
                    line = ((String)line).trim() + this.truncationMarker;
                    break;
                }
                if (this.measureTextWidth((String)line + tok + this.truncationMarker, settings) < width) {
                    line = (String)line + tok + " ";
                    continue;
                }
                if (tokenIndex == tokens.length - 1 && this.measureTextWidth((String)line + tok, settings) < width) {
                    line = (String)line + tok + " ";
                    continue;
                }
                if (this.truncateToWholeToken) {
                    line = ((String)line).trim() + this.truncationMarker;
                    break;
                }
                line = this.fillLineWithTokenAndEllipsis(tok, (String)line, settings, width);
                break;
            }
            if (tok.equals("\n")) {
                this.addLine(lines, ((String)line).trim());
                line = "";
                continue;
            }
            if (this.measureTextWidth((String)line + tok, settings) >= width) {
                if (this.measureTextWidth(tok, settings) >= width) {
                    line = this.addHyphenatedToken((String)line, lines, numLines, tok, width, settings);
                    if (lines.size() < numLines) continue;
                    break;
                }
                this.addLine(lines, ((String)line).trim());
                line = tok + " ";
                continue;
            }
            line = (String)line + tok + " ";
        }
        if (((String)line).length() > 0) {
            this.addLine(lines, (String)line);
        }
        if (lines.isEmpty()) {
            lines.add("");
        }
        return lines;
    }

    private String[] clearEmptyTokens(String[] tokens) {
        ArrayList<String> l = new ArrayList<String>();
        for (String token : tokens) {
            if (!token.equals("\n") && (token.trim().isEmpty() || token.replace(SYLLABLE_SEPARATION_CHAR, ' ').trim().isEmpty())) continue;
            l.add(token);
        }
        return l.toArray(new String[l.size()]);
    }

    private String fillLineWithTokenAndEllipsis(String tok, String line, TextSettings settings, float width) {
        Object subToken = "";
        for (int charIndex = 0; charIndex < tok.length() && this.measureTextWidth((String)line + (String)subToken + tok.charAt(charIndex) + this.truncationMarker, settings) < width; ++charIndex) {
            subToken = (String)subToken + tok.charAt(charIndex);
        }
        line = ((String)subToken).length() > 0 ? (String)line + (String)subToken + this.truncationMarker : ((String)line).trim() + this.truncationMarker;
        return line;
    }

    private String addHyphenatedToken(String currentLine, List<String> lines, int numLines, String token, float width, TextSettings settings) {
        String remaining;
        if (this.measureTextWidth(currentLine + token, settings) < width) {
            return currentLine + token + " ";
        }
        String subToken = this.tryHyphenateWithSyllableChars(currentLine, token, width, settings);
        if (subToken.isEmpty()) {
            subToken = this.hyphenateAtLastPoint(currentLine, token, width, settings);
        }
        if (!currentLine.isEmpty() && subToken.length() < 3) {
            this.addLine(lines, currentLine);
            remaining = token;
        } else {
            if (token.startsWith(subToken)) {
                remaining = token.substring(subToken.length());
            } else {
                remaining = token.substring(subToken.length() - 1);
                if (remaining.isEmpty()) {
                    subToken = subToken.substring(0, subToken.length() - 1);
                }
            }
            if (remaining.isEmpty()) {
                return currentLine + subToken + " ";
            }
            this.addLine(lines, currentLine + subToken);
        }
        if (lines.size() >= numLines - 1) {
            if (remaining.isEmpty() || this.measureTextWidth(remaining, settings) < width) {
                return remaining + " ";
            }
            return this.fillLineWithTokenAndEllipsis(remaining, "", settings, width);
        }
        return this.addHyphenatedToken("", lines, numLines, remaining, width, settings);
    }

    private String hyphenateAtLastPoint(String currentLine, String token, float width, TextSettings settings) {
        String subToken = "" + token.charAt(0);
        for (int charIndex = 1; charIndex < token.length(); ++charIndex) {
            String testText = currentLine + subToken + token.charAt(charIndex);
            if (token.charAt(charIndex) != '-') {
                testText = testText + "-";
            }
            if (!(this.measureTextWidth(testText, settings) < width)) break;
            subToken = subToken + token.charAt(charIndex);
        }
        if (subToken.charAt(subToken.length() - 1) != '-') {
            subToken = subToken + "-";
        }
        return subToken;
    }

    private String tryHyphenateWithSyllableChars(String currentLine, String token, float width, TextSettings settings) {
        int[] syllablePositions = this.getSyllablePositions(token);
        for (int i = syllablePositions.length - 1; i >= 0; --i) {
            Object subToken = token.substring(0, syllablePositions[i]);
            if (((String)subToken).length() == 0) {
                return "";
            }
            if (((String)subToken).charAt(((String)subToken).length() - 1) != '-') {
                subToken = (String)subToken + "-";
            }
            if (!(this.measureTextWidth(currentLine + (String)subToken, settings) < width)) continue;
            return subToken;
        }
        return "";
    }

    private int[] getSyllablePositions(String s) {
        ArrayList<Integer> syllablePositions = new ArrayList<Integer>();
        int index = s.indexOf(SYLLABLE_SEPARATION_CHAR);
        while (index >= 0) {
            syllablePositions.add(index);
            index = s.indexOf(SYLLABLE_SEPARATION_CHAR, index + 1);
        }
        int[] result = new int[syllablePositions.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)syllablePositions.get(i);
        }
        return result;
    }

    private int howManyLinesWillFit(float height, SBFont font) {
        float lineHeight = this.measurer.calculateHorizontalLineHeight(font);
        float num = height / lineHeight;
        return (int)Math.floor(num);
    }

    private float measureTextWidth(String text, TextSettings settings) {
        String s = this.removeSyllableSeparationChar(text).trim();
        return this.measurer.calculateTextWidth(s, settings);
    }

    private void addLine(List<String> lines, String line) {
        String s = this.removeSyllableSeparationChar(line);
        lines.add(s.trim());
    }

    public String removeSyllableSeparationChar(String s) {
        return s.replace(Character.toString(SYLLABLE_SEPARATION_CHAR), "");
    }
}

