/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.ITruncationHandler;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.VerticalAlignment;

public class TextLayoutPreferences {
    private HorizontalAlignment hozAlign = HorizontalAlignment.Left;
    private VerticalAlignment vertAlign = VerticalAlignment.Top;
    private TextDirection textDirection = TextDirection.Horizontal;
    private SBFont font = new SBFont("Arial", 0, 10.0f);
    private boolean hideOnOverflow = false;
    private boolean wrapText = false;
    private float minFontSize = 10.0f;
    private boolean truncateText = false;
    private ITruncationHandler truncationHandler = null;

    public TextLayoutPreferences copy() {
        TextLayoutPreferences tlp = new TextLayoutPreferences().setHorizontalAlignment(this.hozAlign).setVerticalAlignment(this.vertAlign).setTextDirection(this.textDirection).setFont(this.font).minFontSize(this.minFontSize);
        if (this.hideOnOverflow) {
            tlp.hideOnOverflow();
        } else {
            tlp.overflowVisible();
        }
        if (this.wrapText) {
            tlp.wrapText();
        } else {
            tlp.singleLineOfText();
        }
        if (this.truncateText) {
            tlp.truncateText();
        } else {
            tlp.dontTruncateText();
        }
        return tlp;
    }

    public TextLayoutPreferences setHorizontalAlignment(HorizontalAlignment value) {
        this.hozAlign = value;
        return this;
    }

    public TextLayoutPreferences setVerticalAlignment(VerticalAlignment value) {
        this.vertAlign = value;
        return this;
    }

    public TextLayoutPreferences setTextDirection(TextDirection value) {
        this.textDirection = value;
        return this;
    }

    public TextLayoutPreferences setFont(SBFont value) {
        this.font = value;
        this.minFontSize = value.getSize();
        return this;
    }

    public TextLayoutPreferences hideOnOverflow() {
        this.hideOnOverflow = true;
        return this;
    }

    public TextLayoutPreferences overflowVisible() {
        this.hideOnOverflow = false;
        return this;
    }

    public TextLayoutPreferences truncateText() {
        this.truncateText = true;
        return this;
    }

    public TextLayoutPreferences wrapText() {
        this.wrapText = true;
        return this;
    }

    public TextLayoutPreferences singleLineOfText() {
        this.wrapText = false;
        return this;
    }

    public TextLayoutPreferences dontTruncateText() {
        this.truncateText = false;
        return this;
    }

    public TextLayoutPreferences minFontSize(float value) {
        this.minFontSize = value;
        return this;
    }

    public TextLayoutPreferences dontResizeText() {
        this.minFontSize = this.font.getSize();
        return this;
    }

    public TextLayoutPreferences setTruncationHandler(ITruncationHandler handler) {
        this.truncationHandler = handler;
        return this;
    }

    public HorizontalAlignment getHorizontalAllignment() {
        return this.hozAlign;
    }

    public VerticalAlignment getVerticalAllignment() {
        return this.vertAlign;
    }

    public TextDirection getTextDirection() {
        return this.textDirection;
    }

    public SBFont getFont() {
        return this.font;
    }

    public float getMinFontSize() {
        return this.minFontSize;
    }

    public boolean getWrapText() {
        return this.wrapText;
    }

    public boolean shouldTruncate() {
        return this.truncateText;
    }

    public boolean shouldHideIfOverflow() {
        return this.hideOnOverflow;
    }

    public boolean hasTruncationHandler() {
        return this.truncationHandler != null;
    }

    public ITruncationHandler getTruncationHandler() {
        return this.truncationHandler;
    }

    public TextSettings buildSettings() {
        TextSettings settings = new TextSettings(this.getHorizontalAllignment(), this.getVerticalAllignment(), this.getTextDirection(), this.getFont());
        return settings;
    }
}

