/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.ITextRenderer;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.VerticalAlignment;

public class TextRenderer
implements ITextRenderer {
    private static final boolean DEBUG = false;
    private final Graphics2D g;
    private final float scale;
    private final ITextMeasurer measurer;

    public TextRenderer(Graphics2D g, ITextMeasurer measurer, float scale) {
        this.g = g;
        this.measurer = measurer;
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    private void drawVerticalText(String text, float x, float y) {
        AffineTransform orig = this.g.getTransform();
        this.g.rotate(-1.5707963267948966, x * this.getScale(), y * this.getScale());
        this.drawStringInternal(text, x * this.getScale(), y * this.getScale());
        this.g.setTransform(orig);
    }

    private void drawHorizontalText(String text, float x, float y) {
        this.drawStringInternal(text, x * this.getScale(), y * this.getScale());
    }

    @Override
    public Rectangle2D.Float drawString(String text, Rectangle2D.Float rect, TextSettings settings) {
        return this.drawString(new String[]{text}, rect, settings);
    }

    public Rectangle2D.Float calculateDrawnArea(String text, Rectangle2D.Float rect, TextSettings settings) {
        return this.calculateDrawnArea(new String[]{text}, rect, settings);
    }

    @Override
    public Rectangle2D.Float drawString(String[] lines, Rectangle2D.Float rect, TextSettings settings) {
        this.g.setFont(settings.getFont().buildGraphicsFont(this.scale));
        if (settings.getTextDirection() == TextDirection.Vertical) {
            this.drawVerticalString(rect, settings, lines);
        } else {
            this.drawHorizontalString(rect, settings, lines);
        }
        return this.calculateDrawnArea(lines, rect, settings);
    }

    private void drawVerticalString(Rectangle2D.Float rect, TextSettings settings, String[] lines) {
        float xPos = this.getTextXPosition(rect, settings, this.measurer.calculateTextWidth(lines, settings));
        xPos += this.getFontAscent();
        for (String l : lines) {
            float textHeight = this.measurer.calculateTextHeight(l, settings);
            float yPos = this.getTextYPosition(rect, settings, textHeight);
            this.drawVerticalText(l, xPos, yPos + textHeight);
            xPos += this.getLineHeight();
        }
    }

    private void drawHorizontalString(Rectangle2D.Float rect, TextSettings settings, String[] lines) {
        float yPos = this.getTextYPosition(rect, settings, this.measurer.calculateTextHeight(lines, settings));
        yPos += this.getFontAscent();
        for (String l : lines) {
            float textWidth = this.measurer.calculateTextWidth(l, settings);
            float xPos = this.getTextXPosition(rect, settings, textWidth);
            this.drawHorizontalText(l, xPos, yPos);
            yPos += this.getLineHeight();
        }
    }

    public float getFontAscent() {
        return (float)this.g.getFontMetrics().getAscent() / this.getScale();
    }

    public float getFontDescent() {
        return (float)this.g.getFontMetrics().getDescent() / this.getScale();
    }

    public float getLineHeight() {
        return (float)this.g.getFontMetrics().getHeight() / this.getScale();
    }

    public float getFontLeading() {
        return (float)this.g.getFontMetrics().getLeading() / this.getScale();
    }

    private float getTextYPosition(Rectangle2D.Float rect, TextSettings settings, float totalHeight) {
        if (settings.getVerticalAlignment() == VerticalAlignment.Top) {
            return rect.y;
        }
        if (settings.getVerticalAlignment() == VerticalAlignment.Middle) {
            float yShift = (rect.height - totalHeight) * 0.5f;
            return rect.y + yShift;
        }
        return rect.y + rect.height - totalHeight;
    }

    private float getTextXPosition(Rectangle2D.Float rect, TextSettings settings, float textWidth) {
        if (settings.getHorizontalAlignment() == HorizontalAlignment.Left) {
            return rect.x;
        }
        if (settings.getHorizontalAlignment() == HorizontalAlignment.Centre) {
            float xShift = (rect.width - textWidth) * 0.5f;
            return rect.x + xShift;
        }
        return rect.x + rect.width - textWidth;
    }

    private void drawDebugRect(Rectangle2D.Float rect, Color color) {
        Color c = this.g.getColor();
        this.g.setColor(color);
        this.g.drawRect((int)(rect.x * this.getScale()), (int)(rect.y * this.getScale()), (int)(rect.width * this.getScale()), (int)(rect.height * this.getScale()));
        this.g.setColor(c);
    }

    private void drawDebugLine(float x1, float y1, float x2, float y2, Color color) {
        Color c = this.g.getColor();
        this.g.setColor(color);
        this.g.drawLine((int)(x1 * this.getScale()), (int)(y1 * this.getScale()), (int)(x2 * this.getScale()), (int)(y2 * this.getScale()));
        this.g.setColor(c);
    }

    public Rectangle2D.Float calculateDrawnArea(String[] lines, Rectangle2D.Float rect, TextSettings settings) {
        DimensionF textSize = this.measurer.calculateTextDimensions(lines, settings);
        float width = textSize.getWidth();
        float height = textSize.getHeight();
        float x = settings.getHorizontalAlignment() == HorizontalAlignment.Left ? rect.x : (settings.getHorizontalAlignment() == HorizontalAlignment.Centre ? rect.x + rect.width * 0.5f - width * 0.5f : rect.x + rect.width - width);
        float y = settings.getVerticalAlignment() == VerticalAlignment.Top ? rect.y : (settings.getVerticalAlignment() == VerticalAlignment.Middle ? rect.y + rect.height * 0.5f - height * 0.5f : rect.y + rect.height - height);
        Rectangle2D.Float r = new Rectangle2D.Float(x, y, width, height);
        return r;
    }

    private void drawStringInternal(String string, float x, float y) {
        String s = string;
        if (this.g instanceof PdfBoxGraphics2D) {
            s = s.replace("\n", " ");
        }
        this.g.drawString(s, x, y);
    }
}

