/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import jsbchart.graphics.DimensionF;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextSettings;

public class TextSizer {
    public static final int NUM_TRIES_TO_FIT = 10;
    public static final float MIN_FONT_SIZE_DIFFERENCE = 0.1f;
    private final ITextMeasurer measurer;

    public TextSizer(ITextMeasurer m) {
        this.measurer = m;
    }

    public boolean canResize(TextSettings settings, float minSize) {
        return settings.getFont().getSize() - minSize > 0.1f;
    }

    public TextSettings resizeTextToFit(String text, DimensionF box, TextSettings originalSettings, float minSize) {
        String[] lines = new String[]{text};
        if (!this.canResize(originalSettings, minSize)) {
            return originalSettings;
        }
        DimensionF textSize = this.measurer.calculateTextDimensions(lines, originalSettings);
        if (textSize.fitsInside(box)) {
            return originalSettings;
        }
        TextSettings newSettings = originalSettings;
        for (int i = 0; i <= 10; ++i) {
            newSettings = this.resizeIteration(i, originalSettings, minSize);
            textSize = this.measurer.calculateTextDimensions(lines, newSettings);
            if (!textSize.fitsInside(box)) continue;
            return newSettings;
        }
        return newSettings;
    }

    public TextSettings resizeIteration(int i, TextSettings originalSettings, float minSize) {
        if (i <= 0) {
            return originalSettings;
        }
        float shrinkAmount = (originalSettings.getFont().getSize() - minSize) / 10.0f;
        float newSize = originalSettings.getFont().getSize() - (float)i * shrinkAmount;
        SBFont newFont = originalSettings.getFont().resizeFont(newSize);
        return new TextSettings(originalSettings.getHorizontalAlignment(), originalSettings.getVerticalAlignment(), originalSettings.getTextDirection(), newFont);
    }
}

