/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.legacy;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlockBase;
import jsbchart.core.BlockTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplate;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.core.TemplateFactory;
import jsbchart.legacy.LegacyChart;
import jsbchart.legacy.LegacyChartPanelOption;
import jsbchart.legacy.LegacyChartType;
import jsbchart.legacy.SBChartPanel;
import jsbchart.panel.LegacyChartPanelConverter;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelScaleProperties;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonProperties;
import jsbchart.panel.PanelType;
import model3.SBChart;
import model3.SBdb;
import model3.TxGroup;
import model3.Well;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;

public class LegacyChartConverter {
    private final SBdb sbdb;
    private final ChartManager chartManager;
    private final LegacyChart legacyChart;
    private final LegacyChartPanelOption panelOption;
    private final int destinationProjectID;
    private boolean used;

    public LegacyChartConverter(SBdb sbdb, ChartManager chartManager, LegacyChart legacyChart, LegacyChartPanelOption panelOption, int destinationProjectID) {
        this.sbdb = sbdb;
        this.chartManager = chartManager;
        this.legacyChart = legacyChart;
        this.panelOption = panelOption;
        this.destinationProjectID = destinationProjectID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convertLegacyChart() throws SQLException, SBException, SBPermissionException, InvalidFieldException {
        if (this.used) {
            throw new IllegalStateException("You're not supposed to use this converter more than once!");
        }
        try {
            List<SBChartPanel> panels = this.loadPanels();
            if (panels.isEmpty()) {
                Object var2_2 = null;
                return var2_2;
            }
            System.out.println("Initial panel count: " + panels.size());
            Chart chart = this.createChart();
            this.processPanelProperties(panels, chart);
            if (panels.isEmpty()) {
                Object var3_4 = null;
                return var3_4;
            }
            System.out.println("Processing " + panels.size() + " panels...");
            List<List<SBChartPanel>> blockLists = this.createBlockPanelLists('M', panels);
            if (blockLists.isEmpty()) {
                Object var4_6 = null;
                return var4_6;
            }
            for (int i = 0; i < blockLists.size(); ++i) {
                List<SBChartPanel> panelsForBlock = blockLists.get(i);
                BlockTemplate blockTemplate = this.createBlockForChart(panelsForBlock, chart, i);
                if (chart != null) continue;
                assert (blockLists.size() == 1);
                BlockTemplate blockTemplate2 = blockTemplate;
                return blockTemplate2;
            }
            Chart chart2 = chart;
            return chart2;
        }
        finally {
            this.used = true;
        }
    }

    private List<SBChartPanel> loadPanels() throws SQLException {
        LinkedList<SBChartPanel> panels = new LinkedList<SBChartPanel>();
        String sql = "SELECT panel_no,attributes FROM " + this.sbdb.DBTableName(this.legacyChart.type.mbrTableName) + " WHERE " + this.legacyChart.type.idName + "=" + this.legacyChart.ID + " ORDER BY panel_no";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int panelNo = rs.getInt("panel_no");
                String attributes = rs.getString("attributes");
                SBChartPanel panel = new SBChartPanel(panelNo, attributes.trim().split("\\|"));
                panels.add(panel);
            }
        }
        return panels;
    }

    private Chart createChart() throws SQLException {
        Chart chart = null;
        if (this.legacyChart.type == LegacyChartType.CHART) {
            chart = new Chart(new ChartTemplate(this.chartManager, 0, this.legacyChart.name, "Generated from legacy chart " + this.legacyChart.name, this.destinationProjectID, this.sbdb.getDefaultWellList(this.destinationProjectID) != null ? this.sbdb.getDefaultWellList(this.destinationProjectID).getID() : 0, "", 0, null, null, null, 0));
            chart.getProperties().plotBlockCaptions = false;
        }
        return chart;
    }

    private void processPanelProperties(List<SBChartPanel> panels, Chart chart) throws SQLException, SBException {
        ListIterator<SBChartPanel> it = panels.listIterator();
        while (it.hasNext()) {
            SBChartPanel panel = it.next();
            try {
                int panelType = Integer.parseInt(panel.attributes[0]);
                panel.panelType = LegacyChartPanelConverter.getPanelType(panelType, panel.attributes);
                if (panel.panelType == null) {
                    switch (panelType) {
                        case 13: {
                            if (chart == null) break;
                            chart.getProperties().key = LegacyChartPanelConverter.getKeyPanel(panel.attributes);
                            break;
                        }
                        case 11: {
                            if (chart == null) break;
                            chart.getProperties().plotBlockCaptions = true;
                            break;
                        }
                        case 12: {
                            if (chart == null) break;
                            chart.getProperties().header = LegacyChartPanelConverter.getHeaderPanel(panel.attributes);
                            break;
                        }
                        default: {
                            System.out.println("Could not process SBPanelType: " + panel.attributes[0]);
                        }
                    }
                    it.remove();
                    continue;
                }
                if (this.legacyChart.type == LegacyChartType.CHART) {
                    int wellAttNo = SBChart.Panel.getWellAttNo((int)panelType);
                    if (wellAttNo > -1 && wellAttNo < panel.attributes.length) {
                        panel.wellID = Integer.parseInt(panel.attributes[wellAttNo]);
                    }
                    if (panel.wellID < 1) {
                        if (panel.panelType == null || panel.panelType == PanelType.BLANK || panel.panelType == PanelType.SCALE) continue;
                        System.out.println("No well ID for panel " + panel.attributes[0]);
                        it.remove();
                        continue;
                    }
                    if (this.sbdb.getWell(panel.wellID) == null) {
                        System.out.println("No well for " + String.valueOf(panel.panelType) + ", well ID: " + panel.wellID);
                        it.remove();
                        continue;
                    }
                    panel.interpID = LegacyChartPanelConverter.getInterpID(panelType, panel.attributes);
                    if (panel.interpID != null && panel.interpID > 0) {
                        Well well = this.sbdb.getWell(panel.wellID);
                        well.loadInterps();
                        try {
                            well.getInterp(panel.interpID.intValue());
                        }
                        catch (SBException sbe) {
                            panel.interpID = null;
                        }
                    }
                }
                if (panelType == 9) {
                    panel.schID = LegacyChartPanelConverter.getPanelZonesSchemeID(this.sbdb, panel.attributes);
                    if (panel.schID == -1) {
                        System.out.println("No scheme for biozone panel - removing");
                        it.remove();
                    }
                }
                panel.title = panel.attributes[11];
                if (panel.panelType != PanelType.WLOG) continue;
                String sql = "SELECT attributes FROM " + this.sbdb.DBTableName("SBLOGTRC") + " WHERE chart_id=" + this.legacyChart.ID + " AND panel_no=" + panel.panelNo + " ORDER BY panel_no";
                Statement statement = this.sbdb.getDatabase().createStatement();
                try {
                    ResultSet rs = statement.executeQuery(this.sbdb.modQuery(sql));
                    while (rs.next()) {
                        panel.moreAtts.add(rs.getString("attributes"));
                    }
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException nfe) {
                System.out.println(nfe.getClass().getName() + " parsing panel: " + nfe.getMessage() + " : " + Arrays.toString(panel.attributes));
                it.remove();
            }
        }
    }

    private PanelTemplate getPanelTemplate(char chartUnits, SBChartPanel panel, boolean decoupled) throws SQLException, SBException, SBPermissionException {
        PanelProperties p = LegacyChartPanelConverter.getPanelProperties(this.sbdb, chartUnits, panel.panelType, panel.attributes, panel.moreAtts);
        if (p == null) {
            return null;
        }
        PanelType type = p.getPanelType();
        if (PanelType.isTaxonPanel(type)) {
            PanelTaxonGroupProperties prop = (PanelTaxonGroupProperties)p;
            LinkedList<PanelTaxonOcc> innerPanels = prop.getInnerPanels();
            Iterator iterator = innerPanels.iterator();
            while (iterator.hasNext()) {
                TxGroup excludeGroup;
                PanelTaxonOcc o = (PanelTaxonOcc)iterator.next();
                if (o.getFilterGroup() != null && o.getFilterGroup().getProjID() != this.destinationProjectID || o.getFilterSet() != null && o.getFilterSet().getProjID() != this.destinationProjectID) {
                    o.setFilter(null);
                }
                if (!(o.getProperties() instanceof PanelTaxonProperties)) continue;
                PanelTaxonProperties innerProps = (PanelTaxonProperties)o.getProperties();
                TxGroup highlightGroup = (TxGroup)innerProps.getProperty(46);
                if (highlightGroup != null && highlightGroup.getProjID() != this.destinationProjectID) {
                    innerProps.setProperty(46, null);
                }
                if ((excludeGroup = (TxGroup)innerProps.getProperty(5)) == null || excludeGroup.getProjID() == this.destinationProjectID) continue;
                innerProps.setProperty(5, null);
            }
        }
        if (!decoupled) {
            List<PanelTemplate> panels = this.chartManager.getPanels(type, null, true);
            for (PanelTemplate templ : panels) {
                if (templ.getProjID() > 0 && templ.getProjID() != this.destinationProjectID || !templ.getProperties().equalsLegacyPanelProperties(p)) continue;
                return templ;
            }
            System.out.println("Adding panel template... (" + String.valueOf(type) + ")");
        }
        String title = panel.title != null ? panel.title : String.valueOf(panel.panelType) + "/" + this.legacyChart.name;
        String descr = decoupled ? "" : "Created during parsing of legacy chart '" + this.legacyChart.name + "'";
        return this.chartManager.addPanelTemplate(type, title, descr, this.destinationProjectID, p, null, !decoupled);
    }

    private List<List<SBChartPanel>> createBlockPanelLists(char chartUnits, List<SBChartPanel> panels) throws SQLException, SBException, SBPermissionException {
        LinkedList<List<SBChartPanel>> blockLists = new LinkedList<List<SBChartPanel>>();
        LinkedList<SBChartPanel> currentPanelList = new LinkedList<SBChartPanel>();
        int lastWellId = 0;
        for (SBChartPanel sBChartPanel : panels) {
            if (this.legacyChart.type == LegacyChartType.CHART && sBChartPanel.panelType != PanelType.BLANK && sBChartPanel.panelType != PanelType.SCALE && lastWellId > 0 && sBChartPanel.wellID != lastWellId) {
                if (!currentPanelList.isEmpty()) {
                    blockLists.add(currentPanelList);
                    currentPanelList = new LinkedList();
                }
                lastWellId = 0;
                continue;
            }
            if (sBChartPanel.panelType != PanelType.BLANK && sBChartPanel.panelType != PanelType.SCALE) {
                lastWellId = sBChartPanel.wellID;
            }
            switch (this.panelOption) {
                case CREATE_TEMPLATES: {
                    sBChartPanel.template = this.getPanelTemplate(chartUnits, sBChartPanel, false);
                    break;
                }
                case INVISIBLE_TEMPLATES: {
                    sBChartPanel.template = this.getPanelTemplate(chartUnits, sBChartPanel, true);
                    break;
                }
                case DEFAULT_TEMPLATES: {
                    sBChartPanel.template = this.chartManager.getDefaultPanelTemplate(sBChartPanel.panelType);
                }
            }
            if (sBChartPanel.template == null) {
                System.out.println("Warning: no default panel template for type: " + String.valueOf(sBChartPanel.panelType));
                continue;
            }
            currentPanelList.add(sBChartPanel);
        }
        if (!currentPanelList.isEmpty()) {
            blockLists.add(currentPanelList);
        }
        for (List list : blockLists) {
            if (((SBChartPanel)list.get((int)(list.size() - 1))).panelType != PanelType.BLANK) continue;
            list.remove(list.size() - 1);
        }
        return blockLists;
    }

    private BlockTemplate createBlockForChart(List<SBChartPanel> panels, Chart chart, int blockNo) throws SQLException, InvalidFieldException, SBPermissionException, SBException {
        ArrayList<PanelOcc> panelOccs = new ArrayList<PanelOcc>();
        BlockProperties bp = null;
        int wellID = 0;
        int nMetres = 0;
        int nFeet = 0;
        for (SBChartPanel sBChartPanel : panels) {
            PanelOcc occ = new PanelOcc(sBChartPanel.template.getID(), sBChartPanel.interpID, sBChartPanel.title, null, null, sBChartPanel.schID);
            panelOccs.add(occ);
            if (wellID == 0) {
                wellID = sBChartPanel.wellID;
            }
            if (sBChartPanel.panelType == PanelType.BLANK) continue;
            try {
                float topDepth = Float.parseFloat(sBChartPanel.attributes[6]);
                float baseDepth = Float.parseFloat(sBChartPanel.attributes[7]);
                if (sBChartPanel.attributes[9] != null && !sBChartPanel.attributes[9].isEmpty()) {
                    DepthUnits d = DepthUnits.getUnits((char)sBChartPanel.attributes[9].charAt(0));
                    topDepth = DepthUtils.convToM((float)topDepth, (char)d.getChar());
                    baseDepth = DepthUtils.convToM((float)baseDepth, (char)d.getChar());
                    if (d == DepthUnits.F) {
                        ++nFeet;
                    } else {
                        ++nMetres;
                    }
                }
                if (bp == null) {
                    bp = new BlockProperties(BlockProperties.ScaleType.MD);
                    bp.setMin(topDepth);
                    bp.setMax(baseDepth);
                } else {
                    bp.setMin(Math.min(bp.getMin(), topDepth));
                    bp.setMax(Math.min(bp.getMax(), baseDepth));
                }
                float scale = Float.parseFloat(sBChartPanel.attributes[8]);
                bp.setScale(scale);
            }
            catch (IndexOutOfBoundsException | NumberFormatException oob) {
                System.out.println("Non-fatal error parsing panel depth: " + oob.getMessage());
            }
        }
        if (nFeet > nMetres) {
            bp.setUnits('F');
            for (SBChartPanel sBChartPanel : panels) {
                if (sBChartPanel.panelType != PanelType.SCALE) continue;
                PanelScaleProperties p = (PanelScaleProperties)sBChartPanel.template.getProperties();
                if (p.getProperty(6) == Boolean.FALSE) {
                    p.setProperty(6, true);
                    continue;
                }
                p.setProperty(6, false);
            }
        }
        BlockTemplate blockTemplate = null;
        if (chart != null) {
            for (ChartBlockBase block : chart.getBlocks()) {
                if (!block.getTemplate().getPanels().equals(panelOccs)) continue;
                blockTemplate = block.getTemplate();
                break;
            }
        }
        if (blockTemplate == null) {
            blockTemplate = TemplateFactory.newBlockTemplate(this.chartManager, BlockType.WELL, "Block" + (blockNo + 1) + "/" + this.legacyChart.name, "Created from " + this.legacyChart.name, this.destinationProjectID);
            for (PanelOcc pOcc : panelOccs) {
                blockTemplate.addPanel(pOcc);
            }
        }
        if (chart != null) {
            ChartTemplate.BlockOcc blockOcc = new ChartTemplate.BlockOcc(0, wellID, 0, 0, bp != null ? bp.getProperties() : "", null);
            if (this.destinationProjectID > 0) {
                Well well = this.sbdb.getWell(wellID);
                if (!this.sbdb.getWellListService().isWellProjectMember(this.destinationProjectID, well.getWellID())) {
                    this.sbdb.addWellToProject(well, this.destinationProjectID);
                    System.out.println("Added well " + well.getWellCode() + " to project " + this.destinationProjectID);
                }
            }
            try {
                chart.addBlock(ChartFactory.createBlock(this.sbdb, blockTemplate, blockOcc));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidFieldException(e.getMessage(), (Object)blockTemplate);
            }
        }
        return blockTemplate;
    }
}

