/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.listener;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jsbchart.listener.ChartNode;

public class ChartEvent {
    private final ChartEventType type;
    private final ChartNode source;
    private boolean urgent;
    private final List<ChartNode> path = new CopyOnWriteArrayList<ChartNode>();
    private final Object arg;

    public static ChartEvent createPropertyChangeChartEvent(ChartNode source) {
        return new ChartEvent(ChartEventType.PROPERTY, source, null);
    }

    public static ChartEvent createPropertyChangeChartEvent(ChartNode source, Object arg) {
        return new ChartEvent(ChartEventType.PROPERTY, source, arg);
    }

    public static ChartEvent createDataChangeChartEvent(ChartNode source) {
        return new ChartEvent(ChartEventType.DATA, source, null);
    }

    public static ChartEvent createDataChangeChartEvent(ChartNode source, Object arg) {
        return new ChartEvent(ChartEventType.DATA, source, arg);
    }

    public static ChartEvent createSoftChangeChartEvent(ChartNode source) {
        return new ChartEvent(ChartEventType.SOFT, source, null);
    }

    private ChartEvent(ChartEventType type, ChartNode source, Object arg) {
        this.type = type;
        this.source = source;
        this.path.add(source);
        this.arg = arg;
    }

    void addNodeToPath(ChartNode node) {
        this.path.add(0, node);
    }

    public Iterator<ChartNode> getPathIterator() {
        return this.path.iterator();
    }

    public Object getArg() {
        return this.arg;
    }

    public boolean hasArgument() {
        return this.arg != null;
    }

    public ChartEventType getType() {
        return this.type;
    }

    public ChartNode getSource() {
        return this.source;
    }

    public boolean isUrgent() {
        return this.urgent;
    }

    public void setUrgent(boolean urgent) {
        this.urgent = urgent;
    }

    public String toString() {
        return String.valueOf((Object)this.type) + " source: " + this.source.getClass().getName() + ", path length: " + this.path.size() + (String)(this.arg != null ? ", arg: " + String.valueOf(this.arg) : "") + (this.urgent ? " URGENT" : "");
    }

    public static enum ChartEventType {
        PROPERTY,
        DATA,
        SOFT;

    }
}

