/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.core.ChartPanelSnapshot;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.listener.ChartNode;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import model3.InterpHdr;
import model3.WellInterp;
import util.SB;
import util.SBException;
import util.exception.StackError;

public abstract class ChartPanel
extends ChartNode
implements Observer,
PanelTemplate.Listener {
    private final PanelTemplate template;
    private final PanelOcc panelOcc;
    private PanelOcc panelOccTemp;
    private boolean isTemplateSelected = false;
    private boolean isPanelOccSelected = false;

    public abstract void setOutline(boolean var1);

    public abstract PanelProperties getProperties();

    protected Class<? extends PanelProperties> getPropertiesClass() {
        return null;
    }

    protected ChartPanel(PanelTemplate template, PanelOcc panelOcc) {
        this.template = template;
        this.panelOcc = panelOcc;
        if (template != null && panelOcc != null) {
            template.addWeakObserver(this);
            template.addListener(this);
            panelOcc.addWeakObserver(this);
        }
    }

    public void terminate() {
        if (this.template != null) {
            this.template.deleteWeakObserver(this);
        }
        if (this.panelOcc != null) {
            this.panelOcc.deleteWeakObserver(this);
        }
    }

    public void setProperties(PanelProperties p) {
        if (p.getClass() != this.getPropertiesClass()) {
            throw new IllegalArgumentException("Wrong type of panel properties for " + String.valueOf(this.getClass()) + ": " + String.valueOf(p.getClass()));
        }
        if (!p.equals(this.getProperties())) {
            this.setPropertyChanged();
        }
        try {
            Field pField;
            try {
                pField = this.getClass().getDeclaredField("p");
            }
            catch (NoSuchFieldException e) {
                pField = this.getClass().getSuperclass().getDeclaredField("p");
            }
            pField.setAccessible(true);
            pField.set(this, p);
            pField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            StackError.showStackError((Exception)e);
        }
    }

    public Integer getTemplateID() {
        if (this.template != null) {
            return this.template.getID();
        }
        return null;
    }

    public PanelTemplate getTemplate() {
        return this.template;
    }

    public final PanelOcc getPanelOcc() {
        if (this.panelOccTemp != null) {
            return this.panelOccTemp;
        }
        return this.panelOcc;
    }

    public final ChartPanelSnapshot createPanelSnapshot() {
        if (this.panelOcc.getPanelNo() == null && this.panelOccTemp != null) {
            return new ChartPanelSnapshot(this.panelOccTemp, null, this.template);
        }
        return new ChartPanelSnapshot(this.panelOcc, this.panelOccTemp, this.template);
    }

    public PanelType getPanelType() {
        if (this.template != null) {
            return this.template.getType();
        }
        return this.getProperties().getPanelType();
    }

    String toTemplateString() {
        if (this.template != null) {
            return this.template.toString();
        }
        return this.toString();
    }

    public void setTemplateSelected(boolean isSelected) {
        this.isTemplateSelected = isSelected;
    }

    public void setPanelOccSelected(boolean isSelected) {
        this.isPanelOccSelected = isSelected;
    }

    public boolean isTemplateSelected() {
        return this.isTemplateSelected;
    }

    public boolean isPanelOccSelected() {
        return this.isPanelOccSelected;
    }

    public void setPanelOccProperty(int nProp, Object prop) {
        PanelOcc po = this.panelOccTemp != null ? this.panelOccTemp : PanelOcc.copy(this.panelOcc);
        if (!po.setProperty(nProp, prop)) {
            return;
        }
        if (this.panelOcc.equals((Object)po)) {
            if (this.panelOccTemp != null) {
                this.setPropertyChanged();
            }
            po = null;
        } else {
            this.setPropertyChanged();
        }
        this.panelOccTemp = po;
        this.notifyListeners();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.panelOcc || o == this.panelOccTemp) {
            if (o == this.panelOcc && arg != null && this.getPanelType().isInterpPanel()) {
                WellInterp origInterp;
                WellInterp newInterp = null;
                try {
                    if (arg instanceof Integer) {
                        origInterp = this.getBlock().getWell().getInterp(((Integer)arg).intValue());
                    } else if (arg == InterpHdr.class) {
                        origInterp = ((ChartBlock)this.getBlock()).getInterp();
                    } else {
                        assert (false);
                        origInterp = null;
                    }
                    if (this.getBlock().getWell() != null) {
                        this.getBlock().getWell().loadInterps();
                        newInterp = this.getBlock().getWell().getInterp(this.panelOcc.getInterpID() != null ? this.panelOcc.getInterpID().intValue() : this.getBlock().getInterpID());
                    }
                }
                catch (SQLException | SBException sbe) {
                    origInterp = null;
                    newInterp = null;
                }
                if (origInterp != null) {
                    origInterp.deleteWeakObserver((Observer)this);
                }
                if (newInterp != null) {
                    newInterp.addWeakObserver((Observer)this);
                }
            }
            this.setPropertyChanged();
            this.notifyListeners();
        }
    }

    @Override
    public void onTemplateEditingStarted(PanelProperties newEditableProperties) {
        if (!this.isTemplateSelected) {
            return;
        }
        this.setProperties(newEditableProperties);
        this.notifyListeners();
    }

    @Override
    public void onTemplateEditingFinished(boolean wasReverted) {
        this.setProperties(this.template.getProperties());
        if (!wasReverted) {
            this.setPropertyChanged();
        }
        this.notifyListeners();
    }

    @Override
    public void onTemplatePropertyChanged(PanelProperties propertiesThatChanged) {
        if (propertiesThatChanged != this.getProperties()) {
            return;
        }
        this.setPropertyChanged();
        this.notifyListeners();
    }

    public void useEditingProperties() {
        if (this.template.isEditing() && this.getProperties() != this.template.getEditableProp()) {
            this.setProperties(this.template.getEditableProp());
            this.setPropertyChanged();
        }
        this.notifyListeners();
    }

    public void doPropertyChangeNotify() {
        if (this.getProperties() == this.template.getProperties()) {
            assert (false);
        } else {
            this.setPropertyChanged();
        }
        this.notifyListeners();
    }

    public void doDataChangeNotify() {
        this.setDataChanged();
        this.notifyListeners();
    }

    public abstract ChartBlockBase getBlock();

    public Object updatePanelOcc() {
        Object arg = null;
        if (this.panelOccTemp != null) {
            arg = !SB.equal((Object)this.panelOccTemp.getInterpID(), (Object)this.panelOcc.getInterpID()) ? (this.panelOcc.getInterpID() != null ? this.panelOcc.getInterpID() : InterpHdr.class) : null;
            this.panelOcc.copyFields(this.panelOccTemp);
            this.panelOccTemp = null;
        }
        return arg;
    }

    public void clearPanelOccTemp() {
        this.panelOccTemp = null;
    }

    public Set<Integer> getVisibleSchemes(int igdType) throws SBException, SQLException {
        return Collections.emptySet();
    }
}

