/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.wellinterp.LOCNode;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.ProjectBlock;
import jsbchart.block.SubBlockProperties;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelAccumulationRateProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import model3.AccumulationRateInterval;
import model3.LOC;
import model3.LOCNodePair;
import model3.ProjectAccumulationRateSummary;
import model3.TVDList;
import model3.WellInterp;
import util.AgeFormat;
import util.DepthUnits;
import util.DepthUtils;
import util.FloatRange;
import util.SB;
import util.SBException;

public class PanelAccumulationRate
extends SBPanel {
    private final WellBlock block;
    private PanelAccumulationRateProperties props;
    private static final double INFINITE_RATE_MULTIPLIER = 2.0;
    private static final Logger LOGGER = Logger.getLogger(PanelAccumulationRate.class.getName());
    private static final int MAX_ALPHA = 200;
    private static final float TEXT_PADDING = 1.5f;
    private static final float MIN_BANDWIDTH_PORTION = 0.25f;

    PanelAccumulationRate(WellBlock block, PanelTemplate template, PanelOcc occ) throws SQLException, SBException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        assert (template.getType() == PanelType.ACCUMRATE);
        this.block = block;
        this.props = (PanelAccumulationRateProperties)template.getProperties();
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        float captionHeight = SBPanel.getPanelCaptionHeight(cp, mode);
        float subHeaderHeight = SBPanel.getPanelSubHeaderHeight(cp, mode);
        float subHeadingTop = captionHeight + y;
        float top = y + this.getPanelHeaderHeight(cp, mode);
        float base = y + this.getPanelHeaderHeight(cp, mode) + this.block.getHeight();
        double maxAccumRate = 0.0;
        List<AccumulationRateBand> bands = null;
        if (this.block instanceof ProjectBlock) {
            List accumulationRateIntervals = ProjectAccumulationRateSummary.calculateAveragedNodes(this.block.getWells(), (int)this.getInterpID(this.block), (char)this.block.getProp().getUnits(), (AgeFormat)cp.ageFormat);
            maxAccumRate = this.getMaxAccumRateFromIntervals(accumulationRateIntervals);
            bands = this.buildRateBands(accumulationRateIntervals, bp, maxAccumRate);
        } else {
            List<LOCNodePair> pairs = this.getNodePairs();
            if (pairs != null) {
                maxAccumRate = this.getMaxAccumRate(pairs);
                bands = this.buildRateBands(pairs, maxAccumRate, bp, cp);
            }
        }
        if (!(mode != Chart.Mode.NORMAL && mode != Chart.Mode.HEADER_ONLY || bp instanceof SubBlockProperties && bp.getMin() > this.block.getProp().getMin())) {
            g.setColor(cp.foreground);
            g.setFontSize(cp.getFontSize());
            char units = this.block.getProp().getUnits();
            double maxRate = maxAccumRate;
            if (units == DepthUnits.F.getChar()) {
                maxRate = DepthUtils.convFromM((double)maxRate, (char)DepthUnits.F.getChar());
            }
            String maxString = Double.toString(SB.roundToSignificantFigures((double)maxRate, (int)3));
            String caption = "Showing accum. rate up to " + maxString + " " + DepthUnits.getUnits((char)units).getAbr() + "/" + cp.ageFormat.getDescr();
            g.drawStringBox(caption, caption, x + 1.5f, subHeadingTop, (float)this.props.getWidth() - 3.0f, this.getMaxSubheaderStringHeight(cp), true, false, 5, null);
        }
        if ((mode == Chart.Mode.NORMAL || mode == Chart.Mode.NO_HEADER) && bands != null) {
            float maxBandWidth = this.calculateMaxBandWidth(bands, g, cp);
            if (this.props.getPlotStyle() == PanelAccumulationRateProperties.PlotStyle.SHADING) {
                this.drawAccumRateSemitransparentBands(bands, g, x, top, maxBandWidth);
            } else {
                this.drawAccumRateBands(bands, g, x, top, maxBandWidth, bp);
            }
            if (this.props.showText()) {
                this.drawAccumRateText(bands, g, x, top, base, cp, maxBandWidth);
            }
        }
        return x + (float)this.props.getWidth();
    }

    @Override
    public void setProperties(PanelProperties prop) {
        if (!(prop instanceof PanelAccumulationRateProperties)) {
            throw new IllegalArgumentException("Attempt to set PanelAccumulationRate properties to " + String.valueOf(prop));
        }
        this.props = (PanelAccumulationRateProperties)prop;
    }

    private void drawAccumRateSemitransparentBands(List<AccumulationRateBand> bands, SBGraphics g, float x, float top, float maxBandWidth) {
        Color fillColor = this.props.getFillColour();
        for (AccumulationRateBand band : bands) {
            double percent = Math.abs(band.percent);
            int alpha = percent >= 1.0 ? 200 : (int)Math.round(200.0 * percent);
            Color c = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), alpha);
            g.setColor(c);
            g.fillRect(x, top + band.yAxisRange.getMin(), maxBandWidth, band.yAxisRange.getMax() - band.yAxisRange.getMin());
        }
    }

    private void drawAccumRateBands(List<AccumulationRateBand> bands, SBGraphics g, float x, float top, float maxBandWidth, BlockProperties bp) {
        g.setColor(this.props.getFillColour());
        for (AccumulationRateBand band : bands) {
            float bandWidth;
            float offset = 0.0f;
            if (band.percent >= 1.0) {
                bandWidth = maxBandWidth;
            } else {
                bandWidth = (float)((double)maxBandWidth * band.percent);
                if (this.props.getPlotStyle() != PanelAccumulationRateProperties.PlotStyle.BARS_LEFT) {
                    offset = (maxBandWidth - bandWidth) / 2.0f;
                }
            }
            g.fillRect(x + offset, top + band.yAxisRange.getMin(), bandWidth, band.yAxisRange.getMax() - band.yAxisRange.getMin());
        }
    }

    private void drawAccumRateText(List<AccumulationRateBand> bands, SBGraphics g, float x, float top, float base, ChartProperties cp, float maxBandWidth) {
        g.setColor(cp.foreground);
        g.setFontSize(cp.getFontSize());
        for (AccumulationRateBand band : bands) {
            float textYPos = top + band.yAxisRange.getMin() + (band.yAxisRange.getMax() - band.yAxisRange.getMin()) * 0.5f + g.stringHeightSB() * 0.5f;
            float textXPos = x + maxBandWidth + 1.5f;
            if (this.props.getPlotStyle() == PanelAccumulationRateProperties.PlotStyle.SHADING) {
                float width = g.stringWidth(band.text);
                textXPos = x + maxBandWidth * 0.5f - width * 0.5f;
            }
            if (!((double)textYPos + (double)g.stringHeightSB() / 2.0 < (double)base)) continue;
            g.drawString(band.text, textXPos, textYPos);
        }
    }

    private double getMaxAccumRate(List<LOCNodePair> pairs) {
        if (this.props.useAutoAccumulationRate()) {
            return this.findMaxAccumRate(pairs);
        }
        double maxRate = this.props.getAccumRateMax();
        if (this.props.getAccumRateUnits() == PanelAccumulationRateProperties.AccumRateUnits.FEET) {
            maxRate = DepthUtils.convToM((double)maxRate, (char)DepthUnits.F.getChar());
        }
        return maxRate;
    }

    private double getMaxAccumRateFromIntervals(List<AccumulationRateInterval> intervals) {
        if (this.props.useAutoAccumulationRate()) {
            return this.findMaxAccumRateFromIntervals(intervals);
        }
        double maxRate = this.props.getAccumRateMax();
        if (this.props.getAccumRateUnits() == PanelAccumulationRateProperties.AccumRateUnits.FEET) {
            maxRate = DepthUtils.convToM((double)maxRate, (char)DepthUnits.F.getChar());
        }
        return maxRate;
    }

    private double findMaxAccumRate(List<LOCNodePair> pairs) {
        double maxRate = 0.0;
        boolean infPresent = false;
        for (LOCNodePair band : pairs) {
            double accumRate = band.getAccumRate(this.getBlock().getTVDList());
            if (Double.isInfinite(accumRate)) {
                infPresent = true;
                continue;
            }
            if (!(accumRate > maxRate)) continue;
            maxRate = accumRate;
        }
        if (infPresent) {
            maxRate *= 2.0;
        }
        return maxRate;
    }

    private double findMaxAccumRateFromIntervals(List<AccumulationRateInterval> pairs) {
        double maxRate = 0.0;
        boolean infPresent = false;
        for (AccumulationRateInterval interval : pairs) {
            double accumRate = interval.getAccumulationRate();
            if (Double.isInfinite(accumRate)) {
                infPresent = true;
                continue;
            }
            if (!(accumRate > maxRate)) continue;
            maxRate = accumRate;
        }
        if (infPresent) {
            maxRate *= 2.0;
        }
        return maxRate;
    }

    private float calculateMaxBandWidth(List<AccumulationRateBand> bands, SBGraphics g, ChartProperties cp) {
        g.setFontSize(cp.getFontSize());
        if (this.props.showText() && this.props.getPlotStyle() != PanelAccumulationRateProperties.PlotStyle.SHADING) {
            float longestText = 0.0f;
            for (AccumulationRateBand band : bands) {
                float width = g.stringWidth(band.text);
                if (!(width > longestText)) continue;
                longestText = width;
            }
            float maxBandWidth = (float)this.props.getWidth() - longestText - 3.0f;
            if (maxBandWidth < 0.25f * (float)this.props.getWidth()) {
                maxBandWidth = 0.25f * (float)this.props.getWidth();
            }
            return maxBandWidth;
        }
        return this.props.getWidth();
    }

    private List<AccumulationRateBand> buildRateBands(List<LOCNodePair> pairs, double maxAccumRate, BlockProperties bp, ChartProperties cp) {
        ArrayList<AccumulationRateBand> bands = new ArrayList<AccumulationRateBand>();
        FloatRange blockYRange = this.getBlockYAxisRange(bp);
        FloatRange blockScaleRange = new FloatRange(bp.getMin(), bp.getMax());
        char units = this.block.getProp().getUnits();
        for (LOCNodePair pair : pairs) {
            FloatRange bandYRange;
            if (bp instanceof SubBlockProperties && bp.getScaleType() == BlockProperties.ScaleType.MD) {
                FloatRange pairDepthRange = new FloatRange((float)pair.getTopDepth(), (float)pair.getBaseDepth());
                if (!blockScaleRange.overlapsThisRange(pairDepthRange)) continue;
                pairDepthRange = blockScaleRange.getOverlappingRange(pairDepthRange);
                float bandTop = this.block.scaleDepth(pairDepthRange.getMin(), true);
                float bandBase = this.block.scaleDepth(pairDepthRange.getMax(), true);
                bandYRange = new FloatRange(bandTop, bandBase);
            } else {
                float bandBase;
                float bandTop = this.block.scaleDepth((float)pair.getTopDepth(), true);
                bandYRange = new FloatRange(bandTop, bandBase = this.block.scaleDepth((float)pair.getBaseDepth(), true));
                if (!blockYRange.overlapsThisRange(bandYRange)) continue;
                bandYRange = blockYRange.getOverlappingRange(bandYRange);
            }
            TVDList tvdList = null;
            try {
                if (this.block.getWell() != null) {
                    tvdList = this.block.getWell().getTVDlist(false);
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error getting TVD List: ", e);
            }
            double accumRate = pair.getAccumRate(tvdList);
            double percentage = accumRate > maxAccumRate ? 1.0 : accumRate / maxAccumRate;
            String text = pair.getAccumRateString(units, cp.ageFormat, tvdList);
            bands.add(new AccumulationRateBand(this, bandYRange, percentage, text));
        }
        return bands;
    }

    private List<AccumulationRateBand> buildRateBands(List<AccumulationRateInterval> intervals, BlockProperties bp, double maxAccumRate) {
        ArrayList<AccumulationRateBand> bands = new ArrayList<AccumulationRateBand>();
        FloatRange blockYRange = this.getBlockYAxisRange(bp);
        FloatRange blockScaleRange = new FloatRange(bp.getMin(), bp.getMax());
        for (AccumulationRateInterval interval : intervals) {
            FloatRange bandYRange;
            if (bp instanceof SubBlockProperties && bp.getScaleType() == BlockProperties.ScaleType.MD) {
                FloatRange intervalDepthRange = new FloatRange((float)interval.getDepthRange().getMin(), (float)interval.getDepthRange().getMax());
                if (!blockScaleRange.overlapsThisRange(intervalDepthRange)) continue;
                intervalDepthRange = blockScaleRange.getOverlappingRange(intervalDepthRange);
                float bandTop = this.block.scaleDepth(intervalDepthRange.getMin(), true);
                float bandBase = this.block.scaleDepth(intervalDepthRange.getMax(), true);
                bandYRange = new FloatRange(bandTop, bandBase);
            } else {
                float bandBase;
                float bandTop = this.block.scaleDepth((float)interval.getDepthRange().getMin(), true);
                bandYRange = new FloatRange(bandTop, bandBase = this.block.scaleDepth((float)interval.getDepthRange().getMax(), true));
                if (!blockYRange.overlapsThisRange(bandYRange)) continue;
                bandYRange = blockYRange.getOverlappingRange(bandYRange);
            }
            double accumRate = interval.getAccumulationRate();
            double percentage = accumRate > maxAccumRate ? 1.0 : accumRate / maxAccumRate;
            String text = interval.getAccumRateString();
            bands.add(new AccumulationRateBand(this, bandYRange, percentage, text));
        }
        return bands;
    }

    private FloatRange getBlockYAxisRange(BlockProperties bp) {
        float blockBase;
        float blockTop;
        if (bp.getScaleType() == BlockProperties.ScaleType.AGE) {
            blockTop = bp.scaleAge(bp.getMin());
            blockBase = bp.scaleAge(bp.getMax());
        } else {
            blockTop = this.block.scaleDepth(bp.getMin());
            blockBase = this.block.scaleDepth(bp.getMax());
        }
        return new FloatRange(blockTop, blockBase);
    }

    private List<LOCNodePair> getNodePairs() {
        List<LOCNodePair> pairs = null;
        if (this.block.getWell() == null) {
            pairs = this.buildTemplateLocPairs();
        } else if (this.getWellInterp() != null && this.getWellInterp().getLOC() != null) {
            LOC loc = this.getWellInterp().getLOC();
            pairs = this.buildLOCNodePairList(loc);
        }
        return pairs;
    }

    private List<LOCNodePair> buildLOCNodePairList(LOC loc) {
        ArrayList<LOCNodePair> pairs = new ArrayList<LOCNodePair>();
        LOCNode lastNode = null;
        for (LOCNode thisNode : loc.getNodes()) {
            if (lastNode == null) {
                lastNode = thisNode;
                continue;
            }
            LOCNodePair band = new LOCNodePair(lastNode, thisNode);
            pairs.add(band);
            lastNode = thisNode;
        }
        return pairs;
    }

    private List<LOCNodePair> buildTemplateLocPairs() {
        ArrayList<LOCNodePair> list = new ArrayList<LOCNodePair>();
        list.add(this.buildTemplatatePair(0.0, 1.0, 20.0, 40.0));
        list.add(this.buildTemplatatePair(20.0, 40.0, 30.0, 85.0));
        list.add(this.buildTemplatatePair(30.0, 85.0, 50.0, 95.0));
        list.add(this.buildTemplatatePair(50.0, 95.0, 60.0, 120.0));
        list.add(this.buildTemplatatePair(60.0, 120.0, 100.0, 300.0));
        return list;
    }

    private LOCNodePair buildTemplatatePair(double topDepth, double topAge, double baseDepth, double baseAge) {
        LOCNode top = new LOCNode(topDepth, topAge, 1);
        LOCNode base = new LOCNode(baseDepth, baseAge, 1);
        return new LOCNodePair(top, base);
    }

    private WellInterp getWellInterp() {
        if (this.block.getWell() == null) {
            return null;
        }
        try {
            return this.block.getWell().getInterp(this.getInterpID(this.block));
        }
        catch (SBException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float depth = this.block.getDepth(y, bp);
        char units = this.block.getProp().getUnits();
        List<LOCNodePair> pairs = this.getNodePairs();
        TVDList tvdList = null;
        try {
            if (this.block.getWell() != null) {
                tvdList = this.getBlock().getWell().getTVDlist(false);
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error getting TVD List: ", e);
        }
        if (pairs != null) {
            for (LOCNodePair pair : pairs) {
                if (!((double)depth > pair.getTopDepth()) || !((double)depth <= pair.getBaseDepth())) continue;
                return pair.getAccumRateString(units, cp.ageFormat, tvdList);
            }
        }
        return null;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.props.getWidth();
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    protected String getCaption() {
        return "Accumulation Rate";
    }

    @Override
    public PanelProperties getProperties() {
        return this.props;
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    private class AccumulationRateBand {
        FloatRange yAxisRange;
        double percent;
        String text;

        public AccumulationRateBand(PanelAccumulationRate panelAccumulationRate, FloatRange yAxisRange, double percent, String text) {
            Objects.requireNonNull(panelAccumulationRate);
            this.yAxisRange = yAxisRange;
            this.percent = percent;
            this.text = text;
        }
    }
}

