/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.user.Userdef;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jsbchart.core.ChartProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import util.ColourUtils;

class PanelBiocomsProperties
extends PanelProperties {
    private static final String[] propNames = new String[]{"Panel width", "Show sample", "Show analyst", "Analyst colours", "Analysts", "Disciplines", "Use colours", Discipline.MICRO.getAbr(false) + " colour", Discipline.NANNO.getAbr(false) + " colour", Discipline.PALY.getAbr(false) + " colour", Discipline.MACRO.getAbr(false) + " colour", "Alternate colours", "Font size", "Occurrence comments"};
    public static final int PROP_WIDTH = 0;
    public static final int PROP_DRAW_SAMPLES = 1;
    public static final int PROP_DRAW_ANALYSTS = 2;
    public static final int PROP_ANALY_COLOUR = 3;
    public static final int PROP_ANALYSTS = 4;
    public static final int PROP_DISCS = 5;
    public static final int PROP_COLOURS = 6;
    public static final int PROP_COL_M = 7;
    public static final int PROP_COL_N = 8;
    public static final int PROP_COL_P = 9;
    public static final int PROP_COL_A = 10;
    public static final int PROP_ALTCOLOURS = 11;
    public static final int PROP_FONTSIZE = 12;
    public static final int PROP_OCC_COMMENTS = 13;
    float panelWidth = 70.0f;
    boolean drawSamples = true;
    boolean drawAnalyst = true;
    private boolean useAnalystColours = true;
    private List<String> analysts = null;
    private Set<Discipline> discs = null;
    private boolean useAltColour = true;
    private ChartProperties.FontSize fontSize = ChartProperties.FontSize.SMALL;
    private static final Color altColour = new Color(110, 110, 110);
    boolean useColours = false;
    EnumMap<Discipline, Color> colours = new EnumMap(Discipline.class);
    boolean occComments;

    PanelBiocomsProperties() {
        super(PanelType.BIOCOMS);
        for (Discipline disc : Discipline.values()) {
            this.colours.put(disc, disc.getColour());
        }
        this.occComments = false;
    }

    public static PanelBiocomsProperties createCopy(PanelBiocomsProperties rhs) {
        PanelBiocomsProperties p = new PanelBiocomsProperties();
        p.copy(rhs);
        return p;
    }

    PanelBiocomsProperties(String prop, Collection<String> analysts) {
        super(PanelType.BIOCOMS);
        for (Discipline disc : Discipline.values()) {
            this.colours.put(disc, disc.getColour());
        }
        this.occComments = false;
        if (analysts != null && !analysts.isEmpty()) {
            this.analysts = new LinkedList<String>(analysts);
        }
        if (prop == null) {
            return;
        }
        String[] s = prop.split("\\|");
        block14: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.setPanelWidth(Float.parseFloat(s[i]));
                    continue block14;
                }
                case 1: {
                    this.drawSamples = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 2: {
                    this.drawAnalyst = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 3: {
                    this.useAnalystColours = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 4: {
                    this.useAltColour = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 5: {
                    try {
                        this.fontSize = ChartProperties.FontSize.valueOf(s[i]);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        this.fontSize = ChartProperties.FontSize.SMALL;
                    }
                    continue block14;
                }
                case 6: {
                    if (s[i].isEmpty()) continue block14;
                    String[] discStrings = s[i].split("\\,");
                    this.discs = new HashSet<Discipline>();
                    for (String ds : discStrings) {
                        this.discs.add(Discipline.getDisc((String)ds));
                    }
                    continue block14;
                }
                case 7: {
                    this.useColours = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 12: {
                    this.occComments = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                default: {
                    Discipline disc = Discipline.getDisc((char)s[i].charAt(0));
                    if (disc == null) continue block14;
                    this.colours.put(disc, ColourUtils.getColour((String)s[i].substring(1)));
                }
            }
        }
    }

    public boolean useDisc(Discipline discID) {
        if (this.getDiscs() == null) {
            return true;
        }
        return this.getDiscs().contains(discID);
    }

    public boolean useAnalyst(String analyst) {
        if (this.getAnalysts() == null) {
            return true;
        }
        return this.getAnalysts().contains(analyst);
    }

    @Override
    public int getnProps() {
        return propNames.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return propNames[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return (int)this.getPanelWidth();
            }
            case 2: {
                return this.drawAnalyst();
            }
            case 1: {
                return this.drawSamples();
            }
            case 3: {
                return this.useAnalystColours();
            }
            case 4: {
                return this.getAnalysts();
            }
            case 5: {
                return this.getDiscs();
            }
            case 11: {
                return this.useAltColour();
            }
            case 12: {
                return this.getFontSize();
            }
            case 6: {
                return this.useColours;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.colours.get(this.getColDisc(nProp));
            }
            case 13: {
                return this.occComments;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return Integer.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 11: 
            case 13: {
                return Boolean.class;
            }
            case 4: {
                return Userdef[].class;
            }
            case 5: {
                return Discipline[].class;
            }
            case 12: {
                return ChartProperties.FontSize.class;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return Color.class;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    if (prop instanceof Float) {
                        return this.setPanelWidth(((Float)prop).floatValue());
                    }
                    return this.setPanelWidth(Float.parseFloat(prop.toString()));
                }
                case 2: {
                    this.drawAnalyst = (Boolean)prop;
                    break;
                }
                case 1: {
                    this.drawSamples = (Boolean)prop;
                    break;
                }
                case 3: {
                    this.useAnalystColours = (Boolean)prop;
                    break;
                }
                case 4: {
                    if (prop instanceof Collection) {
                        this.analysts = new LinkedList<String>();
                        for (Object o : (Collection)prop) {
                            if (!(o instanceof Userdef)) continue;
                            this.analysts.add(((Userdef)o).getAbr());
                        }
                        Collections.sort(this.analysts);
                        if (!this.analysts.isEmpty()) break;
                        this.analysts = null;
                        break;
                    }
                    this.analysts = null;
                    break;
                }
                case 5: {
                    if (prop instanceof Set) {
                        this.discs = new HashSet<Discipline>((Set)prop);
                        if (!this.discs.isEmpty() && this.discs.size() != Discipline.values().length) break;
                        this.discs = null;
                        break;
                    }
                    this.discs = null;
                    break;
                }
                case 11: {
                    this.useAltColour = (Boolean)prop;
                    break;
                }
                case 12: {
                    this.fontSize = (ChartProperties.FontSize)((Object)prop);
                    break;
                }
                case 6: {
                    this.useColours = (Boolean)prop;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.colours.put(this.getColDisc(nProp), (Color)prop);
                    break;
                }
                case 13: {
                    this.occComments = (Boolean)prop;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No property at: " + nProp);
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Float.floatToIntBits(this.panelWidth);
        hash = 67 * hash + (this.drawSamples ? 1 : 0);
        hash = 67 * hash + (this.drawAnalyst ? 1 : 0);
        hash = 67 * hash + (this.useAnalystColours ? 1 : 0);
        hash = 67 * hash + (this.analysts != null ? this.analysts.hashCode() : 0);
        hash = 67 * hash + (this.discs != null ? this.discs.hashCode() : 0);
        hash = 67 * hash + (this.useAltColour ? 1 : 0);
        hash = 67 * hash + (this.fontSize != null ? this.fontSize.hashCode() : 0);
        hash = 67 * hash + (this.useColours ? 1 : 0);
        hash = 67 * hash + (this.occComments ? 1 : 0);
        for (Discipline disc : Discipline.values()) {
            hash = 67 * hash + this.colours.get(disc).hashCode();
        }
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelBiocomsProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelBiocomsProperties rhs = (PanelBiocomsProperties)comp;
        block4: for (int i = 0; i < this.getnProps(); ++i) {
            Object iProp1 = this.getProperty(i);
            Object iProp2 = rhs.getProperty(i);
            switch (i) {
                case 0: {
                    if (!(Math.abs(this.panelWidth - rhs.panelWidth) > 3.0f)) continue block4;
                    return false;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    continue block4;
                }
                default: {
                    if (Objects.equals(iProp1, iProp2)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public PanelProperties copy() {
        return PanelBiocomsProperties.createCopy(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPropertiesString() {
        void var4_8;
        String[] props = new String[13];
        props[0] = "" + this.getPanelWidth();
        props[1] = "" + (this.drawSamples() ? 1 : 0);
        props[2] = "" + (this.drawAnalyst() ? 1 : 0);
        props[3] = "" + (this.useAnalystColours() ? 1 : 0);
        props[4] = "" + (this.useAltColour() ? 1 : 0);
        props[5] = this.getFontSize().name();
        Object disc = "";
        if (this.getDiscs() != null) {
            for (Discipline discipline : this.getDiscs()) {
                if (!((String)disc).isEmpty()) {
                    disc = (String)disc + ",";
                }
                disc = (String)disc + discipline.getChar();
            }
        }
        props[6] = disc;
        props[7] = "" + (this.useColours ? 1 : 0);
        int i = 8;
        for (Discipline d : Discipline.values()) {
            props[i++] = d.getChar() + ColourUtils.DBColourString((Color)this.colours.get(d), (boolean)false, (boolean)false);
        }
        props[12] = "" + (this.occComments ? 1 : 0);
        String string = "";
        for (String prop : props) {
            String string2 = (String)var4_8 + prop + "|";
        }
        return var4_8;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelBiocomsProperties)) {
            throw new IllegalArgumentException("PanelBiocomsProperties cannot copy " + String.valueOf(pp));
        }
        PanelBiocomsProperties rhs = (PanelBiocomsProperties)pp;
        block5: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 4: {
                    this.analysts = rhs.getAnalysts() != null ? new LinkedList<String>(rhs.getAnalysts()) : null;
                    continue block5;
                }
                case 5: {
                    this.discs = rhs.getDiscs() != null ? new HashSet<Discipline>(rhs.getDiscs()) : null;
                    continue block5;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.colours.put(this.getColDisc(i), rhs.colours.get(this.getColDisc(i)));
                    continue block5;
                }
                default: {
                    this.setProperty(i, rhs.getProperty(i));
                }
            }
        }
    }

    private Discipline getColDisc(int prop) {
        switch (prop) {
            default: {
                assert (false);
            }
            case 10: {
                return Discipline.MACRO;
            }
            case 7: {
                return Discipline.MICRO;
            }
            case 8: {
                return Discipline.NANNO;
            }
            case 9: 
        }
        return Discipline.PALY;
    }

    @Override
    public List<String> getAnalystList() {
        if (this.analysts != null && this.analysts.isEmpty()) {
            this.analysts = null;
        }
        return this.analysts;
    }

    public float getPanelWidth() {
        return this.panelWidth;
    }

    private boolean setPanelWidth(float panelWidth) {
        if (panelWidth > 10.0f && Math.abs((int)this.panelWidth - (int)panelWidth) > 1) {
            this.panelWidth = panelWidth;
            return true;
        }
        return false;
    }

    public static Color getAltColour() {
        return altColour;
    }

    public boolean drawSamples() {
        return this.drawSamples;
    }

    public boolean drawAnalyst() {
        return this.drawAnalyst;
    }

    public boolean useAnalystColours() {
        return this.useAnalystColours;
    }

    public List<String> getAnalysts() {
        return this.analysts;
    }

    public Set<Discipline> getDiscs() {
        return this.discs;
    }

    public boolean useAltColour() {
        return this.useAltColour;
    }

    public ChartProperties.FontSize getFontSize() {
        return this.fontSize;
    }

    @Override
    public String getPrefs() {
        Object string = new String();
        String[] props = new String[11];
        props[0] = "" + this.getPanelWidth();
        props[1] = "" + (this.drawSamples() ? 1 : 0);
        props[2] = "" + (this.drawAnalyst() ? 1 : 0);
        props[3] = "" + (this.useAnalystColours() ? 1 : 0);
        props[4] = "" + (this.useAltColour() ? 1 : 0);
        props[5] = this.getFontSize().name();
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }
}

