/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelCasingProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import model3.Casing;
import model3.CasingPoint;
import model3.SBdb;
import model3.WsWell;
import util.SBException;

class PanelCasing
extends SBPanel {
    private final WellBlock block;
    private PanelCasingProperties p;

    PanelCasing(PanelTemplate template, WellBlock block, PanelOcc occ) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        assert (template.getType() == PanelType.CASING);
        this.block = block;
        this.p = (PanelCasingProperties)template.getProperties();
    }

    @Override
    protected String getCaption() {
        return "Casing";
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    @Override
    public PanelCasingProperties getProperties() {
        return this.p;
    }

    @Override
    public void setProperties(PanelProperties prop) {
        if (!(prop instanceof PanelCasingProperties)) {
            throw new IllegalArgumentException("Attempt to set panel casing properties to " + String.valueOf(prop));
        }
        this.p = (PanelCasingProperties)prop;
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        if (!g.isVisible(x, y, this.getWidth(bp), y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth(bp.getMax()))) {
            return x + this.getWidth(bp);
        }
        try {
            float baseDepth;
            float topDepth;
            Casing casing;
            this.drawSeaBed(g, cp, bp, this.block, this.block.getScaleConverter(), x, y + this.getPanelHeaderHeight(cp, mode));
            if (this.block.getWell() != null) {
                casing = this.block.getWell().getCasing();
            } else {
                assert (this.getDb() != null);
                casing = PanelCasing.getTemplateCasing(this.block);
            }
            if (casing.getList().isEmpty()) {
                return x + this.getWidth(bp);
            }
            if (this.p.plotIntoHeader) {
                g.setClip(x, y, this.getWidth(this.block.getProp()), this.block.getHeight() + this.getPanelHeaderHeight(cp, mode));
            } else {
                g.setClip(x, y + this.getPanelHeaderHeight(cp, mode), this.getWidth(this.block.getProp()), this.block.getHeight());
            }
            float casWidth = 8.0f;
            if (this.p.width < casWidth) {
                casWidth = this.p.width;
            }
            g.setColor(cp.foreground);
            float[] triX = new float[3];
            float[] triY = new float[3];
            float xmid = x + this.p.width / 2.0f;
            g.setStroke(1.0f);
            g.setFont(cp.font, 0, cp.getFontSize());
            if (bp == this.block.getProp()) {
                topDepth = this.block.getTopDepth();
                baseDepth = this.block.getBaseDepth();
            } else {
                topDepth = bp.getMin();
                baseDepth = bp.getMax();
            }
            for (CasingPoint casingPoint : casing.getList()) {
                double depth = casingPoint.getDepth();
                if (depth < (double)topDepth || depth > (double)baseDepth) continue;
                float yPos = y + this.block.scaleDepth((float)casingPoint.getDepth()) + this.getPanelHeaderHeight(cp, mode);
                g.drawLine(xmid - casWidth / 2.0f, yPos, xmid + casWidth / 2.0f, yPos);
                g.drawLine(xmid + casWidth / 2.0f, yPos + 0.5f, xmid + casWidth / 2.0f, yPos - casWidth * 2.0f);
                triX[0] = xmid - casWidth / 2.0f + casWidth * 0.35f;
                triX[1] = xmid + casWidth / 2.0f;
                triX[2] = triX[1];
                triY[0] = yPos;
                triY[1] = yPos;
                triY[2] = yPos - casWidth * 0.65f;
                g.fillPolygon(triX, triY, 3);
                if (this.p.depths) {
                    String depthString = this.getBoundaryLabel(this.block.getProp(), casingPoint.getDepth(), 2, true);
                    g.drawString(depthString, x, yPos + g.stringHeight(), this.getWidth(bp), 0, true);
                }
                g.drawStringVertical(casingPoint.getDiameter(), xmid - casWidth / 2.0f + casWidth * 0.35f, yPos - 2.0f, this.getWidth(bp), false, false, true);
            }
        }
        catch (Exception ex) {
            this.handleException(g, x, y, cp, bp, ex);
        }
        g.setClip(null);
        return x + this.getWidth(bp);
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.width;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Casing points";
    }

    public String toString() {
        return "Casing Points";
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        if (this.block.getWell() != null) {
            try {
                for (CasingPoint p : this.block.getWell().getCasing().getList()) {
                    if (!(p.getDepth() >= (double)this.block.getTopDepth()) || !(p.getDepth() <= (double)this.block.getBaseDepth())) continue;
                    return true;
                }
                return false;
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public Float getDataBound(boolean upper) {
        if (this.block.getWell() != null) {
            try {
                List list = this.block.getWell().getCasing().getList();
                if (list.isEmpty()) {
                    return null;
                }
                return Float.valueOf(upper ? (float)((CasingPoint)list.get(0)).getDepth() : (float)((CasingPoint)list.get(list.size() - 1)).getDepth());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static Casing getTemplateCasing(WellBlock block) throws SBException {
        Casing casing = new Casing(block.getDb());
        casing.add(new CasingPoint(30.0, "13 3/8"));
        casing.add(new CasingPoint(60.0, "9 5/8"));
        return casing;
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        ArrayList<CasingPoint> toFill = new ArrayList<CasingPoint>();
        float topDepth = this.block.getTopDepth();
        float baseDepth = this.block.getBaseDepth();
        for (CasingPoint casingPoint : this.block.getWell().getCasing().getList()) {
            double depth = casingPoint.getDepth();
            if (depth < (double)topDepth || depth > (double)baseDepth) continue;
            toFill.add(casingPoint);
        }
        if (!toFill.isEmpty()) {
            wsWell.fillCasing(toFill);
            dataTypes.add(20);
        }
    }
}

